#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################


from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
import Products.PythonScripts
from Products.ZCatalog.ZCatalog import ZCatalog
from Products.PythonScripts.PythonScript import manage_addPythonScript
import cgi,os,sys,string
from time import time
import math
import fpformat

class gno(ObjectManager,
           PropertyManager,
           RoleManager,
           Item,
           FindSupport,
           ZCatalog):
    """gno Folder object implementation.

    gno Folder objects are folders that can contain subobjects
    and other supporting objects.  They provide properties to all
    Topics and other Topic Types in them.  They also provide
    support methods for displaying Topics and Topic Types.
    """
   
    meta_type = "Gno Folder"
   
    _properties = (
        {'id':'title', 'type': 'string', 'mode': 'w'},
        ) 

    manage_options = (
        (
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'View', 'action': ''}
        )+
        PropertyManager.manage_options
	+ Item.manage_options
        )

    allowedmetatypes = ('Gno Folder','Image','DTML Document','DTML Method','File','GNOWSYS0.5','External Method','Folder','Mail Host','TinyTablePlus','Script (Python)','ZCatalog','Relation','Relation Type','Attribute Type','Object','Object Type','Transparent Folder','FSCounter','Z Search Interface','Cookie Crumbler', 'Accelerated HTTP Cache Manager', 'RAM Cache Manager', 'Browser Id Manager', 'External Method', 'Page Template','Function','FunctionType','Flow','Flow Type','Class','Class Type','BTreeFolder2')


    def all_meta_types(self):
        
        if hasattr(self, 'allowedmetatypes'):
            result = []
            import Products
            for metaType in Products.meta_types:
                if metaType['name'] in self.allowedmetatypes:
                    result.append(metaType)
            return result
        else:
            return Products.meta_types
   
    def __init__(self, id, title):
        self.__version__ = '1.0'
        self.id = id
        self.title = title

     
    def processor(self,id1,REQUEST=None):
        """
	   This script processes the rule selected by the user
	   """
        
        apinit=id1
        ap11=string.replace(apinit,"{","")
	ap1=string.replace(ap11,"}","")
	ap2=string.replace(ap1,"'sobj'","")
	ap3=string.replace(ap2,"'pobj'","")
	ap4=string.replace(ap3,"'assoc'","")
	ap5=string.replace(ap4,"'oper'","")
	ap6=string.replace(ap5,":","")
	j=string.split(ap6,"], ")

        x=0
	a={}
	k={}
	while x<=3:
	 
          yinit=j[x]
	  y1=string.replace(yinit,"['","")
	  y2=string.replace(y1,"']","")
	  y3=string.replace(y2,"', '",",")
	  y4=string.replace(y3,"'","")
	  y5=string.split(y4,",")
	  k[x]=y5
	  x=x+1

        a['sobj']=k[0]
        a['assoc']=k[1]
        a['pobj']=k[2]
        a['oper']=k[3]

        #Script for processing rules
        flag1=[]
        toper1=a['oper']
        toper=toper1.index('Then')
        listlen=len(a['oper'])
        j1=0
        tc1=1

        while j1<toper:
          ts=string.strip(a['sobj'][j1])
          ta=string.strip(a['assoc'][j1])
          tp=string.strip(a['pobj'][j1])
          tflag=0
          #from here if subject is Anything
          if(ts=='Anything'):
     		for temp1 in self.Data.Relations.objectValues():
	  		st2=repr(temp1.RelationType)
		       	st3=repr(temp1.RObjects)
         	       	if(string.find(st2,ta)>0) and (string.find(st3,tp)>0):
		            tflag=1
            		    tc2=tc1
                            tc1=tflag
		            if j1>0:
               			if a['oper'][j1]=='Or':
		                  tc1=tc1 or tc2
               			if a['oper'][j1]=='And':
		                  tc1=tc1 and tc2
    
          #from here if predicate is Anything
  	  elif(tp=='Anything'):
		for temp1 in self.Data.Relations.objectValues():
		        st1=repr(temp1.LObjects)
		        st2=repr(temp1.RelationType)
		        if(string.find(st1,ts)>0) and (string.find(st2,ta)>0):
		            tflag=1
		            tc2=tc1
            		    tc1=tflag
            		    if j1>0:
               			if a['oper'][j1]=='Or':
                  		  tc1=tc1 or tc2
               			if a['oper'][j1]=='And':
		                  tc1=tc1 and tc2
           
          #from here in the normal case
  	  else:
                for temp1 in self.Data.Relations.objectValues():
           	        st1=repr(temp1.LObjects)
           	        st2=repr(temp1.RelationType)
           	        st3=repr(temp1.RObjects)

           	        if(string.find(st1,ts)>0) and (string.find(st2,ta)>0) and (string.find(st3,tp)>0):
             		    tflag=1
                            tc2=tc1
		            tc1=tflag
		            if j1>0:
               			if a['oper'][j1]=='Or':
			          tc1=tc1 or tc2
               			if a['oper'][j1]=='And':
		                  tc1=tc1 and tc2
          j1=j1+1
     
       #end of while
        
        r=toper
	rc1=0
	rc2=0
	if tc1==1:
         
	 while r<listlen:
	    rs=string.strip(a['sobj'][r])
	    ra=string.strip(a['assoc'][r])
	    rp=string.strip(a['pobj'][r])
	    rflag=0
            
	    for temp2 in self.Data.Relations.objectValues():
	      rst1=repr(temp2.LObjects)
	      rst2=repr(temp2.RelationType)
	      rst3=repr(temp2.RObjects)
             
	      if(string.find(rst1,rs)>0) and (string.find(rst2,ra)>0) and (string.find(rst3,rp)>0):
                  rflag=1
            
	    if rflag==0:
	      a_id=repr(int(time())+r)
              rsfin=[]
              rsfin.append(rs)
              rpfin=[]
              rpfin.append(rp)
              rafin=[]
              rafin.append(ra)  
              self.REQUEST.set('BaseName',a_id)
	      self.REQUEST.set('LObjects',rsfin)
	      self.REQUEST.set('RObjects',rpfin)
	      self.REQUEST.set('RelationType',rafin)
             
              self.manage_addProduct['GNOWSYS06'].manage_addnewAssoc(a_id,REQUEST)    
            
  	    if rflag==1:
	      return "Error adding an association:Specified relationalready exists"
	    r=r+1
           
    def percent(self,x,y):
        """ """
        z=float(x)/float(y)*100
        zn=fpformat.fix(z,2)
        print zn
        return float(zn)


    def first(self,t,w,x,y,z,m,k,tmp,ft,fun,f,ci,co,flt,flo,wp):
        """Calculates percentage in System Statistics """
        s=w+x+y+z+m+ft+fun+f+ci+co+flt+flo+wp
        s=s+k
        s=s+tmp

        r=float(w)/float(s)*100
        rn=fpformat.fix(r,2)

        q=float(x)/float(s)*100
        qn=fpformat.fix(q,2)

        p=float(y)/float(s)*100
        pn=fpformat.fix(p,2)

        u=float(z)/float(s)*100
        un=fpformat.fix(u,2)
       
        v=float(m)/float(s)*100
        vn=fpformat.fix(v,2)

        l=float(k)/float(s)*100
        ln=fpformat.fix(l,2)
      
        tmp1=float(tmp)/float(s)*100
        tmpn=fpformat.fix(tmp,2)
        
	sft=float(ft)/float(s)*100
	sft1=fpformat.fix(sft,2)

	sfun=float(fun)/float(s)*100
        sfun1=fpformat.fix(sfun,2)

 	sf=float(f)/float(s)*100
        sf1=fpformat.fix(sf,2)

	sci=float(ci)/float(s)*100
        sci1=fpformat.fix(sci,2)

        sco=float(co)/float(s)*100
        sco1=fpformat.fix(sco,2)

	sflt=float(flt)/float(s)*100
        sflt1=fpformat.fix(sflt,2)

 	sflo=float(flo)/float(s)*100
        sflo1=fpformat.fix(sflo,2)

        swp=float(wp)/float(s)*100
        swp1=fpformat.fix(swp,2)

        i='<p align="center"><font size="2">There are  '+'<strong>'+ repr(s)+ '</strong>'+ '  element/s in the system.' +'<br>'
        i=i+'There are  '+'<strong>'+ repr(t)+ '</strong>' + '   object/s acting as roles in Relation Types.'+'<br>'+'<br>'
        i=i+'<table>'+'<tr><td width="125"></td><td></td>'+'<th align=left>'+'<font size="2">No. of elements '+'</th>'+'<td>'+'</td>'+'<th>'+'<font size="2">&nbsp Percentage'+'</th>'+'</tr>' 	
	i=i+'<tr>'+'<strong><td></td><td><font size="2">Object/s</td><td align=right><font size="2">'+repr(w)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(rn))+'</strong>'+'%'+'</td>'+'</tr>'
	i=i+'<tr>'+'<strong><td></td><td><font size="2">Object Type/s</td><td align=right><font size="2">'+repr(x)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(qn))+'</strong>'+'%'+'</td>'+'</tr>' 	
	i=i+'<tr>'+'<strong><td></td><td><font size="2">Relation Type/s</td><td align=right><font size="2">'+repr(y)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(pn))+'</strong>'+'%'+'</td>'+'</tr>'
	i=i+'<tr>'+'<strong><td></td><td><font size="2">Relation/s</td><td align=right><font size="2">'+repr(z)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(un))+'</strong>'+'%'+'</td>'+'</tr>'
	i=i+'<tr>'+'<strong><td></td><td><font size="2">Attribute Type/s</td><td align=right><font size="2">'+repr(m)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(vn))+'</strong>'+'%'+'</td>'+'</tr>' 	

	i=i+'<tr>'+'<strong><td></td><td><font size="2">MetaType/s</td><td align=right><font size="2">'+repr(k)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(ln))+'</strong>'+'%'+'</td>'+'</tr>' 

        i=i+'<tr>'+'<strong><td></td><td><font size="2">MetaType Relation/s</td><td align=right><font size="2">'+repr(tmp)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(tmpn))+'</strong>'+'%'+'</td>'+'</tr>' 

  	i=i+'<tr>'+'<strong><td></td><td><font size="2">Factory of Function Type/s</td><td align=right><font size="2">'+repr(ft)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(sft1))+'</strong>'+'%'+'</td>'+'</tr>' 
	i=i+'<tr>'+'<strong><td></td><td><font size="2">Objects in Function Folder</td><td align=right><font size="2">'+repr(fun)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(sfun1))+'</strong>'+'%'+'</td>'+'</tr>'
	i=i+'<tr>'+'<strong><td></td><td><font size="2">Customised Function Object/s</td><td align=right><font size="2">'+repr(f)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(sf1))+'</strong>'+'%'+'</td>'+'</tr>' 	
        i=i+'<tr>'+'<strong><td></td><td><font size="2">Class Base</td><td align=right><font size="2">'+repr(ci)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(sci1))+'</strong>'+'%'+'</td>'+'</tr>' 	 	
	i=i+'<tr>'+'<strong><td></td><td><font size="2">Class Objects</td><td align=right><font size="2">'+repr(co)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td width=5 align=right><font size="2">'+'<strong>'+str(float(sco1))+'</strong>'+'%'+'</td>'+'</tr>'
	i=i+'<tr>'+'<strong><td></td><td><font size="2">Flow Type/s</td><td align=right><font size="2">'+repr(flt)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td align=right><font size="2">'+'<strong>'+str(float(sflt1))+ '</strong>'+'%'+'</td>'+'</tr>'
	i=i+'<tr>'+'<strong><td></td><td><font size="2">Flow Object/s</td><td align=right><font size="2">'+repr(flo)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td align=right><font size="2">'+'<strong>'+str(float(sflo1))+'</strong>'+'%'+'</td>'+'</tr>'
        i=i+'<tr>'+'<strong><td></td><td><font size="2">Word Problem/s</td><td align=right><font size="2">'+repr(wp)+'</strong>'+'</td>'+'<td>'+'</td>'+'<td align=right><font size="2">'+'<strong>'+str(float(swp1))+ '</strong>'+'%'+'</td>'+'</tr>'+'</table>' 
      
        return i                            


       
                  
    def strconv(self,temp):
        """
        """   
        b=string.join(temp)
        return b    
        
 
    def newproc(self,obj):
        """
        """
        file=open(obj,'r')
        done=0
        while not done:
		al=file.readline()
                if al != "":
			print al
		else:
			done=1
        file.close()
	return	    

    def addscr(self,REQUEST):
        """
        This script adds a new Rule and stores the rule as dictionary in a Python File in the Rules folder in Data folder 
        """
        j=0
        #oper is a list that stores all the operators in the rule
	oper=[]
        #sobj is a list that stores all the subject objects in the rule
 	sobj=[]
        #assoc is a list that stores all the relationtypes in the rule
	assoc=[]
        #pobj is a list that stores all the predicate objects in the rule
	pobj=[]
	while j<=9:
	  toper=REQUEST['oper'+repr(j)]
	  tsobj=REQUEST['sobj'+repr(j)]
	  tassoc=REQUEST['assoc'+repr(j)]
	  tpobj=REQUEST['pobj'+repr(j)]
          if(tsobj=='Anything' and tpobj=='Anything'):
		return 'Anything cannot be selected as both subject and predicate'

	  oper.append(toper)
	  sobj.append(tsobj)
	  assoc.append(tassoc)
	  pobj.append(tpobj)
	  j=j+1

	l=sobj.index('Select Object')
	del oper[l:]
	del sobj[l:]
	del assoc[l:]
	del pobj[l:]

	#operator list
	opinit=repr(oper)
	opfin='\'oper\':'+opinit+','
	#sobject list
	sobinit=repr(sobj)
	sobfin='\'sobj\':'+sobinit+','
	#relationlist
	asoinit=repr(assoc)
	asofin='\'assoc\':'+asoinit+','
	#pobject list
	pobinit=repr(pobj)
	pobfin='\'pobj\':'+pobinit+''

	rul='return {'+opfin+sobfin+asofin+pobfin+'}'
	method_id=repr(int(time()))
	params='REQUEST=None'
	self.Data.Rules.manage_addProduct['PythonScripts'].manage_addPythonScript(method_id)
	t=self.Data.Rules[method_id]
	t.ZPythonScript_edit(params, rul)
	self.REQUEST.RESPONSE.redirect('bkbdocadd')

    def slideinterscript(self,REQUEST,RESPONSE):
	"""
	"""
	
	nm=[]
	x=REQUEST['firstno']
	y=REQUEST['secondno']

	j=[]
	j=REQUEST['idlist']

	a=int(x)
	a=a-1
	b=int(y)
	b=b-1

	temp=j[a]
	j[a]=j[b]
	j[b]=temp

	nm=j
	abinit=[]
	abinit=nm

	leng=len(abinit)
	i=0
	while i<leng :
	   abinit[i]=string.replace(abinit[i],"['","")
	   i=i+1
	
	b2=abinit
	
	
	i=0
	while i<leng :
	   b2[i]=string.replace(b2[i],"']","")
	   i=i+1

	b3=b2

	
	i=0
	while i<leng :
	   b3[i]=string.replace(b3[i],"','"," ")
	   i=i+1

	b4=b3
	bfin=[]
	bfin=b4
	nm1=[]
	nm1=bfin

	self.dtmlholder.manage_changeProperties(list=nm1,)        
        self.REQUEST.RESPONSE.redirect('newsortslideshow')

    def addslidelistproperty(self,REQUEST,RESPONSE):
	"""
	This script is for adding/modifying sorted list of objects to property slidelist of object type slide
	"""	

        sl = REQUEST['slidelist']

        Path = self.InstancePath
        Path = Path + 'Remove'
        Path = string.replace(Path,'/Remove','')
        RefPath = Path  + '/Data/ObjectType/slide'
        slideRef = self.restrictedTraverse(RefPath)

        propertyid = 'slidelist'

        if slideRef.hasProperty(propertyid):
            slideRef._updateProperty(propertyid,sl)
        else:
            slideRef.manage_addProperty(propertyid,sl,'lines',REQUEST=None)

        slideRef.reindex_object()
        self.REQUEST.RESPONSE.redirect('index_html')

  
    def interscript(self,REQUEST,RESPONSE):
	"""
	"""
	
	nm=[]
	x=REQUEST['firstno']
	y=REQUEST['secondno']

	j=[]
	j=REQUEST['idlist']

	a=int(x)
	a=a-1
	b=int(y)
	b=b-1

	temp=j[a]
	j[a]=j[b]
	j[b]=temp

	nm=j
	abinit=[]
	abinit=nm

	leng=len(abinit)
	i=0
	while i<leng :
	   abinit[i]=string.replace(abinit[i],"['","")
	   i=i+1
	
	b2=abinit
	
	
	i=0
	while i<leng :
	   b2[i]=string.replace(b2[i],"']","")
	   i=i+1

	b3=b2

	
	i=0
	while i<leng :
	   b3[i]=string.replace(b3[i],"','"," ")
	   i=i+1

	b4=b3
	bfin=[]
	bfin=b4
	nm1=[]
	nm1=bfin

	self.dtmlholder.manage_changeProperties(list=nm1,)        
        self.REQUEST.RESPONSE.redirect('newlistobject')

    def newstore(self,REQUEST):
        """
	"""
        newid = self.REQUEST['id']  
	self.Data.Views.manage_addDTMLDocument(newid)
	self.Data.Views[newid].manage_addProperty("sellist","",'tokens',REQUEST=None)

	self.Data.Views[newid].manage_edit('<dtml-var standard_html_header> <dtml-let sum="getProperty('"'sellist'"')"> <dtml-in sum> <dtml-let sit=sequence-item> <dtml-in expr="Data.Objects.objectValues()"> <dtml-let cbase=BaseName> <dtml-if "sit==cbase" > <table width="800"> <tr><td align="left"> <hr> <b><h2><dtml-var BaseName></h2></b> </td> </tr> <tr><td><dtml-var Description><hr></td></tr><tr> <td align="left"> The Object  <b><dtml-var BaseName></b>  belongs to the ObjectType <dtml-in ObjectTypes> <a href="<dtml-var surl>/Data/ObjectType/<dtml-var sequence-item>/index_html"><dtml-var sequence-item></a> </dtml-in> in the gnowledge base.<hr><hr> </td> </tr> </table> </dtml-if> </dtml-let> </dtml-in> <dtml-in expr="Data.ObjectType.objectValues()"> <dtml-let cbase=BaseName> <dtml-if "sit==cbase" > <hr> <b> <h2> <dtml-var BaseName> </h2> </b> <hr> <dtml-var Description> <hr> </dtml-if> </dtml-let> </dtml-in> </dtml-let> </dtml-in> </dtml-let> <form action="storedviews"> <center> <input type="submit" value="Close"> </center> </form> <dtml-var standard_html_footer>',REQUEST['id'])

	j=[]
	j=self.REQUEST['storelist']
	objTTlist=[]
	objTTlist=j
	nm=j
	abinit=[]
	abinit=nm
	
	leng=len(abinit)
	i=0
	while i<leng :
	   abinit[i]=string.replace(abinit[i],"['","")
	   i=i+1
	
	b2=abinit

	i=0
	while i<leng :
	   b2[i]=string.replace(b2[i],"']","")
	   i=i+1

	b3=b2

	i=0
	while i<leng :
	   b3[i]=string.replace(b3[i],"','"," ")
	   i=i+1

	b4=b3
	bfin=[]
	bfin=b4
	nm1=[]
	nm1=bfin

	#ur=self.absolute_url()	
	self.Data.Views[newid].manage_changeProperties(sellist=nm1,)
	self.REQUEST.RESPONSE.redirect('newlistobject')
    
    def printrule(self,j):
        """
        This script reads the Python Script containing the rule and returns a meaningful string in the form operator sobj relationtype pobj
        """
        k={}
        x=''
        k=j
        ctr=0
        l=len(k['oper'])
        while ctr<l:
           x=x+' '+k['oper'][ctr]+' '+k['sobj'][ctr]+' '+k['assoc'][ctr]+' '+k['pobj'][ctr]
           ctr=ctr+1
        print '<br>'
        return x+'<br>' 
### references added 10-12-03

    bkbdocadd=DTMLFile('dtml/display/bkbdocadd',globals())                
    bkbdocdel=DTMLFile('dtml/display/bkbdocdel',globals())
    ViewOptionsFl=DTMLFile('dtml/display/ViewOptionsFl',globals())
    ViewOptionsOT=DTMLFile('dtml/display/ViewOptionsOT',globals())
    ViewOptionsR=DTMLFile('dtml/display/ViewOptionsR',globals())
    ViewOptionsFlT=DTMLFile('dtml/display/ViewOptionsFlT',globals())
    ViewOptionsWP=DTMLFile('dtml/display/ViewOptionsWP',globals())
    ViewOptionsAT=DTMLFile('dtml/display/ViewOptionsAT',globals())
    ViewOptionsRT=DTMLFile('dtml/display/ViewOptionsRT',globals())
    ViewOptionsMT=DTMLFile('dtml/display/ViewOptionsMT',globals())
    ViewOptionsFun=DTMLFile('dtml/display/ViewOptionsFun',globals())
    ViewOptionsC =DTMLFile('dtml/display/ViewOptionsC',globals())
    ViewOptionsFunT=DTMLFile('dtml/display/ViewOptionsFunT',globals())
    ViewOptionsMTR=DTMLFile('dtml/display/ViewOptionsMTR',globals())
    ViewOptionsO=DTMLFile('dtml/display/ViewOptionsO',globals())
    ViewsFirstPage=DTMLFile('dtml/display/ViewsFirstPage',globals())   
    execrule_html=DTMLFile('dtml/display/execrule_html',globals())
    help_html=DTMLFile('dtml/display/help_html',globals())
    impexp=DTMLFile('dtml/display/impexp',globals())
    statform=DTMLFile('CF/statform',globals())
    SearchGnoT=DTMLFile('CF/SearchGnoT',globals())
    Apub0=DTMLFile('CF/Apub0',globals())    
         
# Factory methods

manage_addgnoFolderForm = DTMLFile('dtml/addgnofolderform', globals())

def manage_addgnoFolder(self, id, title, REQUEST=None):
    """
    """

    dest = self.Destination()
    dest._setObject(id, gno(id, title))
    
    if REQUEST is not None:
        try:    url=DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect('%s/manage_main' % url)
    return id
   
InitializeClass(gno)
