######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

#### Class file for PGQL - MET 23/12/03 ####

import os,sys,string,Globals

from string import replace, split
from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import SimpleItem
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.PythonScripts.standard import url_quote


def test(self):
  g=PGQL('PGQL')
  return  g.checktype('Object') 

###########################################################################################################
class PGQL(SimpleItem):

  """
  PGQL implementaton
  """
  meta_type = "PGQL"
  def __init__(self,id):    
    self.id=id
    
  def getinstancepath(self):
    # getting the path of the gnowsys instance in the zope management interface

     Path = self.InstancePath
     Path = Path + 'Remove'
     Path = string.replace(Path,'/Remove','')
     return Path


  def getanyproperty(self,id,type,property):
  
    #This script returns the specified property of the object 
    #having "id" as id and type as meta_type

    # calculate the path
    
    PATH = getinstancepath(self)

    # get the METATYPE (with reference to GNOWSYS) of the OBJECT (i.e Object, ObjectType, Relation, RelationType, MetaType, MetaTypeRelation)
    
    if type == 'AttributeTypes':
      PATH = PATH + '/Data/AttributeTypes/' + id
      objRef = self.restrictedTraverse( PATH )
      return objRef.getProperty(property)
    elif type == 'RelationTypes':
      type = 'GRelation Type'
    elif type == 'Relations':
      type = 'GRelation'
    elif type == 'ObjectType':
      type = 'GObject Type'
    elif type == 'Objects':
      type = 'GObject'
    elif type == 'MetaType':
      type = 'GMetaType'
    elif type == 'MetaTypeRelations':
      type = 'GMetaTypeRelation'

    # get the Object from the Catalog & return the required Property
    
    for x in self.Catalog({'meta_type':type}):
      if x.id == id and x.meta_type == type:
        return x[property]
	
  #############################################################################################################
  
  def getidproperty(self,type,property):
  
    #This script returns id property tuple for all the objects having 
    #meta_type as "type" you will not be able to access attributes with this script.
    #WONDERING if it should look in to the catalog

    # list type variable defined to get list of tuples (id, property)
    IdProperty = []

    # get the METATYPE (with reference to GNOWSYS) of the OBJECT (i.e Object, ObjectType, Relation, RelationType, MetaType, MetaTypeRelation)
    
    if type=='AttributeTypes':
      for x in self.Data.AttributeTypes.objectIds('GAttribute Type'):
        P = self.getAnyProperty(x,type,property)
        y = (x,P)
        IdProperty.append( y )
  
    if type == 'Objects':
      type = 'GObject'
    elif type == 'ObjectType':
      type = 'GObject Type'
    elif type == 'RelationTypes':
      type = 'GRelation Type'
    elif type == 'Relations':
      type = 'GRelation'
    elif type == 'MetaType':
      type = 'GMetaType'
    elif type == 'MetaTypeRelations':
      type = 'GMetaTypeRelation'

    # from catalog get the metatype & loop through it to get all the instances in that metatype & return the tuple of (id,property)
    for x in self.Catalog({'meta_type':type}):
      if x.meta_type == type:
        y = (x.id, x[property])
        IdProperty.append(y)
  
    return IdProperty
  
  ############################################################################################################
  
  #def square(x):
  
    #'''for testing purpose only '''

    # returns a square of a given number
    
    #return x * x
  
  #############################################################################################################
  
  
#  def checktype(self,type):
#  
#    '''This validates the name of the Object specified and returns the name in appropriate form or any type error msg'''
#
#    # Checking the Type of a MetaType & Converting it to a standerd Style 
#
#    type=type.upper()
#    if(type =='CLASSTYPE'):
#      type = 'ClassBase'
#  
#    elif(type =='CLASS' or  type=='CLASSES'):
#      type = 'ClassObjects'
# 
#    elif(type =='FUNCTION TYPE' or type =='FUNCTION TYPE'):
#      type = 'Functions'
#    
#    elif(type =='FUNCTION' or type =='FUNCTIONS' ):
#      type = 'Custom'
#    
#    elif(type =='FLOW' or type == 'FLOWS'):
#      type = 'FlowObjects'
    
#    elif(type =='FLOW TYPE' or type=='FLOW TYPES'):
#      type = 'FlowBase'
  
#    else:
#      return "Invalid Type"
 
#    return type
  ############################################################################################################
  
  #def getall(self,x):
    # ''' Returns the list of specified Type i.e MetaType,ObjectType etc.'''  
    # returns a list of all ID's of a given MetaType
    #list = []
    #x = checktype(x)
    #print "x = %s" % x
    #if x=='Custom':
    #  for i in self.PBase.x.Math.objectValues():
    #      list.append(i.id)
    #  for i in self.PBase.Functions.Strings.objectValues():
    #      list.append(i.id)
    #  for i in self.PBase.Functions.Conditions.objectValues():
    #      list.append(i.id)
    #else:
    #  for i in self.PBase."x".objectValues():
    #      list.append(i.id)
    #return list
  
  #############################################################################################################
  
  def getobjprop(self,x,type):
  
    '''Returns the list of values of a given any Type from Property sheet'''

    # given a ID & type returns property sheet of the ID
    
    list1 = []
    list2 = []
    listfn = []
    y='not found'

    # get the correct format of the MeataType
    z=checktype(self,type)
    if z=="Invalid Type":
      return z
    
    # get the list of ID's of a given MetaType
    list=getall(self,z)

    # calculate the correct path 
    for j in list:
      if j==x:
        PATH = getinstancepath(self)
        PATH = PATH + '/Data/' + z

###############################################
# following 6 lines have been added by hitesh to incorporate hashing

        if z == 'Objects' or z == 'ObjectType':
          x = x[0] + '/' + x
        if z == 'Relations':
          for i in self.Catalog({'meta_type':'GRelation'}):
            if i.meta_type == 'GRelation':
              x = self.getanyproperty(x,'Relations','RelationType') + '/' + x[0] + '/' + x
              
###############################################
              
        PATH = PATH + '/' + x 
        pro = self.restrictedTraverse( PATH )
        y='found'
        # store ID's & values from the Property Sheet
        list2=pro.propertyIds()
        list1=pro.propertyValues()   

    # append the property ID & value to the final list
    for i in range(len(list2)):
#      tmp=[]
#      j=list1[i]
#      tmp.append(list2[i])   
#      tmp.append(j)
      
      listfn.append([list2[i],list1[i]])                         
  
    if y=='not found':
      return 'object not found' 
    else:
      return listfn
  
  ############################################################################################################
  
  def get_ots_of_cat(self,cat):
  
    '''Returns the list of ObjectTypes belonging to a particular given MetaType'''
  
    flag='notfound'
    flag1=0
    objtype=[]
    finalot=[]
    
    # Search for the given Meta Type
    for x in self.Catalog({'meta_type':'GMetaType'}):
      if x.meta_type == 'GMetaType':
        if x.id == cat:
          flag='found'

    # Search for the given Meta Type from the list of given Object Types
    if flag == 'found':
      for ot in self.Catalog({'meta_type':'GObject Type'}):
        if ot.meta_type == 'GObject Type':            
          catlist=getanyproperty(self,ot.id,'ObjectType','PMetaType')
          for each in catlist:
            if each == cat: 
              flag1=1  
              finalot.append(ot.id)
              break 
            
      if flag1:  
        return finalot 
      else:
        return "No Object Type of this MetaType"
    else:
      return 'Invalid MetaType !!' 
  
  #######################################################################################################
  
  def get_obj_of_ot(self,ot):
  
    '''Returns the list of Objects belonging to a particular given ObjectType'''
          
    flag='notfound'
    flag1=0
    obj=[]
    finalobj=[]

    # Search for the given Object Type
    for x in self.Catalog({'meta_type':'GObject Type'}):
      if x.meta_type == 'GObject Type':
        if x.id == ot:
          flag='found'
          
    # Search for the given Object Type from the list of given Object 
    if flag == 'found':
      for obj in self.Catalog({'meta_type':'GObject'}):
        if obj.meta_type == 'GObject':            
          otlist=getanyproperty(self,obj.id,'Objects','ObjectTypes')
          for each in otlist:
            if each == ot: 
              flag1=1  
              finalobj.append(obj.id)
              break
            
      if flag1:  
        return finalobj
      else:
        return "No Objects of this Object Type"
    else:
      return 'Invalid Object Type !!' 
  
  ################################################################################
  
  def objs_of_cat(self,cat):
  
    '''Returns the list of Objects  belonging to a particular given MetaType'''

    listobj=[]
    list2=[]
    list3=[]
    flag=1

    # get the list of the Object Type Inheriting this Meta Type
    listOT=get_ots_of_cat(self,cat)
  
    if listOT=="Invalid MetaType !!":
      return listOT
    if listOT =="No Object Type of this MetaType":
      flag=0

    if flag:
      # get the list of Objects Inheriting this Object Type
      for x in listOT:
        list2=get_obj_of_ot(self,x)
        if list2!="No Objects of this Object Type" and list2!="Invalid Object Type":
          listobj.append(get_obj_of_ot(self,x))

      # check for the duplicate Objects in the list of Objects
      for x in listobj:
        if x not in list3:
          list3.append(x)

      return list3
    else:
      return "No objects since no Ot of this cat"
  
  ########################################################################################################
  
  def list_obj_with_att(self,Type,atrib,mode='none'):
  
    '''Returns the list of Type  with the given Attribute Type'''
  
    flag=0
    final=[]
    list=getall(self,Type)
    if list=='Enter appropriate arguments':
      return list
    atriblen=len(atrib)
    if(atriblen>1 and mode=='none'):
      return "Specify Mode"
    if(mode=='and' or mode=='or' or mode=='none'):
      type=checktype(self,Type)
      if type=="Invalid Type":
        return type
      
      elif(type =='MetaType'):
        attlist=[]
  
      elif(type =='Objects'):
        PATH = getinstancepath(self)
        PATH = PATH + '/Data/' + type
        PATH = PATH + '/D/' + 'Default' 
        pro = self.restrictedTraverse( PATH )
        attlist=pro.propertyIds()
  
      elif(type =='ObjectType'):
        PATH = getinstancepath(self)
        PATH = PATH + '/Data/' + type
        PATH = PATH + '/S/' + 'SystemObject' 
        pro = self.restrictedTraverse( PATH )
        attlist=pro.propertyIds()
  
      elif(type =='AttributeTypes'):
        PATH = getinstancepath(self)
        PATH = PATH + '/Data/' + type
        PATH = PATH + '/' + 'ELIT' 
        pro = self.restrictedTraverse( PATH )
        attlist=pro.propertyIds()
  
      elif(type =='Relations'):
        PATH = getinstancepath(self)
        PATH = PATH + '/Data/' + type
        PATH = PATH + '/' + 'BMS_rel1_1' 
        pro = self.restrictedTraverse( PATH )
        attlist=pro.propertyIds()
    
      elif(type =='RelationTypes'):
        PATH = getinstancepath(self)
        PATH = PATH + '/Data/' + type
        PATH = PATH + '/' + 'is_of_DTD_element_type' 
        pro = self.restrictedTraverse( PATH )
        attlist=pro.propertyIds()
    
      elif(type =='MetaTypeRelations'):
        PATH = getinstancepath(self)
        PATH = PATH + '/Data/' + type
        PATH = PATH + '/' + 'cr1' 
        pro = self.restrictedTraverse( PATH )
        attlist=pro.propertyIds()
      else:
        return "Invalid Type"
  
      PATH = getinstancepath(self)
      PATH = PATH + '/Data/AttributeTypes'
      pro1 = self.restrictedTraverse( PATH )
      list2=pro1.objectIds()
      for x in attlist:
        list2.append(x)
      for each in atrib:
        for i in list2 :
          if i==each:
            flag=1
  
      if flag==1:
        for j in list:
          ctr=0
          PATH = getinstancepath(self)
          PATH = PATH + '/Data/' + type
          PATH = PATH + '/' + j 
          pro = self.restrictedTraverse( PATH )
          list2=pro.propertyIds()
          for each in atrib:
            for i in list2:
              if i==each:
                ctr=ctr+1
          if mode=='and' or mode=='none':       
            if ctr==atriblen:
              final.append(j)
          else:
            if ctr<>0:
              final.append(j)
        if final==[]:
          return "Attribute not attached to the specified type"
        else:
          return final
  
      else:
        return "Invalid Arguments"
    else:
      return "Invalid Mode"
  
  #################################################################################################
    
  def get_subcat_of_cat(self,cat):
  
    ''' Returns the list of Submetatype belonging to  a particular given MetaType'''
  
    flag=0
    flag1=0
    list1=[]
    final=[]
    list=getall(self,'MetaType')
    for y in list:
      if y==cat:
        flag1=1
    for each in list:
      pcat=getanyproperty(self,each,'MetaType','PMetaType')
      for x in pcat:
        if x==cat:
          flag=1 
          list1.append(each)
  
    if flag1:
      if flag:            
        return list1
      else:
        return "This MetaType  doesn't have any Sub-MetaType"
    else:
      return "MetaType doesn't Exist" 
  
  
  #############################################################################################################
  
  def get_subot_of_ot(self,ot):
  
    ''' Returns the list of Sub-ObjectTypes belonging to a particular given ObjectType '''
  
    flag=0
    flag1=0
    list1=[]
    final=[]
    list=getall(self,'objecttype')
    for y in list:
      if y==ot:
        flag1=1
    for each in list:
      pcat=getanyproperty(self,each,'ObjectType','PObjectType')
      for x in pcat:
        if x==ot:
          flag=1 
          list1.append(each)
  
    if flag1:
      if flag:            
        return list1
      else:
        return "This ObjectType  doesn't have any Sub-Object Type"
    else:
      return "Object Type doesn't Exist" 
  
  
  #####################################################################################################
  
  def get_rel_of_reltype(self,reltype):
  
    '''Returns the list of Relations having a given Relation Type'''
  
    flag=0
    flag1=0
    list1=[]
    list=getall(self,'RelationType')
    for y in list:
      if y==reltype:
        flag1=1
  
    rel=getall(self,'Relation')   
    for each in rel:
      relt=getanyproperty(self,each,'Relations','RelationType')
      if relt[0]==reltype:
        flag=1 
        list1.append(each)
    if flag1:
      if flag:            
        return list1
      else:
        return "This RelationType  doesn't have any Relations"
    else:
      return "Relation Type doesn't Exist" 
  
  ##########################################################################################################
  
  
  
  def get_allreltyp_of_cat(self,cat):
  
    '''Returns the list of RelationsType  belonging to  a given MetaType'''
  
    list=[]
    flag=0
    list1=getall(self,'MetaType')
  
    for each in list1:
      if each==cat:
        flag=1
    if flag==1:
      list2=getall(self,'RelationType')
      for x in list2:
        pcat = getanyproperty(self,x,'RelationTypes','RelMetaType')
        for y in pcat:
          if y==cat:
            list.append(x)
        if list==[]:
          return 'No Relation Types of this metatype'
        else :
          return list
    else:
      return 'Invalid MetaType'
  
  #############################################################################################################
  
  def get_allatttyp_of_cat(self,cat):
  
    '''Returns a list of AttributeType belonging to a given MetaType'''
  
    list=[]
    flag=0
    list1=getall(self,'MetaType')
    for each in list1:
      if each==cat:
        flag=1
    if flag==1:
      list2=getall(self,'Attribute')    
      for x in list2:
        pcat = getanyproperty(self,x,'AttributeTypes','AttMetaType')
        for y in pcat:
          if y==cat:
            list.append(x)
        if list==[]:
          return 'No attribute types'
        else :
          return list
    else:
      return 'Invalid MetaType'
  
  ##########################################################################################################
  
  def count(self,id,type,obj):
  
    '''Returns the Number(count) of given argument Type, belonging to particular given Type with its Id'''
  
    if(type =='metatype' or type =='MetaType'):
      if(obj =='objecttype' or obj =='ObjectType' or obj=='Objecttype' or obj =='object type' or obj =='Object Type' or obj=='Object type' ):
  
        r = get_ots_of_cat(self,id)
        if (r=="No Object Type of this MetaType" or r=='Invalid MetaType !!'):
          return r
  
        r1=len(r)    
        return "There are %d Object Types of this MetaType" % (r1)
  
      elif(obj =='object' or obj =='Object' or obj =='objects' or  obj =='Objects'):
        r1 = objs_of_cat(self,id)
        if (r1=="No objects since no Ot of this cat" or r1=="Invalid MetaType !!"):
          return r1
  
        r=len(r1[0])
        return "There are %d Objects of this MetaType" % (r)
  
      elif(obj =='MetaType' or obj =='metatype'):
        r=get_subcat_of_cat(self,id)
        if (r== "This MetaType  doesn't have any Sub-MetaType" or r=="MetaType doesn't Exist"):
          return r
        r1=len(r)
        return "There are %d Sub-Categories of this MetaType" % (r1)
  
      elif(obj =='relationtype' or obj =='RelationType' or obj=='relation type' or obj =='Relation Type' or obj =='Relationtype' or obj=='Relation type' ):         
        r=get_allreltyp_of_cat(self,id)
        if (r=='No Relation Types of this metatype' or r=='Invalid MetaType'):
          return r
        r1=len(r)  
        return "There are %d Relation Types of this MetaType" % (r1)
  
      elif(obj =='attribute' or obj =='Attribute' or obj =='attribute type' or obj =='Attribute Type ' or obj =='Attribute type' or obj =='AttributeType' or obj =='attributetype' or obj =='AttributeType'):
        r=get_allatttyp_of_cat(self,id)
        if (r=='No attribute types' or r=='Invalid MetaType'):
          return r
        r1=len(r)
        return "There are %d Attribute Types of this MetaType" % (r1)
      else:
        return "%s is an invalid parameter" % (obj)
  
  
  
    elif(type =='objecttype' or type =='ObjectType' or type=='Objecttype' or type =='object type' or type =='Object Type' or type=='Object type' ):         
      if(obj =='object' or obj =='Object' or obj =='objects' or  obj =='Objects'):
        r=get_obj_of_ot(self,id)
        if (r== "No Objects of this Object Type" or r=='Invalid Object Type !!'):
          return r
        else:
          r1=len(r)    
          return "There are %d Objects of this Object Type" % (r1)
  
      elif(obj =='objecttype' or obj =='ObjectType' or obj=='Objecttype' or obj =='object type' or obj =='Object Type' or obj=='Object type' ):
        r=get_subot_of_ot(self,id)
        if (r=="This ObjectType  doesn't have any Sub-Object Type" or r=="Object Type doesn't Exist"):
          return r
        r1=len(r) 
        return "There are %d Sub-ObjectTypes of this Object Type" % (r1)
      else:
        return "%s is an invalid parameter" % (obj)
  
  
    elif(type =='relationtype' or type =='RelationType' or type=='relation type' or type =='Relation Type' or type =='Relationtype' or type=='Relation type' ):         
      if(obj =='Relation' or obj =='relation' or obj == 'relations' or obj == 'Relations'):
        r=get_rel_of_reltype(self,id)
        if (r=="This RelationType  doesn't have any Relations" or r=="Relation Type doesn't Exist"):
          return r
        r1=len(r)
        return "There are %d Relations of this Relation Type" % (r1)
      else:
        return "%s is an invalid parameter" % (obj)
  
    elif(type =='objects' or type =='Objects' or type=='object' or type =='Object'):         
      if(obj =='Relation' or obj =='relation' or obj == 'relations' or obj == 'Relations'):
        r=list_rel_of(self,id)
        if (r=="Either this Object does not participate in any Relation or it doesnot exists"):
          return r
        r1=len(r)
        return "There are %d Relations of this Object" % (r1)
      else:
        return "%s is an invalid parameter" % (obj)
  
    else:
      return "%s is an invalid parameter" % (type)
  
  
  #############################################################################################################
  
  def countall(self,type):
  
    ''' Returns the counted Number of Requested Type '''
  
    r=getall(self,type)
    if (r=='Enter appropriate arguments'):
      return r
    r1=len(r)
    return "There are %d %s present" % (r1,type)
  
  #############################################################################################################
  
  def list_rel_of(self,obj):
  
    '''Returns the list of all Relations in which this Object Participates'''
  
    final=[]
    list=[]
  
    list=getall(self,'Relations')
  
    for each in list:
      list2=getanyproperty(self,each,'Relations','LObjects')
      for a in list2:
        if obj==a:
          final.append(each)
  
      y=getanyproperty(self,each,'Relations','RObjects')      
      for x in y:
        if obj==x:
          if x not in final:
            final.append(each)
  
    if (final <> []):
      return final
  
    return "Either this Object does not participate in any Relation or it does not exists"  
  
  ########################################################################################################
  
  def list_rt_of(self,id):
  
    '''Returns a  list of RelationsType having a given ObjectType or Object'''
  
    list1=[]
    list=getall(self,'Relation Type')
  
    for each in list:
      flag=0
      pcat=getanyproperty(self,each,'RelationTypes','LRoles')
      for x in pcat:
        if x==id:
          flag=1 
      pcat=getanyproperty(self,each,'RelationTypes','RRoles')
      for x in pcat:
        if x==id:
          flag=1 
      if flag==1:
        list1.append(each)
    if list1==[]:          
      return "This Argument doesn't have any Relation Type, Check if the argument 'id'is correct & of Object Type or Object only "
    return list1
  
  #############################################################################################################
  
  def list_catrel_of(self,id):
  
    """ Returns a  list of CategoricalRelations having the   given MetaType or ObjectType as it's Roles """
  
    list1=[]
    list=getall(self,'metatyperelation')
    for each in list:
      flag=0
      pcat=getanyproperty(self,each,'MetaTypeRelations','LRoles')
      for x in pcat:
        if x==id:
          flag=1 
      pcat=getanyproperty(self,each,'MetaTypeRelations','RRoles')
      for x in pcat:
        if x==id:
          flag=1 
      if flag==1:
        list1.append(each)
    if list1==[]:          
      return "This Argument doesn't have any MetaType Relation, Check if the argument 'id' is correct & of MetaType or Object Type only"
    return list1
  
  #########################################################################################################
  
  
  def list_roles(self,id):
  
    ''' Returns the Left and Right Roles belonging to the given Relation or RelationType or CategoricalRelation  '''
  
    list1=[]
    list2=[]
    list3=[]
    flag=0
  
    list6=getall(self,'relation')
    for each in list6:
      if each==id:
        flag=3
  
    if (flag==0):
      list4=getall(self,'Relation Type')
      for each in list4:
        if each==id:
          flag=1
  
    if (flag==0):    
      list5=getall(self,'metatyperelation')
      for each in list5:
        if each==id:
          flag=2
  
    list1.append('LRoles')
    list2.append('RRoles')
  
    if flag==3:
      pcat=getanyproperty(self,id,'Relations','LObjects')
      for x in pcat:
        list1.append(x)
      pcat=getanyproperty(self,id,'Relations','RObjects')
      for x in pcat:
        list2.append(x)
  
    elif flag==1:
      pcat=getanyproperty(self,id,'RelationTypes','LRoles')
      for x in pcat:
        list1.append(x)
      pcat=getanyproperty(self,id,'RelationTypes','RRoles')
      for x in pcat:
        list2.append(x)
  
    elif flag==2:      
      pcat=getanyproperty(self,id,'MetaTypeRelations','LRoles')
      for x in pcat:
        list1.append(x)
      pcat=getanyproperty(self,id,'MetaTypeRelations','RRoles')
      for x in pcat:
        list2.append(x)
    else:
      return "Invalid parameter, check 'id' is of MetaType relation or RelationType or Relation  only "
  
    list3.append(list1)
    list3.append(list2)
    return list3
  
  #############################################################################################################
  
  def list_rel_with_roles(self,lr,rr):
  
    '''Returns a list of Relation or RelationType or MetaTypeRelation having the  given Left and Right Roles  '''
  
    list1=[]
    list2=[]
    list6=[]
    f=0
    f1=0
  
    list3=getall(self,'relation')    
    for each in list3:
      flag4=0
      flag5=0
      pcat=getanyproperty(self,each,'Relations','LObjects')
      for x in pcat:
        if x==lr:
          flag4=1
      pcat=getanyproperty(self,each,'Relations','RObjects')
      for x in pcat:
        if x==rr:
          flag5=1
      if (flag4==1 and flag5==1):
        list6.append(each)
        f=1
  
    if (f==0):
      list4=getall(self,'Relation Type')
      for each in list4:
        flag=0
        flag1=0
        pcat=getanyproperty(self,each,'RelationTypes','LRoles')
        for x in pcat:
          if x==lr:
            flag=1
        pcat=getanyproperty(self,each,'RelationTypes','RRoles')
        for x in pcat:
          if x==rr:
            flag1=1
        if (flag==1 and flag1==1):
          list1.append(each)
          f1=1
  
    if (f==0 and f1==0):     
      list5=getall(self,'metatyperelation')       
      for each in list5:
        flag2=0
        flag3=0
        pcat=getanyproperty(self,each,'MetaTypeRelations','LRoles')
        for x in pcat:
          if x==lr:
            flag2=1
        pcat=getanyproperty(self,each,'MetaTypeRelations','RRoles')
        for x in pcat:
          if x==rr:
            flag3=1
        if (flag2==1 and flag3==1):    
          list2.append(each)
  
    if (list1==[] and list2==[] and list6==[]):
      return "No such Roles playing MetaType Relation or RelationType or Relation Exists"
    elif (list1==[] and list6==[]):
      return "MetaType relation has the given  roles - %s" % (list2)
    elif (list1==[] and list2==[]):
      return "Relation has the given  roles - %s" % (list6)
    return "Relation Type has the given  roles - %s"  % (list1)
  
  ########################################################################################################
  
  def getlist_with_some_attval(self,type,attlist,mode='none'):
  
    '''Returns a list of given Type, having the given Attribute name and Attribute value'''
  
    list=[]
    list1=[]
    list3=[]
    tmp=string.join(attlist)
    tmp1=string.replace(tmp,'=',' ')
    tmp2=string.split(tmp1)
    tmp3=[]
    tmp4=[]
    listf=[]      
    length=len(attlist)
    if(length>1 and mode=='none'):
      return "Specify Mode"
  
    if(mode=='and' or mode=='or' or mode=='none' or mode=='nand' or mode=='xor' or mode=='nor' or mode=='not'):
  
      for i in range(len(tmp2)):
        if i%2==0:
          tmp3.append(tmp2[i])
        else:
          tmp4.append(tmp2[i])
      tmp3len=len(tmp3)
  
  
      if(type =='metatype' or type =='MetaType'):
        type = 'MetaType'
  
      elif(type =='object' or type =='Object' or type =='objects' or  type=='Objects'):
        type = 'Objects'
  
      elif(type =='objecttype' or type =='ObjectType' or type=='Objecttype' or type =='object type' or type =='Object Type' or type=='Object type' ):
        type = 'ObjectType'
  
      else:
        return "Invalid Type given"
  
      list2=getall(self,type)
  
      PATH = getinstancepath(self)
      PATH = PATH + '/Data/' + type
  
      for x in list2:
        ctr=0
        for i in range(len(tmp3)):
          j=tmp4[i]
          PATH1 =  PATH + '/' + x
          y = self.restrictedTraverse( PATH1 )
          list3=y.propertyIds()
          ptr=0
          for each in list3:
            if(each==tmp3[i]):
              val1=y.getPropertyType(tmp3[i])
              val=y.propertyValues()
              k=val[ptr]
  
              if (val1=='lines' or val1=='tokens' or val1=='ulines' or val1=='utokens'):
                for each1 in k:
                  if (each1==j):
                    ctr=ctr+1
                    if mode=='and' or mode=='nand' or mode=='not' or mode=='xor' or mode=='none':
                      if ctr==tmp3len:
                        if x not in list:
                          list.append(x)
                        andlist=list  
                    if mode=='or' or mode=='nor' or mode=='xor':       
                      if x not in list1:
                        list1.append(x)
  
              else:
                if(k==j):
                  ctr=ctr+1
                  if mode=='and' or mode=='nand' or mode=='not' or mode=='xor' or mode=='none':
                    if ctr==tmp3len:
                      if x not in list:
                        list.append(x)
                      andlist=list  
                    if mode=='or' or mode=='nor' or mode=='xor':       
                      if x not in list1:
                        list1.append(x)
            ptr=ptr+1                                      
  
    if mode =='xor':
      list=[]    
      for x in list1:
        if x not in andlist:
          list.append(x)
  
    if mode=='nand' or mode=='not':
      for each in list2:
        if each not in list:
          listf.append(each)
      return listf
  
    if mode=='nor':
      for each in list2:
        if each not in list1:
          listf.append(each)
      if listf<>[]:     
        return listf
  
    if mode=='or' and list1<>[]:   
      return list1
    elif list!=[]:
      return list
  
  
    if list==[] and list1==[] and listf==[]:
      return "Invalid Attribute value or no AttributeType is having this Value"
  
    else:
      return 'Invalid Mode'
  
  ############################################################################################################ 
  
  def getpropvalues(self,Type,selfield):
  
    ''' Returns the values of required attributes(selfields) and the id of all instances of the particular type(object,metatype etc.)'''
  
    type=checktype(self,Type)
    if type=="Invalid Type":
      return type
  
  
    list=list_obj_with_att(self,type,selfield,'and')
    if (list=="Attribute not attached to the specified type" or list=="Invalid Arguments" or list=="Specify Mode" or list=="Invalid Mode" or list=="Invalid Type"):
      return list
    else:
      vallist=[]
      for each in list:
        list1=[]
        #id='ObjectId-'
        list1.append(each)
        for x in selfield:
          val=getanyproperty(self,each,type,x)
          list1.append(val)  
        vallist.append(list1)
    return vallist
  
  
  
  #############################################################################################################
  
  def get_orderedlist(self,Type,selfield,ordby):
  
    '''Selected Attribute list is returned ordered by the given particular Attribute'''
  
    type=checktype(self,Type)
    if type=="Invalid Type":
      return type
  
  
    list1=[]
    list2=[]
  
    select=[]
    for each in selfield:
      select.append(each)
    select.append(ordby)
  
    list=list_obj_with_att(self,type,select,'and')
  
    if (list=="Attribute not attached to the specified type" or list=="Invalid Arguments" or list=="Specify Mode" or list=="Invalid Mode" or list=="Invalid Type"):
      return list
  
  
    PATH = getinstancepath(self)
    PATH = PATH + '/Data/' + type
    for each in list:
      PATH1 =  PATH + '/' + each
      y = self.restrictedTraverse( PATH1 )
      val1=y.getPropertyType(ordby)
      pcat=getanyproperty(self,each,type,ordby)
      if (val1=='lines' or val1=='tokens' or val1=='ulines' or val1=='utokens'):
        for each1 in pcat:
          if each1 not in list1:
            list1.append(each1)
      else:
        if pcat not in list1:
          list1.append(pcat)
  
    list1.sort()
  
    for x in list1:
      for each in list:
        PATH1 =  PATH + '/' + each
        y = self.restrictedTraverse( PATH1 )
        val1=y.getPropertyType(ordby)
        pcat=getanyproperty(self,each,type,ordby)
        if (val1=='lines' or val1=='tokens' or val1=='ulines' or val1=='utokens'):
          for each1 in pcat:
            if each1==x:
              list2.append(each)
        else:
          if pcat==x:
            list2.append(each)
  
    vallist=[]
    for each in list2:
      list1=[]
      list1.append(each)
      for x in selfield:
        val=getanyproperty(self,each,type,x)
        list1.append(val)  
      vallist.append(list1)
    return vallist
  
  ############################################################################################################
  
  
  def groupby(self,Type,selfield,grpby):
  
    '''Selected Attribute of the given type is Grouped & returned according to the given Attribute for grouping''' 
  
    type=checktype(self,Type)
    if type=="Invalid Type":
      return type
  
    list1=[]
    select=[]
    for each in selfield:
      select.append(each)
    select.append(grpby)
  
    list=list_obj_with_att(self,type,select,'and')
    if (list=="Attribute not attached to the specified type" or list=="Invalid Arguments"):
      return list
  
    PATH = getinstancepath(self)
    PATH = PATH + '/Data/' + type
  
    for each in list:      
      PATH1 =  PATH + '/' + each
      y = self.restrictedTraverse( PATH1 )
      val1=y.getPropertyType(grpby)
      pcat=getanyproperty(self,each,type,grpby)
      if (val1=='lines' or val1=='tokens' or val1=='ulines' or val1=='utokens'):
        for each1 in pcat:
          if each1 not in list1:
            list1.append(each1)
      else:
        if pcat not in list1:
          list1.append(pcat)
  
  
    final=[]
    for x in list1:
      # vallist=[]
      # vallist.append(x)
        list2=[] 
        for each in list:
          PATH1 =  PATH + '/' + each
          y = self.restrictedTraverse( PATH1 )
          val1=y.getPropertyType(grpby)
          pcat=getanyproperty(self,each,type,grpby)
          if (val1=='lines' or val1=='tokens' or val1=='ulines' or val1=='utokens'):
            for each1 in pcat:
              if each1==x:
                list2.append(each)
          else:
            if pcat==x:
              list2.append(each)
  
        for each in list2:
          list3=[]
          list3.append(each)
          for x in selfield:
            val=getanyproperty(self,each,type,x)
            list3.append(val)
  
       # vallist.append(list3)
        final.append(list3)
        return final
    
  #############################################################################################################
  
  def getmath(self,Type,att,fun):
  
    '''Performs various math functions'''
  
    type=checktype(self,Type)
    if type=="Invalid Type":
      return type
    obj=[]
    prop=[]
    listpropval=[]
    finalprop=[]
    att1=[]
    att1.append(att)
    obj=list_obj_with_att(self,type,att1)
  
    if (obj=="Attribute not attached to the specified type" or obj=="Invalid Arguments"):
      return obj
    
    PATH = getinstancepath(self)
    PATH = PATH + '/Data/' + type
  
    for each in obj:
      PATH1=PATH + '/' + each
      y = self.restrictedTraverse( PATH1 )
      prop=y.propertyIds()
      prop1=y.propertyValues()
      for i in range(len(prop)):
        if prop[i]==att:
            val=y.getPropertyType(prop[i])
            if val=='int' or val=='float' or val=='long':
              j=prop1[i]
              fin=[]
              fin.append(each)
              fin.append(j)
              listpropval.append(j)
              finalprop.append(fin)
      
    if listpropval==[]:
      return "Specified Attribute has no value"
      
    if fun=='min':
      final=[]
      ans=min(listpropval)
      for each in finalprop:
        if each[1]==ans:
          final.append(each)
         
      
    elif fun=='max':
      final=[]
      ans=max(listpropval)
      for each in finalprop:
        if each[1]==ans:
          final.append(each)
    
        
    elif fun=='avg' or fun=='average':
      
      numb=len(listpropval)
      total=0
      for each in listpropval:
        total=total+each
      final=total/numb
      return float(final)
  
    elif fun=='sum':
      final=0
      for each in listpropval:
        final=final+each
    else:
      return "Enter proper Function Name"
     
    return final     
    
     
  ##########################################################################################################
  
  def getconditionalvalue(self,Type,att,optr,value=0,optr1='none',value1=0):
  
    '''This function allows to perform all type of conditional functions to the Attribute value o f the requested Type '''
  
    flag=0
    flag1=0
    if value!=0:
      if type(value) is type(1):
        flag=1
      else:
        flag=0
    if value1!=0:
      if type(value1) is type(1):
        flag1=1
      else:
        flag1=0
    if flag==0 and flag1==0:
      return "Value should be of type integer"
  
    type1=checktype(self,Type)
    if type1=="Invalid Type":
      return type1
    obj=[]
    prop=[]
    listpropval=[]
    finalless=[]
    finalgreat=[]
    finalequal=[]
    finalnotequal=[]
    finalgreateq=[]
    finallesseq=[]
    finalrange1=[]
    finalrange2=[]
    finalrange3=[]
    finalrange4=[]
    finalrange5=[]
    finalrange6=[]
    finalrange7=[]
    finalrange8=[]
    att1=[]
    att1.append(att)
    obj=list_obj_with_att(self,type1,att1)
    if (obj=="Attribute not attached to the specified type" or obj=="Invalid Arguments"):
      return obj
        
    PATH = getinstancepath(self)
    PATH = PATH + '/Data/' + type1
    
    for each in obj:
      PATH1=PATH + '/' + each
      y = self.restrictedTraverse( PATH1 )
      prop=y.propertyIds()
      prop1=y.propertyValues()
      for i in range(len(prop)):
        if prop[i]==att:
          val=y.getPropertyType(prop[i])
          if val=='int' or val=='float' or val=='long':
            j=prop1[i]  
              
            if optr=='>' and optr1=='none':    
              if j>value:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalgreat.append(fin)
            elif optr=='<' and optr1=='none':
              if j<value:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalless.append(fin)
            elif optr=='=' and optr1=='none':
              if j==value:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalequal.append(fin)
            elif ((optr=='!' or optr=='not' or optr=='<>') and optr1=='none'):
              if j!=value:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalnotequal.append(fin)
            elif optr=='<=' and optr1=='none':
              if j<=value:
                fin=[]
                fin.append(each)
                fin.append(j)
                finallesseq.append(fin)
            elif optr=='>=' and optr1=='none':
              if j>=value:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalgreateq.append(fin)
            elif optr=='>' and optr1=='<':
              if j>value and j<value1:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalrange1.append(fin)               
            elif optr=='<' and optr1=='>':
              if j<value and j>value1:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalrange2.append(fin)            
            elif optr=='<=' and optr1=='>':
              if j<=value and j>value1:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalrange3.append(fin)
            elif optr=='>=' and optr1=='<':
              if j>=value and j<value1:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalrange4.append(fin)
            elif optr=='>=' and optr1=='<=':
              if j>=value and j<=value1:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalrange5.append(fin)
            elif optr=='<=' and optr1=='>=':
              if j<=value and j>=value1:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalrange6.append(fin)
            elif optr=='<' and optr1=='>=':
              if j<value and j>=value1:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalrange7.append(fin)
            elif optr=='>' and optr1=='<=':
              if j>value and j<=value1:
                fin=[]
                fin.append(each)
                fin.append(j)
                finalrange8.append(fin)    
             
            else:
              return "Invalid Argument"
  
    if (finalless==[] and finalequal==[] and finalnotequal==[] and finalgreat==[] and finalrange1==[] and finalrange2==[] and finalrange3==[] and finalrange4==[] and finalrange5==[] and finalrange6==[] and finalrange7==[] and finalrange8==[] and finalgreateq==[] and finallesseq==[]):
      return "No Object satisfy the required condition"
    else:
      if optr=='>' and optr1=='none':
        return finalgreat
      elif optr=='<' and optr1=='none':
        return finalless
      elif optr=='=' and optr1=='none':
        return finalequal
      elif optr=='<=' and optr1=='none':
        return finallesseq
      elif optr=='>=' and optr1=='none':
        return finalgreateq
      elif optr=='>' and optr1=='<':
        return finalrange1
      elif optr=='<' and optr1=='>':
        return finalrange2
      elif optr=='<=' and optr1=='>':
        return finalrange3
      elif optr=='>=' and optr1=='<':
        return finalrange4
      elif optr=='>=' and optr1=='<=':
        return finalrange5
      elif optr=='<=' and optr1=='>=':
        return finalrange6
      elif optr=='<' and optr1=='>=':
        return finalrange7
      elif optr=='>' and optr1=='<=':
        return finalrange8
      elif ((optr=='!' or optr=='<>' or optr=='not') and optr1=='none'):
        return finalnotequal 
  
  ############################################################################################################
  
  
  
  ####   REENA TREE CODE    ########
  
  def getcat(self,cat):
    
    ''' Returns the list of Submetatype belonging to  a particular given MetaType'''
    
    flag=0
    flag1=0
    list1=[]
    final=[]
    list=getall(self,'MetaType')
    for y in list:
      if y==cat:
        flag1=1
    for each in list:
           pcat=getanyproperty(self,each,'MetaType','PMetaType')
           for x in pcat:
             if x==cat:
              flag=1 
              list1.append(each)
  
    if flag1:
       if flag:            
         return list1
       else:
         return 1
         #return "This MetaType  doesn't have any Sub-MetaType"
    else:
         return 1  
         #return "MetaType doesn't Exist"
  
  #################################
  def getobjofot(self,ot):
    
     '''Returns the list of Objects belonging to a particular given ObjectType'''
      
     flag='notfound'
     flag1=0
     obj=[]
     finalobj=[]
  
     for x in self.Catalog({'meta_type':'GObject Type'}):
       if x.meta_type == 'GObject Type':
         if x.id == ot:
           flag='found'
       
     if flag == 'found':
       for obj in self.Catalog({'meta_type':'GObject'}):
         if obj.meta_type == 'GObject':            
           otlist=getanyproperty(self,obj.id,'Objects','ObjectTypes')
           for each in otlist:
             if each == ot: 
               flag1=1  
               finalobj.append(obj.id)
       if flag1:  
         return finalobj
       else:
         return 1
     else:
       return 1 
  
  ####
  def getobjsofcat(self,cat):
    
    '''Returns the list of Objects  belonging to a particular given MetaType'''
  
    listobj=[]
    list2=[]
    list3=[]
    flag=1
    listcat=get_ots_of_cat(self,cat)
    
    if listcat=="Invalid MetaType !!":
      return listcat
    if listcat =="No Object Type of this MetaType":
      flag=0
  
    if flag:
      for x in listcat:   
        listobj.append(get_obj_of_ot(self,x))
        for each in listobj:
          if each =="No Objects of this Object Type" or  each =="Invalid Object Type":
            listobj.remove(each)
            list2.append(x)
            
      list4=listobj[0]
      return list4
    else:
      return 1
  
  
  ##############       
  def getot(self,ot):
  
    ''' Returns the list of Sub-ObjectTypes belonging to a particular given ObjectType '''
    
    flag=0
    flag1=0
    list1=[]
    final=[]
    list=getall(self,'ObjectType')
    for y in list:
      if y==ot:
       flag1=1
    for each in list:
      pcat=getanyproperty(self,each,'ObjectType','PObjectType')
      for x in pcat:
        if x==ot:
          flag=1 
          list1.append(each)
  
    if flag1:
      if flag:            
        return list1
      else:
        return 1
        # return "This ObjectType  doesn't have any Sub-Object Type"
    else:
        return 1
        #return "Object Type doesn't Exist" 
  
  ##############################################
  
  def  getallot(self,cat):
       
       final=[]
       res=[]
       res1=[]
       
  
       res.append(getot(self,cat))
       final.append(getot(self,cat))
       
       while(1):
        
         if res==[]:
           break
  
         for x in range(len(res)):
           for y in range(len(res[x])):
  
             if getot(self,res[x][y])!= 1 :
               res1.append(getot(self,res[x][y]))
         final.append(res1)
       
         res=[]
         if res1==[]:
           break
         for x in range(len(res1)):
           for y in range(len(res1[x])):
             if getot(self,res1[x][y])!= 1 :
               res.append(getot(self,res1[x][y]))
         
         final.append(res)
       
         res1=[]   
         
       return final
  
  ################################################   
  
  def getotsofcat(self,cat):
    
     '''Returns the list of ObjectTypes belonging to a particular given MetaType'''
     
     flag='notfound'
     flag1=0
     objtype=[]
     finalot=[]
  
     for x in self.Catalog({'meta_type':'GMetaType'}):
       if x.meta_type == 'GMetaType':
         if x.id == cat:
           flag='found'
       
     if flag == 'found':
       for ot in self.Catalog({'meta_type':'GObject Type'}):
         if ot.meta_type == 'GObject Type':            
           catlist=getanyproperty(self,ot.id,'ObjectType','PMetaType')
           for each in catlist:
             if each == cat: 
               flag1=1  
               finalot.append(ot.id)
       if flag1:  
         return finalot 
       else:
         return 1
     else:
       return 1 
  
  ###################################################
  ##displays the parent also
     
  def getcatofcat(self,cat):
       
        final=[]
        res=[]
        res1=[]
        one=[]
        stack=[]
        
  
        res.append(getcat(self,cat))
  
        for each in range(len(res)):
          for every in range(len(res[each])):
           me=cat+'.'+res[each][every]
           one.append(me)
        final.append(res)
       
        while(1):
        
          if res==[]:
            break
  
          for x in range(len(res)):
            for y in range(len(res[x])):
  
              if getcat(self,res[x][y])!= 1 :
                res1.append(getcat(self,res[x][y]))
  
                temp=res[x][y]
                stack.append(getcat(self,res[x][y]))
                for each in range(len(stack)):
                    for every in range(len(stack[each])):
                             me=temp+'.'+stack[each][every]
                             one.append(me)
                stack=[]
          final.append(res1)
       
          res=[]
          if res1==[]:
            break
          for x in range(len(res1)):
            for y in range(len(res1[x])):
              if getcat(self,res1[x][y])!= 1 :
                res.append(getcat(self,res1[x][y]))
                temp=res1[x][y]
                stack.append(getcat(self,res1[x][y]))
                for each in range(len(stack)):
                    for every in range(len(stack[each])):
                             me=temp+'.'+stack[each][every]
                             one.append(me)
                stack=[]
             
  
         
          final.append(res)
       
          res1=[]   
        return one  
        return final  
     
  
  #############################################################
  
  def gettreemetatype(self,cat):
        final=[]
        res=[]
        res1=[]
        one=[]
        stack=[]
        objects=[]
        temp1=[]
        temp2=[]
        
  
        res.append(getcat(self,cat))
        
        temp1.append(getcat(self,cat))
  
        for each in range(len(temp1)):
          for every in range(len(temp1[each])):
            temp1[each][every]=cat+'.'+temp1[each][every]+"(Meta Type)"
        
        res.append(getotsofcat(self,cat))
        
        if res==[]:
          return "The Metatype has no sub Metatypes or ObjectTypes"
  
        temp2.append(getotsofcat(self,cat))
        for each in range(len(temp2)):
          for every in range(len(temp2[each])):
            temp2[each][every]=cat+'.'+temp2[each][every]+"(Object Type)"
        
       
  
  
  
        one.append(temp1)
        one.append(temp2)
  
  
        final.append(res)
  
        temp1=[]
        temp2=[]
        objects=[]
       
        while(1):
        
          if res==[]:
            break
  
          temp1=[]
          temp2=[]
  
          for x in range(len(res)):
            for y in range(len(res[x])):
              if getcat(self,res[x][y])!= 1 :
                   res1.append(getcat(self,res[x][y]))
                   temp1.append(getcat(self,res[x][y]))
  
                   for each in range(len(temp1)):
                     for every in range(len(temp1[each])):
  
                       me=res[x][y]+'.'+temp1[each][every]+"(Meta Type)"
                       one.append(me)
                       
  
             
              if getot(self,res[x][y])!= 1 :
                res1.append(getot(self,res[x][y]))
                temp2.append(getot(self,res[x][y]))
                for each in range(len(temp2)):
                     for every in range(len(temp2[each])):
                       me=res[x][y]+'.'+temp2[each][every]+'(Object Type)'
                       one.append(me)
              if getobjofot(self,res[x][y])!=1:
                objects.append(getobjofot(self,res[x][y]))
  
                for each in range(len(objects)):
                     for every in range(len(objects[each])):
                             me=res[x][y]+'.'+objects[each][every]+"(Objects)"
                             one.append(me)
              objects=[]   
               
              temp2=[]              
  
              if getotsofcat(self,res[x][y])!= 1 :
                res1.append(getotsofcat(self,res[x][y]))
                temp2.append(getotsofcat(self,res[x][y]))
                for each in range(len(temp2)):
                     for every in range(len(temp2[each])):
                       me=res[x][y]+'.'+temp2[each][every]+'(Object Type)'
                       one.append(me)
  
  
          final.append(res1)
       
          res=[]
          if res1==[]:
           break
          temp1=[]
          temp2=[]
          for x in range(len(res1)):
            for y in range(len(res1[x])):
              if getcat(self,res1[x][y])!= 1 :
                   res.append(getcat(self,res1[x][y]))
                   temp1.append(getcat(self,res1[x][y]))
  
                   for each in range(len(temp1)):
                     for every in range(len(temp1[each])):
                       me=res1[x][y]+'.'+temp1[each][every]+"(Meta Type)"
                       one.append(me)
                  
  
  
  
                 
              if getot(self,res1[x][y])!= 1 :
                res.append(getot(self,res1[x][y]))
                temp2.append(getot(self,res1[x][y]))
                for each in range(len(temp2)):
                     for every in range(len(temp2[each])):
                       me=res1[x][y]+'.'+temp2[each][every]+'(Object Type)'
                       one.append(me)
              if getobjofot(self,res1[x][y])!=1:
                objects.append(getobjofot(self,res1[x][y]))
                temp=res1[x][y]
                for each in range(len(objects)):
                     for every in range(len(objects[each])):
                             me=temp+'.'+objects[each][every]+"(Objects)"
                             one.append(me)
                 
  
              if getotsofcat(self,res1[x][y])!= 1 :
                res.append(getotsofcat(self,res1[x][y]))
                temp=res1[x][y]
                temp2.append(getotsofcat(self,res1[x][y]))
                for each in range(len(temp2)):
                     for every in range(len(temp2[each])):
                       me=res1[x][y]+'.'+temp2[each][every]+'(Object Type)'
                       one.append(me)
  
  
          temp1=[]
          temp2=[]
          final.append(res)
       
          res1=[]   
        return one 
        return final
     
  #########################################################
  
  def gettreeobjecttype(self,ot):
  
  
       
        final=[]
        res=[]
        res1=[]
        one=[]
        stack=[]
        
  
        res.append(getot(self,ot))
        if res==[]:
          return "No sub-objectTypes of  this ObjectType"
  
       
        for each in range(len(res)):
          for every in range(len(res[each])):
            me=ot+'.'+res[each][every]
            one.append(me)
        final.append(res)
       
        while(1):
        
          if res==[]:
            break
  
          for x in range(len(res)):
            for y in range(len(res[x])):
  
              if getot(self,res[x][y])!= 1 :
                res1.append(getot(self,res[x][y]))
  
                temp=res[x][y]
                stack.append(getot(self,res[x][y]))
                for each in range(len(stack)):
                    for every in range(len(stack[each])):
                             me=temp+'.'+stack[each][every]
                             one.append(me)
                stack=[]
          final.append(res1)
     
          res=[]
          if res1==[]:
            break
          for x in range(len(res1)):
            for y in range(len(res1[x])):
              if getot(self,res1[x][y])!= 1 :
                res.append(getot(self,res1[x][y]))
                temp=res1[x][y]
                stack.append(getot(self,res1[x][y]))
                for each in range(len(stack)):
                    for every in range(len(stack[each])):
                             me=temp+'.'+stack[each][every]
                             one.append(me)
                stack=[]
                  
          final.append(res)
     
          res1=[]   
        return one  
        return final  
     
    
  
  
  ######################################################################################################
  
  def listPGQLfunc(self):
  
    ''' Lists all the functions of the PGQL '''
  
    list=[
      
    "                        List Of PGQL Functions                                                           ",
    "                                                                                                        ",
    "        1. count ('Id', 'Type', 'RequiredTypeofType')                                                   ",
    "        2. countAll('Type')                                                                             ",
    "        3. getAll('Type')                                                                               ",
    "        4. getAllAttributeTypeofCategory('Category')                                                    ",
    "        5. getAllProperties('Id','Type')                                                                ",
    "        6. getAllRelationTypeofCategory('Category')                                                     ",
           " 7. getAnyProperty('Id','Type','Property')                                                       ",
           " 8. getListWithGivenAttributeValue('Type', [attributename=attval],' mode')                       ",
           " 9. getMathFunction('Type', 'Attribute','Function')                                              ",
           " 10.getObjectTypeofCategory('Category')                                                          ",
           " 11.getObjectofCategory('Category')                                                              ",
           " 12.getObjectsofObjectType('ObjectType')                                                         ",
           " 13.getPropertyValues('Type', [list of Properties])                                              ",
           " 14.getRange('Type','Attribute', '1stOperator','value','2ndOperator','value')                    ",
           " 15.getRelationsofRelationType('RelationType')                                                   ",
           " 16.getSubCategoryofCategory('Category')                                                         ",
           " 17.getSubObjectTypeofObjectType('ObjecType')                                                    ",
           " 18.getTreeOfObjectType('Id')                                                                    ",
           " 19.getTreeOfMetaType('Id')                                                                      ",
           " 20.groupby('Type', [List of Attributes],'groupby')                                              ",
           " 21.listCategoricalRelation('Category or ObjectType')                                            ",
           " 22.listObjectWithAttributes('Type', [List of Attributes],'Mode')                                ",
           " 23.listRelationTypeof('ObjectType or Object')                                                   ",
           " 24.listRelationsWithRoles('Id of Lrole','Id of Rrole')                                          ",
           " 25.listReltionsof('TypeId')                                                                     ",
           " 26.listRoles('TypeId')                                                                          ",
           " 27.listPGQLFunctions()                                                                           ",
           " 28.listManageFunctions()                                                                        ",
           " 29.orderBy('Type', [list of Attribute Required],'Orderby')                                      ",
           "                                                                                                 "]
    return list         
       
           
  def listManagefunc(self):
           
     """ List of All Manage Functions """
     
     list=["                              List of Add Functions                                           ",
           "                                                                                              ",
           " 1. addMetaType('Id','BaseName',[Parent MetaType],'Description')                              ",
           " 2. addObjectType('Id','BaseName',[Parent MetaType],[Parent ObjectType],'Description')        ",
           " 3. addObject('Id','BaseName',[Parent ObjectType],'Description')                              ",
           " 4. addAttributeType('Id','BaseName','DataType',[MetaType],'Description')                     ",
           " 5. addAttribute('Type','TypeId','AttName','Scope','FillMode','AttributeValue')               ",
           " 6. addMetaTypeRelation('Id','BaseName','Btw',[LRoles],[RRoles],Constraint,Reflexive,Transitive,Symmetric'                                                                                                 ",
           " 7. addRelationType('Id','BaseName','AlternateName','InverseName',[MetaType],'Btw',[LRoles],[RRoles],'Constraint','Reflexive','Transitive','Symmetric','Necessary')                                        ",
           " 8. addRelation('RelationTypeId',[LRoles],[RRoles],'Constraint')                              ",
           "                                                                                              ",
           "                              List of Edit Functions                                          ",
           "                                                                                              ",
           " 1. editMetaType,('Id','AttName','Scope','FillMode','AttributeValue')                         ",
           " 2. editObjectType('Id','AttName','Scope','FillMode','AttributeValue')                        ",
           " 3. editObject('Id','AttName','Scope','FillMode','AttributeValue')                            ",
           " 4. editRelationType('Id','AttName','AttributeValue')                                         ",
           " 5. editMetaTypeRelation('Id','AttName','AttributeValue')                                     ",
           "                                                                                              ",
           "                              List of Delete Functions                                        ",
           "                                                                                              ",  
           " 1. deleteMetaType('Id')                                                                      ",
           " 2. deleteObjectType('Id')                                                                    ",
           " 3. deleteObject('Id')                                                                        ",
           " 4. deleteRelationType('Id')                                                                  ",
           " 5. deleteRelation  ('Id')                                                                    ",
           " 6. deleteMetaTypeRelation('Id')                                                              ",
           " 7. deleteAttributeType('Id')                                                                 ",
           " 8. deleteAttribute('Type','Id','AttributeName')                                              "]
  
     return list
     
                
manage_addnewPGQLForm = DTMLFile('dtml/addnewPGQLform', globals())
  
def manage_addnewPGQL(dispatcher, id, REQUEST=None):
      """
      Add New PGQL
      """
      dest = dispatcher.Destination()
      id = string.replace(id,' ','')
      dest._setObject(id, PGQL(id))
     
#      PATH = dispatcher.InstancePath + id
#      PGQLRef = dest.restrictedTraverse( PATH )
  
#      PGQLRef.index_object()    
      REQUEST.RESPONSE.redirect("<html><body>PGQL instance Added</body></html>")
      return id
  
  
############################################################################################################
  
InitializeClass(PGQL)
  
