#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from OFS import DTMLMethod
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.PropertySheets import PropertySheet
from OFS.FindSupport import FindSupport

from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo

from Globals import InitializeClass, DTMLFile
from Globals import Persistent

from Products.ZCatalog.CatalogAwareness import CatalogAware

# the import statement is written by Chitra
from OFS.Image import File

import Products.PythonScripts, Globals

import os
import string

file_path = Globals.package_home(globals())

def attributeaddMetaType(self,ft,scope,fillmode,attributeval):
      """
      This script is used for adding Attibutes
      """
      ctmp=[]
      otmp=[]
      token=0
      ctmp=self.Defined
      otmp=self.Possible
      if scope=='Defining':
         for a in ctmp:
       	     if a==ft:
		token=1
		break
             else: 
		token=0
	 if token==0:  
	    for a in otmp:
	      if a==ft:
		self.Possible.remove(a)
		break
            self.Defined.append(ft)
      elif scope=='Possible':
          for a in otmp:
       	     if a==ft:
		token=1
		break
             else: 
		token=0
	  if token==0:
             for a in ctmp:
		if a==ft:
		  self.Defined.remove(a)
		  break
	     self.Possible.append(ft)

      mandatory=[]
      optional=[]
      token=0
      mandatory=self.Mandatory
      optional=self.Optional
      if fillmode=='Mandatory':
         for a in mandatory:
       	     if a==ft:
		token=1
		break
             else: 
		token=0
	 if token==0:  
	    for a in optional:
	      if a==ft:
		self.Optional.remove(a)
		break
            self.Mandatory.append(ft)
      elif fillmode=='Optional':
          for a in optional:
       	     if a==ft:
		token=1
		break
             else: 
		token=0
	  if token==0:
             for a in mandatory:
		if a==ft:
		  self.Mandatory.remove(a)
		  break
	     self.Optional.append(ft)

      if self.hasProperty(ft)>0:
             self._updateProperty(ft,attributeval)
      else:
	     PATH = self.InstancePath + 'Data/AttributeTypes/' + ft
	     attribute = self.restrictedTraverse(PATH)
	     Type1 = ['float','int','long']
	     Type2 = ['boolean']
	     Type3 = ['lines','string','text','tokens','selection','multiple selection']

	     defAttributeValue = attributeval
	     if defAttributeValue is not None:
                  attributeDataType = attribute.getProperty('datatype')
   	          self.manage_addProperty(ft, defAttributeValue, attributeDataType, REQUEST=None)
	     else:
                attributeDataType = attribute.getProperty('datatype')
                if attributeDataType in Type1:
                    defAttributeValue = 0
                elif attributeDataType in Type2:
                    defAttributeValue = 0
                elif attributeDataType in Type3:
                    defAttributeValue = ''                
                self.manage_addProperty(ft,defAttributeValue,attributeDataType,REQUEST=None)
      self.reindex_object()

# the ZopePageTemplate is added instead of the ObjectManager, PropertyManager, RoleManager & Item by Chitra
#ZopePageTemplate
class MetaType(File,
                  FindSupport,
                  CatalogAware):
    """
    MetaType implementation.
    """
    meta_type = "GMetaType"

    _properties = (
        {'id':'BaseName', 'type': 'ustring', 'mode': 'w'},
        {'id':'PMetaType', 'type': 'ulines', 'mode': 'w'},
        {'id':'Description', 'type': 'utext', 'mode': 'w'}, 
        {'id':'Status','type':'ustring','mode':'w'},
	{'id':'Defined','type':'ulines','mode':'w'},
        {'id':'Possible','type':'ulines','mode':'w'},
	{'id':'Mandatory','type':'ulines','mode':'w'},
	{'id':'Optional','type':'ulines','mode':'w'},
	{'id':'child_metatypes','type':'ulines','mode':'w'},
	{'id':'child_objecttypes','type':'ulines','mode':'w'},        
     )
#  the changes are made by Hussain 
    manage_options = (
          ) + File.manage_options
          
    def __init__(self,id,BaseName,PMetaType,Description,Defined,Possible,Mandatory,Optional):
        self.id=id
        self.BaseName=BaseName
        self.PMetaType=PMetaType
	self.Description=Description
	self.Defined=Defined
        self.Possible=Possible 
	self.Mandatory=Mandatory
	self.Optional=Optional
        self.child_metatypes = []
        self.child_objecttypes = []        
        self.Status='Public'
        #Variables added by hussain to incorporate changes that needed MetaType to behave as file Object
        self.content_type="text/html"
        self.data=""

# the comment is made by Chitra as the index_html is removed
#        addDTML(self,'index_html',BaseName,'dtml/mt_index_html')

    def editMetaType(self,RESPONSE,URL1,URL2,REQUEST=None):
        """
        This method updates properties of MetaType after edition of the MetaType.
        """ 

	id = REQUEST['id']
        BaseName=REQUEST['BaseName']
        Description=REQUEST['Description']

	if len(BaseName) == 0:
	   BaseName = id

	self._updateProperty('BaseName',BaseName)
	self._updateProperty('Description',Description)

        self.reindex_object()

        nm="MetaType"
        REQUEST.set('newnm',nm)
	REQUEST.set('newid',BaseName)

	REQUEST.RESPONSE.redirect(self.surl + '/Programs/replyedit?newid=%s&newnm=%s' % (BaseName,nm))
        return

    def catAttributeadd(self, REQUEST=None):
        """
	This script is used for adding Attibutes to MetaType.
        """
        
        ft = REQUEST['ft']
        attributeval = REQUEST['attributeval']
	scope=REQUEST['scope']
	fillmode=REQUEST['fillmode']
        eflag=REQUEST['log']
        
        attributeaddMetaType(self,ft,scope,fillmode,attributeval)

	filen1 = ''
	tmp='T'

        if eflag=='Edit':
              self.REQUEST.RESPONSE.redirect('manage_CatEditform?val=%s' % tmp)
        else:
              filen1 ='manage_CatAttributemainform'
              self.REQUEST.RESPONSE.redirect(filen1)

    def catCheckattribute(self,REQUEST):
        """
        This will check the fillmode field of ObjectType with that of Object to check for the NULL value given to Mandatory Object.
        """
	newid=self.id
        ft = REQUEST['ft']
        attributeval = REQUEST['attributeval']
	scope=REQUEST['scope']
	fillmode=REQUEST['fillmode']

	if fillmode=='Mandatory':      
		tmp=[]
	        otlist=[]		
	        tmpclist=[]
		mtlist=[]

                otlist=self.Data.ObjectType.objectIds()
               	if otlist<>[]:
                   for i in otlist:
##############################################################################################
#                         the following lines r added by hitesh
                          ot_hashed_list_ref=self.restrictedTraverse(self.InstancePath + 'Data/ObjectType' + '/' + i + '/')
                          ot_hashed_list = ot_hashed_list_ref.objectIds()
##############################################################################################                          
                          for k in ot_hashed_list :
                                 OTPATH = self.InstancePath + 'Data/ObjectType/' + i + '/' + k
                                 otref = self.restrictedTraverse( OTPATH )
                                 mtlist=otref.getProperty('PMetaType')
                                 for j in mtlist:
	                                if j==newid:
				              tmp=otref.getProperty('Optional')
                                              if ft in tmp:
					             tmpclist.append(k)
                                	             tmpstr=string.join(tmpclist)
			                             REQUEST.RESPONSE.redirect(self.surl + '/Programs/DisplayObjectofCat?olist=%s' % tmpstr)
		                              else:
			                             attributeaddMetaType(self,ft,scope,fillmode,attributeval)
			       	                     REQUEST.RESPONSE.redirect('manage_CatEditform?newid=%s' % newid)
        else:
              attributeaddMetaType(self,ft,scope,fillmode,attributeval)
              REQUEST.RESPONSE.redirect('manage_CatEditform?newid=%s' % newid)



    def removeattribute(self,REQUEST):
        """
        This will remove the property which is being used as attribute.
        """
        Attibutes = REQUEST['attributelist']
	tmpPossible=[]
	tmpDefined=[]
	tmpPossible=self.getProperty('Possible')
	tmpDefined=self.getProperty('Defined')

	for fc in Attibutes:
		for tmpfc in tmpPossible:
			if fc==tmpfc:
			   tmpPossible.remove(tmpfc)
		for tmpfc in tmpDefined:
			if fc==tmpfc:
			   tmpDefined.remove(tmpfc)
	
	self._updateProperty('Possible',tmpPossible)
	self._updateProperty('Defined',tmpDefined)

	tmpopt=[]
	tmpmand=[]
	tmpopt=self.getProperty('Optional')
	tmpmand=self.getProperty('Mandatory')

	for fc in Attibutes:
		for tmpfc in tmpopt:
			if fc==tmpfc:
			   tmpopt.remove(tmpfc)
		for tmpfc in tmpmand:
			if fc==tmpfc:
			   tmpmand.remove(tmpfc)
	
	self._updateProperty('Optional',tmpopt)
	self._updateProperty('Mandatory',tmpmand)
			
        self.manage_delProperties(Attibutes)
	self.reindex_object()
        REQUEST.RESPONSE.redirect(self.surl + '/Programs/attributedels')
	
    def catRemovelist(self,ul,objTT,REQUEST=None):
        """
	Used for editing Membership of MetaType
        """
        itbinit=ul
	itb2=string.replace(itbinit,"['","")
	itb3=string.replace(itb2,"']","")
	itb4=string.replace(itb3,"', '"," ")
	itbfin=[]
	itbfin=string.split(itb4," ")
	itafin=objTT
	nTT=filter(lambda x,itafin=objTT: x not in itafin,itbfin)
	self._updateProperty('PMetaType',nTT)
	self.reindex_object()
	self.REQUEST.RESPONSE.redirect(self.surl + '/Catmembership')

    def deleteMetaType(self,REQUEST,RESPONSE,URL1,URL2):
        """
        Deletes the requested MetaType.
        """
	id = REQUEST['id']
        BaseName=REQUEST['BaseName']
	if len(BaseName)==0:
	   BaseName = id

# updates neighbourhood information
        PATH = self.InstancePath + 'Data/MetaType/'
        for each in self.Catalog():
              if each.meta_type=='GMetaType':
                    if each.id == id:
                          for xCat in each.PMetaType:
                                pMetaTypeRef = self.restrictedTraverse( PATH + xCat )
                                childMetaTypeList = pMetaTypeRef.getProperty( 'child_metatypes' )
                                if id in childMetaTypeList:                                
                                      childMetaTypeList.remove(id) 
                                      pMetaTypeRef._updateProperty('child_metatypes',childMetaTypeList)
                                      pMetaTypeRef.reindex_object()          

	self.Data.MetaType.manage_delObjects(id)
	self.unindex_object()

       # following two lines remove content file from file system.
        contentFile = os.path.normpath(CLIENT_HOME + '/GContent' + self.InstancePath +'Data/MetaType')
        list_files = os.listdir(contentFile)
        #looping over the list to check wether the file containing the content of this object exist
        #this is done by checking only the filename with the id of the object ignoring the extension
        for file in list_files:
              if self.id == os.path.splitext(file)[0]: #Checking the filename with the id of the Object
                    #Removing the contents file from the filesystem
                    os.remove(contentFile + os.sep +  file)

        nm="MetaType"
 	REQUEST.set('newnm',nm)
	REQUEST.set('newid',BaseName)

        REQUEST.RESPONSE.redirect( self.surl + '/Programs/replydelete?newid=%s&newnm=%s' % (BaseName,nm))

    def catUpdateunsel(self,REQUEST):
         """
	 Used for editing Membership of MetaType
         """
         list_of_ids=[]
         list_of_ids = self.Data.MetaType.objectIds()
         b=[]
         b=self.PMetaType
         a=list_of_ids
         oTT=filter(lambda x,b=self.PMetaType: x not in b,a)
         return oTT 

# Factory methods

manage_addnewMetaTypeForm = DTMLFile('dtml/addnewMetaTypeform', globals())

def manage_addnewMetaType(dispatcher, id, REQUEST=None):
    """
    Add New MetaType
    """
    dest = dispatcher.Destination()
    id = string.replace(id,' ','')
    BaseName=REQUEST['BaseName']
    if len(BaseName)==0:
	BaseName = id
    PMetaType=REQUEST['PMetaType']
    Description=REQUEST['Description']

    Defined=[]
    Possible=[]
    Mandatory=[]
    Optional=[]
	
    dest.Data.MetaType._setObject(id, MetaType(id,BaseName,PMetaType,Description,Defined,Possible,Mandatory,Optional))
   
    PATH = dispatcher.InstancePath
    PATH1= PATH + 'Data/MetaType/' + id
    metaTypeRef = dest.restrictedTraverse( PATH1 )
    attributeaddMetaType(metaTypeRef,'path','Defining','Optional',PATH + 'Programs/Data/MetaType/' + id + '/viewMetaType')
    #attributeaddMetaType(metaTypeRef,'www','Defining','Optional','www')
    #attributeaddMetaType(metaTypeRef,'ftp','Defining','Optional','ftp')
    #attributeaddMetaType(metaTypeRef,'file','Defining','Optional','file')
    parentMetatypes=metaTypeRef.getProperty('PMetaType')

    for i in parentMetatypes:
	    parentMetaTypePath = PATH + 'Data/MetaType/' + i
	    parentMetaTypeRef= metaTypeRef.restrictedTraverse( parentMetaTypePath )

	    mandatoryValues=[]
	    optionalValues=[]

	    mandatoryValues=parentMetaTypeRef.getProperty('Mandatory')
	    optionalValues=parentMetaTypeRef.getProperty('Optional')	

	    for i in mandatoryValues:
                if i not in metaTypeRef.Mandatory:
			metaTypeRef.Mandatory.append(i)
			if i in metaTypeRef.Optional:
				metaTypeRef.Optional.remove(i)
	    for i in optionalValues:
		if i not in metaTypeRef.Optional and  i not in metaTypeRef.Mandatory:
        		metaTypeRef.Optional.append(i)

	    DefinedValues=[]
	    PossibleValues=[]
	    DefinedValues=parentMetaTypeRef.getProperty('Defined')
	    PossibleValues=parentMetaTypeRef.getProperty('Possible')	
	    for i in DefinedValues:
                if i not in metaTypeRef.Defined:
			metaTypeRef.Defined.append(i)
			if i in metaTypeRef.Possible:
				metaTypeRef.Possible.remove(i)
	    for i in PossibleValues:
		if i not in metaTypeRef.Possible and  i not in metaTypeRef.Defined:
        		metaTypeRef.Possible.append(i)

    ############################################################
    #This code maintains the MetaType counter of the instance.
    instancePath = string.replace( dest.InstancePath + 'Remove', '/Remove', '' )
    instanceRef = dest.restrictedTraverse( instancePath )
    metatypeCounter = instanceRef.getProperty( 'metatypes' )
    metatypeCounter = metatypeCounter + 1
    instanceRef._updateProperty('metatypes',metatypeCounter )
    totalCounter = instanceRef.getProperty( 'total')
    totalCounter= totalCounter + 1
    instanceRef._updateProperty('total',totalCounter )
    ############################################################

    ##############################################################
    #This code maintains the neighborhood information.
    PATH = dest.InstancePath + 'Data/MetaType/' 
    for xCat in PMetaType:
          pMetaTypeRef = dest.restrictedTraverse( PATH + xCat )          
          childMetaTypeList = list(pMetaTypeRef.getProperty( 'child_metatypes' ))
          childMetaTypeList.append(id) #insert( len(PMetaType), id )
          pMetaTypeRef._updateProperty('child_metatypes',childMetaTypeList)
          pMetaTypeRef.reindex_object()          
    #############################################################

    metaTypeRef.index_object()
#    REQUEST.set('BaseName',BaseName)
#    REQUEST.set('Id',id)        
    
#    REQUEST.RESPONSE.redirect(dest.surl + '/Programs/Data/MetaType/' + id  + '/addContent?Id=%s&BaseName=%s' % (id,BaseName))
    REQUEST.RESPONSE.redirect(dest.surl + '/Programs/Data/MetaType/' + id  + '/addContent')		
    return id

def addDTML(obj,id,title,file):
	f=open(file_path+'/'+file+'.dtml')
	file=f.read()
	f.close()
	obj.manage_addDTMLMethod(id,title,file)
	return getattr(obj,id)

InitializeClass(MetaType)
