######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from xml.sax import make_parser
import xml.sax.handler

import Products.PythonScripts, Globals
from Products.GNOWSYS06.ObjectType import ObjectType
from Products.GNOWSYS06.RelationType import AssocT
from Products.GNOWSYS06.Object import Object
from Products.GNOWSYS06.AttributeType import attributetype
from Products.GNOWSYS06.Relation import Assoc

from Products.PythonScripts.PythonScript import *
from Products.ZCatalog.CatalogAwareness import CatalogAware
from Products.ZCatalog.Catalog import Catalog

from Globals import InitializeClass, DTMLFile
from Globals import HTMLFile
from Globals import Persistent

import os
import string
import sys

"A class to import XML topic maps data to the GNOWSYS data folder.__doc__"
gTopicTypeList=[]
gAnAssocType={} #will have a structure of this form{id:' ',LRoles:' ',RRoles:' '}
gAssocTypeList=[] #will sore all the relation types
gAssocTypeIDList=[] #to store only the ids of relation Type which are stored in gAssocTypeList
gAttributeTypeList=[]
gPSIList=['object','objectType','relation','relationType','occurrence','occurrenceType','attributeType']

class InstanceHandler(xml.sax.handler.ContentHandler):  
  inMap=0
  inTopic=0
  inInstance=0
  inRData=0
  inRRef=0
  inAssoc=0
  inMember=0
  inRole=0
  memCount=0 #to keep track of whether it is left memeber or right member in relation
  titlink=""
  oitlink=""
  aitlink=""
  
  def startElement(self, name, attrs):
    if name=="topicMap":
      self.inMap=1
    elif self.inMap:  
      if name=="topic":
        self.id=attrs.get("id","")
        self.inTopic=1
      elif self.inInstance:
          if name=="topicRef":
            self.titlink=attrs.get("xlink:href","")
            self.titlink=string.replace(self.titlink,'#','')
            self.makeTopicInstanceList()
            self.inInstance=0
          elif name=="resourceData":
            self.inRData=1
            self.makeAttributeInstanceList()
      elif name=="relation":
        self.inAssoc=1
	self.memCount=0
      elif self.inAssoc:
        if name=="instanceOf":
          self.inAInstance=1
        elif self.inAInstance:
          self.aitlink=attrs.get("xlink:href","")
          self.aitlink=string.replace(self.aitlink,'#','')
          self.inAInstance=0 
        elif name=="member":
          self.memCount+=1;
          self.inMember=1
        elif self.inMember:
          if name=="roleSpec":
            self.inRole=1
          elif self.inRole:
            if name=="topicRef" or name=="subjectIndicatorRef":
              if self.memCount==1:
                self.amrtLeftlink=attrs.get("xlink:href","")
                self.amrtLeftlink=string.replace(self.amrtLeftlink,'#','')
              elif self.memCount==2:
                self.amrtRightlink=attrs.get("xlink:href","")
  		self.amrtRightlink=string.replace(self.amrtRightlink,'#','')      

  def endElement(self,name):
    if name=="topic":
      self.inTopic=0
    if name=="relation":
      self.inAssoc=0
      self.makeAssocInstanceList()
      self.aitlink=""
      self.amrtLeftlink=""
      self.amrtRightlink=""
    if name=="instanceOf":
      self.inInstance=0
      self.inOInstance=0
      self.inAInstance=0
    if name=="member":
      self.inMember=0
    if name=="roleSpec":
      self.inRole=0   
    if name=="topicMap":
      pass
      
  def makeTopicInstanceList(self):
    found=0
    if self.titlink in gPSIList:
      found=1
      self.changeInstanceList()
    for link in gTopicTypeList:
      if link==self.titlink:
        found=1
    if found==0:        
      gTopicTypeList.append(self.titlink)
   
  def makeAttributeInstanceList(self):
    found=0
    if self.oitlink<>"":
      for link in gAttributeTypeList:
        if link==self.oitlink:
          found=1
      if found==0:        
        gAttributeTypeList.append(self.oitlink)
     
  def makeAssocInstanceList(self):
    found=0
    for link in gAssocTypeIDList:
      if link==self.aitlink:
        found=1
    if found==0:
      gAnAssocType={'id':self.aitlink,'LRoles':self.amrtLeftlink,'RRoles':self.amrtRightlink}        
      gAssocTypeList.append(gAnAssocType)
      gAssocTypeIDList.append(self.aitlink)
      
#the following function is used to make changes in the instancelist if required
# say a particular id has gone into some wrong instancelist

  def changeInstanceList(self):
    self.id=string.strip(self.id)
    if self.titlink=='objectType':
      if self.id not in gTopicTypeList:
        gTopicTypeList.append(self.id)
    if self.titlink=='attributeType':
      if self.id not in gAttributeTypeList:
        gAttributeTypeList.append(self.id)
      if self.id in gTopicTypeList:
        gTopicTypeList.remove(self.id)
      if self.id in gTopicTypeList:
        gTopicTypeList.remove(self.id)
      if self.id in gAttributeTypeList:
        gAttributeTypeList.remove(self.id)
    if self.aitlink=='relationType':
      if self.id not in gAssocTypeIDList:
        gAssocTypeList.append(self.id)

class ImportHandler(xml.sax.handler.ContentHandler):
  
  "The following are the initialization for the data structures which are used to store data as the XTM document is parsed"
  inMap=0
  inTopic=0
  inAssoc=0  
  inOInstance=0
  inBaseName=0
  inVariant=0
  inParam=0
  inVariantName=0
  anObject={}
  anObjectType={}
  anRelation={}
  anRelationType={}
  aAttributeType={}
  objects=[]
  objectTypes=[]
  relations=[]
  relationTypes=[]
  attributeTypes=[]
  topicType=""
  inSubid=0
  inMember=0
  inInstance=0
  inVRData=0
  baseName=""
  sortName=""
  displayName=""
  templink=""
  tempOccDict={'id':'','value':''}
  "The following is the complete structure required to store the XTM data"

  XTMDict={'Objects':objects,'Object Types':objectTypes,'Relation':relations,'Relation Types':relationTypes,'Attribute Types':attributeTypes}

  def checkType(self,flag=""):
     if self.id in gAssocTypeIDList:
       self.topicType="anRelationType"
     elif self.id in gTopicTypeList:
       self.topicType="anObjectType"
     elif self.id in gAttributeTypeList:
       self.topicType="aAttributeType"
     elif flag=="relation":
       self.topicType="anRelation"
     else:
       self.topicType="anObject"
   
  def startElement(self, name, attrs):
    self.inBaseNameString=0
    if name=="topicMap":
      self.inMap=1
      self.titlink=[]  #for links in topic-instancOf-topicRef
      self.tislink=[]  #for links in topic-instancOf-subjectIndicatorRef
      self.tstlink=[]  #for links in topic-subjectIdentity-topicRef
      self.tsslink=[]  #for links in topic-subjectIdentity-subjectIndicator
      self.tsrlink=""  #for link  in topic-subjectIdentity-resourceRef
      self.tbvptlink=[]#for links in topic-baseName-variant-parameters-topicRef
      self.tbvpslink=[]#for links in topic-baseName-variant-parameters-subjectIndicatorRef
      self.tbvrlink=[] #for links in topic-baseName-variantName-resourceRef
      self.aitlink=""  #for link  in relation-instancOf-topicRef
      self.aislink=""  #for link  in relation-instancOf-subjectIndicatorRef
      self.amrtLeftlink="" #for links in relation-member-roleSpec-topicRef-LRole
      self.amrtRightlink="" #for links in relation-member-roleSpec-topicRef-RRole
      self.amrslink="" #for links in relation-member-roleSpec-subjectIndicatorRef
      self.amrLeftlink=[]  #for links in relation-member-topicRef-LObject
      self.amrRightlink=[]  #for links in relation-member-topicRef-RObject
      self.amtlink=[]  #for links in relation-member-topicRef
      self.amslink=[]  #for links in relation-member-subjectIndicatorRef
      self.inInstance=0
      self.gAttributelink=[]
      self.gOcclink=[]
      self.inRData=0
      self.tAttributelink=[]
      self.tOcclink=[]
      self.occRef=""
      self.oId="" 
    elif self.inMap:  
      if name=="topic":
        self.id=string.strip(attrs.get("id",""))
        self.inTopic=1
      elif self.inInstance:
          if name=="topicRef":
            self.titlink.append(string.replace(attrs.get("xlink:href","") ,'#',''))
            self.inInstance=0
          elif name=="subjectIndicatorRef":
            self.tislink.append(string.replace(attrs.get("xlink:href",""),'#',''))
            self.inInstance=0
          elif name=="subjectIdentity":
            self.inSubid=1
          elif self.inSubid:
            if name=="resourceRef":
               self.tsrlink=attrs.get("xlink:href","") 
               self.tsrlink=string.replace(self.tsrlink,'#','')
            if name=="topicRef":
               self.tstlink.append(string.replace(attrs.get("xlink:href",""),'#',''))
            elif name=="subjectIndicatorRef":
               self.tsslink.append(string.replace(attrs.get("xlink:href",""),'#',''))
          elif name=="baseName":
            self.inBaseName=1
          elif self.inBaseName:
            if name=="baseNameString":
              self.inBaseNameString=1
          elif name=="variant":
            self.inVariant=1;
          elif self.inVariant:
            if name=="parameters":
              self.inParam=1
            elif self.inParam:
              if name=="topicRef":
                self.templink=attrs.get("xlink:href","")
                self.templink=string.replace(self.templink,'#','')
                self.tbvptlink.append(self.templink)
              elif name=="subjectIndicatorRef":
                self.templink=attrs.get("xlink:href","")
 		self.templink=string.replace(self.templink,'#','')
                self.tbvpslink.append(self.templink)
            elif name=="variantName":
              self.inVariantName=1
            elif self.inVariantName:
              if name=="resourceRef":
                self.tbvrlink=attrs.get("xlink:href","")
                self.tbvrlink=string.replace(self.tbvrlink,'#','')
                self.checkSortDisp() #checks if the resourceRef is for sortName or DisplayName
              elif name=="resourceData":
                self.inVRData=1
          elif self.inOInstance:
            if name=="topicRef":
              self.oId=attrs.get("xlink:href","")
              self.oId=string.replace(self.oId,'#','')
              self.tempOccDict={'id':self.oId,'value':'' }
              self.inOInstance=0
            elif name=="subjectIndicatorRef":
              self.oId=attrs.get("xlink:href","")
 	      self.oId=string.replace(self.oId,'#','')
              self.tempOccDict={'id':self.oId,value:''}
              self.topOrSub="sub"
              self.inOInstance=0
          elif name=="resourceData":
            self.inRData=1
          elif name=="resourceRef":
            self.occRef=attrs.get("xlink:href","")
            self.occRef=string.replace(self.occRef,'#','')
            self.tempOccDict['value']=self.occRef
            self.addPropertyLink()
      elif name=="relation":
        self.memCount=0 #if its value is 1 then,left member and if 2, then right member
        self.inAssoc=1
        self.aid=attrs.get("id","")
      elif self.inAssoc:
        if name=="instanceOf":
          self.inAInstance=1
        elif self.inAInstance:
          if name=="topicRef":
            self.aitlink=attrs.get("xlink:href","")
            self.aitlink=string.replace(self.aitlink,'#','')
            self.inAInstance=0
          elif name=="subjectIndicatorRef":
            self.aislink=attrs.get("xlink:href","")
            self.aislink=string.replace(self.aislink,'#','')
            self.inAInstance=0
        elif name=="member":
          self.memCount+=1;
          self.inMember=1
        elif self.inMember:
          if name=="roleSpec":
            self.inRole=1
          elif self.inRole:
            if name=="topicRef" or name=="subjectIndicatorRef":
              if self.memCount==1:
                self.amrtLeftlink=attrs.get("xlink:href","")
                self.amrtLeftlink=string.replace(self.amrtLeftlink,'#','')
              elif self.memCount==2:
                self.amrtRightlink=attrs.get("xlink:href","")
                self.amrtRightlink=string.replace(self.amrtRightlink,'#','')
          elif name=="resourceRef" or name=="topicRef" or name=="subjectIndicatorRef":
            if self.memCount==1:
              self.amrLeftlink=attrs.get("xlink:href","")
              self.amrLeftlink=string.replace(self.amrLeftlink,'#','')
            if self.memCount==2:
              self.amrRightlink=attrs.get("xlink:href","")
              self.amrRightlink=string.replace(self.amrRightlink,'#','')
      elif name=="mergeMap":
        pass

  def characters(self, characters):
    if self.inBaseNameString:
      self.baseName= characters
    if self.inVRData:
      if string.find(self.templink,'sort')!=-1:
        self.sortName= characters
      if string.find(self.templink,'display')!=-1:
        self.displayName= characters
    if self.inRData:
      self.tempOccDict['value']=characters
      self.addPropertyLink()
      
  def endElement(self,name):
    if name=="instanceOf":
      self.inInstance=0
      self.inOInstance=0
    if name=="subjectIdentity":
      self.inSubid=0
    
    if name=="baseNameString":
      self.inBaseNameString=0

    if name=="variant":
      self.inVariant=0

    if name=="parameters":
      self.inParam=0

    if name=="variantName":
      self.inVariantName=0
      
    if name=="resourceData":
      self.inVRData=0
      self.inRData=0

    if name=="topic":
      if self.id not in gPSIList:
        self.checkType()
        if self.topicType=="anObjectType":
          if 'objectType' in self.titlink:
            self.titlink.remove('objectType')

          self.anObjectType={'id':self.id,'baseName':self.baseName,'sortName':self.sortName,'displayName':self.displayName,'instanceOf':self.titlink,'attributes':self.tAttributelink}
          self.objectTypes.append(self.anObjectType)
        elif self.topicType=="anObject":
          if 'object' in self.titlink:
            self.titlink.remove('object')
          self.anObject={'id':self.id,'baseName':self.baseName,'sortName':self.sortName,'displayName':self.displayName,'instanceOf':self.titlink,'attributes':self.tAttributelink}
          self.objects.append(self.anObject)
        elif self.topicType=="anRelationType":
          self.getRoles() #to get the left and right roles from the gAssocTypeList
          self.anRelationType={'id':self.id,'baseName':self.baseName,'sortName':self.sortName,'displayName':self.displayName,'LRoles':self.lRole,'RRoles':self.rRole}
          self.relationTypes.append(self.anRelationType)
        elif self.topicType=="aAttributeType":
          self.aAttributeType={'id':self.id,'baseName':self.baseName,'sortName':self.sortName,'displayName':self.displayName,}
          self.attributeTypes.append(self.aAttributeType)
       
        self.titlink=[]
        self.tislink=[]
        self.tbvrlink=[]
        self.inTopic=0
        self.inInstance=0
        self.inBaseName=0
        self.sortName=""
        self.displayName=""
        self.lRole=""
        self.rRole=""
        self.tAttributelink=[]
    if name=="relation":
      self.checkType("relation")
      
      if self.topicType=="anRelation":
        if self.aid=="": #if the id doesn't exist, then generate one
          self.aid=string.replace(str(self.amrLeftlink),'#','')+'_'+string.replace(self.aitlink,'#','')+'_'+string.replace(str(self.amrRightlink),'#','')	

        self.anRelation={'id':self.aid,'instanceOf':self.aitlink,'LObjects':self.amrLeftlink,'RObjects':self.amrRightlink}
        self.relations.append(self.anRelation)
      
      self.inAssoc=0
      self.inAInstance=0
      self.amrLeftLink=[]
      self.amrRightLink=[]
      self.aid=""

    if name=="roleSpec":
      self.inRole=0
 
    if name=="member":
      self.inMember=0

    if name=="topicMap":
      for link in self.XTMDict.keys():
        for tlink in self.XTMDict[link]:
          pass
      
    if name=="baseName":
      self.inBaseName=0
    
    gXTMDict=self.XTMDict

  def checkSortDisp(self):
    if string.find(self.templink,'sort')!=-1:
      self.sortName=self.tbvrlink
    if string.find(self.templink,'display')!=-1:
      self.displayName= self.tbvrlink

  def getRoles(self):
    for link in gAssocTypeList:
      if link['id']==self.id:
       	self.lRole=link['LRoles']
        self.rRole=link['RRoles']

#this function adds to the occurrence or attribute list with the actual value

  def addPropertyLink(self):
    if self.oId in gAttributeTypeList:
      self.tAttributelink.append(self.tempOccDict)

def importXTMFile(self,filename):

  xtmfilename = REQUEST['xtmfilename']
  tgzfilename = REQUEST['tgzfilename']

  if os.path.exists(tgzfilename):
    tgzFilePath = CLIENT_HOME + '/GContent' + self.InstancePath		
    os.chdir(tgzFilePath)
    result = os.system('tar -xvzf ' + tgzfilename )
    if result!=0:
      return 'Error while extracting, Aborting Import'
  else:
      pass

  ch1=InstanceHandler()
  saxparser1=make_parser()
  saxparser1.setContentHandler(ch1)
  saxparser1.parse(xtmfilename)
  
  ch=ImportHandler()
  saxparser=make_parser()
  saxparser.setContentHandler(ch)
  saxparser.parse(xtmfilename)
  
  scr_id1=str(xtmfilename)
  ws = string.find(scr_id1,'\\')
  if ws!=-1:
    scr_idlist = scr_id1.split('\\')
  else:
    scr_idlist = scr_id1.split('/')
  scr_idlist.reverse()
  scr_id=scr_idlist[0]
  scr_id=string.replace(scr_id,'.','')

  manage_addPythonScript(self,scr_id)
  self._getOb(scr_id).write('XTMDict='+str(ch.XTMDict))  

  for link in ch.XTMDict.keys():
    if link=="Attribute Types":
      addAttributeTypes(self,ch.XTMDict[link])

  for link in ch.XTMDict.keys():
    if link=="Object Types":
      addObjectTypes(self,ch.XTMDict[link])
    
  for link in ch.XTMDict.keys():
    if link=="Objects":
      addObjects(self,ch.XTMDict[link])
  
  for link in ch.XTMDict.keys():
    if link=="Relation Types":
      addAssocT(self,ch.XTMDict[link])
  
  for link in ch.XTMDict.keys():
    if link=="Relation":
      addRelation(self,ch.XTMDict[link])

def addObjectTypes(self,OTList):
  Path = self.InstancePath
  Path = Path + 'Remove'
  Path = string.replace(Path,'/Remove','')
  for tlink in OTList:
        OTid=str(tlink['id'])
        OTid=string.replace(OTid,' ','')
        OTBaseName=str(tlink['baseName'])
        OTInstanceList=tlink['instanceOf']
	OTPMetaType=['MetaType']
	OTDescr=''
	OTDefined=[]
	OTPossible=[]
	OTManadatory=[]
	OTOptional=[]
        descrFlag=0
        
        anOT=ObjectType(OTid,OTBaseName,OTPMetaType,OTInstanceList,OTDescr,OTDefined,OTPossible,OTMandatory,OTOptional)
        if OTid not in('SystemObject','Role','Theme'):
          self.Data.ObjectType._setObject(OTid,anOT)
          addAttributes(self,anOT,tlink)
          RefPath = Path + '/Data/ObjectType/' + OTid
          Ref = self.restrictedTraverse(RefPath)          
          Ref.index_object()

def addAttributeTypes(self,FTList):
  Path = self.InstancePath
  Path = Path + 'Remove'
  Path = string.replace(Path,'/Remove','')
  for tlink in FTList:
    FTid=str(tlink['id'])
    FTid=string.replace(FTid,' ','')
    FTBaseName=str(tlink['baseName'])
    FTDataType=''
    descrFlag=0
    FTDescr=''
    FTMetaType='MetaType'
    
    if FTid!='Status':
      aFT=attributetype(FTid,FTBaseName,FTDataType,FTDescr,FTMetaType)
      self.Data.AttributeTypes._setObject(FTid,aFT)
      RefPath = Path + '/Data/AttributeTypes/' + FTid
      Ref = self.restrictedTraverse(RefPath)
      Ref.index_object()

def addAssocT(self,ATList):
  Path = self.InstancePath
  Path = Path + 'Remove'
  Path = string.replace(Path,'/Remove','')
  for tlink in ATList:
        ATid=str(tlink['id'])
	ATid=string.replace(ATid,' ','')
        ATBaseName=str(tlink['baseName'])
	ATLRoles = []
        #ATLRoles=tlink['LRoles']
        ATLRoles.append(tlink['LRoles'])
        checkLRole="add"
        roleList=self.Data.ObjectType.objectIds()
        #lroles=str(ATLRoles)
        lroles=ATLRoles[0]        
        if lroles not in roleList:
            checkLRole="not"
       
        checkRRole="add"
        ATRRoles = []
	#ATRRoles=tlink['RRoles']
        ATRRoles.append(tlink['RRoles'])        
        #rroles=str(ATRRoles)
        rroles=ATLRoles[0]        
        if rroles not in roleList:
            checkRRole="not"

	ATReflexive='Not Defined'
        ATTransitive='Not Defined'
        ATSymmetric='Not Defined'
        ATConstraint=0
        ATNecessary = 0
	ATFlag='OTOT'
	ATMetaType='MetaType'
        
        if checkLRole=="add" and checkRRole=="add":
          anAT=AssocT(ATid,ATBaseName,ATMetaType,ATLRoles,ATRRoles,ATReflexive,ATTransitive,ATSymmetric,ATConstraint,ATNecessary,ATFlag)
          self.Data.RelationTypes._setObject(ATid,anAT)
          RefPath = Path + '/Data/RelationTypes/' + ATid
          Ref = self.restrictedTraverse(RefPath)
          Ref.index_object()
         
def addObjects(self,ObjList):
  Path = self.InstancePath
  Path = Path + 'Remove'
  Path = string.replace(Path,'/Remove','')
  for tlink in ObjList:
        Objid=str(tlink['id'])
        Objid=string.replace(Objid,' ','')
        ObjBaseName=str(tlink['baseName'])
        ObjInstanceList=tlink['instanceOf']
        descrFlag=0
        if descrFlag==0:
          ObjDescr=''

	ObjManadatory=[]
	ObjOptional=[]

        checkFlag="add"	  
        listOt=self.Data.ObjectType.objectIds()
        for objType in ObjInstanceList:
          objType1=str(objType)
          if objType1 not in listOt:
            checkFlag="not"
        
        if checkFlag=="add":          
          anObj=Object(Objid,ObjBaseName,ObjInstanceList,ObjDescr,ObjManadatory,ObjOptional)
          if Objid !='Default':          
            self.Data.Objects._setObject(Objid,anObj)
            addAttributes(self,anObj,tlink)
            RefPath = Path + '/Data/Objects/' + Objid
            Ref = self.restrictedTraverse(RefPath)            
            Ref.index_object()

def addRelation(self,AssocList):
  Path = self.InstancePath
  Path = Path + 'Remove'
  Path = string.replace(Path,'/Remove','')
  for tlink in AssocList:
        Associd=str(tlink['id'])
	Associd=string.replace(Associd,' ','_')
        AssocBaseName=Associd

        AssocLobj=[]
	AssocRobj=[]
        AssocType=[]
        
        AssocLobj.append(tlink['LObjects'])
	AssocRobj.append(tlink['RObjects'])
        AssocType.append(tlink['instanceOf'])
        
        #AssocLobj=tlink['LObjects']
	#AssocRobj=tlink['RObjects']
        #AssocType=tlink['instanceOf']

        listAt=self.Data.RelationTypes.objectIds()
        
        checkFlag="add"
        Type=string.replace(AssocType[0],' ','_')
        if Type not in listAt:
            checkFlag="not"
        
        checkLobj="add"
        objList=self.Data.Objects.objectIds()
        #Lobj=str(AssocLobj)
        Lobj=AssocLobj[0]        
        if Lobj not in objList:
            checkLobj="not"
        
        checkRobj="add" 
        #Robj=str(AssocRobj)
        Robj=AssocRobj[0]        
        if Robj not in objList:
            checkRobj="not"
        
        if checkFlag=="add" and checkLobj=="add" and checkRobj=="add":   
          anAssoc=Assoc(Associd,AssocLobj,AssocType,AssocRobj,AssocBaseName)         
          self.Data.Relations._setObject(Associd,anAssoc)
          RefPath = Path + '/Data/Relations/' + Associd
          Ref = self.restrictedTraverse(RefPath)
          Ref.index_object()

def addAttributes(self,anOT,tlink):
  for ftlink in tlink['attributes']:
    FtType=str(ftlink['id'])
    listFt=self.Data.AttributeTypes.objectIds()
    if FtType in listFt:  #add the attribute only if the Attribute Type exists
      FtValue=str(ftlink['value'])
      if FtType !='None':
        if anOT.hasProperty(FtType):
          exsistingoccurrences = []
          exsistingoccurrences = anOT.getProperty(FtType)
          exsistingoccurrences.append(FtValue)
          anOT._updateProperty(FtType,exsistingoccurrences)
      else:
           anOT.manage_addProperty(FtType,FtValue,'lines',REQUEST=None)
  anOT.reindex_object()
