######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

#### Class file for PGQL - CRCE 23/12/03 ####

import os,sys,string,Globals

from string import replace, split
from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import SimpleItem
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.PythonScripts.standard import url_quote

#1  
def getinstancepath(self):						# DONE
     
    # getting the path of the gnowsys instance in the zope management interface
    Path = self.InstancePath
    Path = Path + 'Remove'
    Path = string.replace(Path,'/Remove','')
    return Path

    #############################################################################################################
#2    
#WORKING
def getmetatype(type):
    ''' Returns the metatype for a particular datatype. Type should be returned value of checktype() '''
    
    if type == 'Custom':
      type = 'GFunction'
    elif type == 'Functions':
      type = 'GFunctionType'
    elif type == 'FlowBase':
      type = 'GFlow Type'
    elif type == 'FlowObjects':
      type = 'GFlow'
    elif type == 'ClassBase':
      type = 'GClass Type'
    elif type == 'ClassObjects':
      type = 'GClass'
    return type
    
    #############################################################################################################
#3
def checktype(self,type):					# DONE
  
    '''This validates the name of the Object specified and returns the name in appropriate form or any type error msg'''
    
    # Checking the Type of a MetaType & Converting it to a standerd Style 
    
    type=type.upper()
    type=string.replace(type,' ','')
    if(type =='CLASSTYPE' or type=='CLASSTYPES'):
      return 'ClassBase'
    elif(type =='CLASS' or  type=='CLASSES'):
     type = 'ClassObjects'
    elif(type =='FUNCTIONTYPE' or type =='FUNCTIONTYPES'):
      type = 'Functions'
    elif(type =='FUNCTION' or type =='FUNCTIONS' ):
      type = 'Custom'
    elif(type =='FLOW' or type == 'FLOWS'):
      type = 'FlowObjects'
    elif(type =='FLOWTYPE' or type=='FLOWTYPES'):
      type = 'FlowBase'
    else:
      return "Invalid Type"
    return type

  #############################################################################################################
#4         
#WORKING
def getanyproperty(self,id='',type='',property=''):		
    ''' This script returns the specified property of the object having "id" as id and type as meta_type
       if id='' (DONT OMIT) returns list of all objects of type and their property :- CRCE Team
       if type='' (DONT OMIT) returns property of id
       Combined getanyproperty and getidproperty '''
    
    IdProperty=[]
    PATH = getinstancepath(self)
    if type!='':
      type = checktype(self,type)
      type = getmetatype(type)
    #print type
    typs = ['GFunction','GFunctionType','GFlow Type','GFlow','GClass','GClass Type']
    if id=='' and type=='':			# Search in full catalog for property  
        for x in typs:
	  for x1 in self.Catalog({'meta_type':x}):
	    if x1.meta_type==x and x1[property]:
	        y = (x1.id, x1[property])
    	        IdProperty.append(y)
	        print IdProperty
        return IdProperty
    if id=='' and type!='':			# Search for property in obects of particular type
        for x in self.Catalog({'meta_type':type}):  
          if x.meta_type == type and x[property]:
            if property!='':		#
	     y = (x.id, x[property])    # this is an alternative to getAll - call with only type,id and property=''
            else:			#
	     y = (x.id)                 #
	    IdProperty.append(y)
        return IdProperty        	
    if id!='' and type=='':			# Search for property of given object - id 
        for x in self.Catalog({'id':id}):	
          if x.id==id :  
    	    return x[property]
	    #y = (x.id, x[property])
            #IdProperty.append(y)
        #return IdProperty
    if id!='' and type!='':			# Search property of object when type is known
        for x in self.Catalog({'meta_type':type}):
          if x.id == id and x.meta_type == type:
            return x[property]
    
      
  #############################################################################################################
def square(x):
  
    '''for testing purpose only '''

    # returns a square of a given number
    
    return x * x
  
 
  ############################################################################################################
#5  
def getall(self,x):						# DONE
    ''' Returns the list of specified Type i.e MetaType,ObjectType etc.'''  
    # returns a list of all ID's of a given MetaType
    
    list = []
    x = checktype(self,x)
    y = getmetatype(x)
    
    for i in self.Catalog({'meta_type':y}):
      if i.meta_type == y:
        list.append(i.id)
    
    return list
  
  ############################################################################################################  
#6
  #WORKING
def get_instances_of_type(self,typeid):
    '''Returns the list of Objects belonging to a particular given ObjectType'''
  
    flag='notfound'
    flag1=0
    final=[]
    
    for x in self.Catalog({'id':typeid}):	
      if x.id==typeid :
    	metatyp=x.meta_type	#GFunctionType GClass Type or GFlow Type
    
    metatyp2=string.replace(metatyp,'Type','') 
    metatyp2=string.replace(metatyp2,' ','')     #GFunction GClass GFlow
    metatyp3=string.replace(metatyp2,'G','')     #Function Flow Class
    pmetatyp='P'+metatyp3+'Type'		 #PFunctionType PClassType PFlowType
        
    print metatyp, pmetatyp, metatyp2
    # Search for the given Function/Flow/Class Type
    for x in self.Catalog({'meta_type':metatyp}):
      if x.meta_type == metatyp:			
        if x.id == typeid:
          flag='found'

    # Search for the given Meta Type from the list of given Object Types
    if flag == 'found':
      for object in self.Catalog({'meta_type':metatyp2}):
        if object.meta_type == metatyp2:           
          parent=getanyproperty(self,object.id,metatyp3,pmetatyp)
	  if parent == typeid:
	    final.append(object.id)
	    flag1=1
      if flag1:  
        return final 
      else:
        return "No Object Type of this MetaType"
    else:
      return 'Invalid MetaType !!' 
    
    #############################################################################################################
#7    
#WORKING  
def getobjprop(self,x,type):
  
    '''Returns the list of values of a given any Type from Property sheet'''

    # given a ID & type returns property sheet of the ID
    
    list1 = []
    list2 = []
    listfn = []
    y='not found'

    # get the list of ID's of a given MetaType
    list=getall(self,type)
    # calculate the correct path 
    for j in list:
      if j==x:
        PATH = getinstancepath(self)
        PATH = PATH + '/PBase/' + checktype(self,type)
        PATH = PATH + '/' + x 
        pro = self.restrictedTraverse( PATH )
        y='found'
        # store ID's & values from the Property Sheet
        list2=pro.propertyIds()
        list1=pro.propertyValues()   

    # append the property ID & value to the final list
    for i in range(len(list2)):    
      listfn.append([list2[i],list1[i]])                         
    if y=='not found':
      return 'object not found' 
    else:
      return listfn
  
  ############################################################################################################
#8
#WORKING 
def countall(self,type):
  
    ''' Returns the counted Number of Requested Type '''
    r=getall(self,type)
    r1=len(r)
    return "There are %d %s present" % (r1,type)
  
def countall(self,type):
  
    ''' Returns the counted Number of Requested Type '''
  
    r=getall(self,type)
    if (r=='Enter appropriate arguments'):
      return r
    r1=len(r)
    return "There are %d %s present" % (r1,type)
  
  #############################################################################################################
#9
# WORKING  
def list_flow_with_fun(self,fun):
    '''Returns the list of all flowtype & flowobjects in which given function participates'''
    flow=[]
    flowt=[]
    flow.append('FLOW OBJECTS')  
    for each in self.Catalog({'meta_type':'GFlow'}):
      if each.meta_type=='GFlow':
        st1=each['funobj'] 
        if string.find(st1,fun) !=-1:
           flow.append(each['id'])
    
    flowt.append('FLOW TYPES')
    for each in self.Catalog({'meta_type':'GFlow Type'}):
      if each.meta_type=='GFlow Type':
        st1=each['funobj'] 
        if string.find(st1,fun) !=-1:
           flowt.append(each['id'])
    return flow,flowt
    
   #############################################################################################################
#10
#WORKING    
def list_class_with_methods(self,name):
#def list_rt_of(self,name):
  
    '''Returns a  list of RelationsType having a given ObjectType or Object'''
    class1=[]
    class2=[]
    ls=[]	
    class1.append('CLASS TYPES')  
    for each in self.Catalog({'meta_type':'GClass Type'}):
      if each.meta_type=='GClass Type':
        ls=each['methods'] 
        for x in ls:
          if string.find(x,name) !=-1:
             class1.append(each['id'])

    class2.append('CLASS OBJECTS')  				#  CLASS OBJECTS NOT APPENDING
    for each in self.Catalog({'meta_type':'GClass'}):		# It gets correct class object,its method list,name of the method to luk for
      if each.meta_type=='GClass':
     	ls=each['methods'] 
	for x in ls:
 	  if string.find(x,name) !=-1:
	     class2.append(each['id'])

    return class1,class2
    
#############################################################################################################
# RND version    
def get_obj_with_string(self,str1):
  
    ''' Returns the id of an object containing given string inside its documentation '''

    class1=[]
    doc=""		
    ls = ['GFlow','GFunctionType','GFunction','GClass Type','GClass']
    str1=string.lower(str1)	

    for x in ls :
      for each in self.Catalog({'meta_type':x}):
	doc=""
	if each.meta_type==x:
           if each['documentation']:
	      s=each['documentation'] 	
	      for x1 in range(len(s)):
		 doc= doc + s[x1]
	      doc=string.lower(doc)
	      if doc.find(str1)!=-1:		
		 class1.append(each['id'])
	 	
    return class1

  #############################################################################################################
    
  
#############################################################################################################
#same as getAll("Functiontype")  
#def getmath(self,Type,att,fun):
#'''Performs various math functions'''

#def listGQLfunc(self):
  
#    ''' Lists all the functions of the GQL '''
  
       
