#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

import string

from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport

from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo

from Globals import InitializeClass, DTMLFile
from Globals import Persistent

from Products.ZCatalog.CatalogAwareness import CatalogAware

# the import statement is written by Chitra
from OFS.Image import File
from Products.PageTemplates.ZopePageTemplate import ZopePageTemplate
# the ZopePageTemplate is added instead of ObjectManager, PropertyManager, RoleManager & Item by Chitra

class attributetype(ZopePageTemplate,
                  FindSupport,
                  CatalogAware):
    """
    Attribute Type implementation
    """

    meta_type = "GAttribute Type"


    _properties = (
        {'id':'BaseName', 'type': 'string', 'mode': 'w'},
        {'id':'datatype', 'type': 'string', 'mode':'w'},
        {'id':'Description', 'type': 'text', 'mode': 'w'},
        {'id':'AttMetaType', 'type': 'lines', 'mode': 'w'},
      )

    def __init__(self,id,BaseName,datatype,Description,AttMetaType):

         self.id=id
         self.BaseName=BaseName
         self.datatype=datatype
         self.Description=Description
         self.AttMetaType=AttMetaType

#     manage_options = (
#         { 'label': 'Contents', 'action': 'manage_main'},
#         { 'label': 'View', 'action': 'manage_deltopic'},
#         { 'label': 'Properties', 'action': 'manage_propertiesForm'},
#         ) + Item.manage_options

    manage_options = (
        ) + ZopePageTemplate.manage_options

    def checkAttributeType(self, REQUEST=None):
        """
        This will check for the object/objecttypes/metatypes having this attribute if any.
        """
	newid=self.id

        PATH = self.InstancePath

	otlist=[]
	catlist=[]
	olist=[]
	objtypelist=[]
	MetaTypelist=[]
	objlist=[]
	attlist=[]
	tmpotstr=''
	tmpostr=''
	tmpcatstr=''
        for x in self.Catalog({'meta_type':'GObject Type'}):
            if x.meta_type == 'GObject Type':
                otlist.append(x.id)

       	if otlist<>[]:
	        for i in otlist:
                    PATH1 = PATH + 'Data/ObjectType/' + i[0] + '/' + i
                    otref = self.restrictedTraverse( PATH1 )
                    attlist=otref.propertyIds()
                    for j in attlist:
                        if j==newid:
                            objtypelist.append(i)

        for x in self.Catalog({'meta_type':'GMetaType'}):
            if x.meta_type == 'GMetaType':
                catlist.append(x.id)

       	if catlist<>[]:
            for i in catlist:
                PATH1 = PATH + 'Data/MetaType/' + i
                catref = self.restrictedTraverse( PATH1 )
                attlist=catref.propertyIds()
                for j in attlist:
                    if j==newid:
                        MetaTypelist.append(i)
                        
        for x in self.Catalog({'meta_type':'GObject'}):
            if x.meta_type == 'GObject':
                olist.append(x.id)

       	if olist<>[]:
            for i in olist:
                PATH1 = PATH + 'Data/Objects/' + i[0] + '/'  + i
                oref = self.restrictedTraverse( PATH1 )
                attlist=oref.propertyIds()
                for j in attlist:
                    if j==newid:
                        objlist.append(i)

        if objtypelist<>[]:
	         tmpotstr=string.join(objtypelist)
       	if MetaTypelist<>[]:
		 tmpcatstr=string.join(MetaTypelist)        
	if objlist<>[]:
	         tmpostr=string.join(objlist)

	name='Attribute Type'
	if tmpotstr=='' and tmpostr=='' and tmpcatstr=='':
		self.Data.AttributeTypes.manage_delObjects(newid)
		self.unindex_object()		
		REQUEST.RESPONSE.redirect(self.surl+'/Programs/replydelete?newid=%s&newnm=%s' % (newid,name))
	else:
		 REQUEST.RESPONSE.redirect(self.surl + '/Programs/ObjectsAttachedTOAttr?otlist=%s&oblist=%s&catlist=%s' % (tmpotstr,tmpostr,tmpcatstr) )

# Factory methods

manage_addnewattributetypeForm = DTMLFile('dtml/addnewattributetypeform', globals())

def manage_addnewattributetype(dispatcher, id, REQUEST=None):
    """
    Add New Attribute type object
    """
    dest = dispatcher.Destination()

    type = ['lines','string','tokens','text','boolean','date','int','long','float','selection','multiple selection','ustring','utext','ulines','utokens']

    dtype = ''
    dtype = REQUEST['datatype'][0]

    id = string.replace(id,' ','')

    BaseName = REQUEST['BaseName']

    Description = REQUEST['Description']

    AttMetaType=REQUEST['AttMetaType']
	
    if len(BaseName)==0:
        BaseName = REQUEST['id']

    if  dtype in type :
        dest.Data.AttributeTypes._setObject(id,attributetype(id,BaseName,dtype,Description,AttMetaType)) 
    else:
        return "Invalid Datatype. Please go back and choose a valid Data Type", "Data Type Selected ->",REQUEST['datatype'][0]

    ####################################################################
    #This code maintains attribute type counter on the instance
    instancePath = string.replace( dest.InstancePath + 'Remove', '/Remove', '' )
    instanceRef = dest.restrictedTraverse( instancePath )
    atCounter = instanceRef.getProperty( 'attribute_types' )
    atCounter = atCounter + 1
    instanceRef._updateProperty('attribute_types',atCounter)
    totalCounter = instanceRef.getProperty( 'total' )
    totalCounter = totalCounter + 1
    instanceRef._updateProperty('total',totalCounter)
    ####################################################################

    PATH = dispatcher.InstancePath
    PATH = PATH + 'Data/AttributeTypes/' + id

    objRef = dest.restrictedTraverse( PATH )
    objRef.index_object()


    #commented by GN 
    #dispatcher.Catalog.manage_addIndex(id, 'TextIndex')
    #dispatcher.Catalog.manage_addColumn(id)

    nm="AttributeType"
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',BaseName)

    REQUEST.RESPONSE.redirect(dest.surl + '/Programs/replyadd?newid=%s&newnm=%s' % (BaseName,nm) )
    return id

InitializeClass(attributetype)
