#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from OFS import DTMLMethod
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.PropertySheets import PropertySheet
from OFS.FindSupport import FindSupport

from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo

from Globals import Persistent
from Globals import InitializeClass, DTMLFile

from Products.ZCatalog.CatalogAwareness import CatalogAware

# here the 2 import statements are added by Chitra
from Products.BTreeFolder2.BTreeFolder2 import BTreeFolder2
from OFS.Image import File

import Products.PythonScripts, Globals

import string
import os

file_path = Globals.package_home(globals())

def attributeaddobjtype(self,ft,scope,fillmode,attributeval):
      """
      This function adds Attibutes
      """
      ctmp=[]
      otmp=[]
      token=0
      ctmp=self.Defined
      otmp=self.Possible

      if scope=='Defining':
         for a in ctmp:
       	     if a==ft:
		token=1
		break
             else: 
		token=0
	 if token==0:  
	    for a in otmp:
	      if a==ft:
		self.Possible.remove(a)
		break
            self.Defined.append(ft)
      elif scope=='Possible':
          for a in otmp:
       	     if a==ft:
		token=1
		break
             else: 
		token=0
	  if token==0:
             for a in ctmp:
		if a==ft:
		  self.Defined.remove(a)
		  break
	     self.Possible.append(ft)

      mandatory=[]
      optional=[]
      token=0
      mandatory=self.Mandatory
      optional=self.Optional
      if fillmode=='Mandatory':
         for a in mandatory:
       	     if a==ft:
		token=1
		break
             else: 
		token=0
	 if token==0:  
	    for a in optional:
	      if a==ft:
		self.Optional.remove(a)
		break
            self.Mandatory.append(ft)
      elif fillmode=='Optional':
          for a in optional:
       	     if a==ft:
		token=1
		break
             else: 
		token=0
	  if token==0:
             for a in mandatory:
		if a==ft:
		  self.Mandatory.remove(a)
		  break
	     self.Optional.append(ft)
	
      if self.hasProperty(ft)>0:
             self._updateProperty(ft,attributeval)
      else:
	     PATH = self.InstancePath + 'Data/AttributeTypes/' + ft
	     attribute = self.restrictedTraverse(PATH)
	     Type1 = ['float','int','long']
	     Type2 = ['boolean']
	     Type3 = ['lines','string','text','tokens','selection','multiple selection']

	     defAttributeValue = attributeval
	     if defAttributeValue is not None:
                  attributeDataType = attribute.getProperty('datatype')
   	          self.manage_addProperty(ft, defAttributeValue, attributeDataType, REQUEST=None)
	     else:
                attributeDataType = attribute.getProperty('datatype')
                if attributeDataType in Type1:
                    defAttributeValue = 0
                elif attributeDataType in Type2:
                    defAttributeValue = 0
                elif attributeDataType in Type3:
                    defAttributeValue = ''                
                self.manage_addProperty(ft,defAttributeValue,attributeDataType,REQUEST=None)

      self.reindex_object()

# the ZopePageTemplate is added instead of the ObjectManager, PropertyManager, RoleManager & Item by Chitra

class ObjectType(File,
                  FindSupport,
                  CatalogAware):

    """
    Object type implementation.
    """
    meta_type = "GObject Type"

    _properties = (
        {'id':'BaseName', 'type': 'ustring', 'mode': 'w'},
        {'id':'PMetaType', 'type': 'ulines', 'mode': 'w'},
        {'id':'PObjectType', 'type': 'ulines', 'mode': 'w'},
        {'id':'Description', 'type': 'utext', 'mode': 'w'}, 
        {'id':'Status','type':'ustring','mode':'w'},
	{'id':'Defined','type':'ulines','mode':'w'},
        {'id':'Possible','type':'ulines','mode':'w'},
	{'id':'Mandatory','type':'ulines','mode':'w'},
	{'id':'Optional','type':'ulines','mode':'w'},
	{'id':'child_objecttypes','type':'ulines','mode':'w'},
	{'id':'child_objects','type':'ulines','mode':'w'},
	{'id':'lRoleContainerIn','type':'ulines','mode':'w'},
	{'id':'rRoleContainerIn','type':'ulines','mode':'w'},
	{'id':'lRolePlayedIn','type':'ulines','mode':'w'},
	{'id':'rRolePlayedIn','type':'ulines','mode':'w'},       
     )

#     manage_options = (
#         { 'label': 'Contents', 'action': 'manage_main'},
#         { 'label': 'View', 'action': 'manage_deltopic'},
#         { 'label': 'Properties', 'action': 'manage_propertiesForm'},
#         ) + Item.manage_options

#  the changes are made by Hussain 
    manage_options = (
          ) + File.manage_options        

    def __init__(self,id,BaseName,PMetaType,PObjectType,Description,Defined,Possible,Mandatory,Optional):
        self.id=id
        self.BaseName=BaseName
	self.PMetaType=PMetaType
        self.PObjectType=PObjectType
        self.Description=Description
        self.Defined=Defined
        self.Possible=Possible
	self.Mandatory=Mandatory
	self.Optional=Optional

	self.child_objecttypes = []
	self.child_objects = []
	self.lRoleContainerIn = []
	self.rRoleContainerIn = []
	self.lRolePlayedIn = []
	self.rRolePlayedIn = []

        self.Status='Public'
        #Variables added by hussain to incorporate changes that needed ObjectType to behave as file Object
        self.content_type="text/html"
        self.data=""


# the comment is made by Chitra as the index_html is removed
#	addDTML(self,'index_html',BaseName,'dtml/objtype_index_html')
       
    def editObjectType(self,RESPONSE,URL1,URL2,REQUEST=None):
        """
        This function updates properties of Object Type after edition.
        """
        id = REQUEST['id']
        BaseName=REQUEST['BaseName']
        Description=REQUEST['Description']

	if len(BaseName) == 0:
	   BaseName = id

        self._updateProperty('BaseName',BaseName)
        self._updateProperty('Description',Description)
        self.reindex_object()

        nm="ObjectType"
        REQUEST.set('newnm',nm)
	REQUEST.set('newid',BaseName)

#	REQUEST.RESPONSE.redirect(self.surl+'/replyedit?newid=%s&newnm=%s' % (BaseName,nm))

# the above statement is replaced by the one below by hitesh

	REQUEST.RESPONSE.redirect(self.surl + '/Data/ObjectType/Programs/' + id[0] + '/' + id + '/replyedit?newid=%s&newnm=%s' % (BaseName,nm))

        return

    def attributeadd(self, REQUEST=None):
        """
	This function add Attibutes.
        """
        
        ft = REQUEST['ft']
        attributeval = REQUEST['attributeval']
	scope=REQUEST['scope']
	fillmode=REQUEST['fillmode']
        eflag=REQUEST['log']

        attributeaddobjtype(self,ft,scope,fillmode,attributeval)

	filen1 = ''
	tmp='T'
        
        if eflag=='Edit':
              self.REQUEST.RESPONSE.redirect('manage_OTEditform?val=%s' % tmp)
        else:
              filen1 ='manage_OTAttributemainform'
              self.REQUEST.RESPONSE.redirect(filen1)

    def checkattribute(self,REQUEST):
        """
        This will check the fillmode field of ObjectType with that of Object to check for the NULL value given to Mandatory Object
        """
	newid=self.id
        ft = REQUEST['ft']
        attributeval = REQUEST['attributeval']
	scope=REQUEST['scope']
	fillmode=REQUEST['fillmode']
	if fillmode=='Mandatory':      
	        objlist=[]
	        tmpolist=[]
		otlist=[]
	        objlist=self.Data.Objects.objectIds()        
        	if objlist<>[]:
                   for i in objlist:
			  PATH = self.InstancePath + 'Data/Objects/' + i
		          obref = self.restrictedTraverse( PATH )
                          otlist=obref.getProperty('ObjectTypes')
	                  for j in otlist:
	                      if j==newid:
	                          reqatt=obref.getProperty(ft)
			          if reqatt==[''] or reqatt=='' or reqatt=='None' :
					tmpolist.append(i)
					tmpstr=string.join(tmpolist)		                       
				        REQUEST.RESPONSE.redirect(self.surl + '/DisplayObjectofOT?olist=%s' % tmpstr)
				  else:
			                attributeaddobjtype(self,ft,scope,fillmode,attributeval)
					REQUEST.RESPONSE.redirect('manage_OTEditform?newid=%s'%newid)
	else:
                attributeaddobjtype(self,ft,scope,fillmode,attributeval)
		REQUEST.RESPONSE.redirect('manage_OTEditform?newid=%s'%newid)

    def removeattribute(self,REQUEST):
        """
        This function deletes attribute.
        """
        Attibutes = REQUEST['attributelist']
	tmpPossible=[]
	tmpDefined=[]
	tmpPossible=self.getProperty('Possible')
	tmpDefined=self.getProperty('Defined')

	for fc in Attibutes:
		for tmpfc in tmpPossible:
			if fc==tmpfc:
			   tmpPossible.remove(tmpfc)
		for tmpfc in tmpDefined:
			if fc==tmpfc:
			   tmpDefined.remove(tmpfc)
	
	self._updateProperty('Possible',tmpPossible)
	self._updateProperty('Defined',tmpDefined)

	tmpopt=[]
	tmpmand=[]
	tmpopt=self.getProperty('Optional')
	tmpmand=self.getProperty('Mandatory')

	for fc in Attibutes:
		for tmpfc in tmpopt:
			if fc==tmpfc:
			   tmpopt.remove(tmpfc)
		for tmpfc in tmpmand:
			if fc==tmpfc:
			   tmpmand.remove(tmpfc)
	
	self._updateProperty('Optional',tmpopt)
	self._updateProperty('Mandatory',tmpmand)
			
        self.manage_delProperties(Attibutes)
	self.reindex_object()
        REQUEST.RESPONSE.redirect(self.surl + '/Programs/attributedels')
	
    def OTremovelist(self,ul,objTT,REQUEST=None):
        """
        This function edits membership of object type.
        """
        itbinit=ul
	itb2=string.replace(itbinit,"['","")
	itb3=string.replace(itb2,"']","")
	itb4=string.replace(itb3,"', '"," ")
	itbfin=[]
	itbfin=string.split(itb4," ")
	itafin=objTT
	nTT=filter(lambda x,itafin=objTT: x not in itafin,itbfin)
	self._updateProperty('PObjectType',nTT)
	self.reindex_object()
	self.REQUEST.RESPONSE.redirect(self.surl + '/Programs/Data/ObjectType/' + self.id[0] + '/' + self.id + '/OTinclusion')

    def deleteObjectType(self,REQUEST,RESPONSE,URL1,URL2):
        """
        This function deletes the objecttype.
        """
        id = REQUEST['id']
        BaseName=REQUEST['BaseName']
	if len(BaseName)==0:
	   BaseName = id

        #################################################
        #This code removes ot from child_objecttypes property
        PATH = self.InstancePath
        for each in self.Catalog():
              if each.meta_type=='GObject Type':
                    if each.id==id:
                          for xOt in each.PObjectType:
#                                otRef = self.restrictedTraverse( PATH + 'Data/ObjectType/' + xOt )
# the above statement is replaced by the one below by hitesh
                                otRef = self.restrictedTraverse( PATH + 'Data/ObjectType/' + xOt[0] + '/' + xOt )
                                childObjectTypeList= otRef.getProperty( 'child_objecttypes' )
                                if id in childObjectTypeList:                                
                                      childObjectTypeList.remove(id) #pop( otList.index( self.id ) )
                                      otRef._updateProperty('child_objecttypes',childObjectTypeList )
                                      otRef.reindex_object()
                          for xCat in each.PMetaType:
                                pMetaTypeRef = self.restrictedTraverse( PATH + 'Data/MetaType/' + xCat )
                                childObjectTypeList = pMetaTypeRef.getProperty( 'child_objecttypes' )
                                if id in childObjectTypeList:                                
                                      childObjectTypeList.remove(id) #pop( catList.index( self.id ) )
                                      pMetaTypeRef._updateProperty('child_objecttypes',childObjectTypeList )
                                      pMetaTypeRef.reindex_object()              
        #################################################
	self.restrictedTraverse(PATH + 'Data/ObjectType/' + id[0]).manage_delObjects(id)
	self.unindex_object()


        #following two lines remove content file from file system.
        contentFile = os.path.normpath(CLIENT_HOME + '/GContent' + self.InstancePath +'Data/ObjectType/' + id[0])
        list_files = os.listdir(contentFile)
        #looping over the list to check wether the file containing the content of this object exist
        #this is done by checking only the filename with the id of the object ignoring the extension
        for file in list_files:
              if self.id == os.path.splitext(file)[0]: #Checking the filename with the id of the Object
                    #Removing the contents file from the filesystem
                    os.remove(contentFile + os.sep + file)
        #Checking wether the directory is empty if so removing the directory as well
        list_files = os.listdir(contentFile)
        if list_files==[]:
              del_path = self.InstancePath + 'Data/ObjectType/'
              del_ref = self.restrictedTraverse(del_path)
              del_ref.manage_delObjects(id[0])
              os.rmdir(contentFile)
              
        nm="ObjectType"
 	REQUEST.set('newnm',nm)
	REQUEST.set('newid',BaseName)

        REQUEST.RESPONSE.redirect(self.surl + '/Programs/replydelete?newid=%s&newnm=%s' % (BaseName,nm))
 
    def OTupdateunsel(self,REQUEST):
         """ """
         list_of_ids=[]
         for x in self.Catalog({'meta_type':'GObject Type'}):
               if x.meta_type == 'GObject Type':
                     list_of_ids.append(x.id)
         b=[]
         b=self.PObjectType
         a=list_of_ids
         oTT=filter(lambda x,b=self.PObjectType: x not in b,a)
         return oTT 
   
# Factory methods

manage_addnewObjecttypeForm = DTMLFile('dtml/addnewObjecttypeform', globals())

def manage_addnewObjecttype(dispatcher, id, REQUEST=None):
    """
    This function adds Object type.
    """
    dest = dispatcher.Destination()
    id = string.replace(id,' ','')
    BaseName=REQUEST['BaseName']
    if len(BaseName)==0:
	BaseName = id

    Description=REQUEST['Description']
    PMetaType=REQUEST['PMetaType']
    PObjectType=REQUEST['PObjectType']

    Defined=[]
    Possible=[]
    Mandatory=[]
    Optional=[]

    ########################################################

#   the following statements are added by hitesh

    first_char=id[0]

    folder_path = 'Data/ObjectType'
    otpath = folder_path + '/' + first_char

    otpathref = dest.restrictedTraverse(otpath,"None")

    if otpathref == "None" :
          folder_ref = dest.restrictedTraverse(folder_path)
          folder_ref._setObject(first_char,BTreeFolder2(first_char))
          otpathref = dest.restrictedTraverse(otpath)

          #otpathref._setObject(id, ObjectType(id,BaseName,PMetaType,PObjectType,Description,Defined,Possible,Mandatory,Optional))

    otpathref._setObject(id, ObjectType(id,BaseName,PMetaType,PObjectType,Description,Defined,Possible,Mandatory,Optional))
    ########################################################

    PATH = dispatcher.InstancePath
    path = PATH

#    PATH = PATH + 'Data/ObjectType/' + id
# the above statement is replaced by the statement below by hitesh

    PATH = PATH + 'Data/ObjectType/' + first_char + '/' + id

    objectTypeRef = dest.restrictedTraverse( PATH )

    parentMetatypes=objectTypeRef.getProperty('PMetaType')

    for i in parentMetatypes:
	    parentMetaTypePath = path + 'Data/MetaType/' + i
	    parentMetaTypeRef= objectTypeRef.restrictedTraverse( parentMetaTypePath )

	    MandatoryValues=[]
	    OptionalValues=[]
	    MandatoryValues=parentMetaTypeRef.getProperty('Mandatory')
	    OptionalValues=parentMetaTypeRef.getProperty('Optional')	
	    for i in MandatoryValues:
                if i not in objectTypeRef.Mandatory:
			objectTypeRef.Mandatory.append(i)
			if i in objectTypeRef.Optional:
				objectTypeRef.Optional.remove(i)
	    for i in OptionalValues:
		if i not in objectTypeRef.Optional and  i not in objectTypeRef.Mandatory:
        		objectTypeRef.Optional.append(i)

	    DefinedValues=[]
	    PossibleValues=[]
	    DefinedValues=parentMetaTypeRef.getProperty('Defined')
	    PossibleValues=parentMetaTypeRef.getProperty('Possible')	
	    for i in DefinedValues:
                if i not in objectTypeRef.Defined:
			objectTypeRef.Defined.append(i)
			if i in objectTypeRef.Possible:
				objectTypeRef.Possible.remove(i)
	    for i in PossibleValues:
		if i not in objectTypeRef.Possible and  i not in objectTypeRef.Defined:
        		objectTypeRef.Possible.append(i)

    parentObjectTypes=objectTypeRef.getProperty('PObjectType')

    for i in parentObjectTypes:

#	    parentObjectTypePath = path + 'Data/ObjectType/' + i
# the above statement is replaced by the one below by hitesh
	    parentObjectTypePath = path + 'Data/ObjectType/' + i[0] + '/' + i
            
	    parentObjectTypeRef= objectTypeRef.restrictedTraverse( parentObjectTypePath )
	    definedValues=[]
	    possibleValues=[]
	    definedValues=parentObjectTypeRef.getProperty('Defined')
	    possibleValues=parentObjectTypeRef.getProperty('Possible')	

	    for i in definedValues:
                if i not in objectTypeRef.Defined:
			objectTypeRef.Defined.append(i)
			if i in objectTypeRef.Possible:
				objectTypeRef.Possible.remove(i)
	    for i in possibleValues:
		if i not in objectTypeRef.Possible and  i not in objectTypeRef.Defined:
        		objectTypeRef.Possible.append(i)

	    manadatoryValues=[]
	    optionalValues=[]
	    manadatoryValues=parentObjectTypeRef.getProperty('Mandatory')
	    optionalValues=parentObjectTypeRef.getProperty('Optional')	

	    for i in manadatoryValues:
                if i not in objectTypeRef.Mandatory:
			objectTypeRef.Mandatory.append(i)
			if i in objectTypeRef.Optional:
				objectTypeRef.Optional.remove(i)
	    for i in optionalValues:
		if i not in objectTypeRef.Optional and  i not in objectTypeRef.Mandatory:
        		objectTypeRef.Optional.append(i)

    ############################################################
    #This code maintains the ObjectType counter of the instance.
    instancePath = string.replace( dest.InstancePath + 'Remove', '/Remove', '' )
    instanceRef = dest.restrictedTraverse( instancePath )
    objtypeCounter = instanceRef.getProperty( 'object_types' )
    objtypeCounter = objtypeCounter + 1
    instanceRef._updateProperty('object_types',objtypeCounter )
    totalCounter = instanceRef.getProperty( 'total')
    totalCounter= totalCounter + 1
    instanceRef._updateProperty('total',totalCounter )
    ############################################################

    ############################################################
    #This code maintains the child_objecttypes property for
    #Neighborhood information.
    
    for otId in PObjectType:
    #      otPath = PATH + '/Data/ObjectType/' + otId
    # the above statement is replaced by the one below
          otPath = PATH + '/Data/ObjectType/' + otId[0] + '/' + otId
          pObjectTypeRef = dest.restrictedTraverse( otPath )
          childObjectTypeList = list(pObjectTypeRef.getProperty( 'child_objecttypes' ))
          childObjectTypeList.append(id) #insert(len(tempList),id)
          pObjectTypeRef._updateProperty('child_objecttypes',childObjectTypeList)
          pObjectTypeRef.reindex_object()          
    for mtId in PMetaType:
          mtPath = PATH + '/Data/MetaType/' + mtId
          pMetaTypeRef = dest.restrictedTraverse( mtPath )
          childObjectTypeList = list(pMetaTypeRef.getProperty( 'child_objecttypes' ))
          childObjectTypeList.append(id) #insert(len(otList), id)
          pMetaTypeRef._updateProperty('child_objecttypes',childObjectTypeList )
          pMetaTypeRef.reindex_object()                       
    ############################################################

    objectTypeRef.index_object()
#    REQUEST.set('BaseName',BaseName)
#    REQUEST.set('Id',id)        

#    REQUEST.RESPONSE.redirect(dest.surl + '/Data/ObjectType/' + id  + '/addContent' + '?Id=%s&BaseName=%s' % (id,BaseName))

# the above statement is replaced by the one below by hitesh

#    REQUEST.RESPONSE.redirect(dest.surl + '/Programs/Data/ObjectType/' + id[0] + '/' + id  + '/addContent' + '?Id=%s&BaseName=%s' % (id,BaseName))
    REQUEST.RESPONSE.redirect(dest.surl + '/Programs/Data/ObjectType/' + id[0] + '/' + id  + '/addContent')    
    return id

def addDTML(obj,id,title,file):
	f=open(file_path+'/'+file+'.dtml')
	file=f.read()
	f.close()
	obj.manage_addDTMLMethod(id,title,file)
	return getattr(obj,id)

InitializeClass(ObjectType)
