######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport

from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo

from Globals import InitializeClass, DTMLFile
from Globals import HTMLFile
from Globals import Persistent

import Products.PythonScripts, Globals
from Products.PythonScripts.PythonScript import *
from Products.MailHost.MailHost import manage_addMailHost
from Products.ZCatalog.ZCatalog import manage_addZCatalog

#the following line commneted by hussain since Programs folder is no longer maintained as Transparent Folder
#from Products.TransparentFolders.TransparentFolder import manage_addTransparentFolder
from Products.ExternalMethod.ExternalMethod import *

# the import statement is written by Chitra
from Products.BTreeFolder2.BTreeFolder2 import BTreeFolder2
from Products.PageTemplates.ZopePageTemplate import ZopePageTemplate

from AccessControl.User import manage_addUserFolder
import os
from Products.GNOWSYS06.gno import gno,manage_addgnoFolder
from Products.GNOWSYS06.MetaType import MetaType
from Products.GNOWSYS06.ObjectType import ObjectType
from Products.GNOWSYS06.RelationType import AssocT
from Products.GNOWSYS06.Object import Object
from Products.GNOWSYS06.AttributeType import attributetype
from Products.GNOWSYS06.GQL import GQL

from time import time
from string import split, find

################## Import Statements Below are for Functional Representation Module #################

from Products.GNOWSYS06.listcf import *
from Products.GNOWSYS06.listpy import *

import UserDict
import UserList
import UserString
import maths

import cmaths
import string

from tabclass import *
from FunctionType import *
from ClassType import *
from listing import *
import factoryobj 
from conditiontype import *

import os,sys

file_path = Globals.package_home(globals())

os.chdir('/')
program=sys.argv[0]
here=os.path.join(os.getcwd(),os.path.split(program)[0])
sys.path=[os.path.join(here,'lib','python'),here]+filter(None,sys.path)

################## The GNOWSYS class defination starts from here ####################################
class GNOWSYS(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport):
    """
    GNOWSYS implementation.This is the main GNOWSYS class this class will be used for Instantiating the product.
    """

    meta_type = "GNOWSYS0.6"

    _properties = (
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'image', 'type': 'selection', 'mode': 'wd', 'select_variable': 'image_select'},
        ) 

##################### These are the tabs we see in the main instance folder in ZMI ##################
    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'View', 'action': 'index_html'},
        {'label': 'Properties', 'action':'_properties'}, 
        ) 


allowedmetatypes = ('DTML Method')

##### This function determines what objects can be added inside GNOWSYS standard file hierarchy ####
def all_meta_types(self):
            if hasattr(self, 'allowedmetatypes'):
                result = []
		import Products
                for metaType in Products.meta_types:
                    if metaType['name'] in self.allowedmetatypes:
                        result.append(metaType)

                return result

def __init__(self, id, title):
        self.__version__ = '0.6'
        self.id = id
        self.title = title

############## Form for instantiating the GNOWSYS Class ###################
addGNOWSYSForm = DTMLFile('dtml/addnewGNOWSYSform',globals())

def addGNOWSYS(self,id,title,REQUEST=None):
    
    """
    Replicate FOLDER from the file system to ZODB
    """

################## Following code is only for Functional Representation Module #####################
################## The code below checks for existance of Numeric.py module #######################
## Modules Numeric and umaths can be imported only after os.syspath variable has been updated #####

    flagNumeric = 0
    OS = ''
    appendPath1 = ''
    appendPath2 = ''

    s = REQUEST['SERVER_SOFTWARE']
    f = string.find(s,'win32')
    if (f!=-1):
	OS = 'W'
    else:
	OS = 'NW'

    if OS=='W':
	appendPath1 = 'C:\\PYTHON21\\Lib\\site-packages\\Numeric'
	appendPath2 = 'C:\\PYTHON22\\Lib\\site-packages\\Numeric'
    else :
	appendPath1 = '/usr/lib/python2.1/site-packages/Numeric'
	appendPath2 = '/usr/lib/python2.2/site-packages/Numeric'

    try:
	sys.path.append(appendPath1)
	import Numeric
#	import umaths
	flagNumeric = 1
    except:	
	try:
		sys.path.append(appendPath2)
		import Numeric
	#	import umaths
		flagNumeric = 1		
	except:
		print "Python Numeric module is not installed."

    if hasattr(self,id):
       return ''' <p> <h4>Id %s already in use </h4>
                  <p> <p> please , select some other Id ''' %(id)

    surl = self.absolute_url()
    surl = surl + '/' + id
    
    self.manage_addgnoFolder(id,title)
    curr_folder = get_attr(self,id,'Attribute Err')
#    ex = curr_folder

######################## adding properties to GNOWSYS Instance #################################
    curr_folder.manage_addProperty('SiteTitle',title,'string')
    curr_folder.manage_addProperty('surl', surl, 'string')
    curr_folder.manage_addProperty('Email',REQUEST['Email_Id'],'string')
    curr_folder.manage_addProperty('total',0,'int')
    curr_folder.manage_addProperty('metatypes',0,'int')
    curr_folder.manage_addProperty('objects',0,'int')
    curr_folder.manage_addProperty('object_types',0,'int')
    curr_folder.manage_addProperty('relations',0,'int')
    curr_folder.manage_addProperty('relation_types',0,'int')
    curr_folder.manage_addProperty('attribute_types',0,'int')

    pathstring = surl
    pathstringlist = pathstring.split('/')
    pathstringlist1 = pathstringlist[3:]
    instancepath = '/'
    if pathstringlist1!=[]:
        for x in pathstringlist1:
            instancepath = instancepath + x + '/'

    instancepath = string.replace(instancepath,'%20',' ')
    curr_folder.manage_addProperty('InstancePath', instancepath, 'string')

############################## Creates acl users folder #############################################
    curr_folder.manage_addUserFolder()    


####################################################################################################
##Following lines added by Hussain
    
    curr_folder._setObject('GQL', GQL('GQL'))
#     PATH = curr_folder.InstancePath + 'GQL'
#     GQLRef = curr_folder.restrictedTraverse( PATH )
#     GQLRef.index_object()    
    
####################################################################################################
    
## These are various icons that you see on the GNOWSYS interface stored inside Images Folder. ####
    
# the gno folder is replaced by BTreeFolder2 folder & also the Parameter is reduced from 2 to 1 by Chitra

    curr_folder._setObject('Images', BTreeFolder2('Images'))
    addImage(curr_folder,'GNOWSYSLOGO','www/Gnowsys.png')
    addImage(curr_folder.Images,'FlowType','www/flow-type.png')
    addImage(curr_folder.Images,'Flow','www/flow.png')
    addImage(curr_folder.Images,'FunctionType','www/function-type.png')
    addImage(curr_folder.Images,'Function','www/function.png')
    addImage(curr_folder.Images,'ClassType','www/class-type.png')
    addImage(curr_folder.Images,'Class','www/class.png')
    addImage(curr_folder.Images,'ObjectType','www/Object_Type.jpg')
    addImage(curr_folder.Images,'Object','www/Object.jpg')
    addImage(curr_folder.Images,'RelationType','www/association-type.png')
    addImage(curr_folder.Images,'Relation','www/association.png')
    addImage(curr_folder.Images,'AttributeType','www/attribute-type.png')
    addImage(curr_folder.Images,'Attribute','www/attribute.png')

##### following lines creates directory for stoaring content files of OT,O,CAT ########## 
    client_home = CLIENT_HOME
    directorypath = client_home + '/GContent' + instancepath + 'Data/'
    if not(os.path.exists(directorypath)):
        os.makedirs(directorypath)
    subdirs = ['MetaType','ObjectType','Objects']
    for each in subdirs:
        if not(os.path.exists(directorypath+each)):
            os.mkdir(directorypath + each)

################################ Content Files for Default Meta-Type & Object Type ##############

    DMetaTypePath = directorypath+'MetaType/DMetaType'
    if not(os.path.exists(DMetaTypePath)):
        os.mkdir(DMetaTypePath)            
    DObjectTypePath = directorypath+'ObjectType/D/DObjectType'
    if not(os.path.exists(DObjectTypePath)):
        os.makedirs(DObjectTypePath)
        
    contentpathlist = ['MetaType/DMetaType/DMetaType.html','ObjectType/D/DObjectType/DObjectType.html']
    for each in contentpathlist:
        contentFile = CLIENT_HOME + '/GContent' + instancepath +'Data/' + each
        file = open(contentFile,'w')
        file.write('<html> <head> Content File </head> </html>')
        file.close()

############################ GNOWSYS folder hierarchy.##############################################

# here the gno folders are converted to BTreeFolder2 folders & also the Parameter is reduced from 2 to 1 by Chitra

    curr_folder._setObject('Latex_files', BTreeFolder2('Latex_files'))
    curr_folder._setObject('Pdf_files', BTreeFolder2('Pdf_files'))
    curr_folder._setObject('XTM_Files', BTreeFolder2('XTM_Files'))    
    curr_folder._setObject('GnowML_Files', BTreeFolder2('GnowML_Files'))
    curr_folder._setObject('OWL_Files', BTreeFolder2('OWL_Files'))            
    curr_folder._setObject('Data', BTreeFolder2('Data'))
    curr_folder.Data._setObject('MetaType', BTreeFolder2('MetaType'))
    curr_folder.Data._setObject('MetaTypeRelations', BTreeFolder2('MetaTypeRelations'))
    curr_folder.Data._setObject('Objects', BTreeFolder2('Objects'))
    curr_folder.Data._setObject('ObjectType', BTreeFolder2('ObjectType'))
    curr_folder.Data._setObject('Relations', BTreeFolder2('Relations'))
    curr_folder.Data._setObject('RelationTypes', BTreeFolder2('RelationTypes'))
    curr_folder.Data._setObject('AttributeTypes', BTreeFolder2('AttributeTypes'))
    curr_folder.Data._setObject('Views', BTreeFolder2('Views'))    

################################ Folders for Functional Representation ###########################

# here the gno folder is changed to BTreeFolder2 folder & also the Parameter is reduced from 2 to 1 by Chitra

    curr_folder._setObject('PBase', BTreeFolder2('PBase'))
    curr_folder.PBase._setObject('Functions',listing('Functions','Functions')) 
    curr_folder.PBase._setObject('FlowBase',listing('FlowBase','FlowBase'))
    curr_folder.PBase._setObject('FlowObjects',listing('FlowObjects','FlowObjects')) 
    curr_folder.PBase._setObject('ClassBase',listing('ClassBase','ClassBase')) 
    curr_folder.PBase._setObject('ClassObjects',listing('ClassObjects','ClassObjects')) 
    curr_folder.PBase._setObject('WordProblems',listing('WordProblems','WordProblems')) 
    curr_folder.PBase.Functions._setObject('Conditions',listing('Conditions','Contains Condition Objects'))
    curr_folder.PBase.Functions._setObject('Math',listing('Math','Math Functions'))
    curr_folder.PBase.Functions._setObject('String',listing('String','String Functions'))
    
    if flagNumeric==0:
	filepath=[]
    else:
	if OS=='W':
		filepath=[maths.__file__,cmaths.__file__,string.__file__]
	else:
	#	filepath=[maths.__file__,umaths.__file__,cmaths.__file__,Numeric.__file__,string.__file__]
		filepath=[Numeric.__file__,string.__file__]                

    for i in filepath:
	if OS!='W':
		if i[0]!='/':
			i='/'+i

        i=string.split(i,".py")[0]+".py"
        l2=listcf(i)
        pyfundict=l2.fun               # Dictionary of all functions in the .py
        for j in range(len(pyfundict)):
                factoryobj.tutfun(curr_folder,i,l2,j)

    filelist=[UserList.__file__,UserDict.__file__,UserString.__file__]
    for i in filelist:
        sys.path.append(i)
        modpath=string.split(i,".py")[0]
        module=string.split(modpath,'/').pop()
        i=modpath+".py"
        l1=listcf(i)
        lst=listing('lst','lst')
        lst.filepath=i
                         
        pyclass=l1.classin                # classes within the python file
        for j in range(len(pyclass)):
                methods=[]
                methods=getfunctionsinsideclass(lst,module,pyclass[j])
		curr_folder.PBase.ClassBase._setObject(pyclass[j],ClassType(pyclass[j],pyclass[j],pyclass[j],module,methods,i))

    curr_folder.PBase.Functions.Conditions._setObject('if',conditiontype('if','Condition'))
    curr_folder.PBase.Functions.Conditions._setObject('elif',conditiontype('elif','Condition'))
    curr_folder.PBase.Functions.Conditions._setObject('else',conditiontype('else','Condition'))
    curr_folder.PBase.Functions.Conditions._setObject('endif',conditiontype('endif','EndCondition'))
    curr_folder.PBase.Functions.Conditions._setObject('for',conditiontype('for','Loop'))
    curr_folder.PBase.Functions.Conditions._setObject('endfor',conditiontype('endfor','EndLoop'))
    curr_folder.PBase.Functions.Conditions._setObject('endwhile',conditiontype('endwhile','EndLoop'))
    curr_folder.PBase.Functions.Conditions._setObject('while',conditiontype('while','Loop'))
    curr_folder.PBase._setObject('Custom',tabclass('Custom','This contains customized objects')) # Add class instance folder

################ Catalog creation using ZCatalog with apropriate Indexes and Metadata ##############
    curr_folder.manage_addProduct['ZCatalog'].manage_addZCatalog(id='Catalog',title='Catalog for the Product')

    zopeVersion = self.REQUEST['SERVER_SOFTWARE']
    zopeVersion = string.split(zopeVersion,'(').pop(1)

    if string.find(zopeVersion,'Zope 2.5') >= 0:
       curr_folder.Catalog.manage_delIndex('id','FieldIndex')
       curr_folder.Catalog.manage_delIndex('title','FieldIndex')
       curr_folder.Catalog.manage_delIndex('meta_type','FieldIndex')
       curr_folder.Catalog.manage_delIndex('bobobase_modification_time','FieldIndex')
       curr_folder.Catalog.manage_delIndex('PrincipiaSearchSource','FieldIndex')
       curr_folder.Catalog.manage_delColumn('id')
       curr_folder.Catalog.manage_delColumn('title') 
       curr_folder.Catalog.manage_delColumn('meta_type')
       curr_folder.Catalog.manage_delColumn('bobobase_modification_time')
       curr_folder.Catalog.manage_delColumn('summary')

# Index Entries
    curr_folder.Catalog.manage_addIndex('Altname','TextIndex')
    curr_folder.Catalog.manage_addIndex('Inversename','TextIndex')
    curr_folder.Catalog.manage_addIndex('AttMetaType','TextIndex')
    curr_folder.Catalog.manage_addIndex('BaseName','TextIndex')
    curr_folder.Catalog.manage_addIndex('PMetaType','TextIndex')
    curr_folder.Catalog.manage_addIndex('RelMetaType','TextIndex')
    curr_folder.Catalog.manage_addIndex('CFlag', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('Constraint', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('Defined', 'TextIndex') 
    curr_folder.Catalog.manage_addIndex('Description', 'TextIndex')     
    curr_folder.Catalog.manage_addIndex('Flag', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('LObjects', 'TextIndex')    
    curr_folder.Catalog.manage_addIndex('LRoles', 'TextIndex')    
    curr_folder.Catalog.manage_addIndex('Mandatory', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('Necessary', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('OTFlag','TextIndex')
    curr_folder.Catalog.manage_addIndex('ObjectTypes','TextIndex')
    curr_folder.Catalog.manage_addIndex('Optional', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('Participant','TextIndex')
    curr_folder.Catalog.manage_addIndex('ParticipantType','TextIndex')
    curr_folder.Catalog.manage_addIndex('Possible', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('Reflexive','TextIndex')
    curr_folder.Catalog.manage_addIndex('RelationType','TextIndex')
    curr_folder.Catalog.manage_addIndex('RObjects', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('RRoles', 'TextIndex')
    curr_folder.Catalog.manage_addIndex( 'LParticipants', 'TextIndex' )
    curr_folder.Catalog.manage_addIndex( 'RParticipants', 'TextIndex' )
    curr_folder.Catalog.manage_addIndex('Status', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('Symmetric', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('Transitive', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('PObjectType','TextIndex')
    curr_folder.Catalog.manage_addIndex('child_metatypes','TextIndex')
    curr_folder.Catalog.manage_addIndex('child_objecttypes','TextIndex')
    curr_folder.Catalog.manage_addIndex('child_objects','TextIndex')
    curr_folder.Catalog.manage_addIndex('datatype','TextIndex')            
    #curr_folder.Catalog.manage_addIndex('file', 'TextIndex')
    #curr_folder.Catalog.manage_addIndex('ftp', 'TextIndex') 
    curr_folder.Catalog.manage_addIndex('id', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('lRoleContainerIn','TextIndex')
    curr_folder.Catalog.manage_addIndex('lRolePlayedIn','TextIndex')        
    curr_folder.Catalog.manage_addIndex('meta_type','TextIndex')
    curr_folder.Catalog.manage_addIndex('rRoleContainerIn','TextIndex')
    curr_folder.Catalog.manage_addIndex('rRolePlayedIn','TextIndex')    
    #curr_folder.Catalog.manage_addIndex('www', 'TextIndex')
    curr_folder.Catalog.manage_addIndex('path', 'TextIndex')

# Column entries

    curr_folder.Catalog.manage_addColumn('Altname')
    curr_folder.Catalog.manage_addColumn('Inversename')
    curr_folder.Catalog.manage_addColumn('AttMetaType')
    curr_folder.Catalog.manage_addColumn('BaseName')
    curr_folder.Catalog.manage_addColumn('CFlag')
    curr_folder.Catalog.manage_addColumn('PMetaType')
    curr_folder.Catalog.manage_addColumn('RelMetaType')
    curr_folder.Catalog.manage_addColumn('Constraint')
    curr_folder.Catalog.manage_addColumn('Defined')
    curr_folder.Catalog.manage_addColumn('Description') 
    curr_folder.Catalog.manage_addColumn('Flag')
    curr_folder.Catalog.manage_addColumn('LRoles') 
    curr_folder.Catalog.manage_addColumn('LObjects')
    curr_folder.Catalog.manage_addColumn('Mandatory')
    curr_folder.Catalog.manage_addColumn('Necessary')
    curr_folder.Catalog.manage_addColumn('OTFlag')    
    curr_folder.Catalog.manage_addColumn('ObjectTypes')
    curr_folder.Catalog.manage_addColumn('Optional')
    curr_folder.Catalog.manage_addColumn('Participant')
    curr_folder.Catalog.manage_addColumn('ParticipantType')    
    curr_folder.Catalog.manage_addColumn('Possible')
    curr_folder.Catalog.manage_addColumn('RObjects') 
    curr_folder.Catalog.manage_addColumn('RRoles') 
    curr_folder.Catalog.manage_addColumn('Reflexive') 
    curr_folder.Catalog.manage_addColumn('RelationType') 
    curr_folder.Catalog.manage_addColumn('Status')
    curr_folder.Catalog.manage_addColumn('Symmetric')
    curr_folder.Catalog.manage_addColumn('PObjectType')
    curr_folder.Catalog.manage_addColumn('Transitive')
    curr_folder.Catalog.manage_addColumn('LParticipants')
    curr_folder.Catalog.manage_addColumn('RParticipants')
    curr_folder.Catalog.manage_addColumn('child_metatypes')
    curr_folder.Catalog.manage_addColumn('child_objecttypes')
    curr_folder.Catalog.manage_addColumn('child_objects')
    curr_folder.Catalog.manage_addColumn('datatype')              
    #curr_folder.Catalog.manage_addColumn('file')
    #curr_folder.Catalog.manage_addColumn('ftp')
    curr_folder.Catalog.manage_addColumn('id')
    curr_folder.Catalog.manage_addColumn('lRoleContainerIn')
    curr_folder.Catalog.manage_addColumn('lRolePlayedIn')    
    curr_folder.Catalog.manage_addColumn('meta_type')
    curr_folder.Catalog.manage_addColumn('rRoleContainerIn')
    curr_folder.Catalog.manage_addColumn('rRolePlayedIn')        
    #curr_folder.Catalog.manage_addColumn('www')
    curr_folder.Catalog.manage_addColumn('path')
    
########################## Following Metatypes are required for system. #######################
    #Changes made by Hussain  of batch met 04-05 on 20th oct 2004
    #Changes are made to add just one property path instead of three Property www, ftp , file
#    curr_folder.Data.MetaType._setObject('DMetaType',MetaType('DMetaType','MetaType',['DMetaType'],'This is a default MetaType.',['www','ftp','file'],[],[],['www','ftp','file']))
    curr_folder.Data.MetaType._setObject('DMetaType',MetaType('DMetaType','MetaType',['DMetaType'],'This is a default MetaType.',['path'],[],[],['path'])) 
    curr_folder.Data.MetaType.DMetaType._updateProperty('Status','Private')
################################################################################################
    #Changes made by Hussain of batch met 04-05 on 20th oct 2004
    #Following three properties are no more attached since now only one attribute path is attached
    
    # curr_folder.Data.MetaType.DMetaType.manage_addProperty('www',['www'],'lines',REQUEST=None)
    #curr_folder.Data.MetaType.DMetaType.manage_addProperty('ftp',['ftp'],'lines',REQUEST=None)
    #curr_folder.Data.MetaType.DMetaType.manage_addProperty('file',['file'],'lines',REQUEST=None)
    curr_folder.Data.MetaType.DMetaType.manage_addProperty('path',surl + '/Programs/Data/MetaType/DMetaType/viewMetaType','ulines',REQUEST=None)
################################################################################################
##     curr_folder.Data.MetaType.DMetaType.manage_addProperty('child_metatypes',[],'lines',REQUEST=None)
##     curr_folder.Data.MetaType.DMetaType.manage_addProperty('child_objecttypes',[],'lines',REQUEST=None)
    
    PATH = curr_folder.InstancePath + 'Data/MetaType/DMetaType'
    catRef = curr_folder.restrictedTraverse( PATH )
    catRef.index_object()
    incrementCounter(curr_folder, 'GMetaType')    

######################### Following attribute types are required for system. #######################

    curr_folder.Data.AttributeTypes._setObject('Status',attributetype('Status','Status','lines','Status',['DMetaType']))
    PATH = curr_folder.InstancePath + 'Data/AttributeTypes/Status'
    attRef = curr_folder.restrictedTraverse( PATH )
    attRef.index_object()    
    incrementCounter(curr_folder, 'GAttribute Type')

    ###################################################################################################
    #Changes made by Hussain of batch met 04-05 on 20th oct 2004
    #Following attribute path is added to the system instead of three attribute www,file,ftp
    curr_folder.Data.AttributeTypes._setObject('path',attributetype('path','Path','ulines','Path',['DMetaType']))
    PATH = curr_folder.InstancePath + 'Data/AttributeTypes/path'
    attRef = curr_folder.restrictedTraverse( PATH )
    attRef.index_object()    
    incrementCounter(curr_folder, 'GAttribute Type')

#     curr_folder.Data.AttributeTypes._setObject('www',attributetype('www','World Wide Web','lines','World Wide Web',['DMetaType']))
#     PATH = curr_folder.InstancePath + 'Data/AttributeTypes/www'
#     attRef = curr_folder.restrictedTraverse( PATH )
#     attRef.index_object()    
#     incrementCounter(curr_folder, 'GAttribute Type')
 
#     curr_folder.Data.AttributeTypes._setObject('ftp',attributetype('ftp','File Transfer','lines','File Transfer',['DMetaType']))
#     PATH = curr_folder.InstancePath + 'Data/AttributeTypes/ftp'
#     attRef = curr_folder.restrictedTraverse( PATH )
#     attRef.index_object()    
#     incrementCounter(curr_folder, 'GAttribute Type')

#     curr_folder.Data.AttributeTypes._setObject('file',attributetype('file','File','lines','File',['DMetaType']))
#     PATH = curr_folder.InstancePath + 'Data/AttributeTypes/file'
#     attRef = curr_folder.restrictedTraverse( PATH )
#     attRef.index_object()    
#     incrementCounter(curr_folder, 'GAttribute Type')

##################### Following are default Relation Types created for Publishing ##################

    curr_folder.Data.RelationTypes._setObject('related_to',AssocT('related_to','related_to',['DMetaType'],['Experiments'],['Concepts'],'Not defined','Not defined','Not defined',2,0,'OTOT','related_to','related_to','Objects'))
    incrementCounter(curr_folder, 'GRelation Type' )

    curr_folder.Data.RelationTypes._setObject('is_of_DTD_element_type',AssocT('is_of_DTD_element_type','is_of_DTD_element_type',['DMetaType'],['book'],['dtd_book'],'Not defined','Not defined','Not defined',2,0,'OTOT','is_of_DTD_element_type','is_of_DTD_element_type','Objects'))
    incrementCounter(curr_folder, 'GRelation Type' )
    
################## Following are default Object types required for system ##########################

# here the changes r made by hitesh

    otpath_initial = client_home + '/GContent' + instancepath + '/Data/ObjectType/'
    list_objecttype_dirs = ['D','S','b','d']

    for each in list_objecttype_dirs :
        if not (os.path.exists(otpath_initial + each)) :
            os.mkdir(otpath_initial + each)
            
    folder_ref=curr_folder.restrictedTraverse('Data/ObjectType')
    
    folder_ref._setObject('S',BTreeFolder2('S'))
    otpath_initial_ref=curr_folder.restrictedTraverse('Data/ObjectType/S')            
    otpath_initial_ref._setObject('SystemObject',ObjectType('SystemObject','SystemObject',['DMetaType'],['DObjectType'],'This is a default ObjectType.',[],[],[],[]))
    otpath_initial_ref.SystemObject._updateProperty('Status','Private')
    #Changes made by Hussain of batch met 04-05 on 20th oct 2004
    #Following attribute path is added to the system instead of three attribute www,file,ftp    
    otpath_initial_ref.SystemObject.manage_addProperty('path',surl + '/Programs/Data/ObjectType/S/SystemObject/viewObjectType','ulines',REQUEST=None)    
    #otpath_initial_ref.SystemObject.manage_addProperty('www',['www'],'lines',REQUEST=None)
    #otpath_initial_ref.SystemObject.manage_addProperty('ftp',['ftp'],'lines',REQUEST=None)
    #otpath_initial_ref.SystemObject.manage_addProperty('file',['file'],'lines',REQUEST=None)

    incrementCounter(curr_folder, 'GObject Type')

    folder_ref._setObject('D',BTreeFolder2('D'))
    otpath_initial_ref=curr_folder.restrictedTraverse('Data/ObjectType/D')    
    otpath_initial_ref._setObject('DObjectType',ObjectType('DObjectType','Object',['DMetaType'],['DObjectType'],'This is a default ObjectType.',['path'],[],[],['path'])) 
    otpath_initial_ref.DObjectType._updateProperty('Status','Private')
    #Changes made by Hussain of batch met 04-05 on 20th oct 2004
    #Following attribute path is added to the system instead of three attribute www,file,ftp
    otpath_initial_ref.DObjectType.manage_addProperty('path',surl + '/Programs/Data/ObjectType/D/DObjectType/viewObjectType','ulines',REQUEST=None)    
    #otpath_initial_ref.DObjectType.manage_addProperty('www',['www'],'lines',REQUEST=None)
    #otpath_initial_ref.DObjectType.manage_addProperty('ftp',['ftp'],'lines',REQUEST=None)
    #otpath_initial_ref.DObjectType.manage_addProperty('file',['file'],'lines',REQUEST=None)
    PATH = curr_folder.InstancePath + 'Data/ObjectType/D/DObjectType'
    OTRef = curr_folder.restrictedTraverse( PATH )
    OTRef.index_object()    
    incrementCounter(curr_folder, 'GObject Type' )

################### Following are default Object types for publishing ##########################
    
    folder_ref._setObject('b',BTreeFolder2('b'))
    otpath_initial_ref=curr_folder.restrictedTraverse('Data/ObjectType/b')        
    otpath_initial_ref._setObject('book',ObjectType('book','book',['DMetaType'],['DObjectType'],'This is a default ObjectType.',[],[],[],[]))
    otpath_initial_ref.book._updateProperty('Status','authobj')
    incrementCounter(curr_folder, 'GObject Type' )

    folder_ref._setObject('d',BTreeFolder2('d'))
    otpath_initial_ref=curr_folder.restrictedTraverse('Data/ObjectType/d')    
    otpath_initial_ref._setObject('dtd_book',ObjectType('dtd_book','dtd_book',['DMetaType'],['DObjectType'],'This is a default ObjectType.',[],[],[],[]))
    otpath_initial_ref.dtd_book._updateProperty('Status','authobj')
    incrementCounter(curr_folder, 'GObject Type' )

################### Following are default Objects required for system ##########################

    opath_initial = client_home + '/GContent' + instancepath + 'Data/Objects/'
    list_objects_dirs = ['D','c','s']

    for each in list_objects_dirs :
        if not (os.path.exists(opath_initial + each)) :
            os.mkdir(opath_initial + each)
    
    folder_ref=curr_folder.restrictedTraverse('Data/Objects')

    folder_ref._setObject('D',BTreeFolder2('D'))
    opath_initial_ref=curr_folder.restrictedTraverse('Data/Objects/D')        
    opath_initial_ref._setObject('Default',Object('Default','Default Object',['SystemObject'],'This Object is requred by the system please do not delete or add any data to this Object.',[],[]))
    opath_initial_ref.Default._updateProperty('Status','Private')
    incrementCounter(curr_folder, 'GObject' )

###################### Following are default objects for publishing module ##########################

    folder_ref._setObject('c',BTreeFolder2('c'))
    opath_initial_ref=curr_folder.restrictedTraverse('Data/Objects/c')
    opath_initial_ref._setObject('chapter',Object('chapter','chapter',['dtd_book'],'This Object is requred by the system please do not delete or add any data to this Object.',[],[]))
    opath_initial_ref.chapter._updateProperty('Status','authobj')
    incrementCounter(curr_folder, 'GObject' )

    folder_ref._setObject('s',BTreeFolder2('s'))
    opath_initial_ref=curr_folder.restrictedTraverse('Data/Objects/s')
    opath_initial_ref._setObject('section',Object('section','section',['dtd_book'],'This Object is requred by the system please do not delete or add any data to this Object.',[],[]))
    opath_initial_ref.section._updateProperty('Status','authobj')
    incrementCounter(curr_folder, 'GObject' )

    opath_initial_ref._setObject('subsection',Object('subsection','subsection',['dtd_book'],'This Object is requred by the system please do not delete or add any data to this Object.',[],[]))
    opath_initial_ref.subsection._updateProperty('Status','authobj')
    incrementCounter(curr_folder, 'GObject' )

    opath_initial_ref._setObject('subsubsection',Object('subsubsection','subsubsection',['dtd_book'],'This Object is requred by the system please do not delete or add any data to this Object.',[],[]))
    opath_initial_ref.subsubsection._updateProperty('Status','authobj')
    incrementCounter(curr_folder, 'GObject' )

# the changes r made till here by hitesh

########################################## Adding a mailhost ########################################
    curr_folder.manage_addProduct['MailHost'].manage_addMailHost(id='mailhost',title='Mail Host',smtp_host=REQUEST['SMTP_Host'],localhost='localhost',smtp_port=REQUEST['Port'],timeout=1.0,REQUEST=None) 

########################################## External Method & myRPC Folder ########################################
    rpc=curr_folder
    #Following line is commented by hussain to make rpc folder a BtreeFolder2
    #rpc.manage_addFolder('myRPC','myRPC')
    rpc._setObject('myRPC',BTreeFolder2('myRPC'))
    rpc = rpc.myRPC

 ################################################## GQL ############################################
    manage_addExternalMethod(rpc,'count','Id Type Required Type of Type','GNOWSYS06.GQL','count',REQUEST)
    manage_addExternalMethod(rpc,'countAll','Type','GNOWSYS06.GQL','countall',REQUEST)
    manage_addExternalMethod(rpc,'getAll','Type','GNOWSYS06.GQL','getall',REQUEST)
    manage_addExternalMethod(rpc,'getAllAttributeTypeofMetaType','MetaType','GNOWSYS06.GQL','get_allatttyp_of_cat',REQUEST)
    manage_addExternalMethod(rpc,'getAllProperties','Id Type','GNOWSYS06.GQL','getobjprop',REQUEST)
    manage_addExternalMethod(rpc,'getAllRelationTypeofMetaType','MetaType','GNOWSYS06.GQL','get_allreltyp_of_cat',REQUEST)
    manage_addExternalMethod(rpc,'getListWithGivenAttributeValue','Type [attributename=attval] mode','GNOWSYS06.GQL','getlist_with_some_attval',REQUEST)
    manage_addExternalMethod(rpc,'getMathFunction','Type Attribute Function','GNOWSYS06.GQL','getmath',REQUEST)
    manage_addExternalMethod(rpc,'getObjectTypeofMetaType','MetaType','GNOWSYS06.GQL','get_ots_of_cat',REQUEST)
    manage_addExternalMethod(rpc,'getObjectofMetaType','MetaType','GNOWSYS06.GQL','objs_of_cat',REQUEST)
    manage_addExternalMethod(rpc,'getObjectsofObjectType','ObjectType','GNOWSYS06.GQL','get_obj_of_ot',REQUEST)
    manage_addExternalMethod(rpc,'getRange','Type Attribute 1stOperator value 2ndOperator value','GNOWSYS06.GQL','getconditionalvalue',REQUEST)
    manage_addExternalMethod(rpc,'getRelationsofRelationType','RelationType','GNOWSYS06.GQL','get_rel_of_reltype',REQUEST)
    manage_addExternalMethod(rpc,'getSubMetaTypeofMetaType','MetaType','GNOWSYS06.GQL','get_subcat_of_cat',REQUEST)
    manage_addExternalMethod(rpc,'getSubObjectTypeofObjectType','ObjecType','GNOWSYS06.GQL','get_subot_of_ot',REQUEST)
    manage_addExternalMethod(rpc,'groupby','Type [List of Attributes] groupby','GNOWSYS06.GQL','groupby',REQUEST)
    manage_addExternalMethod(rpc,'listMetaTypeRelation','MetaType or ObjectType','GNOWSYS06.GQL','list_catrel_of',REQUEST)
    manage_addExternalMethod(rpc,'listObjectWithAttributes','Type [List of Attributes] Mode','GNOWSYS06.GQL','list_obj_with_att',REQUEST)
    manage_addExternalMethod(rpc,'listRelationTypeof','ObjectType or Object','GNOWSYS06.GQL','list_rt_of',REQUEST)
    manage_addExternalMethod(rpc,'listRelationsWithRoles','Id of Lrole Id of Rrole','GNOWSYS06.GQL','list_rel_with_roles',REQUEST)
    manage_addExternalMethod(rpc,'listRelationsof','TypeId','GNOWSYS06.GQL','list_rel_of',REQUEST)
    manage_addExternalMethod(rpc,'listRoles','TypeId','GNOWSYS06.GQL','list_roles',REQUEST)
    manage_addExternalMethod(rpc,'orderBy','Type [list of Attribute Required] Orderby','GNOWSYS06.GQL','get_orderedlist',REQUEST)
    manage_addExternalMethod(rpc,'getAnyProperty','Id Type Property','GNOWSYS06.GQL','getanyproperty',REQUEST)
    manage_addExternalMethod(rpc,'getPropertyValues','Type [list of Properties]','GNOWSYS06.GQL','getpropvalues',REQUEST)

    manage_addExternalMethod(rpc,'getTreeOfObjectType','Id of ObjectType','GNOWSYS06.GQL','gettreeobjecttype',REQUEST)
    manage_addExternalMethod(rpc,'getTreeOfMetaType','Id of MetaType','GNOWSYS06.GQL','gettreemetatype',REQUEST)
   
# #################################### manageAdd #################################################

#     manage_addExternalMethod(rpc,'addMetaType','Id BaseName [Parent MetaType] Description','GNOWSYS06.manageAdd','addMetaType',REQUEST)
#     manage_addExternalMethod(rpc,'addObjectType','Id BaseName [Parent MetaType] [Parent ObjectType] Description','GNOWSYS06.manageAdd','addObjectType',REQUEST)
#     manage_addExternalMethod(rpc,'addObject','Id BaseName [Parent ObjectType] Description','GNOWSYS06.manageAdd','addObject',REQUEST)
#     manage_addExternalMethod(rpc,'addAttributeType','Id BaseName DataType [MetaType] Description','GNOWSYS06.manageAdd','addAttributeType',REQUEST)
#     manage_addExternalMethod(rpc,'addAttribute','Type Id_of_Type AttName Scope FillMode AttributeValue','GNOWSYS06.manageAdd','addAttribute',REQUEST)
#     manage_addExternalMethod(rpc,'addMetaTypeRelation','Id BaseName Btw [LRoles] [RRoles] Constraint Reflexive Transitive Symmetric','GNOWSYS06.manageAdd','addMetaTypeRel',REQUEST)
#     manage_addExternalMethod(rpc,'addRelationType','Id BaseName AlternateName InverseName [MetaType] Btw [LRoles] [RRoles] Constraint Reflexive Transitive Symmetric Necessary','GNOWSYS06.manageAdd','addRelType',REQUEST)
#     manage_addExternalMethod(rpc,'addRelation','Id_of_RelationType [LRoles] [RRoles]','GNOWSYS06.manageAdd','addRelation',REQUEST)

#     ##################################### manageEdit ################################################
#     manage_addExternalMethod(rpc,'editMetaType','Id AttName Scope FillMode AttributeValue','GNOWSYS06.manageEdit','metatypeedit',REQUEST)
#     manage_addExternalMethod(rpc,'editObjectType','Id AttName Scope FillMode AttributeValue','GNOWSYS06.manageEdit','objecttypeedit',REQUEST)
#     manage_addExternalMethod(rpc,'editObject','Id AttName Scope FillMode AttributeValue','GNOWSYS06.manageEdit','objectedit',REQUEST)
#     manage_addExternalMethod(rpc,'editRelationType','Id AttName AttributeValue','GNOWSYS06.manageEdit','relationtypeedit',REQUEST)
#     manage_addExternalMethod(rpc,'editMetaTypeRelation','Id AttName AttributeValue','GNOWSYS06.manageEdit','metatyperelationedit',REQUEST)
#     manage_addExternalMethod(rpc,'editMembership','Type Id AttName AttributeValue','GNOWSYS06.manageEdit','membershipedit',REQUEST)
    
#      #################################### manageDelete ###########################################

#     manage_addExternalMethod(rpc,'deleteMetaType','Id','GNOWSYS06.manageDelete','deleteMetaType',REQUEST)
#     manage_addExternalMethod(rpc,'deleteObjectType','Id','GNOWSYS06.manageDelete','deleteObjectType',REQUEST)
#     manage_addExternalMethod(rpc,'deleteObject','Id','GNOWSYS06.manageDelete','deleteObject',REQUEST)
#     manage_addExternalMethod(rpc,'deleteRelationType','Id','GNOWSYS06.manageDelete','deleteRelationType',REQUEST)
#     manage_addExternalMethod(rpc,'deleteRelation','Id','GNOWSYS06.manageDelete','deleteRelation',REQUEST)
#     manage_addExternalMethod(rpc,'deleteMetaTypeRelation','Id','GNOWSYS06.manageDelete','deleteMetaTypeRelation',REQUEST)
#     manage_addExternalMethod(rpc,'deleteAttributeType','Id','GNOWSYS06.manageDelete','deleteAttributeType',REQUEST)
#     manage_addExternalMethod(rpc,'deleteAttribute','Type Id AttributeName','GNOWSYS06.manageDelete','deleteAttribute',REQUEST)

##################### Transparent Folder creation ##################################################

   # manage_addTransparentFolder(curr_folder,'Programs','Programs')
   #above line commented by hussain and following line has been added to create Programs folder as BtreeFolder2
    curr_folder._setObject('Programs',BTreeFolder2('Programs'))

############# Cloning all files from CF folder to Programs of the New Instance. #####################

    tdir = Globals.package_home(globals())
    tdir = tdir + '/CF'
    t = os.listdir(tdir)
    #menu.dtml standard_html_header standard_html_footer and index_html are created outside the Programs Folder
    for temp in t:
        tp = os.path.splitext(os.path.basename(temp))
        fp = os.path.join('CF',tp[0])
        if tp[1] == '.dtml':
            if tp[0] in ['standard_html_header','standard_html_footer','menu','index_html'] :
                addDTML(curr_folder,tp[0],"Method",fp)
            else :
                addDTML(curr_folder.Programs,tp[0],"Method",fp)
        if tp[1] == '.pt' or tp[1] == '.zpt':
            if tp[0] in ['viewAttributes','viewMetaType','viewMetaTypeRelation','viewObject','viewObjectType','viewRelationType','viewRelation'] :
                addPageTemplate(curr_folder,tp[0],"Page Template",fp+tp[1])
            else :
                addPageTemplate(curr_folder.Programs,tp[0],"Page Template",fp+tp[1])
        if tp[1] == '.py':
            addPythonScript(curr_folder.Programs,tp[0],fp)
                
    curr_folder = curr_folder.Programs            
    curr_folder.dtmlholder.manage_addProperty('list',[],'tokens') 
    curr_folder.dtmlholder.manage_addProperty('list2',['Take a Pre-test','View Concept Details','Pre-requisite Concepts','View Experiments','Take a Post-test'],'lines')

######################### External Methods for Import and Export in XTM #############################
    manage_addExternalMethod(curr_folder,'XTMImport','Import-Export method','GNOWSYS06.XTM_Import','importXTMFile',REQUEST)
    manage_addExternalMethod(curr_folder,'XTMExport','Export-XML format','GNOWSYS06.XTM_Export','createXMLFile',REQUEST)
################## External Methods for Import and Export in GnowML  #############################
    manage_addExternalMethod(curr_folder,'GnowMLImport','GnowML Import ','GNOWSYS06.Gnowml_Import','importGnowMLFile',REQUEST)
    manage_addExternalMethod(curr_folder,'GnowMLExport','GnowML Export ','GNOWSYS06.Gnowml_Export','createGnowMLFile',REQUEST)

################## External Methods for Import and Export in GnowML  #############################
    manage_addExternalMethod(curr_folder,'owlImport','Import - OWL format ','GNOWSYS06.OWLImport','importOWLFile',REQUEST)
    manage_addExternalMethod(curr_folder,'owlExport','Export - OWL format','GNOWSYS06.OWLExport','performOWLExport',REQUEST)

####################### External Methods for Graphical Representation Module ########################
#     manage_addExternalMethod(curr_folder,'addimg','Add PNG','GNOWSYS06.membership_tree','addPng',REQUEST)
#     manage_addExternalMethod(curr_folder,'addeps','Add EPS','GNOWSYS06.membership_tree','addeps',REQUEST)
#     manage_addExternalMethod(curr_folder,'addmp','Add MP','GNOWSYS06.membership_tree','addmp',REQUEST)
#     manage_addExternalMethod(curr_folder,'membershiptree','Membership Tree','GNOWSYS06.membership_tree','addnewmp',REQUEST)
#     manage_addExternalMethod(curr_folder,'multiassoctree','Relation Tree','GNOWSYS06.multi_assoc','addnewmp',REQUEST)

########################### Folder for Graphical Representation Module ##############################
    curr_folder.manage_addFolder('createdImages', 'Created Images')

############################## External Methods for Publishing #####################################
    manage_addExternalMethod(curr_folder,'Apub_mkext','','GNOWSYS06.new','readfile',REQUEST)
    manage_addExternalMethod(curr_folder,'Apub_ext1','','GNOWSYS06.new','ftex',REQUEST)
    manage_addExternalMethod(curr_folder,'Apub_exttex','','GNOWSYS06.new','filetex',REQUEST)
    manage_addExternalMethod(curr_folder,'Apub_extpdf','','GNOWSYS06.new','file',REQUEST)

############################## External Methods for stx & tex support #####################################
    manage_addExternalMethod(curr_folder,'getContent','To get content','GNOWSYS06.contentManager','getContent',REQUEST)
    manage_addExternalMethod(curr_folder,'setContent','To save content','GNOWSYS06.contentManager','setContent',REQUEST)
    manage_addExternalMethod(curr_folder,'Uploadfile','To upload content','GNOWSYS06.contentManager','Uploadfile',REQUEST)
    
    return self.manage_main(self,REQUEST,update_menu=1)

def get_attr(base_obj,curr_obj,err):
    try:
        curr_folder = getattr(base_obj,curr_obj)
    except:
        return err
    return curr_folder

def addPythonScript(obj,id,file):
    f=open(file_path+'/'+file+'.py')     
    file=f.read()     
    f.close()     
    manage_addPythonScript(obj,id)
    obj._getOb(id).write(file)
    return getattr(obj,id)

def addDTML(obj,id,title,file):     
    f=open(file_path+'/'+file+'.dtml')     
    file=f.read()     
    f.close()     
    obj.manage_addDTMLMethod(id,title,file)     
    return getattr(obj,id)     

def addPageTemplate(obj,id,title,file):
    f=open(file_path+'/'+ file)
    file=f.read()
    f.close()
    zpt=ZopePageTemplate(id, file)
    zpt.pt_setTitle(title)
    obj._setObject(id,zpt)
    return getattr(obj,id)
     
def addImage(obj,id,file):
    f=open(file_path+'/'+file,'rb')
    contents=f.read()
    f.close()
    title=''
    tlen = len(contents)
    new_id = obj.manage_addImage(id,contents,title=title)
    img_obj = obj.__getitem__(new_id)
    img_obj.content_type = 'image/gif'

def addZCatalog(obj,id,file):
    f=open(file_path+'/'+file)
    file=f.read()
    f.close()
    manage_addZCatalog(obj,id)
    obj._getOb(id).write(file)
    return getattr(obj,id)

def incrementCounter(self, meta_type):
    """
    This function keeps track of the counters by incrementing respective properties as soon as an Object or Object Type etc.is added
    """
    counter = 0
    Rcounter = 0
    Ocounter = 0
    OTcounter = 0
    MTcounter = 0
    RTcounter = 0
    ATcounter = 0
    
    if meta_type == 'GObject Type':
	    OTcounter = self.getProperty( 'object_types' )
	    OTcounter = OTcounter + 1
	    self._updateProperty('object_types',OTcounter)
    elif meta_type == 'GMetaType':
	    MTcounter = self.getProperty( 'metatypes' )
	    MTcounter = MTcounter + 1
	    self._updateProperty('metatypes',MTcounter)
    elif meta_type == 'GObject':
	    Ocounter = self.getProperty( 'objects' )
	    Ocounter = Ocounter + 1
	    self._updateProperty('objects',Ocounter)	    
    elif meta_type == 'GRelation':
	    counter = self.getProperty( 'relations' )
	    Rcounter = Rcounter + 1
	    self._updateProperty('relations',Rcounter)	    
    elif meta_type == 'GRelation Type':
	    RTcounter = self.getProperty( 'relation_types' )
	    RTcounter = RTcounter + 1
	    self._updateProperty('relation_types',RTcounter)	    
    elif meta_type == 'GAttribute Type':
	    ATcounter = self.getProperty( 'attribute_types' )
	    ATcounter = ATcounter + 1
	    self._updateProperty('attribute_types',ATcounter)
    totalCounter = self.getProperty( 'total' )
    totalCounter = totalCounter + 1
    self._updateProperty('total',totalCounter)

confirm=DTMLFile('CF/confirm',globals())
callinterfun=DTMLFile('pdtml/callinterfun',globals())
enterpath = DTMLFile('pdtml/enterpath',globals()) # Used to view content of the object

InitializeClass(GNOWSYS)
