######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################
# This file contain functions which are useful for content file management.

import os
import string
import sys
import StructuredText
from StructuredText import Basic
from StructuredText import Document
from StructuredText import HTML

from types import StringType
from mimetypes import guess_extension
from webdav.Lockable import ResourceLockedError

def getContent(self,type_file):

 	"""
	This function returns content of stored in the filesystem
	"""
	#Objects and Object Type has been hashed 
	if type_file == 'Objects' or type_file == 'ObjectType' :
		type_file = type_file + "/" +  self.id[0]

	filepath = CLIENT_HOME + '/GContent' + self.InstancePath +'Data/' + type_file  + '/'
	#guessing the extension
	extension=guess_ext(self.content_type)
        
        #Retrieving the contents of the Object
	if os.path.exists(filepath + self.id + extension):
		file = open(filepath + self.id + extension,'r')
		contents = file.read()
		file.close()
		return contents
	else:
		#we are here since, the extension that we guessed this time is different from the one that we used to store the contents
		#This difference occurs since we guess the extension based on content_type
		#so now checking the directory wether the file exists or not by ignoring the extension
		if not os.path.exists(filepath):
			return ""
		list_files = os.listdir(filepath)
		#looping over the list to check wether the file containing the content of this object exist
		#this is done by checking only the filename with the id of the object ignoring the extension
		for file in list_files:
			if self.id == os.path.splitext(file)[0]: #Checking the filename with the id of the Object
				file = open(filepath + file,'r')
				contents = file.read()
				file.close()
				return contents
	#if we are here then the file does'nt exist return blank contents
	return ""

def Uploadfile(self, REQUEST):
	"""Replace the document with the text in file."""
	if self.wl_isLocked():
		raise ResourceLockedError, "File is locked via WebDAV"        
        file=REQUEST['upload_file']	
	if type(file) is not StringType:
		if not file: raise ValueError, 'File not specified'
		#Storing the contents of the file being uploaded
		contents = file.read()
	#Storing the contents to the FileSystem
	content_to_fs(self,REQUEST,contents,mode='Uploadfile')
	#the function set the content type in the request Object
	REQUEST.set('content_type',self.content_type)
	return ""

def content_to_fs(self,REQUEST,contents,mode='setContent'):
	#Function to store the contents to the filesystem 
	#Since Hashing is done changing the path based on type	
	type_file=str(REQUEST['type'])
	if type_file=='Objects' or type_file=='ObjectType':		
 	    type_file = type_file + '/' + self.id[0]
	    
       	filepath = CLIENT_HOME + '/GContent' + self.InstancePath +'Data/'  + type_file + '/'
	
	#Setting the content Type based on file being uploaded
	content_type=""	
	if mode == 'setContent':
		content_type=REQUEST['content_type']
	else:
		content_type=self._get_content_type(REQUEST['upload_file'], contents, self.id)
	if self.content_type != content_type and os.path.exists(filepath):
		#removing the old file with different extension
		#so now checking the directory wether the file exists or not by ignoring the extension
		list_files = os.listdir(filepath)
		#looping over the list to check wether the file containing the content of this object exist
		#this is done by checking only the filename with the id of the object ignoring the extension
		for file in list_files:
			if self.id == os.path.splitext(file)[0]: #Checking the filename with the id of the Object
				os.system('rm -Rf ' + filepath + file) #Removing the file whose name starts with the objects name
				
        self.content_type=content_type
	#guessing the extension
	extension=guess_ext(content_type)
        
        #Creating the directory in the filesystem having the name similiar to the ID of the Object
	if not(os.path.exists(filepath)):
		os.makedirs(filepath)
		
	#Storing the content as a image, html or other type based on the contenttype being loaded
        filename = filepath + self.id + extension
 	file = open(filename,'w')
 	file.write(contents)
 	file.close()

def guess_ext(content_type):
	#If somebody changed the content_type using ZMI, this function will return the wrong extension
	#and other function won't be able to open the file from the filesystem
	# A list that stores the extension that should be used based on content type
	extension=""
	extension_list={'text/plain':'.txt','text/html':'.html','application/octet-stream':'.none'}
	if extension_list.has_key(content_type):
		extension=extension_list[content_type]
	else:
		extension=guess_extension(content_type)
		if extension == None:
			extension = ".none"
	return extension
        
def setContent(self,REQUEST):
	
	"""
	This function stores content in a file.
	"""	
	# Adding attributes and contents to the file
#	return "Called"
        id = self.id
        type_file = REQUEST['type']
	RFlag = REQUEST['RFlag']

	#if the Object,Object Type or Meta Type  is being edited only its content is changed
        if RFlag=='Edit':
		text = REQUEST['text']
		self.title=str(REQUEST['title'])
		#Storing the contents to the FileSystem
		content_to_fs(self,REQUEST,text)
		self.reindex_object()
	        REQUEST.RESPONSE.redirect(self.InstancePath + 'Programs/EditForm')
		return 

	#updating the description
        self._updateProperty("Description", REQUEST["Description"])
	
       # The Object , Object Type and Meta type Information , description , contents are saved here

	text = REQUEST['text']
        self.title=str(REQUEST['title'])
        #Storing the contents to the FileSystem
	content_to_fs(self,REQUEST,text)
	
	PATH = self.InstancePath + "Data/"

	inheritedAttr=[] #list containing the defining attributes to be attached to the Object
	possibleAttr=[] #list containing the possible attributes that can be attached to the Object

	#Adding the list of defined attributes to inherited attribuites that are to be added to the object implicitly
	inheritedAttr=  REQUEST.get("txtdefined")
	if inheritedAttr==None: #if no defined attribuites need to be inherited
		inheritedAttr=[]
	
	#determining which of the Possible attributes to be attached to the Object
	possibleAttr= REQUEST.get("chkpossible")
	if possibleAttr != None: #If no check box is selected or possible attributes is not needed to be inherited
		for attr in possibleAttr:	
			inheritedAttr.append(attr)

        #Checking wether value is provided for all the mandatory attribute
	inherit_mand=[]
	mesg=""	
	for i in self.Mandatory:
		if i in inheritedAttr:
#			print "inheriterd mandatory " , i , "   Request :: " , REQUEST.get('attr_' + i)
			if REQUEST.get('attr_' + i)== "":
				#if we are here then value is not provided for a mandatory attribute
				#thus creating a list to display in the HTML page
				attributeType = self.restrictedTraverse(PATH + 'AttributeTypes/' + i)
				attributeBN = attributeType.getProperty('BaseName')
#				print "In here" + attributeBN
				mesg = mesg + attributeBN + "<br>"
		        inherit_mand.append(i)
        if mesg != "":
		mesg_mandatory = "You must supply a value for the following attribute<br><ul>" + \
		                  mesg + "</ul><br>"

		REQUEST.response.redirect(self.InstancePath + 'Programs/addContentError?m_error=%s' %mesg)
		return 
        
        replyform=""
        #Adding the attribute along with the value to the Meta Type
	if type_file=="MetaType":
		ExistingProperties = self.propertyIds()
		for eachId in ExistingProperties:
			if eachId in inheritedAttr:
				inheritedAttr.remove(eachId)
				
		catlist=[]
		catlist=self.getProperty('PMetaType')
		if 'Cateory' in catlist:
			catlist.remove('MetaType')
		if inheritedAttr!=[]:
			for i in inheritedAttr:
				attributeType = self.restrictedTraverse(PATH + 'AttributeTypes/' + i)
				attributeDataType = attributeType.getProperty('datatype')
				tmpatt=REQUEST['attr_' + i]				
				if tmpatt != "":
					self.manage_addProperty( i, tmpatt, attributeDataType)
					continue
				
				for cat in catlist:
					newcat = self.restrictedTraverse(PATH + 'MetaType/' + cat)
					if newcat.hasProperty(i):
						tmpatt=newcat.getProperty(i)						
						self.manage_addProperty( i, tmpatt, attributeDataType)
						break
			inheritedAttr.append('path')		
			#inheritedAttr.append('www')
			#inheritedAttr.append('ftp')
			#inheritedAttr.append('file')
			TDValues=[]
			TPValues=[]
			for i in self.Defined:
				if i in inheritedAttr:
					TDValues.append(i)
			for i in self.Possible:
				if i in inheritedAttr:
					TPValues.append(i)
			self.manage_changeProperties(Defined=TDValues)
			self.manage_changeProperties(Possible=TPValues)
		replyform="newid=" + self.id + "&newnm=MetaType"
	
        #Adding the attribute along with the value to the Object Type
	if type_file=="ObjectType":
		type_file = type_file + '/' + id[0]
		parentCategories=[]
		parentCategories=self.getProperty('PMetaType')
		if 'Category' in parentCategories:
			parentCategories.remove('MetaType')

 	        parentObjectTypes=[]
		parentObjectTypes=self.getProperty('PObjectType')
		if 'Object' in parentObjectTypes:
			parentObjectTypes.remove('Object')

		checkFlagOT=0

		if inheritedAttr!=[]:
			for i in inheritedAttr:			
			        attributeType = self.restrictedTraverse(PATH + 'AttributeTypes/' + i)
                   		attributeDataType = attributeType.getProperty('datatype')
				checkFlagOT=0
				tmpatt=REQUEST['attr_' + i]
   		                if tmpatt != "":
					self.manage_addProperty( i, tmpatt, attributeDataType)
					continue
				
				for eachObjectTypeId in parentObjectTypes:					
					parentObjectType = self.restrictedTraverse(PATH + 'ObjectType/' + eachObjectTypeId[0] + '/' + eachObjectTypeId)
					if parentObjectType.hasProperty(i):
						tmpatt=parentObjectType.getProperty(i)
						checkFlagOT=1
						break
				if checkFlagOT==0:
					for eachMetaTypeId in parentCategories:
						parentMetaType = self.restrictedTraverse(PATH + 'MetaType/' + eachMetaTypeId)
						if parentMetaType.hasProperty(i):
							tmpatt=parentMetaType.getProperty(i)
							break
				self.manage_addProperty( i, tmpatt, attributeDataType)

			TDValues=[]
			TPValues=[]
			for i in self.Defined:
				if i in inheritedAttr:
					TDValues.append(i)
			for i in self.Possible:
				if i in inheritedAttr:
					TPValues.append(i)
			self.manage_changeProperties(Defined=TDValues)
			self.manage_changeProperties(Possible=TPValues)
		replyform="newid=" + self.id + "&newnm=ObjectType"
			
        #Adding the attribute along with the value to the Object
	if type_file=="Objects":
		type_file = type_file + '/' + id[0]
		otlist=[]
		otlist=self.ObjectTypes
		if inheritedAttr<>[]:
			for i in inheritedAttr:
			      #Retrieving datatype of the Attribute
			      attributeType = self.restrictedTraverse(PATH + 'AttributeTypes/' + i)
			      attributeDataType = attributeType.getProperty('datatype')
			
			      #tmpatt is the value for the property
			      #if value is supplied by the user then using it otherwise using the
			      #value supplied while adding the Object Type
			      tmpatt=REQUEST['attr_' + i]
			      if tmpatt != "":
				      self.manage_addProperty( i, tmpatt, attributeDataType)
				      continue
			      #Searching the Object Type for value of the attribute
			      for ot in otlist:
				      newot = self.restrictedTraverse(PATH + 'ObjectType/' + ot[0] + '/' + ot)
				      if newot.hasProperty(i):
					      tmpatt=newot.getProperty(i)
					      self.manage_addProperty( i, tmpatt, attributeDataType)
					      break
		replyform="newid=" + self.id + "&newnm=Object"

	#Updating the Mandatory field and Optional Field
	inherit_opt=[]
	for i in self.Optional:
		if i in inheritedAttr:
			inherit_opt.append(i)
	self.manage_changeProperties(Mandatory=inherit_mand)
	self.manage_changeProperties(Optional=inherit_opt)
	self.reindex_object()
	if RFlag=='Add':		
                REQUEST.RESPONSE.redirect(self.InstancePath + 'Programs/Data/' + type_file +'/' + id + '/replyadd?' + replyform)


# The following getContent is no more used but is not deleted for future refrence

# def getContent(self,id,type,extensionFlag):

#  	"""
# 	This function returns content of file.
# 	"""
# ###############################################################################################################################
	
# # the statements below are added by hitesh

# 	if type != 'Objects' and type != 'ObjectType' :
# 		filepath = CLIENT_HOME + '/GContent' + self.InstancePath +'Data/' + type + '/' + id + '/'
# 	else :
# 		filepath = CLIENT_HOME + '/GContent' + self.InstancePath +'Data/' + type + '/' + id[0] + '/' + id + '/'

# ###############################################################################################################################
# 	priorityList = []

# 	if extensionFlag == 'edit':
# 		priorityList = ['.tex','.stx','.html']
# 		for each in priorityList:
# 			tfilename = filepath + id + each
# 			if os.path.exists(tfilename):
# 				filename = tfilename
# 				exists = 1
# 				break
# 			else:
# 				exists = 0
# 				continue
# 	elif extensionFlag == 'view':
# 		priorityList = ['.html','.stx','.tex']
# 		for each in priorityList:
# 			tfilename = filepath + id + each
# 			if os.path.exists(tfilename):
# 				filename = tfilename
# 				exists = 1
# 				break
# 			else:
# 				exists = 0
# 				continue

# 	if exists == 1:
# 		file = open(filename,'r')
# 		contents = file.read()
# 		file.close()
# 		return contents
# 	else:
# 		return ""



# The following setContent is no more used but is not deleted for future refrence

# def setContent(self,REQUEST):
	
# 	"""
# 	This function stores content in a file.
# 	"""
# 	id = self.id
#         type = REQUEST['type']
# 	text = REQUEST['text']        
# 	#extension = "" # REQUEST['extension']

# # changes made to contents r saved here these r copied from pt_editAction

# 	self.expand=REQUEST['expand']
#         self.pt_setTitle(REQUEST['title'])
#         self.pt_edit(text, REQUEST['content_type'])
# 	REQUEST.set('text', self.read()) 
# 	if getattr(self, '_v_warnings', None):
# 		message = ("<strong>Warning:</strong> <i>%s</i>" % '<br>'.join(self._v_warnings))
# 	prg = self.restrictedTraverse(self.InstancePath + 'Programs' )	
# 	prg.copySelectedAttributesToObject(REQUEST)
# 	for attr_nm in REQUEST['attr']:
# 		value=REQUEST.get(attr_nm)
# 		if value!=None:
# 			self._updateProperty(attr_nm, value)		

# # changes made in properties r saved here these r copied from manage_editProperties

# #         for prop in self._propertyMap():
# # 		name=prop['id']
# # 		print "mandatory = ",name
# # 		if 'w' in prop.get('mode', 'wd'):
# # 			if prop['type'] == 'multiple selection':
# # 				value=REQUEST.get(name)
# # 			else:
# # 			        value=REQUEST.get(name)
				
# # 			if value!=None:
# # 				self._updateProperty(name, value)
					
# 	replyForm=''
#         if type=='Objects':
		
# ###############################################
# #	the statement below is added by hitesh
# 	    type = type + '/' + id[0]
# ###############################################
	    
#             replyForm='DisplayInheritedPropertiesforObject'
#         elif type=='ObjectType':
		
# ###############################################
# #	the statement below is added by hitesh		
# 	    type = type + '/' + id[0]
# ###############################################
	    
#             replyForm='DisplayInheritedPropertiesforObjectType'
#         elif type=='MetaType':
#             replyForm='DisplayInheritedPropertiesforMetaType'

# # #	filepath = CLIENT_HOME + '/GContent' + self.InstancePath +'Data/' + type + '/' + id + '/'
# # #	if not(os.path.exists(filepath)):

# # ###############################################

# # #		os.mkdir(filepath)

# # # the above statement is replaced by the statement below

# # #		os.makedirs(filepath)
# # ###############################################
		
# # 	if extension == 'default':
# # 		optionstx = id + '.stx'
# # 		optiontex = id + '.tex'
# # 		if os.path.exists(filepath + optiontex):
# # 			extension = '.tex'
# # 		elif os.path.exists(filepath + optionstx):
# # 			extension = '.stx'
# # 		else:
# # 			extension = '.html'
	
# #         filename = filepath + id + extension

# # 	file = open(filename,'w')
# # 	file.write(contents)
# # 	file.close()

# # 	converter(filepath,id,extension)

# 	RFlag = REQUEST['RFlag']
# 	if RFlag=='Add':
# 		BaseName = self.BaseName
#                 REQUEST.RESPONSE.redirect(self.InstancePath + 'Programs/Data/' + type +'/' + id + '/' + replyForm + '?Id=%s&BaseName=%s' % (id,BaseName))
# 	elif RFlag=='Edit':
# 	        REQUEST.RESPONSE.redirect(self.InstancePath + 'Programs/EditForm')


	   
def converter(filepath,file,extension):
	if extension == '.tex':
		filename = filepath + file + extension
		tex_to_html='latex2html -split 0 -no_subdir -info 0 -no_navigation ' +  filename
		os.system(tex_to_html)
	elif extension == '.stx':
		filename = filepath + file + extension

		fp = open(filename,'r')
		raw = fp.read()
		fp.close()		

		st = StructuredText.Basic(raw)
		doc = StructuredText.Document(st)
		html = StructuredText.HTML(doc)
		
		filename1 = filepath + file + '.html'
		fpo= open(filename1,'w')
		fpo.write(html)
		fpo.close()
