######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

# This file contain functions which are useful for content file management.

import os
import string
import sys
import StructuredText
from StructuredText import Basic
from StructuredText import Document
from StructuredText import HTML


def getContent(self,id,type,extensionFlag):

 	"""
	This function returns content of file.
	"""
	
	filepath = CLIENT_HOME + '/GContent' + self.InstancePath +'Data/' + type + '/' + id + '/'

	priorityList = []
	
	if extensionFlag == 'edit':
		priorityList = ['.tex','.stx','.html']
		for each in priorityList:
			tfilename = filepath + id + each
			if os.path.exists(tfilename):
				filename = tfilename
				break
			else:
				continue
	elif extensionFlag == 'view':
		priorityList = ['.html','.stx','.tex']
		for each in priorityList:
			tfilename = filepath + id + each
			if os.path.exists(tfilename):
				filename = tfilename
				break
			else:
				continue
	                            
	file = open(filename,'r')
	contents = file.read()
	file.close()

	return contents

def setContent(self,REQUEST):
	
	"""
	This function stores content in a file.
	"""

	id = REQUEST['Id']
        type = REQUEST['type']
	contents = REQUEST['content']        
	extension = REQUEST['extension']
		
	replyForm=''
        if type=='Objects':
            replyForm='DisplayInheritedPropertiesforObject'
        elif type=='ObjectType':
            replyForm='DisplayInheritedPropertiesforObjectType'
        elif type=='MetaType':
            replyForm='DisplayInheritedPropertiesforMetaType'

	filepath = CLIENT_HOME + '/GContent' + self.InstancePath +'Data/' + type + '/' + id + '/'
	if not(os.path.exists(filepath)):
		os.mkdir(filepath)

	if extension == 'default':
		optionstx = id + '.stx'
		optiontex = id + '.tex'
		if os.path.exists(filepath + optiontex):
			extension = '.tex'
		elif os.path.exists(filepath + optionstx):
			extension = '.stx'
		else:
			extension = '.html'
	
        filename = filepath + id + extension

	file = open(filename,'w')
	file.write(contents)
	file.close()

	converter(filepath,id,extension)

	RFlag = REQUEST['RFlag']
	if RFlag=='Add':
		BaseName = REQUEST['BaseName']
                REQUEST.RESPONSE.redirect(self.InstancePath + 'Data/' + type +'/' + id + '/' + replyForm + '?Id=%s&BaseName=%s' % (id,BaseName))
	elif RFlag=='Edit':
	        REQUEST.RESPONSE.redirect(self.InstancePath + 'EditForm')
	   
def converter(filepath,file,extension):
	if extension == '.tex':
		filename = filepath + file + extension
		tex_to_html='latex2html -split 0 -no_subdir -info 0 -no_navigation ' +  filename
		os.system(tex_to_html)
	elif extension == '.stx':
		filename = filepath + file + extension

		fp = open(filename,'r')
		raw = fp.read()
		fp.close()		

		st = StructuredText.Basic(raw)
		doc = StructuredText.Document(st)
		html = StructuredText.HTML(doc)
		
		filename1 = filepath + file + '.html'
		fpo= open(filename1,'w')
		fpo.write(html)
		fpo.close()
