######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

import os,sys,string

def validfilename(filename):

    if filename=='':
        return 0
    
    v = filename.isalnum()
    
    return v

def getStart():
    start = []
    start.append('<?xml version="1.0" encoding="UTF-8"?>\n')
    start.append('<topicMap xmlns="http://www.topicmaps.org/xtm/1.0/" xmlns:xlink="http://www.w3.org/1999/xlink"> \n')
    start.append('<!-- Exported from GNOWSYS version 0.4 -->\n')
    
    return start

def getEnd():
    end = []
    end.append ('</topicMap>')

    return end

def getPsiStructure():
    Psi = []
    Psi.append('<topic id="object">\n')
    Psi.append('<subjectIdentity>\n')
    Psi.append('<subjectIndicatorRef xlink:href="http://www.topicmaps.org/xtm/1.0/core.xtm#psi-topic"/>\n')
    Psi.append('</subjectIdentity>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="objectType">\n')
    Psi.append('<baseName>\n')
    Psi.append('<baseNameString> Object Type </baseNameString>\n')
    Psi.append('</baseName>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="relation">\n')
    Psi.append('<subjectIdentity>\n')
    Psi.append('<subjectIndicatorRef xlink:href="http://www.topicmaps.org/xtm/1.0/core.xtm#psi-relation"/>\n')
    Psi.append('</subjectIdentity>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="relationType">\n')
    Psi.append('<baseName>\n')
    Psi.append('<baseNameString> Relation Type </baseNameString>\n')
    Psi.append('</baseName>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="attributeType">\n')
    Psi.append('<baseName>\n')
    Psi.append('<baseNameString> Attribute Type </baseNameString>\n')
    Psi.append('</baseName>\n')
    Psi.append('</topic>\n')

    return Psi

def getObjectTypes(self):
    ObjectTypes = []

    octlist = []

    fctlist = []
    for eachOct in self.Catalog():
        if eachOct.meta_type == 'GAttribute Type':
            fctlist.append(eachOct.id)

    for eachOT in self.Catalog():
        if eachOT.meta_type == 'GObject Type':     
            ObjectTypes.append ('<topic id="' + eachOT.id + '" >\n')

            ObjectTypes.append ('<instanceOf>\n')
            ObjectTypes.append ('<topicRef xlink:href="#objectType"/>\n')
            ObjectTypes.append ('</instanceOf>\n')
            for eachPObjectTypeitem in eachOT.PObjectType:
                if eachPObjectTypeitem!='Object': # if it is an instanceof 'Object', then it is trivial and hence ignored
                    ObjectTypes.append ('<instanceOf>\n')
                    ObjectTypes.append ('<topicRef xlink:href="#' + eachPObjectTypeitem + '"/>\n')
                    ObjectTypes.append ('</instanceOf>\n')
            ObjectTypes.append ('<baseName>\n')
            ObjectTypes.append ('<baseNameString>' + eachOT.BaseName + '</baseNameString>\n')
	    ObjectTypes.append ('</baseName>\n')

            for eachFct in fctlist:
                Attribute = eachOT.getProperty(eachFct)
                if Attribute:
                    ObjectTypes.append ('<instanceOf>\n')
                    ObjectTypes.append ('<topicRef xlink:href="#' + eachFct + '"/>\n')
                    ObjectTypes.append ('</instanceOf>\n')
                    ObjectTypes.append ('<resourceData>' + Attribute + '</resourceData>\n')
            
            ObjectTypes.append ( '</topic>\n')            
    
    return ObjectTypes

def getObjects(self):
    Objects = []

    for eachO in self.Catalog():
        if eachO.meta_type == 'GObject':     
            Objects.append ('<topic id="' + eachO.id + '" >\n')
            Objects.append ('<instanceOf>\n')
            Objects.append ('<topicRef xlink:href="#object"/>\n')
            Objects.append ('</instanceOf>\n')
            for eachObjectTypeitem in eachO.ObjectTypes:
                if eachObjectTypeitem!='Object': # if it is an instanceof 'Object', then it is trivial and hence ignored
                    Objects.append ('<instanceOf>\n')
                    Objects.append ('<topicRef xlink:href="#' + eachObjectTypeitem + '"/>\n')
                    Objects.append ('</instanceOf>\n')
            Objects.append ('<baseName>\n')
            Objects.append ('<baseNameString>' + eachO.BaseName + '</baseNameString>\n')
	    Objects.append ('</baseName>\n')

            Desc = eachO.Description
            if Desc:
              Objects.append ('<resourceData>' + Desc + '</resourceData> \n')
                        
            Objects.append ( '</topic>\n')            
    
    return Objects

def getRelationTypes(self):
    RelationTypes = []

    for eachAT in self.Catalog():
        if eachAT.meta_type == 'GRelation Type':
            RelationTypes.append ('<topic id="' + eachAT.id + '" >\n')
            RelationTypes.append ('<instanceOf>\n')
            RelationTypes.append ('<topicRef xlink:href="#relationType"/>\n')
            RelationTypes.append ('</instanceOf>\n')
            RelationTypes.append ('<baseName>\n')
            RelationTypes.append ('<baseNameString>' + eachAT.BaseName + '</baseNameString>\n')
	    RelationTypes.append ('</baseName>\n')
            RelationTypes.append ('</topic>\n')            
    
    return RelationTypes

def getRelations(self):
    Relations = []

    for eachA in self.Catalog():
        if eachA.meta_type == 'GRelation':
            asType =eachA.RelationType[0]
            lobj=string.join(eachA.LObjects,',')
            robj=string.join(eachA.RObjects,',')
            Relations.append ('<relation id="' + eachA.id + '">\n')
            Relations.append ('<instanceOf>\n')
            Relations.append ('<topicRef xlink:href="#' + eachA.RelationType[0] + '"/>\n')
            Relations.append ('</instanceOf>\n')
            
            for eachAT in self.Catalog():
                if eachAT.meta_type == 'GRelation Type':
                    if asType == eachAT.id :
                        Relations.append ('<member>\n')  
                        Relations.append ('<roleSpec>\n')
                        Relations.append ('<topicRef xlink:href="#' + eachAT.LRoles[0] + '"/>\n')
                        Relations.append ('</roleSpec>\n')
                        Relations.append ('<topicRef xlink:href="#' + lobj + '"/>\n')
                        Relations.append ('</member>\n')

                        Relations.append ('<member>\n')
                        Relations.append ('<roleSpec>\n')
                        Relations.append ('<topicRef xlink:href="#' + eachAT.RRoles[0] + '"/>\n')
                        Relations.append ('</roleSpec>\n')
                        Relations.append ('<topicRef xlink:href="#' + robj + '"/>\n')
                        Relations.append ('</member>\n')
           
            Relations.append ('</relation>\n')
            
    return Relations        

def getAttributeTypes(self):
    AttributeTypes = []

    for eachFT in self.Catalog():
        if eachFT.meta_type == 'GAttribute Type':     
            AttributeTypes.append ('<topic id="' + eachFT.id + '" >\n')
            AttributeTypes.append ('<instanceOf>\n')
            AttributeTypes.append ('<topicRef xlink:href="#attributeType"/>\n')
            AttributeTypes.append ('</instanceOf>\n')
            AttributeTypes.append ('<baseName>\n')
            AttributeTypes.append ('<baseNameString>' + eachFT.BaseName + '</baseNameString>\n')
	    AttributeTypes.append ('</baseName>\n')
            AttributeTypes.append ('</topic>\n')            
    
    return AttributeTypes
   
def createXMLFile(self,REQUEST):

    try:
        rootdirectory = os.listdir('/tmp/')
    except:
        os.makedirs('tmp')
        rootdirectory = os.listdir('/tmp/')

    filename1 = REQUEST['filename']
    
    if validfilename(filename1)==0:
        url = self.surl + '/exportCheckfilename'
        REQUEST.RESPONSE.redirect(url)
        return

    filename1 = filename1 + '.xtm'
    filename = '/tmp/' + filename1
    
    file=open(filename,'w')
    file.writelines(getStart())    
    file.writelines(getPsiStructure())
    file.writelines(getObjectTypes(self))
    file.writelines(getObjects(self))
    file.writelines(getRelations(self))
    file.writelines(getRelationTypes(self))
    file.writelines(getAttributeTypes(self))    
    file.writelines(getEnd())    
    file.close()

    file=open(filename,'r')    
    filedata = file.read()
    file.close()

    self.XTM_Files.manage_addProduct['OFSP'].manage_addFile(filename1,filedata,filename1,'','')

    os.remove(filename)

    REQUEST.RESPONSE.redirect( self.surl + '/replyExport?filename=%s' % (filename1) )
