######################################################################
#
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA.
#
######################################################################
#
#   The Export module for Gnowledge Markup Language (GnowML)
#
#   Initially Created by :
#       Ganesh Jayaraman : ganesh_jayaraman@rediffmail.com
#       Karmalkar Vishal : karmalkarv@rediffmail.com
#       Sawant Khalil    : khalil_sawant@rediffmail.com
#               Shah & Anchor Kutchhi Engineering College
#
######################################################################

from xml.sax import make_parser
import xml.sax.handler

import Products.PythonScripts, Globals
from Products.GNOWSYS05.MetaType import *
from Products.GNOWSYS05.MetaTypeRelation import CatRel
from Products.GNOWSYS05.ObjectType import *
from Products.GNOWSYS05.RelationType import AssocT
from Products.GNOWSYS05.Object import *
from Products.GNOWSYS05.AttributeType import attributetype
from Products.GNOWSYS05.Relation import Assoc
from Products.PythonScripts.PythonScript import *

from Globals import InitializeClass, DTMLFile
from Globals import HTMLFile
from Globals import Persistent

import os
import string
import sys

class InstanceHandler(xml.sax.handler.ContentHandler):

	metaTypelist=[]
	metaTypeRelationlist=[]
	attributeTypelist=[]
	objectTypelist=[]
	objectlist=[]
	relationTypelist=[]
	relationlist=[]
	subTypeOflist=[]
	instanceOflist=[]
	attributelist=[]
	descriptionlist=[]
	leftRolelist=[]
	rightRolelist=[]

	inGnowML=0
	inmetaType=0
	inmetaTypeRelation=0
	inattributeType=0
	inobjectType=0
	inrelationType=0
	inobject=0
	inrelation=0
	indescription=0

	def startElement(self, name, attrs):
		if name=='GnowML':
			self.inGnowML=1
		elif name=='metaType':
			self.inmetaType=1
			keylist=[]
			valuelist=[]
			keyvaluedict={}
			keylist.append('id')
			valuelist.append(attrs.get('id',''))
			keylist.append('baseName')
			valuelist.append(attrs.get('baseName',''))
			for i in range (0,len(keylist)):
				keyvaluedict[keylist[i]]=valuelist[i]
			self.metaTypelist.append(keyvaluedict)
		elif name=='metaTypeRelation':
			self.inmetaTypeRelation=1
			keylist=[]
			valuelist=[]
			keyvaluedict={}
			keylist.append('id')
			valuelist.append(attrs.get('id',''))
			keylist.append('baseName')
			valuelist.append(attrs.get('baseName',''))
			keylist.append('roleType')
			valuelist.append(attrs.get('roleType',''))
			keylist.append('reflexivity')
			valuelist.append(attrs.get('reflexivity',''))
			keylist.append('symmetry')
			valuelist.append(attrs.get('symmetry',''))
			keylist.append('transitivity')
			valuelist.append(attrs.get('transitivity',''))
			for i in range (0,len(keylist)):
				keyvaluedict[keylist[i]]=valuelist[i]
			self.metaTypeRelationlist.append(keyvaluedict)
		elif name=='attributeType':
			self.inattributeType=1
			keylist=[]
			valuelist=[]
			keyvaluedict={}
			keylist.append('id')
			valuelist.append(attrs.get('id',''))
			keylist.append('baseName')
			valuelist.append(attrs.get('baseName',''))
			keylist.append('dataType')
			valuelist.append(attrs.get('dataType',''))
			for i in range (0,len(keylist)):
				keyvaluedict[keylist[i]]=valuelist[i]
			self.attributeTypelist.append(keyvaluedict)
		elif name=='objectType':
			self.inobjectType=1
			keylist=[]
			valuelist=[]
			keyvaluedict={}
			keylist.append('id')
			valuelist.append(attrs.get('id',''))
			keylist.append('baseName')
			valuelist.append(attrs.get('baseName',''))
			for i in range (0,len(keylist)):
				keyvaluedict[keylist[i]]=valuelist[i]
			self.objectTypelist.append(keyvaluedict)
		elif name=='relationType':
			self.inrelationType=1
			keylist=[]
			valuelist=[]
			keyvaluedict={}
			keylist.append('id')
			valuelist.append(attrs.get('id',''))
			keylist.append('baseName')
			valuelist.append(attrs.get('baseName',''))
			keylist.append('altName')
			valuelist.append(attrs.get('altName',''))
			keylist.append('invName')
			valuelist.append(attrs.get('invName',''))
			keylist.append('roleType')
			valuelist.append(attrs.get('roleType',''))
			keylist.append('reflexivity')
			valuelist.append(attrs.get('reflexivity',''))
			keylist.append('symmetry')
			valuelist.append(attrs.get('symmetry',''))
			keylist.append('transitivity')
			valuelist.append(attrs.get('transitivity',''))
			keylist.append('cardinality')
			valuelist.append(attrs.get('cardinality',''))
			keylist.append('necessary')
			valuelist.append(attrs.get('necessary',''))
			keylist.append('OTFlag')
			valuelist.append(attrs.get('OTFlag',''))
			for i in range (0,len(keylist)):
				keyvaluedict[keylist[i]]=valuelist[i]
			self.relationTypelist.append(keyvaluedict)
		elif name=='object':
			self.inobject=1
			keylist=[]
			valuelist=[]
			keyvaluedict={}
			keylist.append('id')
			valuelist.append(attrs.get('id',''))
			keylist.append('baseName')
			valuelist.append(attrs.get('baseName',''))
			for i in range (0,len(keylist)):
				keyvaluedict[keylist[i]]=valuelist[i]
			self.objectlist.append(keyvaluedict)
		elif name=='relation':
			self.inrelation=1
			keylist=[]
			valuelist=[]
			keyvaluedict={}
			keylist.append('id')
			valuelist.append(attrs.get('id',''))
			keylist.append('baseName')
			valuelist.append(attrs.get('id',''))
			keylist.append('leftObject')
			valuelist.append(attrs.get('leftObject',''))
			keylist.append('rightObject')
			valuelist.append(attrs.get('rightObject',''))
			keylist.append('participant')
			valuelist.append(attrs.get('participant',''))
                        keylist.append('participanttype')
			valuelist.append(attrs.get('participanttype','')) 
			for i in range (0,len(keylist)):
				keyvaluedict[keylist[i]]=valuelist[i]
			self.relationlist.append(keyvaluedict)
		elif name=='attribute':
			keylist=[]
			valuelist=[]
			keyvaluedict={}
			keylist.append('ref')
			valuelist.append(attrs.get('ref',''))
			keylist.append('mandatory')
			valuelist.append(attrs.get('mandatory',''))
			keylist.append('value')
			valuelist.append(attrs.get('value',''))

			if self.inmetaType==1 or self.inobjectType==1:
				keylist.append('defining')
				valuelist.append(attrs.get('defining',''))

			keylist.append('parent')
			if self.inmetaType==1:
				temp=self.metaTypelist[len(self.metaTypelist)-1]['id']
				valuelist.append(temp)
			elif self.inobjectType==1:
				temp=self.objectTypelist[len(self.objectTypelist)-1]['id']
				valuelist.append(temp)
			elif self.inobject==1:
				temp=self.objectlist[len(self.objectlist)-1]['id']
				valuelist.append(temp)
			keylist.append('parentType')
			if self.inmetaType==1:
				valuelist.append('metaType')
			elif self.inobjectType==1:
				valuelist.append('objectType')
			elif self.inobject==1:
				valuelist.append('object')
			for i in range (0,len(keylist)):
				keyvaluedict[keylist[i]]=valuelist[i]
			self.attributelist.append(keyvaluedict)
		elif name=='subTypeOf':
			keyvaluedict={}
			if self.inmetaType==1:
				keyvaluedict['metaType']=self.metaTypelist[len(self.metaTypelist)-1]['id']
				keyvaluedict['subTypeOf']=attrs.get('ref','')
			elif self.inobjectType==1:
				keyvaluedict['objectType']=self.objectTypelist[len(self.objectTypelist)-1]['id']
				keyvaluedict['subTypeOf']=attrs.get('ref','')
			self.subTypeOflist.append(keyvaluedict)
		elif name=='instanceOf':
			keyvaluedict={}
			if self.inattributeType==1:
				keyvaluedict['attributeType']=self.attributeTypelist[len(self.attributeTypelist)-1]['id']
				keyvaluedict['instanceOf']=attrs.get('ref','')
			elif self.inobjectType==1:
				keyvaluedict['objectType']=self.objectTypelist[len(self.objectTypelist)-1]['id']
				keyvaluedict['instanceOf']=attrs.get('ref','')
			elif self.inrelationType==1:
				keyvaluedict['relationType']=self.relationTypelist[len(self.relationTypelist)-1]['id']
				keyvaluedict['instanceOf']=attrs.get('ref','')
			elif self.inobject==1:
				keyvaluedict['object']=self.objectlist[len(self.objectlist)-1]['id']
				keyvaluedict['instanceOf']=attrs.get('ref','')
			elif self.inrelation==1:
				keyvaluedict['relation']=self.relationlist[len(self.relationlist)-1]['id']
				keyvaluedict['instanceOf']=attrs.get('ref','')
			self.instanceOflist.append(keyvaluedict)
		elif name=='leftRole':
			keyvaluedict={}
			if self.inmetaTypeRelation==1:
				keyvaluedict['metaTypeRelation']=self.metaTypeRelationlist[len(self.metaTypeRelationlist)-1]['id']
				keyvaluedict['leftRole']=attrs.get('ref','')
			elif self.inrelationType==1:
				keyvaluedict['relationType']=self.relationTypelist[len(self.relationTypelist)-1]['id']
				keyvaluedict['leftRole']=attrs.get('ref','')
			self.leftRolelist.append(keyvaluedict)
		elif name=='rightRole':
			keyvaluedict={}
			if self.inmetaTypeRelation==1:
				keyvaluedict['metaTypeRelation']=self.metaTypeRelationlist[len(self.metaTypeRelationlist)-1]['id']
				keyvaluedict['rightRole']=attrs.get('ref','')
			elif self.inrelationType==1:
				keyvaluedict['relationType']=self.relationTypelist[len(self.relationTypelist)-1]['id']
				keyvaluedict['rightRole']=attrs.get('ref','')
			self.rightRolelist.append(keyvaluedict)
		elif name=='description':
			self.indescription=1

	def characters(self,content):
		if self.indescription==1:
			keyvaluedict={}
			if self.inmetaType==1:
				keyvaluedict['metaType']=self.metaTypelist[len(self.metaTypelist)-1]['id']
				keyvaluedict['description']=content
			elif self.inattributeType==1:
				keyvaluedict['attributeType']=self.attributeTypelist[len(self.attributeTypelist)-1]['id']
				keyvaluedict['description']=content
			elif self.inobjectType==1:
				keyvaluedict['objectType']=self.objectTypelist[len(self.objectTypelist)-1]['id']
				keyvaluedict['description']=content
			elif self.inobject==1:
				keyvaluedict['object']=self.objectlist[len(self.objectlist)-1]['id']
				keyvaluedict['description']=content
			self.descriptionlist.append(keyvaluedict)

	def endElement(self,name):
		if name=='GnowML':
			self.inGnowML=0
		elif name=='metaType':
			self.inmetaType=0
		elif name=='metaTypeRelation':
			self.inmetaTypeRelation=0
		elif name=='attributeType':
			self.inattributeType=0
		elif name=='objectType':
			self.inobjectType=0
		elif name=='relationType':
			self.inrelationType=0
		elif name=='object':
			self.inobject=0
		elif name=='relation':
			self.inrelation=0
		elif name=='description':
			self.indescription=0

def insertmetaType(self,reference):
	for eachmetaType in reference.metaTypelist:
		subTypeOfInstlist=[]
		definingattlist=[]
		possibleattlist=[]
		mandatoryattlist=[]
		optionalattlist=[]
		descriptionInst=''
		id=str(eachmetaType['id'])
		baseName=str(eachmetaType['baseName'])

		for eachDictEntry in reference.subTypeOflist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='metaType':
					if id==str(eachDictEntry['metaType']):
						subTypeOfInstlist.append(str(eachDictEntry['subTypeOf']))

		for eachDictEntry in reference.descriptionlist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='metaType':
					if id==str(eachDictEntry['metaType']):
						descriptionInst=str(eachDictEntry['description'])

		for eachDictEntry in reference.attributelist:
			if eachDictEntry['parentType']=='metaType':
				if id==str(eachDictEntry['parent']):
					if str(eachDictEntry['defining'])=='True':
						definingattlist.append(str(eachDictEntry['ref']))
					if str(eachDictEntry['defining'])=='False':
						possibleattlist.append(str(eachDictEntry['ref']))
					if str(eachDictEntry['mandatory'])=='True':
						mandatoryattlist.append(str(eachDictEntry['ref']))
					if str(eachDictEntry['mandatory'])=='False':
						optionalattlist.append(str(eachDictEntry['ref']))


		DRefMetaType=MetaType(id,baseName,subTypeOfInstlist,descriptionInst,definingattlist,possibleattlist,mandatoryattlist,optionalattlist)
		self.Data.MetaType._setObject(id,DRefMetaType)
		MetaTypePath = self.InstancePath + 'Data/MetaType/' + id
		MTRef = self.restrictedTraverse(MetaTypePath)
		MTRef.index_object()

		for eachattribute in reference.attributelist:
			if eachattribute['parentType']=='metaType':				
				if str(eachattribute['parent'])==id:
					datatype=''
					ft=str(eachattribute['ref'])
					if eachattribute['defining']=='True':
						scope='Defining'
					else:
						scope='Possible'
					if eachattribute['mandatory']=='True':
						fillmode='Mandatory'
					else:
						fillmode='Optional'
						
					for eachattributeType in reference.attributeTypelist:
						if eachattributeType['id']==ft:
							datatype=str(eachattributeType['dataType'])

					attributeval = eachattribute['value']
					
					if datatype=='tokens' or datatype=='utokens':
						localtoken=()
						localtoken=localtoken+(str(eachattribute['value']),)
						attributeval=localtoken				    
					elif datatype=='lines' or datatype=='ulines':
						locallist=[]
						locallist.append(str(eachattribute['value']))
						attributeval=locallist
					elif datatype=='text' or datatype=='utext': 
						attributeval=str(eachattribute['value'])
					elif datatype=='string' or datatype=='ustring':
						attributeval=str(eachattribute['value'])
					elif datatype=='boolean':
						attributeval=bool(str(eachattribute['value']))
					elif datatype=='float':
						attributeval=float(str(eachattribute['value']))
					elif datatype=='long':
						attributeval=long(str(eachattribute['value']))
					elif datatype=='int':
						attributeval=int(str(eachattribute['value']))
					attributeaddMetaType(MTRef,ft,scope,fillmode,attributeval)

					
def insertmetaTypeRelation(self,reference):
	for eachmetaTypeRelation in reference.metaTypeRelationlist:
		leftRoleInstlist=[]
		rightRoleInstlist=[]
		id=str(eachmetaTypeRelation['id'])
		baseName=str(eachmetaTypeRelation['baseName'])
		reflexive=str(eachmetaTypeRelation['reflexivity'])
		transitive=str(eachmetaTypeRelation['transitivity'])
		symmetric=str(eachmetaTypeRelation['symmetry'])
		cflag=str(eachmetaTypeRelation['roleType'])
		for eachDictEntry in reference.leftRolelist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='metaTypeRelation':
					if id==str(eachDictEntry['metaTypeRelation']):
						leftRoleInstlist.append(str(eachDictEntry['leftRole']))

		for eachDictEntry in reference.rightRolelist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='metaTypeRelation':
					if id==str(eachDictEntry['metaTypeRelation']):
						rightRoleInstlist.append(str(eachDictEntry['rightRole']))

		DRefMetaTypeRelation = CatRel(id,baseName,leftRoleInstlist,rightRoleInstlist,reflexive,transitive,symmetric,cflag)
		self.Data.MetaTypeRelations._setObject(id,DRefMetaTypeRelation)
		MetaTypePath = self.InstancePath + 'Data/MetaTypeRelations/' + id
		MTRef = self.restrictedTraverse(MetaTypePath)
		MTRef.index_object()

def insertobjectType(self,reference):
	for eachobjectType in reference.objectTypelist:
		subTypeOfInstlist=[]
		instanceOfInstlist=[]
		definingattlist=[]
		possibleattlist=[]
		mandatoryattlist=[]
		optionalattlist=[]
		descriptionInst=''
		id=str(eachobjectType['id'])
		baseName=str(eachobjectType['baseName'])
		for eachDictEntry in reference.subTypeOflist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='objectType':
					if id==str(eachDictEntry['objectType']):
						subTypeOfInstlist.append(str(eachDictEntry['subTypeOf']))

		for eachDictEntry in reference.instanceOflist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='objectType':
					if id==str(eachDictEntry['objectType']):
						instanceOfInstlist.append(str(eachDictEntry['instanceOf']))
						
		for eachDictEntry in reference.descriptionlist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='objectType':
					if id==str(eachDictEntry['objectType']):
						descriptionInst=str(eachDictEntry['description'])

		for eachDictEntry in reference.attributelist:
			if eachDictEntry['parentType']=='metaType':
				if id==str(eachDictEntry['parent']):
					if str(eachDictEntry['defining'])=='True':
						definingattlist.append(str(eachDictEntry['ref']))
					if str(eachDictEntry['defining'])=='False':
						possibleattlist.append(str(eachDictEntry['ref']))
					if str(eachDictEntry['mandatory'])=='True':
						mandatoryattlist.append(str(eachDictEntry['ref']))
					if str(eachDictEntry['mandatory'])=='False':
						optionalattlist.append(str(eachDictEntry['ref']))

		DRefMetaType = ObjectType(id,baseName,instanceOfInstlist,subTypeOfInstlist,descriptionInst,definingattlist,possibleattlist,mandatoryattlist,optionalattlist)
		self.Data.ObjectType._setObject(id,DRefMetaType)
		MetaTypePath = self.InstancePath + 'Data/ObjectType/' + id
		MTRef = self.restrictedTraverse(MetaTypePath)
		MTRef.index_object()

		for eachattribute in reference.attributelist:
			if eachattribute['parentType']=='objectType':				
				if str(eachattribute['parent'])==id:
					datatype=''
					ft=str(eachattribute['ref'])
					if eachattribute['defining']=='True':
						scope='Defining'
					else:
						scope='Possible'
					if eachattribute['mandatory']=='True':
						fillmode='Mandatory'
					else:
						fillmode='Optional'
						
					for eachattributeType in reference.attributeTypelist:
						if eachattributeType['id']==ft:
							datatype=str(eachattributeType['dataType'])

					attributeval = eachattribute['value']
					if datatype=='tokens' or datatype=='utokens':
						localtoken=()
						localtoken=localtoken+(str(eachattribute['value']),)
						attributeval=localtoken				    
					elif datatype=='lines' or datatype=='ulines':
						locallist=[]
						locallist.append(str(eachattribute['value']))
						attributeval=locallist
					elif datatype=='text' or datatype=='utext': 
						attributeval=str(eachattribute['value'])
					elif datatype=='string' or datatype=='ustring':
						attributeval=str(eachattribute['value'])
					elif datatype=='boolean':
						attributeval=bool(str(eachattribute['value']))
					elif datatype=='float':
						attributeval=float(str(eachattribute['value']))
					elif datatype=='long':
						attributeval=long(str(eachattribute['value']))
					elif datatype=='int':
						attributeval=int(str(eachattribute['value']))

					attributeaddobjtype(MTRef,ft,scope,fillmode,attributeval)
					
					
def insertobject(self,reference):
	for eachobject in reference.objectlist:
		instanceOfInstlist=[]
		mandatoryattlist=[]
		optionalattlist=[]
		descriptionInst=''
		id=str(eachobject['id'])
		baseName=str(eachobject['baseName'])

		for eachDictEntry in reference.instanceOflist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='object':
					if id==str(eachDictEntry['object']):
						instanceOfInstlist.append(str(eachDictEntry['instanceOf']))

		for eachDictEntry in reference.descriptionlist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='object':
					if id==str(eachDictEntry['object']):
						descriptionInst=str(eachDictEntry['description'])

		for eachDictEntry in reference.attributelist:
			if eachDictEntry['parentType']=='object':
				if id==str(eachDictEntry['parent']):
					if str(eachDictEntry['mandatory'])=='True':
						mandatoryattlist.append(str(eachDictEntry['ref']))
					if str(eachDictEntry['mandatory'])=='False':
						optionalattlist.append(str(eachDictEntry['ref']))

		DRefMetaType = Object(id,baseName,instanceOfInstlist,descriptionInst,mandatoryattlist,optionalattlist)
		self.Data.Objects._setObject(id,DRefMetaType)
		MetaTypePath = self.InstancePath + 'Data/Objects/' + id
		MTRef = self.restrictedTraverse(MetaTypePath)
		MTRef.index_object()


		for eachattribute in reference.attributelist:
			if eachattribute['parentType']=='object':				
				if str(eachattribute['parent'])==id:
					datatype=''
					ft=str(eachattribute['ref'])
					if eachattribute['mandatory']=='True':
						fillmode='Mandatory'
					else:
						fillmode='Optional'
						
					for eachattributeType in reference.attributeTypelist:
						if eachattributeType['id']==ft:
							datatype=str(eachattributeType['dataType'])

					attributeval = eachattribute['value']
					
					if datatype=='tokens' or datatype=='utokens':
						localtoken=()
						localtoken=localtoken+(str(eachattribute['value']),)
						attributeval=localtoken				    
					elif datatype=='lines' or datatype=='ulines':
						locallist=[]
						locallist.append(str(eachattribute['value']))
						attributeval=locallist
					elif datatype=='text' or datatype=='utext': 
						attributeval=str(eachattribute['value'])
					elif datatype=='string' or datatype=='ustring':
						attributeval=str(eachattribute['value'])
					elif datatype=='boolean':
						attributeval=bool(str(eachattribute['value']))
					elif datatype=='float':
						attributeval=float(str(eachattribute['value']))
					elif datatype=='long':
						attributeval=long(str(eachattribute['value']))
					elif datatype=='int':
						attributeval=int(str(eachattribute['value']))

					attributeaddobj(MTRef,ft,fillmode,attributeval)


		

def insertrelationType(self,reference):
	for eachrelationType in reference.relationTypelist:
		leftRoleInstlist=[]
		rightRoleInstlist=[]
		instanceOfInstlist=[]
		baseName=str(eachrelationType['baseName'])
		altname=str(eachrelationType['altName'])
		inversename=str(eachrelationType['invName'])
		id=str(eachrelationType['id'])
		reflexive=str(eachrelationType['reflexivity'])
		transitive=str(eachrelationType['transitivity'])
		symmetric=str(eachrelationType['symmetry'])
		c=int(str(eachrelationType['cardinality']))
		if str(eachrelationType['necessary'])=="0":
			r=0
		else:
			r=1
		flag=str(eachrelationType['roleType'])
		OTFlag=str(eachrelationType['OTFlag'])

		for eachDictEntry in reference.instanceOflist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='relationType':
					if id==str(eachDictEntry['relationType']):
						instanceOfInstlist.append(str(eachDictEntry['instanceOf']))

		for eachDictEntry in reference.leftRolelist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='relationType':
					if id==str(eachDictEntry['relationType']):
						leftRoleInstlist.append(str(eachDictEntry['leftRole']))

		for eachDictEntry in reference.rightRolelist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='relationType':
					if id==str(eachDictEntry['relationType']):
						rightRoleInstlist.append(str(eachDictEntry['rightRole']))

		DRefMetaTypeRelation = AssocT(id,baseName,instanceOfInstlist,leftRoleInstlist,rightRoleInstlist,reflexive,transitive,symmetric,c,r,flag,altname,inversename,OTFlag)
		self.Data.RelationTypes._setObject(id,DRefMetaTypeRelation)
		MetaTypePath = self.InstancePath + 'Data/RelationTypes/' + id
		MTRef = self.restrictedTraverse(MetaTypePath)
		MTRef.index_object()

def insertrelation(self,reference):
	for eachrelation in reference.relationlist:
		lobjects=[]
		robjects=[]
		relationtype=[]
		id=str(eachrelation['id'])
		lobjects.append(str(eachrelation['leftObject']))
		robjects.append(str(eachrelation['rightObject']))
		baseName=str(eachrelation['baseName'])
		participant=str(eachrelation['participant'])
		participanttype=str(eachrelation['participanttype'])

		for eachDictEntry in reference.instanceOflist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='relation':
					if id==str(eachDictEntry['relation']):
						relationtype.append(str(eachDictEntry['instanceOf']))
						for eachrelationType in reference.relationTypelist:
							if eachrelationType['id']==relationtype:
								participanttype=eachrelationType['roleType']

		DRefMetaTypeRelation = Assoc(id,lobjects,relationtype,robjects,baseName,participant,participanttype)
		self.Data.Relations._setObject(id,DRefMetaTypeRelation)
		MetaTypePath = self.InstancePath + 'Data/Relations/' + id
		MTRef = self.restrictedTraverse(MetaTypePath)
		MTRef.index_object()
		

def insertattributetype(self,reference):
	for eachattributetype in reference.attributeTypelist:
		id=str(eachattributetype['id'])
		baseName=str(eachattributetype['baseName'])
		datatype=str(eachattributetype['dataType'])
		descriptionInst = ''
		instanceOfInst = []

		for eachDictEntry in reference.descriptionlist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='attributeType':
					if id==str(eachDictEntry['attributeType']):
						descriptionInst=str(eachDictEntry['description'])

		for eachDictEntry in reference.instanceOflist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='attributeType':
					if id==str(eachDictEntry['attributeType']):
						instanceOfInst.append(str(eachDictEntry['instanceOf']))

		DRefMetaTypeRelation = attributetype(id,baseName,datatype,descriptionInst,instanceOfInst)
		self.Data.AttributeTypes._setObject(id,DRefMetaTypeRelation)
		MetaTypePath = self.InstancePath + 'Data/AttributeTypes/' + id
		MTRef = self.restrictedTraverse(MetaTypePath)
		MTRef.index_object()
		
		self.Catalog.manage_addIndex(id, 'TextIndex')
		self.Catalog.manage_addColumn(id)


def insertredundancies(self,reference):
	
	
	PATH = self.InstancePath + 'Data/MetaType/' 
	for metatype in reference.metaTypelist:
		locallist=[]
		id=str(metatype['id'])
		for eachDictEntry in reference.subTypeOflist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='metaType':
					if id==str(eachDictEntry['metaType']):
						locallist.append(str(eachDictEntry['subTypeOf']))
					
		
		for parentMetaType in locallist:
			pMetaTypeRef = self.restrictedTraverse( PATH + parentMetaType )
			childMetaTypeList = pMetaTypeRef.getProperty( 'child_metatypes' )
			childMetaTypeList.append(id) 
			pMetaTypeRef._updateProperty('child_metatypes',childMetaTypeList)
			pMetaTypeRef.reindex_object()

	PATH = self.InstancePath
	for objecttype in reference.objectTypelist:
		locallist=[]
		id=str(objecttype['id'])
		for eachDictEntry in reference.subTypeOflist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='objectType':
					if id==str(eachDictEntry['objectType']):
						locallist.append(str(eachDictEntry['subTypeOf']))
		for otId in locallist:
			otPath = PATH + 'Data/ObjectType/' + otId
			pObjectTypeRef = self.restrictedTraverse( otPath )
			childObjectTypeList = pObjectTypeRef.getProperty( 'child_objecttypes' )
			childObjectTypeList.append(id)
			pObjectTypeRef._updateProperty('child_objecttypes',childObjectTypeList)
			pObjectTypeRef.reindex_object()
			

	PATH = self.InstancePath
	for objecttype in reference.objectTypelist:
		locallist=[]
		id=str(objecttype['id'])
		for eachDictEntry in reference.instanceOflist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='objectType':
					if id==str(eachDictEntry['objectType']):
						locallist.append(str(eachDictEntry['instanceOf']))
	
		for mtId in locallist:
			mtPath = PATH + 'Data/MetaType/' + mtId
			pMetaTypeRef = self.restrictedTraverse( mtPath )
			childObjectTypeList = pMetaTypeRef.getProperty( 'child_objecttypes' )
			childObjectTypeList.append(id) 
			pMetaTypeRef._updateProperty('child_objecttypes',childObjectTypeList )
			pMetaTypeRef.reindex_object()


	PATH = self.InstancePath
	for objects in reference.objectlist:
		locallist=[]
		id=str(objects['id'])
		for eachDictEntry in reference.instanceOflist:
			for eachkey in eachDictEntry.keys():
				if eachkey=='object':
					if id==str(eachDictEntry['object']):
						locallist.append(str(eachDictEntry['instanceOf']))

	
		for otId in locallist:
			otPath = PATH + 'Data/ObjectType/' + otId
			pObjectTypeRef = self.restrictedTraverse( otPath )
			childObjectList = pObjectTypeRef.getProperty( 'child_objects' )
			childObjectList.append(id)
			pObjectTypeRef._updateProperty('child_objects',childObjectList)
			pObjectTypeRef.reindex_object()

#	rightobjectlist=[]
#	leftobjectlist=[]

#	for relation in reference.relationlist:
#		rightobjectlist.append(relation['rightObject'])
#		leftobjectlist.append(relation['leftObject'])



#	oList = self.Data.Objects.objectIds('GObject')
#	otList = self.Data.ObjectType.objectIds('GObject Type')

#	PATH = self.InstancePath + 'Data/'

#	for x in rightobjectlist:

#		PATH = self.InstancePath + 'Data/'

#		if x in oList:

#			PATH = PATH + 'Objects/' + x
#			ref = self.restrictedTraverse( PATH )
#			ref = self.restrictedTraverse( PATH + 'Objects/' + x )
#			rList = ref.getProperty( 'rRolePlayedIn' )
		
#			rList = self.getAnyProperty(x,'Objects','rRolePlayedIn')
#			rList.append(id)
#			ref = self.restrictedTraverse( PATH + 'Objects/' + x )		
#			ref._updateProperty('rRolePlayedIn',rList)
#			ref.reindex_object()	                
#		elif x in otList:

#			PATH = PATH + 'ObjectType/' + x
#			ref = self.restrictedTraverse( PATH )
#			ref = self.restrictedTraverse( PATH + 'ObjectType/' + x )
#			rList = ref.getProperty( 'rRolePlayedIn' )

#			rList = self.getAnyProperty(x,'ObjectType','rRolePlayedIn')
#			rList.append(id)
#			ref = self.restrictedTraverse( PATH + 'ObjectType/' + x )
#			ref._updateProperty('rRolePlayedIn',rList)
#			ref.reindex_object()

#	PATH = self.InstancePath + 'Data/'
	
#	for x in leftobjectlist:
#		PATH = self.InstancePath + "Data/"
#		if x in oList:
#			PATH = PATH + "Objects/" + x
#			ref = self.restrictedTraverse( PATH + 'Objects/' + x)
#			rList = ref.getProperty( 'lRolePlayedIn' )
#			rList.append(id)
#			ref._updateProperty('lRolePlayedIn',rList)
#			ref.reindex_object()	                
#		elif x in otList:
#			PATH = PATH + "ObjectType/" + x
#			ref = self.restrictedTraverse( PATH + 'ObjectType/' + x)
#			rList = ref.getProperty( 'lRolePlayedIn' )
#			rList.append(id)
#			ref._updateProperty('lRolePlayedIn',rList)
#			ref.reindex_object()	                
	
		

def importGnowMLFile(self,gmlfilename,tgzfilename):

	if os.path.exists(tgzfilename):
		tgzFilePath = CLIENT_HOME + '/GContent' + self.InstancePath		
		os.chdir(tgzFilePath)
		result = os.system('tar -xvzf ' + tgzfilename )
		if result!=0:
			return 'Error while extracting, Aborting Import'
	else:
		return 'No such tgz file OR Permission denied,Please Check Permissions'
	
	ch=InstanceHandler()
	saxparser1=make_parser()
	saxparser1.setContentHandler(ch)
	saxparser1.parse(gmlfilename)


	insertattributetype(self,ch)
	insertmetaType(self,ch)
	insertmetaTypeRelation(self,ch)
	insertobjectType(self,ch)
	insertobject(self,ch)
	insertrelationType(self,ch)
	insertrelation(self,ch)
	insertredundancies(self,ch)



