#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

import os
import string
import re
from OFS import SimpleItem
from Globals import DTMLFile,InitializeClass
from Globals import HTMLFile
from listpy import *
from listcf import *
from FunctionType import *
from conditiontype import *
from ClassType import *
from FlowType import *
from Function import *
from GNOWSYS import *
from AccessControl.DTML import RestrictedDTML


# Listing class inherits the classes for creating folders and giving
# other related functionalities in the Web Interface 

class listing(ObjectManager,
           PropertyManager,
           RoleManager,
           Item,
           FindSupport,
           ZCatalog,
	   SimpleItem,
	   RestrictedDTML, 
           HTML, 
           Acquisition.Implicit,
	   ):
    """A listing product"""

    meta_type = 'gnoListing'

    _properties= ( 
	{'id':'id', 'type':'string', 'mode':'r'},
	{'id':'title', 'type':'string', 'mode':'w'},
        )

    manage_options =(
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'View', 'action': 'enterpath',},
	{'label': 'Flow', 'action': 'interfun',},
	{'label': 'Properties', 'action': 'manage_propertiesForm'}, 
	{'label': 'Roles', 'action': 'manage_access',},

	)

    allowedmetatypes = ('DTML Method','DTML Document','Folder','Temporary Folder','User Folder','Image','File','External Method','Script(Python)','ZCatalog','Association','Association Type','Facet Type','Occurrence Type','Object','Object Type','Transparent Folder','Z Search Interface','Cookie Crumbler','Accelerated HTTP Cache Manager', 'Ram Cache Manager', 'Browser Id Manager', 'Page Template','Function','FunctionType','Flow','Flow Type','Class','Class Type')
    def all_meta_types(self):
        if hasattr(self, 'allowedmetatypes'):
            result = []
            import Products
            for metaType in Products.meta_types:
                if metaType['name'] in self.allowedmetatypes:
                    result.append(metaType)
            return result
        else:
            return Products.meta_types

    def __init__(self, id, title):
        "Inits the product with default values"
        self.id = id
        self.title = title
	self.FunObject=[]    # List of functions which are selected in the flow object   
	self.pyfdir=[]       # List of the diretory path of  pyfiles
	self.pycldict=[]     # List of dictionary of classes
	self.pyfundict=[]    # List of dictionary of functions
	self.filepath=None    
	self.cfline=[]       # List of line numbers of functions within classes   
	self.fline=[]        # List of line numbers of functions outside classes
	self.fs=""      
        self.modname=""
	self.meth={}            
	self.dbname=[]      
	self.docstring=''   
	self.dirdir=[]       # List of path of the  dierctories

    def manage_editAction(self, title, RESPONSE=None):
        "Changes the product values"
        self.title = title
        self._p_changed = 1  # Makes the change persistant in ZODB
        RESPONSE.redirect('manage_editForm')

    def callistpy(self,searchPath,REQUEST,RESPONSE=None):
        "displays path"
	l1=listpy(REQUEST['searchPath'])   # Create an object of listpy to display py files in a given path
        pyf=str(l1.pyfiles)                 # All .py files in the search path
	pyd=str(l1.direct)                  # All directories within the search path
	self.dirdir=pyd 
	temp=string.replace(pyf,"[","")
	temp1=string.replace(temp,"]","")
	
	temp2=string.replace(pyd,"[","")
	temp3=string.replace(temp2,"]","")
	#self.dirdir=l1.dirpath
	self.pyfdir=l1.pathpyfiles
	REQUEST.set('pyfiles',temp1)
	REQUEST.set('direct',temp3)
	RESPONSE.redirect('resultPage?pyfiles=%s&direct=%s' %(temp1,temp3)) # Redirect to ResultPage for displaying

    def callistcf(self,REQUEST,RESPONSE=None):
	"""calls listcf ...lists all functions/classes and their line nos"""
	if 'pathno' in REQUEST.keys():
		pathnum=int(REQUEST['pathno'])
		self.filepath=self.pyfdir[pathnum-1]
	elif 'path' in REQUEST.keys():
		self.filepath=REQUEST['path']
	l2=listcf(self.filepath)          # Create an object of listclfn which is used to display classes and functions
	self.pycldict=l2.funcl              # Dictionary of all classes
	self.pyfundict=l2.fun               # Dictionary of all functions in the .py file
	self.cfline=l2.v                    # Line numbers of functions within class
	self.fline=l2.l                     # Line numbers of functions in .py file
	self.clfn=l2.m                      # functions within the class    
	t1=str(l2.newfun)                   # All the functions within py files
	t2=str(l2.newcl)                    # All classes within py file
	t3=string.replace(t1,"[","")    
	temp1=string.replace(t3,"]","")
	t4=string.replace(t2,"[","")
	temp2=string.replace(t4,"]","")
	REQUEST.set('newfun',temp1)
	REQUEST.set('newcl',temp2)
	RESPONSE.redirect('resultPage1?newcl=%s&newfun=%s' %(temp2,temp1)) # Redirect to ResultPage to display results

    def createfuntype(self,pathnofn,val,REQUEST,RESPONSE=None):
	"list arg function"
	t=[]
	self.classnm=''
	t1=int(pathnofn)
	fp=open(self.filepath)
	if val=="1":                            # val==1 indicates function
		no=self.fline[t1-1]
		self.fname=self.pyfundict[t1-1]	
	elif val=="2":                          # val==2 indicates function within a class
		no=self.cfline[self.clno-1][t1-1]
		self.fname=self.clfn[self.clno-1][t1-1]
		
	for i in range(no):
		fread=fp.readline()
	self.dbname=os.path.split(self.filepath)
	if self.dbname[1]=="maths":
		self.dbname[1]="math"
        os.chdir(self.dbname[0])
        self.modname=os.path.splitext(self.dbname[1])[0]
	if val=="1":
		evalst=compile('import '+self.modname,'','single') #Importing the module
       		exec evalst
        	name=self.modname+'.'+self.fname[0]
        	evaldoc=compile('docu='+name+'.__doc__','','single') # Documentation of the function
        	exec evaldoc
        elif val=="2":
		self.classnm=self.pycldict[self.clno-1][0]
		evalst=compile('from '+self.modname+' import *' ,'','single')
		exec evalst
		evaldoc=compile('docu='+self.clname+'.__doc__','','single')
		exec evaldoc
		if docu==None:
			docu=''
	t.append(string.replace(docu," ","|"))
	f=string.replace(fread,' ','')
	f=string.split(f,'def')[1]
	ff=self.classnm+"_|_"+str(val)+"|"+self.filepath+"|"+f
	REQUEST.set('defline',ff)
	REQUEST.set('docstring',str(t))
	fp.close()
	# Redirect to functiontype for adding a new function
	RESPONSE.redirect(self.surl+'/manage_addProduct/GNOWSYS/manage_addFunctionType?docstring=%s&defline=%s'%(str(t),ff))

    def callistclfun(self,pathnocl,REQUEST,RESPONSE=None):
	"listclfun function"
	self.clno=int(pathnocl)
	self.typefun=''
	self.clname=self.pycldict[self.clno-1][0]
	#dict=self.pycldict[t1-1][1].__dict__
	#self.meth=dict["methods"]
	#meth1=str(dict["methods"].keys())
	meth1=str(self.clfn[self.clno-1])
	temp1=string.replace(meth1,"[","")
	temp2=string.replace(temp1,"]","")
	REQUEST.set('meth1',temp2)
	RESPONSE.redirect('resultPage2?meth1=%s'%(temp2))

    def createobj(self,REQUEST,RESPONSE=None):
	"Create class instance"
	t1=int(REQUEST['pathnocl'])
	self.clname=self.pycldict[t1-1][0]
	methods=str(self.clfn[t1-1])
	linenos=str(self.cfline[t1-1])
	REQUEST.set('linenos',linenos)
	REQUEST.set('clname',self.clname)
	REQUEST.set('methods',methods)
	REQUEST.set('path',self.filepath)
	RESPONSE.redirect(self.surl+'/manage_addProduct/GNOWSYS/manage_addClassType?clname=%s&methods=%s&linenos=%s&path=%s'%(self.clname,methods,linenos,self.filepath))

    def callintermed(self,REQUEST,RESPONSE=None):
        intermed(REQUEST)

    def createfactory(self,REQUEST,RESPONSE=None):
	"""instantiate all functions and classes within one particular directory"""
	dirpath=REQUEST.form['searchPath']
	if os.path.isdir(dirpath):
		l1=listpy(dirpath)   # Create an object of listpy to display py files in a given path
		self.pyfdir=l1.pathpyfiles
		for pfile in self.pyfdir:
			clfn=[]
			fline=[]
			cfline=[]
			pycldict=[]
			pyfundict=[]
			filelines=[]
			l2=listcf(pfile)   	         # Create an object of listclfn which is used to display classes and functions
			clfn.extend(l2.m)		 #functions within class
			fline.extend(l2.l)                    # Line numbers of functions in .py file
			cfline.extend(l2.v)                    # Line numbers of functions within class
			pycldict.extend(l2.funcl)              # Dictionary of all classes
			pyfundict.extend(l2.fun)               # Dictionary of all functions in the .py file
			fp=open(pfile)
			filelines=fp.readlines()
			dbname=os.path.split(pfile)
			path=dbname[0]
			os.chdir(dbname[0])
			modname=os.path.splitext(dbname[1])[0]
			for i in range(len(pyfundict)):
				no=fline[i]
				fread=filelines[no-1]
				while string.find(fread,':')==-1:
					fread=fread+filelines[no]
					no=no+1
				try:
					evalst=compile('import '+modname,'','single') #Importing the module
	       				exec evalst
				except:
					continue
	        		name=modname+'.'+pyfundict[i][0]
				try:
		        		evaldoc=compile('docu='+name+'.__doc__','','single') # Documentation of the function
		        		exec evaldoc
				except:
					docu=''
				#if docu==None:
					#docu=''
				#t.append(string.replace(docu," ","|"))
				f=string.replace(fread,'\n','')
				f=string.replace(f,' ','')
				defline=string.split(f,'def')[1]
				fname=pyfundict[i][0]
				self.setfunObject(fname,defline,docu,modname,path)
			if pycldict!=[]:
				for k in range(len(pycldict)):
					clname=pycldict[k][0]
					methods=str(clfn[k])
					linenos=str(cfline[k])
					self.setclassObject(clname,methods,linenos,path)
			fp.close()
		REQUEST.set('dirname',dirpath)
		RESPONSE.redirect('confirmAddition?dirname=%s'%(dirpath))
	else:
		message=dirpath+' is not a directory. Please enter a directory path.'
		REQUEST.set('msg',message)
		RESPONSE.redirect('errorPage?msg=%s'%(message))

    def setfunObject(self,name,defline,doc,modname,dbname):
	""" call setObject"""
	phyurl=self.getPhysicalPath()[1]
	if name[0:1]=='_':
		name=name[1:]
	m=self.restrictedTraverse('/'+phyurl+'/PBase/Functions/',default=None)
	print phyurl
	try:
		m._setObject(name,FunctionType(name,name,defline,doc,modname,dbname))
	except:
		print "Exception"

    def setclassObject(self,name,methods,linenos,dbname):
	""" call setObject """
	phyurl=self.getPhysicalPath()[1]
	if name[0:1]=='_':
		name=name[1:]
	m=self.restrictedTraverse('/'+phyurl+'/PBase/ClassBase/',default=None)
	try:
		m._setObject(name,ClassType(name,name,name,methods,linenos,dbname))
	except:
		print "Exception"


    def addfile(self,REQUEST,RESPONSE):
	"""Add the composed file"""
	content=REQUEST['problem']
	content="<dtml-var standard_html_header>"+content+"<dtml-var standard_html_footer>"
	filename=REQUEST['filename']
	title=REQUEST['title']
	phyurl=self.getPhysicalPath()[1]
	m=self.restrictedTraverse('/'+phyurl+'/PBase/WordProblems',default=None)
	m.manage_addDTMLMethod(filename,title,content)
	REQUEST.set('newname',filename)
	REQUEST.set('newid',title)
	RESPONSE.redirect('confirm?newid=%s&newname=%s' %(title,filename))

    #the below function editForm is not used	
    def editForm(self,REQUEST,RESPONSE=None):
    	""" Edits the form """
	id=REQUEST.form['id']
	phyurl=self.getPhysicalPath()[1]
	return
	fp=fopen('/'+phyurl+'/PBase/WordProblems/'+id,'r')
	a=fp.fread()
	return str(a)    	
    
    def DelWP(self,REQUEST,RESPONSE=None):
	"""Deletes the Word Problem"""
	delid=REQUEST.form['id']
        self.PBase.WordProblems.manage_delObjects(delid)
        nm="WordProblems"
        REQUEST.set('newnm',nm)
        REQUEST.set('newid',delid)
        REQUEST.RESPONSE.redirect(REQUEST['URL2']+'/replydelete?newid=%s&newnm=%s' %(delid,nm))

    def checkanswer(self,REQUEST,RESPONSE=None):
        """ Check the answer """
	answer=float(REQUEST.form['answer'])
        chanswer=float(REQUEST.form['chanswer'])
        if answer==chanswer:
		comment="right"
        else:
		comment="wrong"
	REQUEST.set('comment',comment)
	REQUEST.set('chanswer',chanswer)
	REQUEST.set('answer',answer)
	RESPONSE.redirect('WordResult?comment=%s&chanswer=%s&answer=%s' %(comment,chanswer,answer))

    def interfun(self,REQUEST,RESPONSE=None):
	"Form forflow to flowform"
	# Check initally whether FunctionObject already exists (ie Edit Flow Object) or create a new Flow Object
	self.FunObject=[]
	if 'FunctionObject' in REQUEST.keys():
		FunObj=string.replace(REQUEST['FunctionObject'],"'","")
		for i in string.split(FunObj,",",-1):		
			self.FunObject.append(i)
	FunObject=string.replace(str(self.FunObject),"[","")
	FunObject=string.replace(FunObject,"]","")
	FunObject=string.replace(FunObject,"'","")
	REQUEST.set('FunctionObject',FunObject)
	if 'objid' in REQUEST.keys():
		objvar=REQUEST['objid']
	else:
		objvar=''
	REQUEST.set('objid',objvar)
	if 'typ' in REQUEST.form.keys(): 
		t=REQUEST.form['typ']
	else:
		t='none'
	REQUEST.set('typ',t)
	err='None'
	if 'error' in REQUEST.keys():
		err=REQUEST['error']
	# Redirect to flowform initially
	RESPONSE.redirect('addnewFlowtypeform?FunctionObject=%s&objid=%s&typ=%s&err=%s'%(FunObject,objvar,t,err))
	

    def makeflow(self,REQUEST,RESPONSE=None):
	"Redirect to the flow page"
	error=''
	fobj=REQUEST['selobj']
	fobj=string.replace(fobj,"'","")
	self.FunObject=string.split(fobj,",",-1)
	if self.FunObject.count('if')>0:
		ifcnt=self.FunObject.count('if')
		endifcnt=self.FunObject.count('endif')
		if ifcnt!=endifcnt:
			error='<h3>Error !!!</h3>if without endif<br>'
  	if self.FunObject.count('for')>0:
                forcnt=self.FunObject.count('for')
                endforcnt=self.FunObject.count('endfor')
                if forcnt!=endforcnt:
                        error='<h3>Error !!!</h3>for without endfor<br>'
	if self.FunObject.count('while')>0:
                whcnt=self.FunObject.count('while')
                endwhcnt=self.FunObject.count('endwhile')
                if whcnt!=endwhcnt:
                        error='<h3>Error !!!</h3>while without endwhile<br>'
	FunObject=string.replace(str(self.FunObject),"[","")
        FunObject=string.replace(FunObject,"]","")
	FunObject=string.replace(FunObject," ","")
	if error!='':
		REQUEST.set('FunctionObject',FunObject)
		REQUEST.set('error',error)
		RESPONSE.redirect('interfun?FunctionObject=%s&error=%s'%(FunObject,error))
	else:
        	# Redirect to Flow to create a flow object of the selected functions in Function Object
		FunObject=string.replace(FunObject,"','","|")
		REQUEST.set('FunctionObject',FunObject)
		ty=REQUEST['typ']
		if ty=='':
			ty=REQUEST['typ1']
		REQUEST.set('typ',ty)
		REQUEST.set('objid',REQUEST.form['objid'])
		RESPONSE.redirect(self.surl+'/manage_addProduct/GNOWSYS/manage_addFlowType?FunctionObject=%s&objid=%s&typ=%s'%(FunObject,REQUEST.form['objid'],ty))
		
	
    errorPage = DTMLFile('pdtml/errorPage',globals())   # Result of all directories and .py files within a given search path
    confirmdir = DTMLFile('pdtml/confirmdir',globals()) 
    confirmAddition = DTMLFile('pdtml/confirmAddition',globals()) 
    selection = DTMLFile('pdtml/selection',globals()) 
    manage_editForm = DTMLFile('pdtml/manage_editForm',globals()) # Edit the content of the object
    resultPage = DTMLFile('pdtml/resultPage',globals())   # Result of all directories and .py files within a given search path
    resultPage1= DTMLFile('pdtml/resultPage1',globals())	# Result of all classes and functions within a .py file
    resultPage2= DTMLFile('pdtml/resultPage2',globals())	# Result of all functions withn a class
    addnewFlowtypeform=DTMLFile('pdtml/addnewFlowtypeform',globals())	# Displays all functions in the Functions folder which can be selected for reating flow objects
    forflow=DTMLFile('pdtml/forflow',globals())             
    selfuncon=DTMLFile('pdtml/selfuncon',globals())	
    condPage=DTMLFile('pdtml/condPage',globals()) 
    WordResult=DTMLFile('pdtml/WordResult',globals()) 
    inputPage2=DTMLFile('pdtml/inputPage2',globals())
    #manage_addFunction=DTMLFile('pdtml/manage_addFunction',globals())
    choice=DTMLFile('pdtml/choice',globals())	
    composeProb=DTMLFile('pdtml/composeProb',globals())
    editProb=DTMLFile('pdtml/editProb',globals())
    exWP=DTMLFile('pdtml/exWP',globals())


# constructor pages. Only used when the product is added to a folder.

callinterfun=DTMLFile('pdtml/callinterfun',globals())
enterpath = DTMLFile('pdtml/enterpath',globals()) # Used to view content of the object


def get_attr(base_obj,curr_obj,err):
    try:
        curr_folder = getattr(base_obj,curr_obj)
    except:
        return err
    return curr_folder

#index_html=DTMLFile('index_html',globals())

InitializeClass(listing)
