######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

import os,sys,string

def validfilename(filename):

    if filename=='':
        return 0
    
    v = filename.isalnum()
    
    return v

def getStart():
    start = []
    start.append('<?xml version="1.0" encoding="UTF-8"?>\n')
    start.append('<topicMap xmlns="http://www.topicmaps.org/xtm/1.0/" xmlns:xlink="http://www.w3.org/1999/xlink"> \n')
    start.append('<!-- Exported from GNOWSYS version 0.4 -->\n')
    
    return start

def getEnd():
    end = []
    end.append ('</topicMap>')

    return end

def getSort(SortName):
    sort = []
    sort.append ('<variant>\n')
    sort.append ('<parameters>\n')
    sort.append ('<topicRef xlink:href="#sort"/>\n')
    sort.append ('</parameters>\n')
    sort.append ('<variantName>\n')
    sort.append ('<resourceData>'+ SortName +'</resourceData>\n')
    sort.append ('</variantName>\n')        
    sort.append ('</variant>\n')

    return sort

def getDisp(DispName):
    disp = []
    disp.append ('<variant>\n')
    disp.append ('<parameters>\n')
    disp.append ('<topicRef xlink:href="#display"/>\n')
    disp.append ('</parameters>\n')
    disp.append ('<variantName>\n')
    disp.append ('<resourceData>' + DispName +'</resourceData>\n')
    disp.append ('</variantName>\n')        
    disp.append ('</variant>\n')

    return disp;

def getPsiStructure():
    Psi = []
    Psi.append('<topic id="object">\n')
    Psi.append('<subjectIdentity>\n')
    Psi.append('<subjectIndicatorRef xlink:href="http://www.topicmaps.org/xtm/1.0/core.xtm#psi-topic"/>\n')
    Psi.append('</subjectIdentity>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="objectType">\n')
    Psi.append('<baseName>\n')
    Psi.append('<baseNameString> Object Type </baseNameString>\n')
    Psi.append('</baseName>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="association">\n')
    Psi.append('<subjectIdentity>\n')
    Psi.append('<subjectIndicatorRef xlink:href="http://www.topicmaps.org/xtm/1.0/core.xtm#psi-association"/>\n')
    Psi.append('</subjectIdentity>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="associationType">\n')
    Psi.append('<baseName>\n')
    Psi.append('<baseNameString> Association Type </baseNameString>\n')
    Psi.append('</baseName>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="occurrence">\n')
    Psi.append('<subjectIdentity>\n')
    Psi.append('<subjectIndicatorRef xlink:href="http://www.topicmaps.org/xtm/1.0/core.xtm#psi-occurrence"/>\n')
    Psi.append('</subjectIdentity>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="occurrenceType">\n')
    Psi.append('<baseName>\n')
    Psi.append('<baseNameString> Occurrence Type </baseNameString>\n')
    Psi.append('</baseName>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="facetType">\n')
    Psi.append('<baseName>\n')
    Psi.append('<baseNameString> Facet Type </baseNameString>\n')
    Psi.append('</baseName>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="sort">\n')
    Psi.append('<subjectIdentity>\n')
    Psi.append('<subjectIndicatorRef xlink:href="http://www.topicmaps.org/xtm/1.0/core.xtm#psi-sort"/>\n')
    Psi.append('</subjectIdentity>\n')
    Psi.append('</topic>\n')
    Psi.append('<topic id="display">\n')
    Psi.append('<subjectIdentity>\n')
    Psi.append('<subjectIndicatorRef xlink:href="http://www.topicmaps.org/xtm/1.0/core.xtm#psi-display"/>\n')
    Psi.append('</subjectIdentity>\n')
    Psi.append('</topic>\n')

    return Psi

def getObjectTypes(self):
    ObjectTypes = []

    octlist = []
    for eachOct in self.Catalog({'meta_type':'Occurrence Type'}):
        if eachOct.meta_type == 'Occurrence Type':
            octlist.append(eachOct.id)

    fctlist = []
    for eachOct in self.Catalog({'meta_type':'Facet Type'}):
        if eachOct.meta_type == 'Facet Type':
            fctlist.append(eachOct.id)

    for eachOT in self.Catalog({'meta_type':'Object Type'}):
        if eachOT.meta_type == 'Object Type':     
            #topicidtext = '<topic id="' + eachOT.id + '" >\n'
            ObjectTypes.append ('<topic id="' + eachOT.id + '" >\n')

            ObjectTypes.append ('<instanceOf>\n')
            ObjectTypes.append ('<topicRef xlink:href="#objectType"/>\n')
            ObjectTypes.append ('</instanceOf>\n')
            for eachTTListitem in eachOT.TTList:
                if eachTTListitem!='Object': # if it is an instanceof 'Object', then it is trivial and hence ignored
                    ObjectTypes.append ('<instanceOf>\n')
                    ObjectTypes.append ('<topicRef xlink:href="#' + eachTTListitem + '"/>\n')
                    ObjectTypes.append ('</instanceOf>\n')
            ObjectTypes.append ('<baseName>\n')
            ObjectTypes.append ('<baseNameString>' + eachOT.BaseName + '</baseNameString>\n')
            
            SortName = eachOT.SortName
            if SortName:
                sortlist = getSort(SortName)
                for each in sortlist:
                    ObjectTypes.append(each)

            DispName = eachOT.DisplayName
            if DispName:
                displist = getSort(DispName)
                for each in displist:
                    ObjectTypes.append(each)                    
                
            ObjectTypes.append ('</baseName>\n')
            #ObjectTypes.append ('<subjectIdentity>\n')
            #ObjectTypes.append ('</subjectIdentity>\n')

            for eachOct in octlist:
                Occ = eachOT.getProperty(eachOct)
                if Occ:
                    for eachOcc in Occ:
                        ObjectTypes.append ('<occurrence>\n')
                        ObjectTypes.append ('<instanceOf>\n')
                        ObjectTypes.append ('<topicRef xlink:href="#' + eachOct + '"/>\n')
                        ObjectTypes.append ('</instanceOf>\n')
                        if string.find(eachOcc,'http://')!=-1:
                            ObjectTypes.append ('<resourceRef xlink:href="' + eachOcc + '"/>\n')
                        else:
                            ObjectTypes.append ('<resourceData>' + eachOcc + '</resourceData>\n')
                        ObjectTypes.append ('</occurrence>\n')

            for eachFct in fctlist:
                Facet = eachOT.getProperty(eachFct)
                if Facet:
                    ObjectTypes.append ('<occurrence>\n')
                    ObjectTypes.append ('<instanceOf>\n')
                    ObjectTypes.append ('<topicRef xlink:href="#' + eachFct + '"/>\n')
                    ObjectTypes.append ('</instanceOf>\n')
                    ObjectTypes.append ('<resourceData>' + Facet + '</resourceData>\n')
                    ObjectTypes.append ('</occurrence>\n')
            
            ObjectTypes.append ( '</topic>\n')            
    
    return ObjectTypes

def getObjects(self):
    Objects = []

    for eachO in self.Catalog({'meta_type':'Object'}):
        if eachO.meta_type == 'Object':     
            Objects.append ('<topic id="' + eachO.id + '" >\n')
            Objects.append ('<instanceOf>\n')
            Objects.append ('<topicRef xlink:href="#object"/>\n')
            Objects.append ('</instanceOf>\n')
            for eachObjectTypeitem in eachO.ObjectTypes:
                if eachObjectTypeitem!='Object': # if it is an instanceof 'Object', then it is trivial and hence ignored
                    Objects.append ('<instanceOf>\n')
                    Objects.append ('<topicRef xlink:href="#' + eachObjectTypeitem + '"/>\n')
                    Objects.append ('</instanceOf>\n')
            Objects.append ('<baseName>\n')
            Objects.append ('<baseNameString>' + eachO.BaseName + '</baseNameString>\n')
            
            SortName = eachO.SortName
            if SortName:
                sortlist = getSort(SortName)
                for each in sortlist:
                    Objects.append(each)

            DispName = eachO.DisplayName
            if DispName:
                displist = getSort(DispName)
                for each in displist:
                    Objects.append(each)                    
                
            Objects.append ('</baseName>\n')

            Desc = eachO.Description
            if Desc:
                Objects.append ('<occurrence>');
                Objects.append ('<resourceData>' + Desc + '</resourceData> \n')
                Objects.append ('</occurrence>')
            
            Objects.append ( '</topic>\n')            
    
    return Objects

def getAssociationTypes(self):
    AssociationTypes = []

    for eachAT in self.Catalog({'meta_type':'Association Type'}):
        if eachAT.meta_type == 'Association Type':
            AssociationTypes.append ('<topic id="' + eachAT.id + '" >\n')
            AssociationTypes.append ('<instanceOf>\n')
            AssociationTypes.append ('<topicRef xlink:href="#associationType"/>\n')
            AssociationTypes.append ('</instanceOf>\n')
            AssociationTypes.append ('<baseName>\n')
            AssociationTypes.append ('<baseNameString>' + eachAT.BaseNameA + '</baseNameString>\n')
            
            SortName = eachAT.SortName
            if SortName:
                sortlist = getSort(SortName)
                for each in sortlist:
                    AssociationTypes.append(each)

            DispName = eachAT.DisplayName
            if DispName:
                displist = getSort(DispName)
                for each in displist:
                    AssociationTypes.append(each)                    
                
            AssociationTypes.append ('</baseName>\n')          
            AssociationTypes.append ('</topic>\n')            
    
    return AssociationTypes

def getAssociations(self):
    Associations = []

    for eachA in self.Catalog({'meta_type':'Association'}):
        if eachA.meta_type == 'Association':
            #asType =string.join(eachA.AssociationType,',')
            asType =eachA.AssociationType[0]
            lobj=string.join(eachA.LObjects,',')
            robj=string.join(eachA.RObjects,',')
            Associations.append ('<association id="' + eachA.id + '">\n')
            Associations.append ('<instanceOf>\n')
            Associations.append ('<topicRef xlink:href="#' + eachA.AssociationType[0] + '"/>\n')
            Associations.append ('</instanceOf>\n')
            
            for eachAT in self.Catalog({'meta_type':'Association Type'}):
                if eachAT.meta_type == 'Association Type':
                    if asType == eachAT.id :
                        #lrole = string.join(eachAT.LRoles,',')
                        Associations.append ('<member>\n')  
                        Associations.append ('<roleSpec>\n')
                        Associations.append ('<topicRef xlink:href="#' + eachAT.LRoles[0] + '"/>\n')
                        Associations.append ('</roleSpec>\n')
                        Associations.append ('<topicRef xlink:href="#' + lobj + '"/>\n')
                        Associations.append ('</member>\n')

                        #rrole=string.join(eachAT.RRoles,',')
                        Associations.append ('<member>\n')
                        Associations.append ('<roleSpec>\n')
                        Associations.append ('<topicRef xlink:href="#' + eachAT.RRoles[0] + '"/>\n')
                        Associations.append ('</roleSpec>\n')
                        Associations.append ('<topicRef xlink:href="#' + robj + '"/>\n')
                        Associations.append ('</member>\n')
           
            Associations.append ('</association>\n')
            
    return Associations        

def getOccurrenceTypes(self):
    OccurrenceTypes = []

    for eachOCT in self.Catalog({'meta_type':'Occurrence Type'}):
        if eachOCT.meta_type == 'Occurrence Type':     
            OccurrenceTypes.append ('<topic id="' + eachOCT.id + '" >\n')
            OccurrenceTypes.append ('<instanceOf>\n')
            OccurrenceTypes.append ('<topicRef xlink:href="#occurrenceType"/>\n')
            OccurrenceTypes.append ('</instanceOf>\n')
            OccurrenceTypes.append ('<baseName>\n')
            OccurrenceTypes.append ('<baseNameString>' + eachOCT.BaseName + '</baseNameString>\n')
            
            SortName = eachOCT.SortName
            if SortName:
                sortlist = getSort(SortName)
                for each in sortlist:
                    OccurrenceTypes.append(each)

            DispName = eachOCT.DisplayName
            if DispName:
                displist = getSort(DispName)
                for each in displist:
                    OccurrenceTypes.append(each)                    
                
            OccurrenceTypes.append ('</baseName>\n')          
            OccurrenceTypes.append ('</topic>\n')            
    
    return OccurrenceTypes

def getFacetTypes(self):
    FacetTypes = []

    for eachFT in self.Catalog({'meta_type':'Facet Type'}):
        if eachFT.meta_type == 'Facet Type':     
            FacetTypes.append ('<topic id="' + eachFT.id + '" >\n')
            FacetTypes.append ('<instanceOf>\n')
            FacetTypes.append ('<topicRef xlink:href="#facetType"/>\n')
            FacetTypes.append ('</instanceOf>\n')
            FacetTypes.append ('<baseName>\n')
            FacetTypes.append ('<baseNameString>' + eachFT.facettype + '</baseNameString>\n')
            
            SortName = eachFT.SortName
            if SortName:
                sortlist = getSort(SortName)
                for each in sortlist:
                    FacetTypes.append(each)

            DispName = eachFT.DisplayName
            if DispName:
                displist = getSort(DispName)
                for each in displist:
                    FacetTypes.append(each)                    
                
            FacetTypes.append ('</baseName>\n')          
            FacetTypes.append ('</topic>\n')            
    
    return FacetTypes
   
def createXMLFile(self,REQUEST):

    try:
        rootdirectory = os.listdir('/tmp/')
    except:
        os.makedirs('tmp')
        rootdirectory = os.listdir('/tmp/')

    filename1 = REQUEST['filename']
    
    if validfilename(filename1)==0:
        url = self.surl + '/exportCheckfilename'
        REQUEST.RESPONSE.redirect(url)
        return

    filename1 = filename1 + '.xtm'
    filename = '/tmp/' + filename1
    
    file=open(filename,'w')
    file.writelines(getStart())    
    file.writelines(getPsiStructure())
    file.writelines(getObjectTypes(self))
    file.writelines(getObjects(self))
    file.writelines(getAssociations(self))
    file.writelines(getAssociationTypes(self))
    file.writelines(getOccurrenceTypes(self))
    file.writelines(getFacetTypes(self))    
    file.writelines(getEnd())    
    file.close()

    file=open(filename,'r')    
    filedata = file.read()
    file.close()

    self.XTM_Files.manage_addProduct['OFSP'].manage_addFile(filename1,filedata,filename1,'','')

    os.remove(filename)

    REQUEST.RESPONSE.redirect( self.surl + '/replyExport?filename=%s' % (filename1) )
