#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

import string
import os
from Products.ZCatalog import ZCatalog
from OFS.SimpleItem import * 
from GNOWSYS import *

class ClassType(ObjectManager,
           PropertyManager,
           RoleManager,
           Item,
           FindSupport,
           ZCatalog, 
	   SimpleItem):
        """adding a classtype instance"""

	meta_type ='Class Type'

        _properties= (
                {'id':'id', 'type':'string', 'mode':'r'},
                {'id':'title', 'type':'string', 'mode':'r'},
                {'id':'module','type':'string','mode':'r'},
                {'id':'classname','type':'string','mode':'r'},
                {'id':'methods','type':'string','mode':'r'},
                )

        __ac_permissions__=(
        ('Manage Properties',('manage_addProperty',
                              'manage_editProperties',
                              'manage_delProperties',
                              'manage_changeProperties',
                              'Access content information')),
         )

        manage_options =(
                {'label': 'Contents', 'action': 'manage_main'},
                {'label': 'Properties', 'action': 'manage_propertiesForm'},
                {'label': 'View', 'action': 'classinit'},
               	)
		
	def __init__(self,id,title,clname,methods,linenos,path):
		"""Initialises class instance"""
		self.id=id
		self.title=title
		self.module=string.split(os.path.basename(path),'.',1)[0]
		self.classname=clname
		self.methods=methods	
		self.linenos=linenos
		self.filepath=path
		try :
			evalst=compile('import '+self.module,'','single')
			exec evalst
    			evalst1=compile('doc='+self.classname+'.__doc__','','single')
    			exec evalst1
		except:
			evalst=compile('from '+self.module+' import *','','single')
    			exec evalst
    			evalst1=compile('doc='+self.classname+'.__doc__','','single')
    			exec evalst1
		if doc==None:
			doc=''
		self.manage_addProperty('documentation',doc,'lines')
		self.manage_addProperty('InstanceValue','','string')
		self.manage_addProperty('Result','','string')
			
	def DelClassT(self,REQUEST,RESPONSE=None):	#Delete the classtype from database
                """Delete the class type"""
		delid=REQUEST.form['id']
                self.PBase.ClassBase.manage_delObjects(delid)
       		nm="ClassType"
       		REQUEST.set('newnm',nm)
      	 	REQUEST.set('newid',delid)
       		REQUEST.RESPONSE.redirect(REQUEST['URL2']+'/replydelete?newid=%s&newnm=%s' % (delid,nm))

	def createclassobj(self,REQUEST,RESPONSE=None):		#Create a class instance of the class type
		"""create class object"""
		self.url=REQUEST['URL3']
		REQUEST.set('id',REQUEST.form['id'])
		REQUEST.set('title',self.classname)
		REQUEST.set('methods',self.methods)
		REQUEST.set('linenos',self.linenos)
		REQUEST.set('initarg',REQUEST.form['initarg'])
		REQUEST.set('path',self.filepath)
		RESPONSE.redirect(self.url+'/manage_addProduct/GNOWSYS/manage_Class?id=%s&title=%s&methods=%s&linenos=%s&path=%s&initarg=%s'%(REQUEST.form['id'],self.classname,self.methods,self.linenos,self.filepath,REQUEST.form['initarg']))

	classinit=DTMLFile('pdtml/classinit',globals()) 	#Obtains id for class instance

def manage_ClassType(dispatcher,id,clname,methods,linenos,path,REQUEST=None):	#Constructor
    """constructor-add a classtype to a folder."""
    dest=dispatcher.Destination()
    title=clname
    idt=dest.absolute_url()
    dest.PBase.ClassBase._setObject(id,ClassType(id,title,clname,methods,linenos,path))
    REQUEST.set('newname',id)	
    if REQUEST is not None:   
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
	vname='ClassType'
	REQUEST.set('newid',vname)
        REQUEST.RESPONSE.redirect(url+'/confirm?newname=%s&newid=%s' % (id,vname))

manage_addClassType=DTMLFile('pdtml/manage_addClassType',globals())
addnewClassform=DTMLFile('pdtml/addnewClassform',globals())

InitializeClass(ClassType)
