######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Globals import HTMLFile
import Products.PythonScripts, Globals
from Products.PythonScripts.PythonScript import manage_addPythonScript
from Products.ZCatalog.ZCatalog import manage_addZCatalog
from Products.TransparentFolders.TransparentFolder import manage_addTransparentFolder			

from Products.GNOWSYS.gno import manage_addgnoFolder

file_path = Globals.package_home(globals())

class GNOWSYS(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport):
    """gno Folder object implementation.

    gno Folder objects are folders that can contain subobjects
    and other supporting objects.  They provide properties to all
    Objects and other Object Types in them.  They also provide
    support methods for displaying Objects and Object Types.
    """

    meta_type = "GNOWSYS"
  
   
    _properties = (
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'image', 'type': 'selection', 'mode': 'wd', 'select_variable': 'image_select'},
        ) 


    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'View', 'action': 'index_html'},
        ) 

allowedmetatypes = ('DTML Method')

def all_meta_types(self):

            if hasattr(self, 'allowedmetatypes'):
                result = []
		import Products
                for metaType in Products.meta_types:
                    if metaType['name'] in self.allowedmetatypes:
                        result.append(metaType)
                return result

def __init__(self, id, title):
        self.__version__ = '1.0'
        self.id = id
        self.title = title

 
#constructors


ncallclone = DTMLFile('dtml/ncallclone',globals())


def ncl(self,id,title,REQUEST=None):

    """replicate FOLDER from system to ZODB """

    if hasattr(self,id):
       return ''' <p> <h4>Id %s already in use </h4>
                  <p> <p> please , select some other Id ''' %(id)
    self.manage_addgnoFolder(id,title)
    curr_folder = get_attr(self,id,'Attribute Err') 

    manage_addTransparentFolder(curr_folder,'Programs','Programs')
    curr_folder=curr_folder.Programs
    curr_folder.manage_addFolder('Data1',"Data1")
    curr_folder.Data1.manage_addFolder('Objects','Objects')
    addDTML(curr_folder,'index_html','GNOWSYS HomePage','index_html')
   # addDTML(curr_folder,'index_html','GNOWSYS HomePage','index_html')
    addDTML(curr_folder,'ContentsList',"proj",'CloneFolder/ContentsList')
    addDTML(curr_folder,'FacetaddForm',"proj",'CloneFolder/FacetaddForm')
    addDTML(curr_folder,'QueryOptions',"proj",'CloneFolder/QueryOptions')
    addDTML(curr_folder,'ReportGnoT',"proj",'CloneFolder/ReportGnoT')
    addDTML(curr_folder,'SearchGnoT',"proj",'CloneFolder/SearchGnoT')
    addDTML(curr_folder,'Tcontents',"proj",'CloneFolder/Tcontents')
    addDTML(curr_folder,'ViewOptions',"proj",'CloneFolder/ViewOptions')
    addDTML(curr_folder,'ViewOptions1',"proj",'CloneFolder/ViewOptions1')
    addDTML(curr_folder,'assotlist',"proj",'CloneFolder/assotlist')
    addDTML(curr_folder,'facetdels',"proj",'CloneFolder/facetdels')
    addDTML(curr_folder,'facetlist',"proj",'CloneFolder/facetlist')
    addDTML(curr_folder,'loginform',"proj",'CloneFolder/loginform')
    addDTML(curr_folder,'occurlist',"proj",'CloneFolder/occurlist')
    addDTML(curr_folder,'occurrencesdel',"proj",'CloneFolder/occurrencesdel')
    addDTML(curr_folder,'occurrencesadd',"proj",'CloneFolder/occurrencesadd')
    addDTML(curr_folder,'replyadd',"proj",'CloneFolder/replyadd')
    addDTML(curr_folder,'replydelete',"proj",'CloneFolder/replydelete')
    addDTML(curr_folder,'replyedit',"proj",'CloneFolder/replyedit')
    addDTML(curr_folder,'sendEmail',"proj",'CloneFolder/sendEmail')
    addDTML(curr_folder,'standard_error_message',"proj",'CloneFolder/standard_error_message')
    addDTML(curr_folder,'userform',"proj",'CloneFolder/userform')
    addDTML(curr_folder,'viewlst',"proj",'CloneFolder/viewlst')
    addDTML(curr_folder,'bkbdoc',"proj",'CloneFolder/bkbdoc')
    addDTML(curr_folder,'delassos',"proj",'CloneFolder/delassos')
    addDTML(curr_folder,'delassots',"proj",'CloneFolder/delassots')
    addDTML(curr_folder,'delitems',"proj",'CloneFolder/delitems')
    addDTML(curr_folder,'deltopics',"proj",'CloneFolder/deltopics')
    addDTML(curr_folder,'manage_deltopic',"proj",'dtml/deltopic')
    addDTML(curr_folder,'documentation_html',"proj",'CloneFolder/documentation_html')
    addDTML(curr_folder,'EditForm',"proj",'CloneFolder/EditForm')
    addDTML(curr_folder,'manage_editmain',"proj",'dtml/editmain')
    addDTML(curr_folder,'manage_membership',"proj",'dtml/membership')
    addDTML(curr_folder,'manage_facetedit',"proj",'dtml/facetedit')
    addDTML(curr_folder,'facetcall',"proj",'CloneFolder/Data/facetcall')
    addDTML(curr_folder,'callfacettypedel',"proj",'CloneFolder/Data/callfacettypedel')
    addDTML(curr_folder,'manage_Facetmainform',"proj",'dtml/Facetmainform')
    addDTML(curr_folder,'ttl',"proj",'dtml/ttl')
    addDTML(curr_folder,'unl',"proj",'dtml/unl')
    addDTML(curr_folder,'delfacets',"proj",'dtml/delfacets')
    addDTML(curr_folder,'changett',"proj",'dtml/changett')
    addDTML(curr_folder,'remtt',"proj",'dtml/remtt')
    addDTML(curr_folder,'manage_occuredit',"proj",'dtml/occuredit')
    addDTML(curr_folder,'manage_occurmain',"proj",'dtml/occurmain')
    addDTML(curr_folder,'help_html',"proj",'CloneFolder/help_html')
    addDTML(curr_folder,'impexp',"proj",'CloneFolder/impexp')
    addDTML(curr_folder,'menu',"proj",'CloneFolder/menu')
    addDTML(curr_folder,'callocc',"proj",'CloneFolder/callocc')	
    addDTML(curr_folder,'ReportGnoA',"proj",'CloneFolder/ReportGnoA')
    addDTML(curr_folder,'SearchGnoA',"proj",'CloneFolder/SearchGnoA')
    addDTML(curr_folder,'standard_html_header',"proj",'CloneFolder/standard_html_header')
    addDTML(curr_folder,'standard_html_footer',"proj",'CloneFolder/standard_html_footer')
    addDTML(curr_folder,'team_html',"proj",'CloneFolder/team_html')
    addDTML(curr_folder,'topiclist',"proj",'CloneFolder/topiclist')
    addDTML(curr_folder,'occurdel',"proj",'dtml/occurdel')
    addDTML(curr_folder,'callsocc',"proj",'CloneFolder/Data/callsocc')
    addDTML(curr_folder,'socc',"proj",'CloneFolder/Data/socc')
    addDTML(curr_folder,'EditMain',"proj",'dtml/EditMain')
    addDTML(curr_folder,'alistinfo',"proj",'dtml/alistinfo')
    addDTML(curr_folder,'delasso',"proj",'dtml/delasso')
    addDTML(curr_folder,'Msg1OT',"proj",'dtml/Msg1OT')
    addDTML(curr_folder,'Test1OT',"proj",'dtml/Test1OT')
    addDTML(curr_folder,'OTeditmain',"proj",'dtml/OTeditmain')
    addDTML(curr_folder,'OTmembership',"proj",'dtml/OTmembership')
    addDTML(curr_folder,'OTtopictlist',"proj",'dtml/OTtopictlist')
    addDTML(curr_folder,'OTlistunsel',"proj",'dtml/OTlistunsel')
    addDTML(curr_folder,'addtoOTlist',"proj",'dtml/addtoOTlist')
    addDTML(curr_folder,'OTremovefromlist',"proj",'dtml/OTremovefromlist') 
    addPythonScript(curr_folder,'copytt','CloneFolder/copytt')
    addPythonScript(curr_folder,'copyot','CloneFolder/copyot')
    addPythonScript(curr_folder,'copyft','CloneFolder/copyft')
    addPythonScript(curr_folder,'loginscript','CloneFolder/loginscript')
    addPythonScript(curr_folder,'strconv','CloneFolder/strconv')
    addPythonScript(curr_folder,'useradd','CloneFolder/useradd')
       
    return self.manage_main(self,REQUEST,update_menu=1)

   
def get_attr(base_obj,curr_obj,err):
    try:
        curr_folder = getattr(base_obj,curr_obj)
    except:
        return err
    return curr_folder


def addPythonScript(obj,id,file):
    f=open(file_path+'/'+file+'.py')     
    file=f.read()     
    f.close()     
    manage_addPythonScript(obj,id)
    obj._getOb(id).write(file)
    return getattr(obj,id)     

def addDTML(obj,id,title,file):     
    f=open(file_path+'/'+file+'.dtml')     
    file=f.read()     
    f.close()     
    obj.manage_addDTMLMethod(id,title,file)     
    return getattr(obj,id)     
     
def addImage(obj,id,file):     
    f=open(file_path+'/'+file,'rb')     
    contents=f.read()     
    f.close()     
    title=''     
    tlen = len(contents)     
    new_id = obj.manage_addImage(id,contents,title=title)   
    img_obj = obj.__getitem__(new_id)  
    img_obj.content_type = 'image/gif'

def addZCatalog(obj,id,file):
    f=open(file_path+'/'+file)     
    file=f.read()     
    f.close()     
    manage_addZCatalog(obj,id)
    obj._getOb(id).write(file)
    return getattr(obj,id)     



InitializeClass(GNOWSYS)
