#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Globals import HTMLFile
import Products.PythonScripts, Globals
from Products.PythonScripts.PythonScript import *
from Products.MailHost.MailHost import manage_addMailHost
from Products.ZCatalog.ZCatalog import manage_addZCatalog
from Products.TransparentFolders.TransparentFolder import manage_addTransparentFolder
from Products.ExternalMethod.ExternalMethod import *
from AccessControl.User import manage_addUserFolder
import os
from Products.GNOWSYS.gno import gno,manage_addgnoFolder
from Products.GNOWSYS.ObjectType import ObjectType
from Products.GNOWSYS.OccurrenceType import occurrencetype
from Products.GNOWSYS.AssociationType import AssocT
from Products.GNOWSYS.Object import Object
from Products.GNOWSYS.FacetType import facettype
from time import time
from string import split, find

################Import Statements Below are for Functional Representation Module###############
#from Products.GNOWSYS.listing import *
from Products.GNOWSYS.listcf import *
from Products.GNOWSYS.listpy import *

import UserDict
import UserList
#import MutableString
import UserString
import maths

import cmaths
import string
from tabclass import *
from FunctionType import *
from ClassType import *
from listing import *
#from factoryobj import *
import factoryobj 
from conditiontype import *

import os,sys
os.chdir('/')
program=sys.argv[0]
here=os.path.join(os.getcwd(),os.path.split(program)[0])

sys.path=[os.path.join(here,'lib','python'),here]+filter(None,sys.path)

file_path = Globals.package_home(globals())

######################The GNOWSYS class defination starts from here############################
class GNOWSYS(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport):
    """
    GNOWSYS implementation.
    This is the main GNOWSYS class this class will be used for 
    Instantiating the product.
    """

    meta_type = "GNOWSYS"

    _properties = (
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'image', 'type': 'selection', 'mode': 'wd', 'select_variable': 'image_select'},
        ) 

################These are the tabs we see in the main instance folder in ZMI###################
    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'View', 'action': 'index_html'},
        {'label': 'Properties', 'action':'_properties'}, 
        ) 


allowedmetatypes = ('DTML Method')

###############################################################################################
#This function determines what objects can be added
#inside GNOWSYS standard file hierarchy
###############################################################################################

def all_meta_types(self):

            if hasattr(self, 'allowedmetatypes'):
                result = []
		import Products
                for metaType in Products.meta_types:
                    if metaType['name'] in self.allowedmetatypes:
                        result.append(metaType)
                return result

def __init__(self, id, title):
        self.__version__ = '0.4'
        self.id = id
        self.title = title

#constructors

###############This is the form you see while Instantiating the GNOWSYS Instance###############

ncallclone = DTMLFile('dtml/ncallclone',globals())
RuleForm = DTMLFile('CF/RuleForm',globals())

###############################################################################################
#This method copies the contents of CF folder inside GNOWSYS to the Programs folder in ZMI
#These are usually dtml forms or python scripts.
###############################################################################################
def ncl(self,id,title,REQUEST=None):

    """replicate FOLDER from the file system to ZODB """
    import string

################# Following code is only for Functional Representation Module #####################
#################The code below checks for existance of Numeric.py module.#####################
# Modules Numeric and umaths can be imported only after os.syspath variable has been updated. #

    flagNumeric = 0
    OS = ''
    appendPath1 = ''
    appendPath2 = ''

    s = REQUEST['SERVER_SOFTWARE']
    f = string.find(s,'win32')
    if (f!=-1):
	OS = 'W'
    else:
	OS = 'NW'

    if OS=='W':
	appendPath1 = 'C:\\PYTHON21\\Lib\\site-packages\\Numeric'
	appendPath2 = 'C:\\PYTHON22\\Lib\\site-packages\\Numeric'
    else :
	appendPath1 = '/usr/lib/python2.1/site-packages/Numeric'
	appendPath2 = '/usr/lib/python2.2/site-packages/Numeric'

    try:
	sys.path.append(appendPath1)
	import Numeric
	import umaths
	flagNumeric = 1
    except:	
	try:
		sys.path.append(appendPath2)
		import Numeric
		import umaths
		flagNumeric = 1		
	except:
		print "Python Numeric module is not installed."
# End of check for Numeric #

    if hasattr(self,id):
       return ''' <p> <h4>Id %s already in use </h4>
                  <p> <p> please , select some other Id ''' %(id)
    surl = self.absolute_url()
    surl = surl + '/' + id
   
    self.manage_addgnoFolder(id,title)
    curr_folder = get_attr(self,id,'Attribute Err')

   
    """
    Below code adds Data, Objects,... folders to store the instances created by     a user and the System Objects and Object Types
    """

###############################################################################################
#These are various icons that you see on the GNOWSYS interface. 
#In ZMI you can find them inside Images Folder.
###############################################################################################

    curr_folder._setObject('Images', gno('Images','Icons of GNOWSYS'))
    addImage(curr_folder,'GnowsysLogo','www/Gnowsys.png')
    addImage(curr_folder.Images,'FlowType','www/flow-type.png')
    addImage(curr_folder.Images,'Flow','www/flow.png')
    addImage(curr_folder.Images,'FunctionType','www/function-type.png')
    addImage(curr_folder.Images,'Function','www/function.png')
    addImage(curr_folder.Images,'ClassType','www/class-type.png')
    addImage(curr_folder.Images,'Class','www/class.png')
    addImage(curr_folder.Images,'ObjectType','www/Object_Type.jpg')
    addImage(curr_folder.Images,'Object','www/Object.jpg')
    addImage(curr_folder.Images,'AssociationType','www/association-type.png')
    addImage(curr_folder.Images,'Association','www/association.png')
    addImage(curr_folder.Images,'FacetType','www/facet-type.png')
    addImage(curr_folder.Images,'Facet','www/facet.png')
    addImage(curr_folder.Images,'OccurrenceType','www/occurrence-type.png')

##################Here we create the entire GNOWSYS folder hierarchy.##########################
    curr_folder._setObject('Latex_files', gno('Latex_files','Latex_files'))
    curr_folder._setObject('Pdf_files', gno('Pdf_files','Pdf_files'))
    curr_folder.manage_addProperty('SiteTitle',title,'string')
    curr_folder.manage_addProperty('Email',REQUEST['Email_Id'],'string')
    curr_folder._setObject('Data', gno('Data','Data'))
    curr_folder.Data._setObject('Objects', gno('Objects','Objects'))
    curr_folder.Data._setObject('ObjectType', gno('ObjectType','ObjectType'))
    curr_folder.Data._setObject('Associations', gno('Associations','Associations'))
    curr_folder.Data._setObject('AssociationTypes', gno('AssociationTypes','AssociationTypes'))
    curr_folder.Data._setObject('FacetTypes', gno('FacetTypes','FacetTypes'))
    curr_folder.Data._setObject('OccurrenceTypes', gno('OccurrenceTypes','OccurrenceTypes'))
    curr_folder.Data._setObject('Rules', gno('Rules','Rule Base'))
    curr_folder.Data._setObject('Views', gno('Views','Stored Views'))

###############################################################################################
#surl is an important property that is attacehd to the main gnowsys folder. 
#This property holds the instance path along with the domain name of the server. 
#This property is used for calculating URL addreses
###############################################################################################

    curr_folder.manage_addProperty('surl', surl, 'string')
    pathstring = surl
    pathstringlist = pathstring.split('/')
    pathstringlist1 = pathstringlist
    pathstringlist1 = pathstringlist1[3:]
    instancepath = '/'
    if pathstringlist1!=[]:
        for x in pathstringlist1:
            instancepath = instancepath + x + '/'
            
    curr_folder.manage_addProperty('InstancePath', instancepath, 'string')

###################These are Folders related to Functional Representation######################

    curr_folder._setObject('PBase', gno('PBase','PBase'))

    # Add function folder
    curr_folder.PBase._setObject('Functions',listing('Functions','Functions')) 
    curr_folder.PBase._setObject('FlowBase',listing('FlowBase','FlowBase'))  # Add flow base folder
    curr_folder.PBase._setObject('FlowObjects',listing('FlowObjects','FlowObjects'))  # Add flow objects folder
    curr_folder.PBase._setObject('ClassBase',listing('ClassBase','ClassBase')) # Add class instance folder
    curr_folder.PBase._setObject('ClassObjects',listing('ClassObjects','ClassObjects')) # Add class instance folder
    curr_folder.PBase._setObject('WordProblems',listing('WordProblems','WordProblems')) # Add class instance folder
    curr_folder.PBase.Functions._setObject('Conditions',listing('Conditions','Contains Condition Objects')) #Add Conditions
    curr_folder.PBase.Functions._setObject('Math',listing('Math','Math Functions'))
    curr_folder.PBase.Functions._setObject('String',listing('String','String Functions'))

    if flagNumeric==0:
	filepath=[]
    else:
	if OS=='W':
		filepath=[maths.__file__,cmaths.__file__,string.__file__]
	else:
		filepath=[maths.__file__,umaths.__file__,cmaths.__file__,Numeric.__file__,string.__file__]

    for i in filepath:
	if OS!='W':
		if i[0]!='/':
			i='/'+i

        i=string.split(i,".py")[0]+".py"
        l2=listcf(i)
        pyfundict=l2.newfun               # Dictionary of all functions in the .py
        #return '<html><body>'+str(l2.newfun)+'</body></html>'
        for j in range(len(pyfundict)):
                factoryobj.tutfun(curr_folder,i,l2,j,l2.l)
                #return '<html><body>'+'</body></html>'

    filelist=[UserList.__file__,UserDict.__file__,UserString.__file__]
    #return str(filelist)
    for i in filelist:
        sys.path.append(i)
        i=string.split(i,".py")[0]+".py"
        l1=listcf(i)
        pyclass=l1.newcl                # classes within the python file
        #return '<html><body>'+str(pyclass)+'</body></html>'
        for j in range(len(pyclass)):
		curr_folder.PBase.ClassBase._setObject(pyclass[j],ClassType(pyclass[j],pyclass[j],pyclass[j],str(l1.m[j]),str(l1.v[j]),i))

    curr_folder.PBase.Functions.Conditions._setObject('if',conditiontype('if','Condition'))
    curr_folder.PBase.Functions.Conditions._setObject('elif',conditiontype('elif','Condition'))
    curr_folder.PBase.Functions.Conditions._setObject('else',conditiontype('else','Condition'))
    curr_folder.PBase.Functions.Conditions._setObject('endif',conditiontype('endif','EndCondition'))
    curr_folder.PBase.Functions.Conditions._setObject('for',conditiontype('for','Loop'))
    curr_folder.PBase.Functions.Conditions._setObject('endfor',conditiontype('endfor','EndLoop'))
    curr_folder.PBase.Functions.Conditions._setObject('endwhile',conditiontype('endwhile','EndLoop'))
    curr_folder.PBase.Functions.Conditions._setObject('while',conditiontype('while','Loop'))
    curr_folder.PBase._setObject('Custom',tabclass('Custom','This contains customized objects')) # Add class instance folder

    #--------------------------------------------------------------------------------------------------------------------

    idt = self.absolute_url()+'/'+id+'/Data/'
    u = self.absolute_url()+'/'+id+'/Data/ObjectType/'
    u2 = self.absolute_url()+'/'+id+'/Data/Object/'


    curr_folder.Data.OccurrenceTypes._setObject('www',occurrencetype('www','www','World Wide Web','lines','','Occurrence of an Object on the WWW'))
    curr_folder.Data.OccurrenceTypes.www.index_object()

    curr_folder.Data.OccurrenceTypes._setObject('file',occurrencetype('file','file','A file existing on the hard disk','lines','','Occurrence of an Object on the file system'))
    curr_folder.Data.OccurrenceTypes.file.index_object()

    curr_folder.Data.FacetTypes._setObject('Status',facettype('Status','Status','Status','lines','Status','Status','Status',))
    curr_folder.Data.FacetTypes.Status.index_object()

    curr_folder.Data.FacetTypes._setObject('PStatus',facettype('PStatus','PStatus','PStatus','lines','PStatus','PStatus','PStatus'))


#    curr_folder.Data.FacetTypes._setObject('OPTION1',facettype('OPTION1','OPTION1','OPTION1','lines','OPTION1','OPTION1','fq'))


#    curr_folder.Data.FacetTypes._setObject('OPTION2',facettype('OPTION2','OPTION2','OPTION2','lines','OPTION2','OPTION2','fq'))

#    curr_folder.Data.FacetTypes._setObject('OPTION3',facettype('OPTION3','OPTION3','OPTION3','lines','OPTION3','OPTION3','fq'))


#    curr_folder.Data.FacetTypes._setObject('OPTION4',facettype('OPTION4','OPTION4','OPTION4','lines','OPTION4','OPTION4','fq'))

#    curr_folder.Data.FacetTypes._setObject('OPTION5',facettype('OPTION5','OPTION5','OPTION5','lines','OPTION5','OPTION5','fq'))

#    curr_folder.Data.FacetTypes._setObject('CORRECT-ANS',facettype('CORRECT-ANS','CORRECT-ANS','CORRECT-ANS','lines','CORRECT-ANS','CORRECT-ANS','fq'))


#    curr_folder.Data.FacetTypes._setObject('DIFFICULTY-LEVEL',facettype('DIFFICULTY-LEVEL','DIFFICULTY-LEVEL','DIFFICULTY-LEVEL','lines','DIFFICULTY-LEVEL','DIFFICULTY-LEVEL','fq'))


    curr_folder.Data.FacetTypes._setObject('fname',facettype('fname','fname','fanme','lines','fname','fname','fname'))

    curr_folder.Data.FacetTypes._setObject('lname',facettype('lname','lname','lname','lines','lname','lname','lname'))


    curr_folder.Data.FacetTypes._setObject('email',facettype('email','email','email','lines','email','email','email'))

    curr_folder.Data.FacetTypes._setObject('place',facettype('place','place','place','lines','place','place','place'))

    curr_folder.Data.FacetTypes._setObject('phone',facettype('phone','phone','phone','lines','phone','phone','phone'))

    curr_folder.Data.FacetTypes._setObject('profession',facettype('profession','profession','profession','lines','profession','profession','profession'))

    curr_folder.Data.FacetTypes._setObject('expertise',facettype('expertise','expertise','expertise','lines','expertise','expertise','expertise'))

    curr_folder.Data.FacetTypes._setObject('homepage',facettype('homepage','homepage','homepage','lines','homepage','homepage','homepage'))

    curr_folder.Data.FacetTypes._setObject('details',facettype('details','details','details','lines','details','details','details'))


# Following are default AssociationTypes created for ATP

#    curr_folder.Data.AssociationTypes._setObject('Depends_on',AssocT('Depends_on','Depends_on','Depends_on','Depends-on','Depends_on','',['Concepts'],['Concepts'],0,0,1,'Depends_on',0))

# Status is not present for AssociationTypes hence These lines should 
# not be uncommented unless needed
#    curr_folder.Data.AssociationTypes.Depends_on._updateProperty('Status','authobj')

#    curr_folder.Data.AssociationTypes._setObject('is_a_posttest_question_of',AssocT('is_a_posttest_question_of','is_a_posttest_question_of','is_a_posttest_question_of','Are-posttest-questions-of','is_a_posttest_question_of',['Question'],['Concepts'],0,0,2,'is_a_posttest_question_of',0))

#    curr_folder.Data.AssociationTypes.is_a_posttest_question_of._updateProperty('Status','authobj')
#    curr_folder.Data.AssociationTypes._setObject('is_a_pretest_question_of_',AssocT('is_a_pretest_question_of_','is_a_pretest_question_of_','is_a_pretest_question_of_','Are-pretest-questions-of','is_a_pretest_question_of_',['Question'],['Concepts'],0,0,2,'is_a_pretest_question_of_',0))

#    curr_folder.Data.AssociationTypes.is_a_pretest_question_of_._updateProperty('Status','authobj')
    curr_folder.Data.AssociationTypes._setObject('related_to',AssocT('related_to','related_to','related_to','Related_to','related_to','',['Experiments'],['Concepts'],0,0,2,'related_to',0))

#    curr_folder.Data.AssociationTypes.related_to._updateProperty('Status','authobj')

    curr_folder.Data.AssociationTypes._setObject('is_of_DTD_element_type',AssocT('is_of_DTD_element_type','is_of_DTD_element_type','is_of_DTD_element_type','Is_of_DTD_element_type','is_of_DTD_element_type','',['book'],['dtd_book'],0,0,2,'is_of_DTD_element_type',0))

#    curr_folder.Data.AssociationTypes.is_of_DTD_element_type._updateProperty('Status','authobj')

    curr_folder.Data.ObjectType._setObject('SystemObject',ObjectType('SystemObject','SystemObject',idt+'SystemObject','SystemObject','SystemObject','SystemObject',['Object'],['Object'],['SystemObject'],'This is a default ObjectType.'))
#    curr_folder.Data.ObjectType.SystemObject._updateProperty('Status','Private')

    curr_folder.Data.ObjectType._setObject('book',ObjectType('book','book',idt+'book','book','book','book',['Object'],['Object'],['book'],'This is a default ObjectType.'))


#Members is the default ObjectType created for Authentication
    curr_folder.Data.ObjectType._setObject('Members',ObjectType('Members','Members',idt+'Members','Members','Members','Members',['Object'],['Object'],['Members'],'This is a default ObjectType.'))


#Lesson is the default ObjectType created for TMI
#    curr_folder.Data.ObjectType._setObject('Lesson',ObjectType('Lesson','Lesson',idt+'Lesson','Lesson','Lesson','Lesson',['Object'],['Object'],['Lesson'],'This is a default ObjectType.'))



#    curr_folder.Data.ObjectType._setObject('Experiments',ObjectType('Experiments','Experiments',idt+'Experiments','Experiments','Experiments','Experiments',['Object'],['Object'],['Experiments'],'This is a default ObjectType.'))

    curr_folder.Data.ObjectType._setObject('dtd_book',ObjectType('dtd_book','dtd_book',idt+'dtd_book','dtd_book','dtd_book','dtd_book',['Object'],['Object'],['dtd_book'],'This is a default ObjectType.'))


#    curr_folder.Data.ObjectType._setObject('Concepts',ObjectType('Concepts','Concepts',idt+'Concepts','Concepts','Concepts','Concepts',['Object'],['Object'],['Concepts'],'This is a default ObjectType.'))

#    curr_folder.Data.ObjectType._setObject('Question',ObjectType('Question','Question',idt+'Question','Question','Question','Question',['Object'],['Object'],['Question'],'This is a default ObjectType.'))


    
#    curr_folder.Data.ObjectType._setObject('Role',ObjectType('Role','Role',idt+'Role','Role','Role','Role',['Object'],['Object'],['Role'],'This is a default ObjectType.')) 
#    curr_folder.Data.ObjectType.Role._updateProperty('Status','Private') 
    curr_folder.Data.ObjectType._setObject('Theme',ObjectType('Theme','Theme','','Theme','Theme','Theme',['Object'],['Object'],['Theme'],'This is a default ObjectType.')) 
    curr_folder.Data.ObjectType.Theme._updateProperty('Status','Private')


# This is for assigning default FacetTypes to ObjectTypes Members and Question
 
#    curr_folder.Data.ObjectType.Question.manage_addProperty('OPTION1','','string',REQUEST=None)
#    curr_folder.Data.ObjectType.Question.manage_addProperty('OPTION2','','string',REQUEST=None)
#    curr_folder.Data.ObjectType.Question.manage_addProperty('OPTION3','','string',REQUEST=None)
#    curr_folder.Data.ObjectType.Question.manage_addProperty('OPTION4','','string',REQUEST=None)
#    curr_folder.Data.ObjectType.Question.manage_addProperty('OPTION5','','string',REQUEST=None)
#    curr_folder.Data.ObjectType.Question.manage_addProperty('CORRECT-ANS','','string',REQUEST=None)
#    curr_folder.Data.ObjectType.Question.manage_addProperty('DIFFICULTY-LEVEL','','string',REQUEST=None)

    curr_folder.Data.ObjectType.Members.manage_addProperty('fname','','string',REQUEST=None)
    curr_folder.Data.ObjectType.Members.manage_addProperty('lname','','string',REQUEST=None)
    curr_folder.Data.ObjectType.Members.manage_addProperty('email','','string',REQUEST=None)
    curr_folder.Data.ObjectType.Members.manage_addProperty('place','','string',REQUEST=None)
    curr_folder.Data.ObjectType.Members.manage_addProperty('phone','','string',REQUEST=None)
    curr_folder.Data.ObjectType.Members.manage_addProperty('profession','','string',REQUEST=None)
    curr_folder.Data.ObjectType.Members.manage_addProperty('expertise','','string',REQUEST=None)
    curr_folder.Data.ObjectType.Members.manage_addProperty('homepage','','string',REQUEST=None)
    curr_folder.Data.ObjectType.Members.manage_addProperty('details','','string',REQUEST=None)
    
# this for assigning default status authobj to ObjectTypes Question,Members,Experiments and Concepts to hide them from users

#    curr_folder.Data.ObjectType.Question._updateProperty('Status','authobj')
#    curr_folder.Data.ObjectType.Concepts._updateProperty('Status','authobj')
#    curr_folder.Data.ObjectType.Experiments._updateProperty('Status','authobj')
#    curr_folder.Data.ObjectType.Lesson._updateProperty('Status','authobj')

    curr_folder.Data.ObjectType.Members._updateProperty('Status','authobj')
    curr_folder.Data.ObjectType.SystemObject._updateProperty('Status','authobj')
    curr_folder.Data.ObjectType.book._updateProperty('Status','authobj')
    curr_folder.Data.ObjectType.dtd_book._updateProperty('Status','authobj')

    curr_folder.Data.Objects._setObject('Default',Object('Default','Default Object','','Default Object','Default Object','',['SystemObject'],'','This Object is requred by the system please do not delete or add any data to this Object.',[]))
    curr_folder.Data.Objects.Default._updateProperty('Status','Private')

    curr_folder.Data.Objects._setObject('chapter',Object('chapter','chapter','','chapter','chapter','',['dtd_book'],'','This Object is requred by the system please do not delete or add any data to this Object.',[]))
    curr_folder.Data.Objects.chapter._updateProperty('Status','authobj')

    curr_folder.Data.Objects._setObject('section',Object('section','section','','section','section','',['dtd_book'],'','This Object is requred by the system please do not delete or add any data to this Object.',[]))
    curr_folder.Data.Objects.section._updateProperty('Status','authobj')

    curr_folder.Data.Objects._setObject('subsection',Object('subsection','subsection','','subsection','subsection','',['dtd_book'],'','This Object is requred by the system please do not delete or add any data to this Object.',[]))
    curr_folder.Data.Objects.subsection._updateProperty('Status','authobj')

    curr_folder.Data.Objects._setObject('subsubsection',Object('subsubsection','subsubsection','','subsubsection','subsubsection','',['dtd_book'],'','This Object is requred by the system please do not delete or add any data to this Object.',[]))
    curr_folder.Data.Objects.subsubsection._updateProperty('Status','authobj')

    # for adding a Transparent Folder

    manage_addTransparentFolder(curr_folder,'Programs','Programs')
    curr_folder.manage_addUserFolder()    
    ex = curr_folder    
    curr_folder = curr_folder.Programs

    # for adding ZCatalog with apropriate Indexes and Metadata
    
    ex.manage_addProduct['ZCatalog'].manage_addZCatalog(id='Catalog',title='Catalog for the Product')

    zopeVersion = self.REQUEST['SERVER_SOFTWARE']
    zopeVersion = string.split(zopeVersion,'(').pop(1)

    if string.find(zopeVersion,'Zope 2.5') >= 0:
       ex.Catalog.manage_delIndex('id','FieldIndex')
       ex.Catalog.manage_delIndex('title','FieldIndex')
       ex.Catalog.manage_delIndex('meta_type','FieldIndex')
       ex.Catalog.manage_delIndex('bobobase_modification_time','FieldIndex')
       ex.Catalog.manage_delIndex('PrincipiaSearchSource','FieldIndex')
       ex.Catalog.manage_delColumn('id')
       ex.Catalog.manage_delColumn('title') 
       ex.Catalog.manage_delColumn('meta_type')
       ex.Catalog.manage_delColumn('bobobase_modification_time')
       ex.Catalog.manage_delColumn('summary')

    ex.Catalog.manage_addIndex('BaseName','TextIndex')
    ex.Catalog.manage_addIndex('BaseNameA','TextIndex')
    ex.Catalog.manage_addIndex('TTList','TextIndex')
    ex.Catalog.manage_addIndex('DisplayName','TextIndex')
    ex.Catalog.manage_addIndex('SortName','TextIndex')
    ex.Catalog.manage_addIndex('ObjectTypes','TextIndex')
    ex.Catalog.manage_addIndex('AssociationType','TextIndex')
    ex.Catalog.manage_addIndex('FacetValue','TextIndex')
    ex.Catalog.manage_addIndex('Occurences','TextIndex')
    ex.Catalog.manage_addIndex('Scope','TextIndex')
    ex.Catalog.manage_addIndex('meta_type','TextIndex')
    ex.Catalog.manage_addIndex('id', 'TextIndex')
    ex.Catalog.manage_addIndex('Transitive', 'TextIndex')
    ex.Catalog.manage_addIndex('Symmetric', 'TextIndex')
    ex.Catalog.manage_addIndex('Constraint', 'TextIndex')
    ex.Catalog.manage_addIndex('LObjects', 'TextIndex')    
    ex.Catalog.manage_addIndex('RObjects', 'TextIndex')
    ex.Catalog.manage_addIndex('LRoles', 'TextIndex')    
    ex.Catalog.manage_addIndex('RRoles', 'TextIndex')

    ex.Catalog.manage_addColumn('BaseName')
    ex.Catalog.manage_addColumn('BaseNameA')
    ex.Catalog.manage_addColumn('Identity') 
    ex.Catalog.manage_addColumn('DisplayName') 
    ex.Catalog.manage_addColumn('SortName')
    ex.Catalog.manage_addColumn('ObjectTypes')
    ex.Catalog.manage_addColumn('Description') 
    ex.Catalog.manage_addColumn('LRoles') 
    ex.Catalog.manage_addColumn('AssociationType') 
    ex.Catalog.manage_addColumn('RRoles') 
    ex.Catalog.manage_addColumn('Scope')
    ex.Catalog.manage_addColumn('meta_type')
    ex.Catalog.manage_addColumn('id')
    ex.Catalog.manage_addColumn('TTList')
    ex.Catalog.manage_addColumn('Transitive')
    ex.Catalog.manage_addColumn('Symmetric')
    ex.Catalog.manage_addColumn('Constraint')
    ex.Catalog.manage_addColumn('LObjects')
    ex.Catalog.manage_addColumn('RObjects') 
 
    #end of ZCatalog
    
    #add a mailhost
    ex.manage_addProduct['MailHost'].manage_addMailHost(id='mailhost',title='Mail Host',smtp_host=REQUEST['SMTP_Host'],localhost='localhost',smtp_port=REQUEST['Port'],timeout=1.0,REQUEST=None) 

    #cloning all files from CF folder to the newinstance.
    #This method checks if the file is a DTML or a PythonScript and calls the
    #appropriate clone functions.

    #This is needed for Import and Export in XTM 
    manage_addExternalMethod(curr_folder,'import','Import-Export method','GNOWSYS.import','importTest',REQUEST)

    #This is needed for Graphical Representation Module
    manage_addExternalMethod(curr_folder,'addimg','Add PNG','GNOWSYS.membership_tree','addPng',REQUEST)
    manage_addExternalMethod(curr_folder,'addeps','Add EPS','GNOWSYS.membership_tree','addeps',REQUEST)
    manage_addExternalMethod(curr_folder,'addmp','Add MP','GNOWSYS.membership_tree','addmp',REQUEST)
    manage_addExternalMethod(curr_folder,'membershiptree','Membership Tree','GNOWSYS.membership_tree','addnewmp',REQUEST)
    manage_addExternalMethod(curr_folder,'multiassoctree','Association Tree','GNOWSYS.multi_assoc','addnewmp',REQUEST)
    curr_folder.manage_addFolder('createdImages', 'Created Images')

    #for adding Ext Methods for ATP
    manage_addExternalMethod(curr_folder,'Apub_mkext','','GNOWSYS.new','readfile',REQUEST)
    manage_addExternalMethod(curr_folder,'Apub_ext1','','GNOWSYS.new','ftex',REQUEST)
    manage_addExternalMethod(curr_folder,'Apub_exttex','','GNOWSYS.new','filetex',REQUEST)
    manage_addExternalMethod(curr_folder,'Apub_extpdf','','GNOWSYS.new','file',REQUEST)



    tdir = Globals.package_home(globals())
    tdir = tdir + '/CF'
    t = os.listdir(tdir)
    for temp in t:
	tp = os.path.splitext(os.path.basename(temp))
        fp = os.path.join('CF',tp[0])
	if tp[1] == '.dtml':
		addDTML(curr_folder,tp[0],"Method",fp)
                
	if tp[1] == '.py':
		addPythonScript(curr_folder,tp[0],fp) 
    
    curr_folder.dtmlholder.manage_addProperty('list',[],'tokens') 
    curr_folder.dtmlholder.manage_addProperty('list2',['Take a Pre-test','View Concept Details','Pre-requisite Concepts','View Experiments','Take a Post-test'],'lines')
    return self.manage_main(self,REQUEST,update_menu=1)

def get_attr(base_obj,curr_obj,err):
    try:
        curr_folder = getattr(base_obj,curr_obj)
    except:
        return err
    return curr_folder

def addPythonScript(obj,id,file):
    f=open(file_path+'/'+file+'.py')     
    file=f.read()     
    f.close()     
    manage_addPythonScript(obj,id)
    obj._getOb(id).write(file)
    return getattr(obj,id)


def addDTML(obj,id,title,file):     
    f=open(file_path+'/'+file+'.dtml')     
    file=f.read()     
    f.close()     
    obj.manage_addDTMLMethod(id,title,file)     
    return getattr(obj,id)     
     
def addImage(obj,id,file):
    f=open(file_path+'/'+file,'rb')
    contents=f.read()
    f.close()
    title=''
    tlen = len(contents)
    new_id = obj.manage_addImage(id,contents,title=title)
    img_obj = obj.__getitem__(new_id)
    img_obj.content_type = 'image/gif'

def addZCatalog(obj,id,file):
    f=open(file_path+'/'+file)
    file=f.read()
    f.close()
    manage_addZCatalog(obj,id)
    obj._getOb(id).write(file)
    return getattr(obj,id)

confirm=DTMLFile('CF/confirm',globals())
callinterfun=DTMLFile('pdtml/callinterfun',globals())
enterpath = DTMLFile('pdtml/enterpath',globals()) # Used to view content of the object

InitializeClass(GNOWSYS)
