#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

import string
import os
from OFS import SimpleItem
import random
from GNOWSYS import *

class Class(PropertyManager,SimpleItem):
        """adding a class instance"""
	meta_type ='Class'


        _properties= (
                {'id':'id', 'type':'string', 'mode':'r'},
                {'id':'title', 'type':'string', 'mode':'r'},
                {'id':'module','type':'string','mode':'r'},
                {'id':'classname','type':'string','mode':'r'},
                {'id':'methods','type':'string','mode':'r'},
                )

        __ac_permissions__=(
        ('Manage Properties',('manage_addProperty',
                              'manage_editProperties',
                              'manage_delProperties',
                              'manage_changeProperties',
                              'Access content information')),
#         ('Delete Objects',('manage_delObjects)),
         )

        manage_options =(
                {'label': 'Properties', 'action': 'manage_propertiesForm'},
                {'label': 'View', 'action': 'classinterface'},
               	)
		
	def __init__(self,id,title,clname,methods,linenos,path,initarg):
		"""Initialises class instance"""
		self.id=id
		self.title=title
		self.module=string.split(os.path.basename(path),'.',1)[0]
		self.classname=clname
		self.methods=methods	
		self.filepath=path
		self.initarg=initarg
		evalst=compile('from '+self.module+' import *','','single')
    		exec evalst
    		evalst1=compile('doc='+self.classname+'.__doc__','','single')
    		exec evalst1
    		if doc==None:
			doc=''
		if self.module=="UserList":
			meta_type="UserList"
		elif self.module=="UserDict":
			meta_type="UserDict"
		elif self.module=="UserString":
			meta_type="UserString"
		else:
			meta_type=self.module
	
		self.manage_addProperty('documentation',doc,'lines')
		self.manage_addProperty('InstanceValue','','string')
		self.manage_addProperty('Result','','string')
		st="from "+self.module+" import *"
		evalst=compile(st,'','single') #Importing the module
   		exec evalst
		evalst1=compile('self.a='+self.classname+'('+self.initarg+')','','single')
		exec evalst1
		self._updateProperty('InstanceValue',str(self.a))
		
		l=string.replace(methods,'[','')
		l=string.replace(l,']','')
		l=string.replace(l,"'","")
		self.methlist=[]
		mlist=string.split(l,',',-1)
		for i in mlist:
			self.methlist.append(string.replace(i,' ',''))
		l1=string.replace(linenos,'[','')
		l1=string.replace(l1,']','')
		l1=string.replace(l1,"'","")
		self.linenos=string.split(l1,',',-1)
			
	def __call__(self,*args):
		val=self.getProperty('InstanceValue') 
		if self.getProperty('classname')=='UserList':
			lis=[]
			l1=string.split(val,'[',1)[1]
			i=len(l1)
			st=l1[0:i-1]
			for a in string.split(st,',',len(string.split(st,','))):
				lis.append(a)
			return lis
				
		elif self.getProperty('classname')=='UserDict':
			lis={}
	                l=string.split(val,'{',1)[1]
                        li=len(l)
			lf=l[0:li-1]
			lf=string.replace(lf,"]","]|")
			lf=string.replace(lf,"'","")
			lf=string.replace(lf,' ','')
			if string.find(lf,'[')!=-1:
				for a in string.split(lf,'|,',len(string.split(lf,'|,'))):
                                	string.replace(a,"'",'')
                                	string.replace(a,'"','')
					kv=string.split(a,':',1)
					k=kv[0]
					v=kv[1]
					newl=[]
					for i in string.split(v,',',-1):
						i=string.replace(i,'[','')
						i=string.replace(i,']','')
						i=string.replace(i,'|','')
						i=string.replace(i,'}','')
						newl.append(i)
                                	lis[k]=newl
			else:
				for a in string.split(lf,',',len(string.split(lf,','))):
                                	string.replace(a,"'",'')
                                	string.replace(a,'"','')
					kv=string.split(a,':',1)
					k=kv[0]
					v=kv[1]
                                	lis[k]=v
			return lis
		else:
			return val

	def parsearg(self,REQUEST,RESPONSE=None):	#Parses the "def" line of the function selected
		"""Parses the defline"""
		if 'funcsel' in REQUEST.form.keys():
		    	self.funcname=REQUEST['funcsel']
		if self.funcname in self.methlist:
			ind=self.methlist.index(self.funcname)
		fl=self.linenos[ind]
		fp=open(self.filepath)
		for i in range(int(fl)):
			fread=fp.readline()
		df=string.replace(fread,' ','')
		df=string.split(df,')',1)[0]
		self.defline=string.split(df,'(',1)[1]
		REQUEST.set('funcname',self.funcname)
		REQUEST.set('defline',self.defline)
		RESPONSE.redirect('classfuninput?funcname=%s&defline=%s'%(self.funcname,self.defline))

	
	def callclfun(self,REQUEST,RESPONSE=None):
		"execute functions"
		n=[]
       		m=[]
		phyurl=self.getPhysicalPath()[1]   #Get the product instance id
		proplist=[]
		s=self.propertyIds()
        	classname=self.getProperty('class')
		n1=[]
        	sc=""
		tp={}
       		temp=[]
		if 'initarg' in REQUEST.form.keys():
			temp.append(REQUEST['initarg'])
			self._updateProperty('InstanceValue','')
			self._updateProperty('Result','')
			self.funcname='__init__'
		else:
			for i in string.split(self.defline,',',-1):
				if i!='self': 
					temp.append(REQUEST.form[i])
		for i in range(len(temp)):
                	c=temp[i].count('[')    #Checking if passed values r in a list
                	if c>0:
                        	rt=string.replace(temp[i],"[","")
                        	rtt=string.replace(rt,"]","")
				if string.find(rtt,', ')!=-1:
					rtt=string.replace(rtt,', ',',')
                        	liarg=string.split(rtt,",",-1)
	                       	for k in liarg:         #Checking for args datatype.
                                	if k.isdigit():	#extra
                                        	n.append(int(k))	#extra
                                	elif (re.search('^-[0-9]*[0-9]',k)!=None or re.search('^[0-9]*[0-9]',k)!=None):
                                        	if re.search('[a-z]|[A-Z]',k)!=None:
							n.append(str(k))
						elif string.find(k,'.')!=-1:
                                                	n.append(float(k))
                                        	else:
                                                	n.append(int(k))
                               		elif k=="" or k=='None':
    	                           		n.append(None)
                                	elif k.endswith("'"):
                                        	n.append(string.replace(k,"'",""))
                                	else:
                                        	n.append(str(k))

                        	m.append(n)
                        	n=[]
                	else:           #Args which are not in a list
                        	if temp[i].isdigit():
                                	m.append(int(temp[i]))
                        	elif (re.search('^-[0-9]*[0-9]',temp[i])!=None or re.search('^[0-9]*[0-9]',temp[i])!=None):   
                             		if re.search('[a-z]|[A-Z]',temp[i])!=None:
						m.append(str(temp[i]))
					elif string.find(temp[i],'.')!=-1:
                                		#if string.find(temp[i],'.')!=-1:
                                        	m.append(float(temp[i]))
                                	else:
                                        	m.append(int(temp[i]))
                        	elif temp[i].isspace():
                                	m.append(' ')
                        	elif temp[i].endswith("'"):
                                	m.append(string.replace(temp[i],"'",""))
                       		elif temp[i]=='None' or temp[i]=="":
                                	m.append(None)
                       		else :
                                	m.append(str(temp[i]))
		args=tuple(m)           #Converting to tuple for passing args in Apply func

        	#For execution of the function selected
		#os.chdir(self.dbname)
		st="from "+self.module+" import *"
		evalst=compile(st,'','single') 	#Importing the module
   		exec evalst
		name='self.a.'+self.funcname
		par=str(args)
		if par=='(None,)':
			par=''
        	evalfun=compile('res=apply('+name+','+par+')','','single')  #Calling func with args
	        exec evalfun
		self._updateProperty('InstanceValue',str(self.a))
		self._updateProperty('Result',res)
		RESPONSE.redirect('classfunresult')

	def DelClass(self,REQUEST,RESPONSE=None):	#Deletes the particular class
                """Delete the class object"""
                delid=REQUEST.form['id']
                self.PBase.ClassObjects.manage_delObjects(delid)
		nm="ClassObject"
                REQUEST.set('newnm',nm)
                REQUEST.set('newid',delid)
                REQUEST.RESPONSE.redirect(REQUEST['URL2']+'/replydelete?newid=%s&newnm=%s' % (delid,nm))
		
	classinterface=DTMLFile('pdtml/classinterface',globals())	#Displays all the functions within the class type
	classfuninput=DTMLFile('pdtml/classfuninput',globals())		#Input page for selected function
	classfunresult=DTMLFile('pdtml/classfunresult',globals())	#Result page for selected function

def manage_Class(dispatcher,id,title,methods,linenos,path,initarg,REQUEST=None):	#Constructor
    """constructor-add a class instance to a folder."""
    idt=dispatcher.absolute_url()
    phyurl=dispatcher.getPhysicalPath()[1]
    phypath=phyurl+'/PBase/ClassObjects'
    obj=dispatcher.restrictedTraverse(phypath)
    obj._setObject(id,Class(id,title,title,methods,linenos,path,initarg))
    REQUEST.set('newname',id) 	
    if REQUEST is not None:   
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
	vname='Class'
	REQUEST.set('newid',vname)
	REQUEST.RESPONSE.redirect(url+'/confirm?newname=%s&newid=%s' % (id,vname))

InitializeClass(Class)
