// -*- c++ -*-

//  Gnomoradio - gnomoradio/playlist-store.h
//  Copyright (C) 2003  Jim Garrison, Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __PLAYLIST_STORE_H
#define __PLAYLIST_STORE_H

#include <gtkmm.h>
#include "song-rater.h"
#include "wraporadio/wraporadio.h"

namespace Gnomoradio
{
	/* internal representation of a play list. this should update itself
	 * when its child SongList is changed, and changes in this should
	 * be reflected in the SongList.  These are typically created by
	 * the global PlaylistChooserStore and viewed with PlaylistView
	 */

	class PlaylistStore : public sigc::trackable
	{
	public:
		static PlaylistStore *lookup (const Wraporadio::SongList &songlist);

		Glib::RefPtr<Gtk::ListStore> store;

		Gtk::TreeModelColumn<Wraporadio::SongList::iterator> data_col;
		Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > status_col;
		Gtk::TreeModelColumn<Glib::ustring> title_col;
		Gtk::TreeModelColumn<Glib::ustring> artist_col;
		Gtk::TreeModelColumn<Glib::ustring> album_col;

		Wraporadio::SongList get_song_list () const { return sl; }

		Gtk::TreeIter find_row_from_data (Wraporadio::SongList::iterator pos);

	protected:
		PlaylistStore (const Wraporadio::SongList &songlist);

	private:
		Wraporadio::SongList sl;
		Wraporadio::SongList::iterator current_song;
		void fill_row_info (const Gtk::TreeIter &iter,
			       const Wraporadio::SongList::iterator &el);
		Glib::RefPtr<Gdk::Pixbuf> determine_status_icon (const Wraporadio::SongList::iterator &el);
		void update_list ();
		void update_active_song ();

		void on_song_removed (Wraporadio::SongList::iterator pos);
		void on_song_inserted (Wraporadio::SongList::iterator pos);
		void on_song_moved (Wraporadio::SongList::iterator pos);
		void on_song_info_changed (Wraporadio::SongList::iterator pos);
		void on_song_import_progress (Wraporadio::SongList::iterator pos,
					      unsigned int progress);

		void on_song_list_destroyed ();

		static bool initialized;
		static Glib::RefPtr<Gdk::Pixbuf> icon_playing;
		static Glib::RefPtr<Gdk::Pixbuf> icon_not_available, icon_available;
		static Glib::RefPtr<Gdk::Pixbuf> icon_downloading, icon_ready;
		static Glib::RefPtr<Gdk::Pixbuf> icon_cc_playing;
		static Glib::RefPtr<Gdk::Pixbuf> icon_cc_available;
		static Glib::RefPtr<Gdk::Pixbuf> icon_cc_downloading, icon_cc_ready;
		static Glib::RefPtr<Gdk::Pixbuf> icon_beaker_empty, icon_beaker_full;
	};
}

#endif
