// -*- c++ -*-

//  Gnomoradio - roboradio/player.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_PLAYER_H
#define __ROBORADIO_PLAYER_H

#include <sigc++/sigc++.h>
#include "roboradio/song-list.h"

namespace Roboradio
{
	class Player : public SigC::Object
	{
	public:
		void play (const ref_ptr<SongList> &list,
			   SongList::iterator song);
		void play (const ref_ptr<SongList> &list);
		void stop ();

		void prev ();
		void next ();

		SongRef get_song () const { if (&*current_song_list && &*current_song_list->get_current_song()) return *current_song_list->get_current_song(); else return SongRef(); }
		ref_ptr<SongList> get_song_list () const { return current_song_list; }

		void pause ();
		bool get_paused ();

		Time get_position ();
		void seek (Time pos);

		SigC::Signal0<void> signal_state_changed;
		SigC::Signal0<void> signal_song_changed;

	private:
		ref_ptr<SongList> current_song_list;
		SigC::Connection current_song_list_done_connection;
		SigC::Connection current_song_list_shuffle_connection;
		SigC::Connection current_song_list_changed_connection;

		void done ();
		void on_shuffle_changed (bool s, ref_ptr<SongList> sl);
	};
}

#endif
