// -*- c++ -*-

//  Gnomoradio - rainbow/alarm.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __RAINBOW_ALARM_H
#define __RAINBOW_ALARM_H

#include <sigc++/sigc++.h>
#include <ctime>

namespace Rainbow
{
	class Alarm : public SigC::Object
	{
	public:
		Alarm ();
		Alarm (std::time_t set_time);
		~Alarm ();

		void set (std::time_t set_time);
		void set_relative (unsigned int rel)
			{ set(rel + time(0)); }
		void reset ()
			{ t = 0; }

		SigC::Signal0<void> &signal_alarm () { return signal; }

	private:
		bool timeout_handler ();

		SigC::Signal0<void> signal;
		time_t t;
	};
}

#endif
