// -*- c++ -*-

//  Gnomoradio - gnomoradio/song-rater.h
//  Copyright (C) 2003  Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __SONG_RATER_H
#define __SONG_RATER_H

#include <gtkmm.h>

namespace Gnomoradio
{
	/* This class is for the SongRater widget for use in *
	 * the SongInfoBox and to set rating in schedule     */
	class SongRater : public Gtk::HBox
	{
	public:
		/* rating widget that can be changed */
		SongRater (int value, int lower, int upper)
;
		/* simply displays a value */
		SongRater (int value);
		virtual ~SongRater ();

		/* signal is emitted when value is changed and widget has been updated */
		SigC::Signal0<void> signal_value_changed;

		void set_value (int new_value) { adj.set_value(new_value); }
		int get_value  ()              { return (int) adj.get_value(); }

	protected:
		std::vector<Gtk::Image *> images;
		std::vector<Gtk::EventBox *> event_boxes;

		Gtk::Button plus, minus;

		void update_rater ();

		void on_plus_clicked ();
		void on_minus_clicked ();
		bool on_image_clicked (GdkEventButton* event, int image_number);
		void on_adj_value_changed ();

		static Glib::RefPtr<Gdk::Pixbuf> good_pixbuf, bad_pixbuf, blank_pixbuf, neutral_pixbuf, empty_pixbuf;
		static bool initialized;

	private:
		/* internal GtkAdjustment */
		Gtk::Adjustment adj;

		/* is widget in compact mode? */
		bool compact;
	};
}

#endif
