// -*- c++ -*-

//  Gnomoradio - gnomoradio/player-controls.h
//  Copyright (C) 2003  Jim Garrison, Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __PLAYER_CONTROLS
#define __PLAYER_CONTROLS

#include <gtkmm.h>
#include <string>
#include "wraporadio/wraporadio.h"
#include "playlist-view.h"

namespace Gnomoradio
{
	class MainWindow;

	/* this class shows the player controls (stop, next, etc.)
	 * it must be associated with a PlaylistView because it will
	 * operate on the currently viewed playlist
	 */
	class PlayerControls : public Gtk::HBox
	{
	public:
		PlayerControls (Wraporadio::Init *wrap, PlaylistView *pl_view, MainWindow *main_win);
	protected:
		void on_prev_clicked ();
		void on_state_clicked ();
		void on_next_clicked ();

		void on_song_changed ();
		void on_state_changed ();
		void on_viewed_playlist_changed (Wraporadio::SongList list);

		bool on_button_press_event (GdkEventButton *event);
		
		void on_song_position_changed (Wraporadio::Time pos);
		bool on_position_click_event (GdkEventButton *event);
		// Causes timer to reflect changes to position value as
		// user makes changes
		void sync_timer_to_position_change ();

		Glib::ustring format_time (Wraporadio::Time pos);

		Wraporadio::Init *wr;
		PlaylistView *view;
		MainWindow *mw;

		Gtk::Image play_img, stop_img, pause_img, next_img, prev_img;

		Gtk::Button prev, state, next;
		Gtk::HScale position;
		Gtk::Label timer, song_info; 
		
		bool user_changing_position;

		SigC::Connection song_position_changed_connection, position_timer_connection;
	};
}

#endif
