// -*- c++ -*-

//  Gnomoradio - gnomoradio/criteria-creator.cc
//  Copyright (C) 2004  Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <libintl.h>
#include <iostream>
#include "criteria-creator.h"

#define _(String) gettext (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

using namespace std;
using namespace Gtk;
using namespace Wraporadio;

Gnomoradio::CriteriaCreator::CriteriaCreator ()
	: add_button(_("Add Criteria")),
	  boolean_and(_("all")),
	  boolean_or(_("any"))
{
	s_window.set_policy(POLICY_NEVER, POLICY_AUTOMATIC);

	s_window.add(vbox);

	boolean_type_menu.append(boolean_and);
	boolean_type_menu.append(boolean_or);
	boolean_type.set_menu(boolean_type_menu);
	boolean_type.set_sensitive(false);

	HBox *boolean_type_box = manage(new HBox);
	boolean_type_box->pack_start(*manage(new Label(_("Require "))), PACK_SHRINK);
	boolean_type_box->pack_start(boolean_type, PACK_SHRINK);
	boolean_type_box->pack_start(*manage(new Label(_(" of the following:"))), PACK_SHRINK);

	pack_start(*boolean_type_box, PACK_SHRINK, 4);
	pack_start(add_button, PACK_SHRINK);
	pack_start(s_window);

	xmlpp::Element *el = 0; // C++ sucks my asshole
	add_button.signal_clicked().connect(bind(SigC::slot(*this, &Gnomoradio::CriteriaCreator::add_new_input), el));
}

Gnomoradio::CriteriaCreator::~CriteriaCreator ()
{
	for (list<CriteriaInput*>::iterator i = inputs.begin(); i != inputs.end(); ++i)
		delete *i;
}

Glib::ustring Gnomoradio::CriteriaCreator::get_criterion ()
{
	Glib::ustring crit;

	if (inputs.size() == 1)
		crit = inputs.front()->get_criteria();
	else {
		xmlpp::Document query;
		xmlpp::Element *boolean_element = query.create_root_node("boolean");
		boolean_element->set_attribute("type", (boolean_type_menu.get_active() == &boolean_and) ? "and" : "or");
		
		for (list<CriteriaInput *>::iterator i = inputs.begin(); i != inputs.end(); ++i)
			(*i)->add_criteria(boolean_element);

		crit = query.write_to_string();
	}

	return crit;
}

void Gnomoradio::CriteriaCreator::set_criterion (Glib::ustring criterion)
{
	xmlpp::DomParser tree;

	tree.parse_memory(criterion);
	
	xmlpp::Node *root = tree.get_document()->get_root_node();

	if (root->get_name() != "boolean") { //one input
		add_new_input(dynamic_cast<xmlpp::Element*>(root));
	} else {
		xmlpp::Attribute *t = dynamic_cast<xmlpp::Element*>(root)->get_attribute("type");
		if (t)
			boolean_type.set_history((t->get_value() == "and") ? 0 : 1);

		xmlpp::Node::NodeList crits = root->get_children();

		for (xmlpp::Node::NodeList::iterator i = crits.begin(); i != crits.end(); ++i) {
			xmlpp::Element *el = dynamic_cast<xmlpp::Element*>(*i);
			if (el)
				add_new_input(el);
		}
	}
}

void Gnomoradio::CriteriaCreator::add_new_input (xmlpp::Element *element)
{
	inputs.push_back(new CriteriaInput);

	if (element) {
		inputs.back()->set_criteria(element);
	}

	inputs.back()->signal_remove_clicked.connect(SigC::bind(SigC::slot(*this, &Gnomoradio::CriteriaCreator::remove_input), inputs.back()));
	inputs.back()->signal_changed.connect(SigC::slot(*this, &Gnomoradio::CriteriaCreator::emit_changed_signal));
	vbox.pack_start(*inputs.back(), PACK_SHRINK, 3);

	signal_changed.emit();

	inputs.back()->show();

	if (inputs.size() == 2)
		boolean_type.set_sensitive(true);
}

void Gnomoradio::CriteriaCreator::remove_input (CriteriaInput *input)
{
	input->hide();
	inputs.remove(input);

	signal_changed.emit();

	if (inputs.size() == 0)
		signal_no_more_inputs.emit();

	if (inputs.size() == 1)
		boolean_type.set_sensitive(false);
}
