# -*- coding: utf-8 -*-

#    This file is part of Gnomolicious.
#
#    Gnomolicious is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    Gnomolicious is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Gnomolicious; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    (C) 2006 Nicolas Évrard <nicoe@nutellux.be>

__revision__ = "$Id: dbusapi.py,v 1.4 2006/03/22 23:25:53 nicoe Exp $"

import logging
import dbus
import dbus.service

import delicious

if getattr(dbus, 'version', (0,0,0)) >= (0,41,0):
    import dbus.glib

session_bus = dbus.SessionBus()
bus_name = dbus.service.BusName('org.gnome.gnomolicious', bus=session_bus)
logger = logging.getLogger('gnomolicious')


class GnomoliciousDBusService(dbus.service.Object):

    def __init__(self, gnomolicious):
        self.gnomolicious = gnomolicious
        super(GnomoliciousDBusService, self).__init__(bus_name,
                                                      '/org/gnome/Gnomolicious')

    @dbus.service.method('org.gnome.GetUrlsIFace')
    def getUrls(self, tags):
        logger.info('Searching for "%s" through dbus' % tags)
        self.gnomolicious.delicious_user._get_all_posts()
        tagset = [delicious.Tag(tag) for tag in tags.split()]
        hrefs = tagset[0].hrefs
        for tag in (t for t in tagset[1:] if t.hrefs):
            hrefs = hrefs & tag.hrefs
        if not hrefs:
            logger.info('No results found')
            return False
        else:
            logger.info('Returning %d result(s)' % len(hrefs))
            return [[webpage.url, webpage.description] for webpage in hrefs]

