import cgi
import logging
from gettext import gettext as _

import dbus
import gnomevfs
import deskbar
import deskbar.Handler
from deskbar.BrowserMatch import BrowserMatch

HANDLERS = {"DeliciousHandler" : 
            {'name' : _('del.icio.us Bookmarks'),
             'description' : _('Search your del.icio.us account'),}}
IMAGE_FILE = '/usr/local/share/gnomolicious/gnomolicious.png'
QUERY_DELAY = 1

def init_logger():
    logger = logging.getLogger('deskbar-gnomolicious')
    hdlr = logging.FileHandler('/tmp/deskbar.log')
    formatter = logging.Formatter('%(name)s:%(filename)s:%(lineno)d: %(message)s')
    hdlr.setFormatter(formatter)
    logger.addHandler(hdlr)
    logger.setLevel(logging.DEBUG)

class DeliciousMatch(BrowserMatch):
	def __init__(self, handler, title, url, icon):
		BrowserMatch.__init__(self, handler, title, url, icon)

	def get_verb(self):
		return "%(name)s"

class DeliciousHandler(deskbar.Handler.AsyncHandler):

    def __init__(self):
        init_logger()
        self.log = logging.getLogger('deskbar-gnomolicious')
        self.log.info('Starting DeliciousHandler')
        super(DeliciousHandler,
              self).__init__('/usr/local/share/gnomolicious/gnomolicious.png')
        self.server = None

    def initialize(self):
        self.log.info('Initializing the dbus interface')
        bus = dbus.SessionBus()
        proxy = bus.get_object('org.gnome.gnomolicious',
                               '/org/gnome/Gnomolicious')
        self.dbus = dbus.Interface(proxy, 'org.gnome.GetUrlsIFace')
        self.log.debug('Initialized the dbus interface')

    def query(self, qstring):
        qmax = deskbar.DEFAULT_RESULTS_PER_HANDLER
        self.check_query_changed(timeout=QUERY_DELAY)
        self.log.info('Querying dbus api for: %s' % qstring)
        urls = self.dbus.getUrls(qstring)
        self.log.info('Received: %s' % urls)
        self.check_query_changed()
        if urls:
            return [DeliciousMatch(self, cgi.escape(x[1]), x[0], IMAGE_FILE)
                    for x in urls[:qmax-1]]
        else:
            return []
