import logging
from gettext import gettext as _

import dbus
import gnomevfs
import deskbar, deskbar.indexer, deskbar.locale_utils, deskbar.handler_utils
import deskbar.handler

HANDLERS = {"DeliciousHandler" : 
            {'name' : _('del.icio.us Bookmarks'),
             'description' : _('Search your del.icio.us account'),}}

def init_logger():
    logger = logging.getLogger('deskbar-gnomolicious')
    hdlr = logging.FileHandler('/tmp/deskbar.log')
    formatter = logging.Formatter('%(name)s:%(filename)s:%(lineno)d: %(message)s')
    hdlr.setFormatter(formatter)
    logger.addHandler(hdlr)
    logger.setLevel(logging.DEBUG)

class DeliciousMatch(deskbar.handler.Match):

    def __init__(self, backend, url, description):
        self.url = url
        self.description = description
        deskbar.handler.Match.__init__(self, backend, url)

    def action(self, text=None):
        gnomevfs.url_show(self.url)

    def get_verb(self):
        return _('Open <b>%s</b>' % self.description)


class DeliciousHandler(deskbar.handler.AsyncHandler):

    def __init__(self):
        init_logger()
        self.log = logging.getLogger('deskbar-gnomolicious')
        self.log.info('Starting DeliciousHandler')
        super(DeliciousHandler,
              self).__init__('/usr/local/share/gnomolicious/gnomolicious.png')

    def initialize(self):
        self.log.info('Initializing the dbus interface')
        bus = dbus.SessionBus()
        proxy = bus.get_object('org.gnome.gnomolicious',
                               '/org/gnome/Gnomolicious')
        self.dbus = dbus.Interface(proxy, 'org.gnome.GetUrlsIFace')
        self.log.debug('Initialized the dbus interface')

    def query(self, qstring, qmax=5):
        self.log.info('Querying dbus api for: %s' % qstring)
        urls = self.dbus.getUrls(qstring)
        self.log.info('Received: %s' % urls)
        self.check_query_changed()
        if urls:
            return [DeliciousMatch(self, *x) for x in urls[:qmax-1]]
        else:
            return []
