#!/usr/bin/env python
# -*- coding: utf-8 -*-
# setup from gnomolicious
#   taken from straw http://www.nongnu.org/straw/index.html
#   adapted by Nicolas Évrard <nicoe@nutellux.be>

import imp
import sys
import os
import glob

from tools.gnome_distutils import setup
try:
    from dsextras import TemplateExtension, getoutput, GLOBAL_MACROS
except ImportError:
    try:
        from gtk.dsextras import TemplateExtension, getoutput, GLOBAL_MACROS
    except ImportError:
        sys.exit('Error: Can not find dsextras or gtk.dsextras')

name = 'gnomolicious'
version = '0.6.1'

def modules_check():
    '''Check if necessary modules is installed.
    The function is executed by distutils (by the install command).'''
    try:
        import pygtk
        pygtk.require('2.0')
        imp.find_module('gtk')
    except AssertionError:
        sys.exit('Error: pygtk > 2.0 is required')
    except ImportError:
        sys.exit('Error: pygtk is required')
    except:
        sys.exit('Error: Unknown error')
        raise

    mod_list = [
        ('gnome', 'gnome', 0),
        ('gconf', "gconf", 0)]

    ok = 1
    for m, w, x in mod_list:
        try:
            if not x:
                exec('import %s' % m)
            else:
                imp.find_module(m)
        except ImportError:
            ok = False
            print 'Error: %s Python module is required to install %s' \
                  % (w, name.title())

    # gtk.glade needs special care (ugly...)
    if ok:
        path = imp.find_module('gtk')
        if not os.path.exists(path[1] + '/glade.so'):
            ok = False
            print 'Error: %s module is required to install %s' \
                  % ("PyGTK's glade", name.title())
    if not ok:
        sys.exit(1)

def translations():
    '''Build mo-po mapping from po directory'''
    trans = []
    dest = 'share/locale/%s/LC_MESSAGES/%s.mo'
    for po in glob.glob('po/*.po'):
        lang = os.path.splitext(os.path.basename(po))[0]
        trans.append((dest % (lang , name), po))
    return trans

def translation_files():
    '''Files for translation...'''
    potfile = './po/POTFILES.in'

    if not os.path.exists(potfile):
        sys.exit("No such file, '%s'. Please file a bug report.." % potfile)

    f = open(potfile)
    files = []

    for line in f:
        # ignore comments and newline
        if line.startswith('#') or line.startswith('\n'):
            continue
        else: files.append(line.strip())

    f.close()
    return files

def data_files():
    '''Build list of data files to be installed'''
    images = glob.glob('data/*.png')
    files = [
        ('share/pixmaps', ['data/gnomolicious.png']),
        ('share/gnomolicious', images + ['glade/gnomolicious.glade'])]
    return files

long_desc = '''\
Gnomolicious is a GNOME Applet to help you post on the del.icio.us
bookmarks sharing site.'''

classifiers = """\
Development Status :: 5 - Production/Stable
Intended Audience :: End Users/Desktop
License :: OSI Approved :: GNU General Public License (GPL)
Programming Language :: Python
Topic :: Communications
Topic :: Desktop Environment :: Gnome
Topic :: Internet :: WWW/HTTP
Topic :: Utilities
"""

setup(name             = name,
      version          = version,
      description      = 'A GNOME way to post on del.icio.us',
      long_description = long_desc,
      url              = 'http://www.nongnu.org/gnomolicious',
      author           = 'Nicolas Évrard',
      author_email     = 'nicoe@altern.org',
      classifiers      = filter(None, classifiers.split("\n")),
      license          = 'GPL',
      data_files       = data_files(),
      pot_file         = 'po/gnomolicious.pot',
      translations     = translations(),
      #config_files     = [('gconf/schemas',['data/straw.schemas'],
      #                     'with-gconf-schema-file-dir')],
      scripts          = ['scripts/gnomolicious'],
      modules_check    = modules_check,
      packages         = ['gnomolicious'],
      package_dir      = {'gnomolicious' : 'src'},
      msg_sources      = translation_files(),
      desktop_file     = [],
      server_file      = ['data/gnomolicious.server.in']
      )



