/* $Id: phonebookview.c,v 1.8 2004/04/27 16:26:00 thrulliq Exp $ */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <glade/glade.h>
#include <gnokii.h>

#include "gnocky.h"
#include "utils.h"

extern GSList *phonebook_list;
extern GMutex *phonebook_mutex;
extern gboolean phonebook_updated;

static GladeXML *phonebook_xml;
static GtkListStore *store;
static GtkTreeIter iter;
GdkPixbuf *me_pixbuf;
GdkPixbuf *sm_pixbuf;

enum {
	COL_TYPE,
	COL_NAME,
	COL_NUMBER,
	COL_POINTER
};
  
static GtkTreeModel *gnocky_pb_create_model()
{
  /* create list store */
  store = gtk_list_store_new (4, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_POINTER);

  return GTK_TREE_MODEL (store);
}


static void gnocky_pb_add_columns(GtkTreeView *treeview)
{
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	//GtkTreeModel *model = gtk_tree_view_get_model (treeview);
	
	renderer = gtk_cell_renderer_pixbuf_new();
	column = gtk_tree_view_column_new_with_attributes ("Type",
						     renderer,
						     "pixbuf",
						     COL_TYPE,
						     NULL);
	gtk_tree_view_append_column (treeview, column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Name",
						     renderer,
						     "text",
						     COL_NAME,
						     NULL);
	gtk_tree_view_column_set_sort_column_id (column, COL_NAME);
	gtk_tree_view_append_column (treeview, column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Number",
						     renderer,
						     "text",
						     COL_NUMBER,
						     NULL);
	gtk_tree_view_column_set_sort_column_id (column, COL_NUMBER);
	gtk_tree_view_append_column (treeview, column);
}

void gnocky_pb_load_from_phone_clicked(GtkWidget *widget, gpointer data)
{
	gnocky_event_push(GNOCKY_EVENT_READ_PHONEBOOK, NULL);
}

void gnocky_pb_save_to_phone_clicked(GtkWidget *widget, gpointer data)
{
	gnocky_event_push(GNOCKY_EVENT_WRITE_PHONEBOOK, NULL);
}

static void show_edit_pb_dialog(gn_phonebook_entry *en)
{
	GladeXML *edit_xml;
	GtkWidget *edit;
	GtkWidget *entry;
	gchar *name, *number;
	gint res;
	
	edit_xml = create_gladexml("gnocky-edit-phonebook.glade", "edit_phonebook_dialog");
	
	if (!edit_xml)
		g_error("Cannot create edit view!\n");
	
	name = g_convert(en->name, -1, "UTF-8", "ISO-8859-2", NULL, NULL, NULL);
	entry = glade_xml_get_widget(edit_xml, "name_entry");
	gtk_entry_set_text(GTK_ENTRY(entry), name);
	g_free(name);
	
	entry = glade_xml_get_widget(edit_xml, "number_entry");
	gtk_entry_set_text(GTK_ENTRY(entry), en->number);
	
	edit = glade_xml_get_widget(edit_xml, "edit_phonebook_dialog");
	res = gtk_dialog_run(GTK_DIALOG(edit));
	if (res == GTK_RESPONSE_OK) {
		GtkWidget *widget;
		
		entry = glade_xml_get_widget(edit_xml, "name_entry");
		name = g_convert(gtk_entry_get_text(GTK_ENTRY(entry)), -1, "ISO-8859-2", "UTF-8", NULL, NULL, NULL);
		snprintf(en->name, sizeof(en->name), name);
		g_free(name);
		
		entry = glade_xml_get_widget(edit_xml, "number_entry");
		number = g_convert(gtk_entry_get_text(GTK_ENTRY(entry)), -1, "ISO-8859-2", "UTF-8", NULL, NULL, NULL);
		snprintf(en->number, sizeof(en->number), number);
		g_free(number);
		
		widget = glade_xml_get_widget(edit_xml, "save_changes_check");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
			gnocky_event_push(GNOCKY_EVENT_WRITE_PHONEBOOK_ENTRY, en);
		else 
			phonebook_updated = TRUE;
	}
	gtk_widget_destroy(edit);
	g_object_unref(G_OBJECT(edit_xml));
}

static gboolean pb_pressed(GtkWidget *widget, GdkEventKey *ev, gpointer user_data)
{
	if (ev->keyval == GDK_Delete) {
		GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(widget));
		GtkTreePath *treepath = NULL;
		GtkTreeIter iter;
		GtkWidget *dialog;
		gint res;
		gn_phonebook_entry *en;
		
		gtk_tree_view_get_cursor (GTK_TREE_VIEW(widget), &treepath, NULL);
		gtk_tree_model_get_iter(model, &iter, treepath);
		gtk_tree_model_get(model, &iter, 3, &en, -1);
		
		dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, 
                                             GTK_BUTTONS_OK_CANCEL,
					     _("Do you want to delete this phonebbok entry?"));

		res = gtk_dialog_run(GTK_DIALOG(dialog));
		if (res == GTK_RESPONSE_OK) {
			gnocky_event_push(GNOCKY_EVENT_DELETE_PHONEBOOK_ENTRY, en);
		}
		
		gtk_widget_destroy(dialog);
	}
	return FALSE;
}

static gboolean pb_clicked(GtkWidget *widget, GdkEventButton *ev, gpointer user_data)
{
	if (ev->type == GDK_2BUTTON_PRESS && ev->button == 1) {
		GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(widget));
		GtkTreeViewColumn *treevc = NULL;
		GtkTreePath *treepath = NULL;
		GtkTreeIter iter;
		gn_phonebook_entry *en;
		
		if (!gtk_tree_view_get_path_at_pos
		    (GTK_TREE_VIEW(widget), ev->x, ev->y, &treepath, &treevc, NULL, NULL))
			return FALSE;
		gtk_tree_model_get_iter(model, &iter, treepath);
		gtk_tree_model_get(model, &iter, 3, &en, -1);
		show_edit_pb_dialog(en);
		g_print("button_clicked 2 times\n");
	}
	return FALSE;
}

GtkWidget *gnocky_phonebook_view_create()
{
	GtkTreeModel *model;
	GtkWidget *treeview;
	GtkWidget *pbv;

	phonebook_xml = create_gladexml("gnocky-phonebook-view.glade", "phonebook_view");

	if (!phonebook_xml)
		g_error("Cannot create phone view!\n");

	glade_xml_signal_autoconnect(phonebook_xml);

	pbv = glade_xml_get_widget(phonebook_xml, "phonebook_view");

	if (pbv == NULL)
		g_error("Wrong glade data!\n");
	
	model = gnocky_pb_create_model();
	treeview = glade_xml_get_widget(phonebook_xml, "phonebook_tree");
	gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), model);
	g_object_unref (model);
	
	gnocky_pb_add_columns(GTK_TREE_VIEW (treeview));
	g_signal_connect(G_OBJECT(treeview), "button-press-event", G_CALLBACK(pb_clicked), NULL); 
	g_signal_connect(G_OBJECT(treeview), "key-press-event", G_CALLBACK(pb_pressed), NULL);
	

	me_pixbuf = create_pixbuf("me.png");
	sm_pixbuf = create_pixbuf("sm.png");
	
	gtk_widget_show_all(pbv);
	
	return pbv;
}

void gnocky_phonebook_view_update(GnockyPhoneMonitor pm)
{
	GtkWidget *widget;
	
	if (g_mutex_trylock(phonebook_mutex)) {
		GSList *tmp = phonebook_list;
		if (phonebook_updated) {
			gtk_list_store_clear(store);
			while (tmp) {
				gn_phonebook_entry *en = (gn_phonebook_entry *) tmp->data;
				gchar *number_string = g_strdup("");
				gchar *name = g_convert(en->name, -1, "UTF-8", "ISO-8859-2", NULL, NULL, NULL);
				
				if (en->subentries_count) {
					gint i;
					gchar *tmp;
					
					for (i = 0;i<en->subentries_count;i++) {
						tmp = g_strdup_printf("%s %s", number_string, en->subentries[i].data.number);
						g_free(number_string);
						number_string = tmp;
					}
				} else {
					number_string = g_strdup(en->number);
				}
				
				gtk_list_store_append (store, &iter);
				gtk_list_store_set (store, &iter, COL_NAME, name, COL_NUMBER, number_string, COL_POINTER, en, -1);
				
				g_free(name);
				g_free(number_string);
				
				switch (en->memory_type) {
					case GN_MT_ME:
						gtk_list_store_set (store, &iter, COL_TYPE, me_pixbuf, -1);
						break;
					case GN_MT_SM:
						gtk_list_store_set (store, &iter, COL_TYPE, sm_pixbuf, -1);
						break;
					default:
						break;
				}
				tmp = tmp->next;
			}
			phonebook_updated = FALSE;
		}
		g_mutex_unlock(phonebook_mutex);
	}
	widget = glade_xml_get_widget(phonebook_xml, "memory_status_label");
	if (widget) {
		gchar *sm_memory_info;
		gchar *me_memory_info;
		gchar *memory_info; 
		
		if (pm.ms_sm_used != -1) {
			sm_memory_info = g_strdup_printf(_("<b>%d</b> used, <b>%d</b> free"), pm.ms_sm_used, pm.ms_sm_free);
		} else {
			sm_memory_info = g_strdup(_("N/A"));
		}
		
		if (pm.ms_me_used != -1) {
			me_memory_info = g_strdup_printf(_("<b>%d</b> used, <b>%d</b> free"), pm.ms_me_used, pm.ms_me_free);
		} else {
			me_memory_info = g_strdup(_("N/A"));
		}
		
		memory_info = g_strdup_printf(_("SIM card memory: %s. Internal memory: %s"), sm_memory_info, me_memory_info);
		gtk_label_set_markup(GTK_LABEL(widget), memory_info);
		
		g_free(sm_memory_info);
		g_free(me_memory_info);
		g_free(memory_info);
	}
}

gchar *gnocky_pb_get_name(gchar *number)
{
	GSList *tmp;
	if (!number || !number[0])
		return NULL;
	
	if (g_mutex_trylock(phonebook_mutex)) {
		gchar *name, *tmpnumber;
		tmp = phonebook_list;
		
		if (number[0] == '+')
			number += 3;
		
		while (tmp) {
			gn_phonebook_entry *en = (gn_phonebook_entry *) tmp->data;
			tmpnumber = en->number;
			
			if (en->number[0] == '+') 
				tmpnumber += 3;

			if (!g_strcasecmp(tmpnumber, number)) {
				name = g_strdup(en->name);
				g_mutex_unlock(phonebook_mutex);
				return name;
			}
			tmp = tmp->next;
		}
		g_mutex_unlock(phonebook_mutex);
	}
	return NULL;
}
