/* $Id: preferences.c,v 1.4 2004/02/20 19:26:23 thrulliq Exp $ */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <gnokii.h>
#include "utils.h"

void create_preferences(gn_config *cfg)
{
	GladeXML *prefs_xml;
	GtkWidget *prefs;
	GtkWidget *widget;
	gint res;
	
	prefs_xml = create_gladexml("gnocky-preferences.glade", "gnocky_preferences");

	if (!prefs_xml)
		g_error("Cannot create preferences!\n");

	prefs = glade_xml_get_widget(prefs_xml, "gnocky_preferences");

	if (prefs == NULL)
		g_error("Wrong glade data!\n");
	
	switch (cfg->connection_type) {
		case GN_CT_Irda:
			widget = glade_xml_get_widget(prefs_xml, "irda_radio");
			break;
		case GN_CT_Bluetooth:
			widget = glade_xml_get_widget(prefs_xml, "bluetooth_radio");
			break;
		case GN_CT_Serial:
		default:
			widget = glade_xml_get_widget(prefs_xml, "serial_radio");
			break;
	}
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
	
	widget = glade_xml_get_widget(prefs_xml, "model_entry");
	gtk_entry_set_text(GTK_ENTRY(widget), cfg->model);
	
	widget = glade_xml_get_widget(prefs_xml, "port_entry");
	gtk_entry_set_text(GTK_ENTRY(widget), cfg->port_device);
	
	res = gtk_dialog_run(GTK_DIALOG(prefs));
	
	gtk_widget_destroy(prefs);
	
	return; 
}
