/*
 * `gnetic' is a program to use and enjoy by all alive being
 * Jesús Burgos <jburmac@gmail.com>
 * Joan Lledó <joanlluislledo@gmail.com>
 *
 *  Copyright (C) 2005 Jesús Burgos
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _UTIL_H
#define _UTIL_H

#define _FILE_OFFSET_BITS 64

#include <sys/types.h>
#include <unistd.h>

#define msgerror(message, args...) 					      \
	__msgerror (message, 						      \
		(char *) __FILE__, __LINE__, (char *)__PRETTY_FUNCTION__,     \
		##args)

typedef enum
{ false, true } bool;

int __msgerror (char *, char *, int, char *, ...);
off_t lsendfile (int, int, off_t, int);
void set_optimal_bufsize (unsigned int);
void showbt ();

ssize_t recv_waitall (int, void *, size_t);

ssize_t (*get_nbytes) (int, void *, size_t);

#define set_fd_is_socket() \
	get_nbytes = recv_waitall

#define set_fd_is_file() \
	get_nbytes = read

#endif /* _UTIL_H */
