/*
 * `gnetic' is a program to use and enjoy by all alive being
 * Jesús Burgos <jburmac@gmail.com>
 * Joan Lledó <joanlluislledo@gmail.com>
 *
 *  Copyright (C) 2005 Jesús Burgos
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* slash.c implements functions to use a progress bar in a text terminal.
 * Include:
 * - Create and update the progress bar.*/

#include <stdlib.h>
#include <stdio.h>

#include "util.h"
#include "slash.h"

#include <libintl.h>
#include <locale.h>

#define _(x) gettext(x)
#define N_(x) (x)

#define slashsize 50

/* Draw the progress bar */
int
update_slash (const unsigned int nbytes, int finish)
{
	static unsigned int writed_kbytes = 0;
	unsigned int percentage;

	writed_kbytes += nbytes / 1024;

	if (writed_kbytes > image_size)
	{
		msgerror (_("The obtained percentage don't appears to be valid"));
		return -1;
	}
	char palitroque[5] = "|/-\\";
	//int percentage = (writed_kbytes * 100) / image_size;
	if (finish)
	{
		percentage = 100;
		writed_kbytes = 0;
	}
	else
	{
		percentage = writed_kbytes / (image_size / (float) 2) * 50;
	}
	char slash[slashsize + 1];
	int i;
	for (i = 0; i < slashsize; i++)
		if (i < (percentage / (100 / slashsize)))
			slash[i] = '=';
		else
			slash[i] = ' ';
	slash[i] = '\0';

	fprintf (stderr, "\r [%s] %c %i%% - Total: %.2fGiB.", slash,
			 palitroque[percentage % 4], percentage,
			 (double) (image_size / 1024) / 1024);
	fflush (stderr);

	return 0;
}
