/*
 * `gnetic' is a program to use and enjoy by all alive being
 * Jesús Burgos <jburmac@gmail.com>
 * Joan Lledó <joanlluislledo@gmail.com>
 *
 *  Copyright (C) 2005 Jesús Burgos
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _DISK_H
#define _DISK_H

#define _FILE_OFFSET_BITS 64
#include <sys/types.h>
#include <parted/parted.h>

#include "image.h"
#include "grub.h"

int disk_max_partitions; //Max number of partitions in the disk

#define set_disk_is_ide() \
	disk_max_partitions = 63

#define set_disk_is_sata() \
	disk_max_partitions= 15

enum fs_codes get_fs_code (const char *);
unsigned char get_minor (const char *);
unsigned char get_major (const char *);
int get_disk_path_from_part (const char *, char *);
char *get_pedname_from_code (enum fs_codes);

int check_for_commands (struct part_info *);

enum fs_types get_fs_type (enum fs_codes);
off_t fs_free_kbytes (const char *);

int procpt (unsigned char, unsigned char, char *, int);

int read_label (const char *, enum fs_codes, unsigned char *);
int write_label (const char *, enum fs_codes, unsigned char *);

int is_blk (const char *);

int mount_part (const char *, enum fs_codes, unsigned long, char *);
int mount_part_n (const char *, int, enum fs_codes, unsigned long, char *);
int umount_part ();

unsigned long long get_part_offset (const char *, int);
unsigned long long get_part_size (const char *, int);
PedPartition *get_part_from_path (const char *, int);

int write_partition (const char *, struct part_info *);
int write_disk (const char *, struct part_info[nlogicals + 4]);

int read_partition (const char *, struct part_info *);
int read_disk (const char *, struct part_info[nlogicals + 4]);

int set_disk_type(char *);

bool is_disk(char *);

#endif /* _DISK_H */
