/* main.c - Main program routines
 *
 * Copyright (C) 2005-2006   Ivo Clarysse
 *
 * This file is part of GMediaRender.
 *
 * GMediaRender is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GMediaRender is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GMediaRender; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA 02110-1301, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <upnp/upnp.h>
#include <upnp/ithread.h>
#include <upnp/upnptools.h>

#include "output_gstreamer.h"
#include "upnp.h"
#include "upnp_renderer.h"
#include "upnp_connmgr.h"
#include "upnp_control.h"

int main(int argc, char **argv)
{
	output_gstreamer_init(&argc, &argv);

	connmgr_init();

	if (init_upnp_renderer())
		return -1;
	while (1) {
		sleep(100);
	}
	return 0;
}
