/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 20 "treasure.y"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <argz.h>

#include <stdlib.h>

#include "config.h"
#include "st.h"
#include "opts.h"
#include "treasure.h"
#include "tcheck.h"
#include "xvasprintf.h"

int yylex();
int yyerror( char *s );


/*
 * defined_t is used to indicate whether all fields have been defined
 */

typedef struct {
    unsigned	special: 1,
		tval: 1,
		tchar: 1,
		subval: 1,
		p1: 1,
		cost: 1,
		number: 1,
		weight: 1,
		tohit: 1,
		todam: 1,
		ac: 1,
		toac: 1,
		damage: 1,
		stackable: 1,
		stackable_id: 1,
		buyable: 1,
		unique_function: 1,
		store_only: 1,
		level: 1,
		mushroom_flag: 1;
} defined_t;



/*
 * template_t contains treasure definition & flags
 */

typedef struct 
{
  char *id;
  state_type state;
  treasure_type	val;
  defined_t def;
} template_t;

typedef struct 
{
  char *id;
  state_type state;
  treasure_type	val;
  defined_t def;
} sorted_template_t;



/*
 * symInit_t is used to initialize symbol tables with integer values
 */

typedef struct 
{
  char *name;
  int32u val;
} symInit_t;


static symInit_t 
eatingcausesInit[] = 
{
   { "poisoning", 0 },
   { "blindness", 1 },
   { "fear", 2 },
   { "confusion_i", 3 },
   { "confusion_ii", 4 },
   { "cure_poison", 5 },
   { "cure_blindness", 6 },
   { "cure_fear", 7 },
   { "cure_confusion", 8 },
   { "lose_strength", 9 },
   { "lose_constitution", 10 },
   { "restore_strength", 15 },
   { "restore_constitution", 16 },
   { "restore_intelligence", 17 },
   { "restore_wisdom", 18 },
   { "restore_dexterity", 19 },
   { "restore_charisma", 20 },
   { "cure_wounds_i", 21 },
   { "cure_wounds_ii", 22 },
   { "cure_wounds_iii", 23 },
   { "cure_wounds_iv", 25 },
   { "cause_wounds", 26 },
   { NULL, 0 }
};

static symInit_t 
potion1causesInit[] = 
{
   { "gain_strength", 0 },
   { "lose_strength", 1 },
   { "restore_strength", 2 },
   { "gain_intelligence", 3 },
   { "lose_intelligence", 4 },
   { "restore_intelligence", 5 },
   { "gain_wisdom", 6 },
   { "lose_wisdom", 7 },
   { "restore_wisdom", 8 },
   { "gain_charisma", 9 },
   { "lose_charisma", 10 },
   { "restore_charisma", 11 },
   { "cure_wounds_i", 12 },
   { "cure_wounds_ii", 13 },
   { "cure_wounds_iii", 14 },
   { "healing", 15 },
   { "gain_constitution", 16 },
   { "gain_experience", 17 },
   { "sleep", 18 },
   { "blindness", 19 },
   { "confusion", 20 },
   { "poisoning", 21 },
   { "speed", 22 },
   { "slowness", 23 },
   { "gain_dexterity", 25 },
   { "restore_dexterity", 26 },
   { "restore_constitution", 27 },
   { "cure_blindness", 28 },
   { "cure_confusion", 29 },
   { "cure_poison", 30 },
   { NULL, 0 }
};

static symInit_t 
potion2causesInit[] = 
{
   { "lose_experience", 1 },
   { "throw_up", 2 },
   { "invulnerability", 3 },
   { "heroism", 4 },
   { "super_heroism", 5 },
   { "cure_fear", 6 },
   { "restore_life_levels", 7 },
   { "resist_heat", 8 },
   { "resist_cold", 9 },
   { "see_invisible", 10 },
   { "slow_poison", 11 },
   { "cure_poison", 12 },
   { "restore_mana", 13 },
   { "infravision", 14 },
   { NULL, 0 }
};

static symInit_t 
scrollcausesInit[] = 
{
   { "increase_tohit", 0 },
   { "increase_todam", 1 },
   { "enchant_armor_i", 2 },
   { "identify", 3 },
   { "remove_curse", 4 },
   { "light", 5 },
   { "summon_monster", 6 },
   { "phase_door", 7 },
   { "teleport", 8 },
   { "teleport_level", 9 },
   { "confuse_monster", 10 },
   { "magic_mapping", 11 },
   { "sleep_monsters_i", 12 },
   { "warding_glyph", 13 },
   { "detect_treasure", 14 },
   { "detect_objects", 15 },
   { "detect_traps", 16 },
   { "detect_secret_doors", 17 },
   { "mass_genocide", 18 },
   { "detect_invisble", 19 },
   { "aggravate_monster", 20 },
   { "create_trap", 21 },
   { "trap_or_door_destruction", 22 },
   { "create_door", 23 },
   { "recharge", 24 },
   { "genocide", 25 },
   { "darkness", 26 },
   { "protection_from_evil", 27 },
   { "create_food", 28 },
   { "dispel_undead", 29 },
   { "enchant_weapon", 32 },
   { "curse_weapon", 33 },
   { "enchant_armor_ii", 34 },
   { "curse_armor", 35 },
   { "summon_undead", 36 },
   { "bless_i", 37 },
   { "bless_ii", 38 },
   { "bless_iii", 39 },
   { "recall", 40 },
   { "earthquake", 41 },
   { NULL, 0 }
};

static symInit_t 
staffcausesInit[] = 
{
   { "light", 0 },
   { "detect_secret_doors", 1 },
   { "detect_traps", 2 },
   { "detect_treasures", 3 },
   { "detect_objects", 4 },
   { "teleport", 5 },
   { "earthquake", 6 },
   { "summon_monster", 7 },
   { "earthquake_ii", 9 },
   { "starlight", 10 },
   { "speed_monsters", 11 },
   { "slow_monsters", 12 },
   { "sleep_monsters_ii", 13 },
   { "cure_wounds_i", 14 },
   { "detect_invisible", 15 },
   { "speed", 16 },
   { "slowness", 17 },
   { "mass_polymorph", 18 },
   { "remove_curse", 19 },
   { "detect_evil", 20 },
   { "curing", 21 },
   { "dispel_undead", 22 },
   { "darkness", 24 },
   { NULL, 0 }
};

static symInit_t 
wandcausesInit[] = 
{
   { "light_line", 0 },
   { "lightning_bolt", 1 },
   { "frost_bolt", 2 },
   { "fire_bolt", 3 },
   { "stone_to_mud", 4 },
   { "polymorph_monster", 5 },
   { "heal_monster", 6 },
   { "haste_monster", 7 },
   { "slow_monster", 8 },
   { "confuse_monster", 9 },
   { "sleep_monster", 10 },
   { "drain_life", 11 },
   { "destroy_traps_and_doors", 12 },
   { "magic_missile", 13 },
   { "build_wall", 14 },
   { "clone_monster", 15 },
   { "teleport_monster", 16 },
   { "disarm_all", 17 },
   { "lightning_ball", 18 },
   { "cold_ball", 19 },
   { "fire_ball", 20 },
   { "poison_gas", 21 },
   { "acid_ball", 22 },
   { "wonder", 23 },
   { NULL, 0 }
};


static symInit_t 
specialInit[] = 
{
    { "strength", 0 },
    { "intelligence", 1 },
    { "wisdom", 2 },
    { "dexterity", 3 },
    { "constitution", 4 },
    { "charisma", 5 },
    { "search", 6 },
    { "slow_digestion", 7 },
    { "stealth", 8 },
    { "aggravate", 9 },
    { "teleport", 10 },
    { "regenerate", 11 },
    { "speed", 12 },
    { "ego_slay_dragon", 13 },
    { "ego_slay_animal", 14 },
    { "ego_slay_evil", 15 },
    { "ego_slay_undead", 16 },
    { "ego_frost_brand", 17 },
    { "ego_flame_tongue", 18 },
    { "resist_fire", 19 },
    { "resist_acid", 20 },
    { "resist_cold", 21 },
    { "sustain_stat", 22 },
    { "free_action", 23 },
    { "see_invisible", 24 },
    { "resist_lightning", 25 },
    { "free_falling", 26 },
    { "blindness", 27 },
    { "fear", 28 },
    { "tunnel", 29 },
    { "infrared", 30 },
    { "cursed", 31 },
    { NULL, 0 }
};

static symInit_t
spellsInit[] = 
{
    { "magic_missile", 0},
    { "detect_monsters", 1},
    { "phase_door", 2},
    { "light_area", 3},
    { "cure_light_wounds", 4},
    { "find_hidden_traps_and_doors", 5},
    { "stinking_cloud", 6},
    { "confusion", 7},
    { "lightning_bolt", 8},
    { "trap_and_door_destruction", 9},
    { "sleep_i", 10},
    { "cure_poison", 11},
    { "teleport_self", 12},
    { "remove_curse", 13},
    { "frost_bolt", 14},
    { "turn_stone_to_mud", 15},
    { "create_food", 16},
    { "recharge_item_i", 17},
    { "sleep_ii", 18},
    { "polymorph_other", 19},
    { "identify", 20},
    { "sleep_iii", 21},
    { "fire_bolt", 22},
    { "slow_monster", 23},
    { "frost_ball", 24},
    { "recharge_item_ii", 25},
    { "teleport_other", 26},
    { "haste_self", 27},
    { "fire_ball", 28},
    { "resist_poison_gas", 29},
    { "word_of_destruction", 30},
    { "genocide", 31},
    { NULL, 0 },
};

static symInit_t
prayersInit[] = 
{
    { "detect_evil", 0},
    { "cure_light_wounds", 1},
    { "bless", 2},
    { "remove_fear", 3},
    { "call_light", 4},
    { "find_traps", 5},
    { "detect_doors_and_stairs", 6},
    { "slow_poison", 7},
    { "blind_creature", 8},
    { "portal", 9},
    { "cure_medium_wounds", 10},
    { "chant", 11},
    { "sanctuary", 12},
    { "create_food", 13},
    { "remove_curse", 14},
    { "resist_heat_and_cold", 15},
    { "neutralize_poison", 16},
    { "orb_of_draining", 17},
    { "cure_serious_wounds", 18},
    { "sense_invisible", 19},
    { "protection_from_evil", 20},
    { "earthquake", 21},
    { "sense_surroundings", 22},
    { "cure_critical_wounds", 23},
    { "turn_undead", 24},
    { "pray_prayer", 25},
    { "dispel_undead", 26},
    { "heal", 27},
    { "dispel_evil", 28},
    { "resist_poison_gas", 29},
    { "glyph_of_warding", 30},
    { "holy_word", 31},
    { NULL, 0 },
};

static symInit_t
stackableInit[] = 
{
    { "never", 0},
    { "with_same_kind", 1},
    { "with_same_p1", 2},
    { NULL, 0 },
};

static symInit_t
buyableInit[] = 
{
    { "by_general_store", 0 },
    { "by_armoury", 1 },
    { "by_weaponsmith", 2 },
    { "by_temple", 3 },
    { "by_alchemist", 4 },
    { "by_magic_shop", 5 },
    { "exclusively_in_town", 6 },
    { NULL, 0 },
};

static symInit_t 
uniqfuncInit[] = 
{
    { "chest_ruined", UNIQ_CHEST_RUINED},
    { "wizard_object", UNIQ_WIZARD_OBJECT},
    { "scare_monster", UNIQ_SCARE_MONSTER},
    { "created_by_spell", UNIQ_CREATED_BY_SPELL},
    { "inventory_object", UNIQ_INVENTORY_OBJECT},
    { NULL, 0 }
};

static symInit_t 
containsInit[] = 
{
    { "carry_small_obj", 23 },
    { "carry_obj", 24 },
    { "carry_gold", 25 },
    { "has_random_60", 26 },
    { "has_random_90", 27 },
    { "has_1d2_obj", 28 },
    { "has_2d2_obj", 29 },
    { "has_4d2_obj", 30 },
    { NULL, 0 }
};

static symInit_t
tvalInit[] = 
{
    { "nothing", 0},
    { "misc", 1},
    { "chest", 2},
    { "sling_ammo", 10},
    { "bolt", 11},
    { "arrow", 12},
    { "spike", 13},
    { "light", 15},
    { "bow", 20},
    { "hafted", 21},
    { "polearm", 22},
    { "sword", 23},
    { "digging", 25},
    { "boots", 30},
    { "gloves", 31},
    { "cloak", 32},
    { "helm", 33},
    { "shield", 34},
    { "hard_armor", 35},
    { "soft_armor", 36},
    { "amulet", 40},
    { "ring", 45},
    { "staff", 55},
    { "wand", 65},
    { "scroll", 70},
    { "potion1", 75},
    { "potion2", 76},
    { "potion", 75}, //placeholder for potion1 (75) or potion2 (76)
    { "flask", 77},
    { "food", 80},
    { "mushroom", 80}, //not a tval. distinguishing between mushrooms and food
    { "magic_book", 90},
    { "prayer_book", 91},
    { "gold", 100},
    { "invis_trap", 101},
    { "vis_trap", 102},
    { "rubble", 103},
    { "open_door", 104},
    { "closed_door", 105},
    { "up_stair", 107},
    { "down_stair", 108},
    { "secret_door", 109},
    { "store_door", 110},
    { NULL, 0 },
};



/*
 * Maximum token length = maximum string constant length
 * Also, trim the stack to an "acceptable" size.
 */

#define	MAX_TOK_LEN	64		/* maximum acceptable token length  */
#define	YYSTACKSIZE	128

#define GEN_TYPE_TMPL	256		/* type of a template for st	    */

int treasureCt;
/*
 * Globals used by the tokenizer (lexical analyzer)
 */

#define INPUT_BUF_SIZE 256
static char	inputBuf[INPUT_BUF_SIZE] = { 0 };
					/* input line buffer		    */
static char	*inputBufp = inputBuf;	/* position in input line buffer    */
static int	lineNo = 0;		/* number of current line	    */
static FILE	*input_F;
static char	tokStr[MAX_TOK_LEN];	/* text of current token	    */
static	int	tokType;		/* type of current token	    */

static template_t blankTemplate;	/* blank template for init-ing     */
static template_t tmpTemplate;		/* working template for current     */
					/* class or treasure		    */

char *adjective_argz = NULL;            /* the working adjective           */
size_t adjective_argz_len = 0;
char *mushroom_adjectives_argz = NULL;  /* unidentified mushroom words      */
size_t mushroom_adjectives_argz_len = 0;
char *wand_adjectives_argz = NULL;      /* unidentified wand words          */
size_t wand_adjectives_argz_len = 0;
char *staff_adjectives_argz = NULL;     /* unidentified staff words         */
size_t staff_adjectives_argz_len = 0;
char *potion_adjectives_argz = NULL;    /* unidentified potion words        */
size_t potion_adjectives_argz_len = 0;
char *amulet_adjectives_argz = NULL;    /* unidentified amulet words        */
size_t amulet_adjectives_argz_len = 0;
char *ring_adjectives_argz = NULL;      /* unidentified ring words          */
size_t ring_adjectives_argz_len = 0;
char *syllables_argz = NULL;            /* syllables for scrolls           */
size_t syllables_argz_len = 0;


/*
 * Global symbol tables
 */

static st_Table_Pt keywordT_P;		/* parser's keywords		    */
static st_Table_Pt containsT_P;		/* treasure flags for chests	    */
static st_Table_Pt specialT_P;		/* special properties		    */
static st_Table_Pt uniqfuncT_P;		/* the horrible one-offs	    */
static st_Table_Pt spellsT_P;		/* spells that go in books	    */
static st_Table_Pt prayersT_P;		/* prayers that go in books	    */
static st_Table_Pt eatingcausesT_P;	/* effects of eating foodstuffs     */
static st_Table_Pt potion1causesT_P;	/* effects of eating tv_potion1     */
static st_Table_Pt potion2causesT_P;	/* effects of eating tv_potion2     */
static st_Table_Pt scrollcausesT_P;	/* effects of reading tv_scroll    */
static st_Table_Pt staffcausesT_P;	/* effects of using tv_staff        */
static st_Table_Pt wandcausesT_P;	/* effects of zapping tv_wand       */
static st_Table_Pt tvalT_P;		/* treasure types		    */
static st_Table_Pt stackableT_P;	/* how the object stacks	    */
static st_Table_Pt buyableT_P;		/* object is in these stores*/
static st_Table_Pt classT_P;		/* class templates		    */
static st_Table_Pt treasureT_P;		/* treasure definitions		    */
static st_Table_Pt sortedtreasureT_P;	/* sorted treasure definitions	    */

/*
 * Function declarations
 */

extern void WriteTreasure ();
extern void PutClassTemplate ();
extern template_t GetClassTemplate ();
extern int MergeClassTemplate (char *s, template_t *t1);
extern void AddSpecial ();
extern void NegSpecial ();
extern void AddContainsFlag ();
extern void NegContainsFlag ();
extern void AddSpell ();
extern void NegSpell ();
extern void AddPrayer ();
extern void NegPrayer ();
extern void AddStackableFlag ();
extern void AddRelativeSubval();
extern void NegStackableFlag ();
extern void AddEquipNewFlag ();
extern void NegEquipNewFlag ();
extern void AddBuyableFlag ();
extern void AddEatingFlag ();
extern void NegEatingFlag ();
extern void AddPotionFlag ();
extern void NegPotionFlag ();
extern void AddScrollFlag ();
extern void NegScrollFlag ();
extern void AddStaffFlag ();
extern void NegStaffFlag ();
extern void AddWandFlag ();
extern void NegWandFlag ();
extern void AddTVal ();
extern void AddAdjective ();
extern void AddUniqueFunction ();
extern void PutTreasure ();
extern void PutAdjectives ();
extern void PutSyllables ();


#line 666 "treasure.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif


/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    CLASS = 258,                   /* CLASS  */
    TREASURE = 259,                /* TREASURE  */
    SPECIAL = 260,                 /* SPECIAL  */
    TVAL = 261,                    /* TVAL  */
    TCHAR = 262,                   /* TCHAR  */
    P1 = 263,                      /* P1  */
    COST = 264,                    /* COST  */
    NUMBER = 265,                  /* NUMBER  */
    WEIGHT = 266,                  /* WEIGHT  */
    TO_HIT = 267,                  /* TO_HIT  */
    TO_DAM = 268,                  /* TO_DAM  */
    AC = 269,                      /* AC  */
    TO_AC = 270,                   /* TO_AC  */
    DAMAGE = 271,                  /* DAMAGE  */
    LEVEL = 272,                   /* LEVEL  */
    NONE = 273,                    /* NONE  */
    PRAYER = 274,                  /* PRAYER  */
    SPELL = 275,                   /* SPELL  */
    BUYABLE = 276,                 /* BUYABLE  */
    STACKABLE = 277,               /* STACKABLE  */
    SUBVAL = 278,                  /* SUBVAL  */
    UNIQUE_FUNCTION = 279,         /* UNIQUE_FUNCTION  */
    EATING_CAUSES = 280,           /* EATING_CAUSES  */
    CONTAINS = 281,                /* CONTAINS  */
    RELSUBVAL = 282,               /* RELSUBVAL  */
    POTION_CAUSES = 283,           /* POTION_CAUSES  */
    SCROLL_CASTS = 284,            /* SCROLL_CASTS  */
    UNIDENTIFIED = 285,            /* UNIDENTIFIED  */
    WAND_CASTS = 286,              /* WAND_CASTS  */
    STAFF_CASTS = 287,             /* STAFF_CASTS  */
    SYLLABLES = 288,               /* SYLLABLES  */
    IDENTIFIER = 289,              /* IDENTIFIER  */
    FLOAT_LIT = 290,               /* FLOAT_LIT  */
    INT_LIT = 291,                 /* INT_LIT  */
    STRING_LIT = 292,              /* STRING_LIT  */
    BOOL_LIT = 293                 /* BOOL_LIT  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define CLASS 258
#define TREASURE 259
#define SPECIAL 260
#define TVAL 261
#define TCHAR 262
#define P1 263
#define COST 264
#define NUMBER 265
#define WEIGHT 266
#define TO_HIT 267
#define TO_DAM 268
#define AC 269
#define TO_AC 270
#define DAMAGE 271
#define LEVEL 272
#define NONE 273
#define PRAYER 274
#define SPELL 275
#define BUYABLE 276
#define STACKABLE 277
#define SUBVAL 278
#define UNIQUE_FUNCTION 279
#define EATING_CAUSES 280
#define CONTAINS 281
#define RELSUBVAL 282
#define POTION_CAUSES 283
#define SCROLL_CASTS 284
#define UNIDENTIFIED 285
#define WAND_CASTS 286
#define STAFF_CASTS 287
#define SYLLABLES 288
#define IDENTIFIER 289
#define FLOAT_LIT 290
#define INT_LIT 291
#define STRING_LIT 292
#define BOOL_LIT 293

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 624 "treasure.y"

	int ival;
	double dval;
	char sval[MAX_TOK_LEN];
	

#line 799 "treasure.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;


int yyparse (void);



/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_CLASS = 3,                      /* CLASS  */
  YYSYMBOL_TREASURE = 4,                   /* TREASURE  */
  YYSYMBOL_SPECIAL = 5,                    /* SPECIAL  */
  YYSYMBOL_TVAL = 6,                       /* TVAL  */
  YYSYMBOL_TCHAR = 7,                      /* TCHAR  */
  YYSYMBOL_P1 = 8,                         /* P1  */
  YYSYMBOL_COST = 9,                       /* COST  */
  YYSYMBOL_NUMBER = 10,                    /* NUMBER  */
  YYSYMBOL_WEIGHT = 11,                    /* WEIGHT  */
  YYSYMBOL_TO_HIT = 12,                    /* TO_HIT  */
  YYSYMBOL_TO_DAM = 13,                    /* TO_DAM  */
  YYSYMBOL_AC = 14,                        /* AC  */
  YYSYMBOL_TO_AC = 15,                     /* TO_AC  */
  YYSYMBOL_DAMAGE = 16,                    /* DAMAGE  */
  YYSYMBOL_LEVEL = 17,                     /* LEVEL  */
  YYSYMBOL_NONE = 18,                      /* NONE  */
  YYSYMBOL_PRAYER = 19,                    /* PRAYER  */
  YYSYMBOL_SPELL = 20,                     /* SPELL  */
  YYSYMBOL_BUYABLE = 21,                   /* BUYABLE  */
  YYSYMBOL_STACKABLE = 22,                 /* STACKABLE  */
  YYSYMBOL_SUBVAL = 23,                    /* SUBVAL  */
  YYSYMBOL_UNIQUE_FUNCTION = 24,           /* UNIQUE_FUNCTION  */
  YYSYMBOL_EATING_CAUSES = 25,             /* EATING_CAUSES  */
  YYSYMBOL_CONTAINS = 26,                  /* CONTAINS  */
  YYSYMBOL_RELSUBVAL = 27,                 /* RELSUBVAL  */
  YYSYMBOL_POTION_CAUSES = 28,             /* POTION_CAUSES  */
  YYSYMBOL_SCROLL_CASTS = 29,              /* SCROLL_CASTS  */
  YYSYMBOL_UNIDENTIFIED = 30,              /* UNIDENTIFIED  */
  YYSYMBOL_WAND_CASTS = 31,                /* WAND_CASTS  */
  YYSYMBOL_STAFF_CASTS = 32,               /* STAFF_CASTS  */
  YYSYMBOL_SYLLABLES = 33,                 /* SYLLABLES  */
  YYSYMBOL_IDENTIFIER = 34,                /* IDENTIFIER  */
  YYSYMBOL_FLOAT_LIT = 35,                 /* FLOAT_LIT  */
  YYSYMBOL_INT_LIT = 36,                   /* INT_LIT  */
  YYSYMBOL_STRING_LIT = 37,                /* STRING_LIT  */
  YYSYMBOL_BOOL_LIT = 38,                  /* BOOL_LIT  */
  YYSYMBOL_39_ = 39,                       /* ';'  */
  YYSYMBOL_40_ = 40,                       /* '#'  */
  YYSYMBOL_41_ = 41,                       /* '{'  */
  YYSYMBOL_42_ = 42,                       /* '}'  */
  YYSYMBOL_43_ = 43,                       /* ','  */
  YYSYMBOL_44_ = 44,                       /* ':'  */
  YYSYMBOL_45_ = 45,                       /* '|'  */
  YYSYMBOL_46_ = 46,                       /* '*'  */
  YYSYMBOL_47_ = 47,                       /* '~'  */
  YYSYMBOL_YYACCEPT = 48,                  /* $accept  */
  YYSYMBOL_treasures = 49,                 /* treasures  */
  YYSYMBOL_comment_def = 50,               /* comment_def  */
  YYSYMBOL_comments = 51,                  /* comments  */
  YYSYMBOL_comment = 52,                   /* comment  */
  YYSYMBOL_more_comments = 53,             /* more_comments  */
  YYSYMBOL_syllables_def = 54,             /* syllables_def  */
  YYSYMBOL_unidentified_def = 55,          /* unidentified_def  */
  YYSYMBOL_adjectives = 56,                /* adjectives  */
  YYSYMBOL_adjective = 57,                 /* adjective  */
  YYSYMBOL_more_adjectives = 58,           /* more_adjectives  */
  YYSYMBOL_class_def = 59,                 /* class_def  */
  YYSYMBOL_parent_classes = 60,            /* parent_classes  */
  YYSYMBOL_parent_class = 61,              /* parent_class  */
  YYSYMBOL_more_classes = 62,              /* more_classes  */
  YYSYMBOL_treasure_def = 63,              /* treasure_def  */
  YYSYMBOL_features = 64,                  /* features  */
  YYSYMBOL_feature = 65,                   /* feature  */
  YYSYMBOL_buy_flags = 66,                 /* buy_flags  */
  YYSYMBOL_buy_flag = 67,                  /* buy_flag  */
  YYSYMBOL_more_buy_flags = 68,            /* more_buy_flags  */
  YYSYMBOL_unique_functions = 69,          /* unique_functions  */
  YYSYMBOL_tval = 70,                      /* tval  */
  YYSYMBOL_carries = 71,                   /* carries  */
  YYSYMBOL_carry = 72,                     /* carry  */
  YYSYMBOL_more_carries = 73,              /* more_carries  */
  YYSYMBOL_stack_flags = 74,               /* stack_flags  */
  YYSYMBOL_stack_flag = 75,                /* stack_flag  */
  YYSYMBOL_more_stack_flags = 76,          /* more_stack_flags  */
  YYSYMBOL_spells = 77,                    /* spells  */
  YYSYMBOL_spell = 78,                     /* spell  */
  YYSYMBOL_more_spells = 79,               /* more_spells  */
  YYSYMBOL_prayers = 80,                   /* prayers  */
  YYSYMBOL_prayer = 81,                    /* prayer  */
  YYSYMBOL_more_prayers = 82,              /* more_prayers  */
  YYSYMBOL_specials = 83,                  /* specials  */
  YYSYMBOL_special = 84,                   /* special  */
  YYSYMBOL_more_specials = 85,             /* more_specials  */
  YYSYMBOL_eatingcauses = 86,              /* eatingcauses  */
  YYSYMBOL_eatingcause = 87,               /* eatingcause  */
  YYSYMBOL_more_eatingcauses = 88,         /* more_eatingcauses  */
  YYSYMBOL_potion1causes = 89,             /* potion1causes  */
  YYSYMBOL_potion1cause = 90,              /* potion1cause  */
  YYSYMBOL_more_potion1causes = 91,        /* more_potion1causes  */
  YYSYMBOL_scrollcauses = 92,              /* scrollcauses  */
  YYSYMBOL_scrollcause = 93,               /* scrollcause  */
  YYSYMBOL_more_scrollcauses = 94,         /* more_scrollcauses  */
  YYSYMBOL_staffcauses = 95,               /* staffcauses  */
  YYSYMBOL_staffcause = 96,                /* staffcause  */
  YYSYMBOL_more_staffcauses = 97,          /* more_staffcauses  */
  YYSYMBOL_wandcauses = 98,                /* wandcauses  */
  YYSYMBOL_wandcause = 99,                 /* wandcause  */
  YYSYMBOL_more_wandcauses = 100           /* more_wandcauses  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */
#line 643 "treasure.y"

static symInit_t 
keywordInit[] = 
{
    { "class", CLASS },
    { "treasure", TREASURE},
    { "special", SPECIAL},
    { "spell", SPELL},
    { "prayer", PRAYER},
    { "kind", TVAL},
    { "letter", TCHAR},
    { "p1", P1},
    { "cost", COST},
    { "quantity", NUMBER},
    { "weight", WEIGHT},
    { "to_hit", TO_HIT},
    { "to_dam", TO_DAM},
    { "ac", AC},
    { "to_ac", TO_AC},
    { "damage", DAMAGE},
    { "level", LEVEL},
    { "none", NONE},
    { "stackable", STACKABLE},
    { "subval", SUBVAL},
    { "relsubval", RELSUBVAL},
    { "unique_function", UNIQUE_FUNCTION},
    { "sold", BUYABLE},
    { "eating_causes", EATING_CAUSES},
    { "contains", CONTAINS},
    { "potion_causes", POTION_CAUSES},
    { "scroll_casts", SCROLL_CASTS},
    { "staff_casts", STAFF_CASTS},
    { "wand_casts", WAND_CASTS},
    { "unidentified", UNIDENTIFIED},
    { "syllable", SYLLABLES},
    { NULL, 0 } /* note, is 32 the max here ?*/
};

#line 964 "treasure.c"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  19
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   201

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  48
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  53
/* YYNRULES -- Number of rules.  */
#define YYNRULES  123
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  243

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   293


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,    40,     2,     2,     2,     2,
       2,     2,    46,     2,    43,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    44,    39,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    41,    45,    42,    47,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   701,   701,   702,   703,   704,   705,   706,   709,   713,
     716,   720,   721,   724,   728,   732,   735,   739,   740,   743,
     748,   750,   753,   756,   760,   761,   764,   778,   779,   782,
     785,   789,   792,   793,   796,   799,   802,   805,   808,   811,
     814,   817,   820,   823,   824,   825,   826,   827,   828,   829,
     830,   831,   832,   833,   834,   835,   838,   841,   842,   844,
     847,   848,   851,   854,   857,   860,   861,   862,   865,   866,
     869,   872,   873,   874,   877,   878,   881,   884,   885,   886,
     889,   890,   893,   896,   897,   898,   901,   902,   905,   908,
     909,   910,   913,   914,   917,   920,   921,   922,   925,   926,
     929,   932,   933,   934,   937,   938,   941,   944,   945,   946,
     949,   950,   953,   956,   957,   958,   961,   962,   965,   968,
     969,   970,   973,   974
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "CLASS", "TREASURE",
  "SPECIAL", "TVAL", "TCHAR", "P1", "COST", "NUMBER", "WEIGHT", "TO_HIT",
  "TO_DAM", "AC", "TO_AC", "DAMAGE", "LEVEL", "NONE", "PRAYER", "SPELL",
  "BUYABLE", "STACKABLE", "SUBVAL", "UNIQUE_FUNCTION", "EATING_CAUSES",
  "CONTAINS", "RELSUBVAL", "POTION_CAUSES", "SCROLL_CASTS", "UNIDENTIFIED",
  "WAND_CASTS", "STAFF_CASTS", "SYLLABLES", "IDENTIFIER", "FLOAT_LIT",
  "INT_LIT", "STRING_LIT", "BOOL_LIT", "';'", "'#'", "'{'", "'}'", "','",
  "':'", "'|'", "'*'", "'~'", "$accept", "treasures", "comment_def",
  "comments", "comment", "more_comments", "syllables_def",
  "unidentified_def", "adjectives", "adjective", "more_adjectives",
  "class_def", "parent_classes", "parent_class", "more_classes",
  "treasure_def", "features", "feature", "buy_flags", "buy_flag",
  "more_buy_flags", "unique_functions", "tval", "carries", "carry",
  "more_carries", "stack_flags", "stack_flag", "more_stack_flags",
  "spells", "spell", "more_spells", "prayers", "prayer", "more_prayers",
  "specials", "special", "more_specials", "eatingcauses", "eatingcause",
  "more_eatingcauses", "potion1causes", "potion1cause",
  "more_potion1causes", "scrollcauses", "scrollcause", "more_scrollcauses",
  "staffcauses", "staffcause", "more_staffcauses", "wandcauses",
  "wandcause", "more_wandcauses", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-109)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      -2,   -22,   -20,   -16,     0,    10,    45,    -2,     7,     8,
       9,    11,     5,     5,    12,    14,  -109,  -109,    10,  -109,
    -109,    -2,    -2,    -2,    -2,    18,    41,    42,    14,  -109,
      43,    44,    10,  -109,  -109,  -109,  -109,  -109,  -109,    46,
      49,    49,    48,  -109,    14,  -109,  -109,    18,  -109,    40,
      47,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      73,    74,    75,    76,    77,    50,    83,    81,  -109,    44,
      46,   -15,    52,   -21,    80,    88,    89,    90,    91,    92,
      93,    94,    95,    96,   -14,   -13,    -9,   -12,    97,   100,
     -11,   -10,    99,    -8,    -7,    -5,    -4,  -109,    49,  -109,
    -109,  -109,  -109,  -109,   102,  -109,    98,  -109,  -109,  -109,
    -109,  -109,  -109,  -109,  -109,  -109,  -109,  -109,  -109,   101,
    -109,  -109,  -109,   103,  -109,   104,  -109,  -109,   105,  -109,
     106,  -109,   107,  -109,   108,  -109,  -109,   109,  -109,   111,
    -109,  -109,  -109,  -109,  -109,   110,  -109,   112,  -109,  -109,
     114,  -109,   113,  -109,  -109,  -109,   116,  -109,   115,  -109,
    -109,   118,  -109,   117,  -109,  -109,   123,  -109,   119,  -109,
    -109,   125,  -109,   120,  -109,  -109,   -15,  -109,   128,  -109,
     -14,  -109,  -109,   -13,  -109,   129,    -9,  -109,  -109,   -12,
    -109,  -109,   -11,  -109,  -109,   -10,  -109,  -109,    -8,  -109,
    -109,    -7,  -109,  -109,    -5,  -109,  -109,    -4,  -109,    98,
    -109,   104,   106,  -109,   108,   111,   112,   113,   115,   117,
     119,   120,  -109,  -109,  -109,  -109,  -109,  -109,  -109,  -109,
    -109,  -109,  -109
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       7,     0,     0,     0,     0,     0,     0,     7,     0,     0,
       0,     0,    21,    21,     0,     0,    10,     8,    12,     1,
       6,     7,     7,     7,     7,    23,     0,     0,     0,    16,
       0,    18,    12,     9,     5,     4,     2,     3,    22,    25,
      28,    28,     0,    13,     0,    15,    11,    23,    20,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    14,    18,
      25,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    19,    28,    26,
      17,    24,    91,    89,     0,    50,    93,    63,    44,    36,
      35,    40,    31,    41,    42,    38,    39,    34,    37,     0,
      29,    85,    83,     0,    52,    87,    79,    77,     0,    51,
      81,    59,    57,    43,    61,    73,    71,     0,    54,    75,
      33,    62,    55,    97,    95,     0,    45,    99,    67,    65,
       0,    53,    69,    32,   103,   101,     0,    46,   105,   109,
     107,     0,    47,   111,   121,   119,     0,    49,   123,   115,
     113,     0,    48,   117,    27,    90,     0,    88,     0,    84,
       0,    82,    78,     0,    76,     0,     0,    56,    72,     0,
      70,    96,     0,    94,    66,     0,    64,   102,     0,   100,
     108,     0,   106,   120,     0,   118,   114,     0,   112,    93,
      30,    87,    81,    58,    61,    75,    99,    69,   105,   111,
     123,   117,    92,    86,    80,    60,    74,    98,    68,   104,
     110,   122,   116
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -109,    72,  -109,  -109,   133,   134,  -109,  -109,   139,   124,
      82,  -109,   127,   122,   121,  -109,   -41,  -109,  -109,  -108,
     -82,  -109,  -109,  -109,   -60,   -57,  -109,   -28,   -53,  -109,
     -19,   -49,  -109,    -6,   -46,  -109,    -3,   -43,  -109,   -25,
     -48,  -109,   -29,   -47,  -109,   -31,   -44,  -109,   -35,   -45,
    -109,   -27,   -42
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_uint8 yydefgoto[] =
{
       0,     6,     7,    17,    32,    33,     8,     9,    30,    31,
      45,    10,    26,    39,    48,    11,    75,    76,   143,   144,
     197,   152,   118,   161,   162,   206,   148,   149,   200,   139,
     140,   194,   134,   135,   191,   115,   116,   187,   156,   157,
     203,   167,   168,   209,   172,   173,   212,   182,   183,   218,
     177,   178,   215
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_uint8 yytable[] =
{
      77,     1,     2,   112,   131,   136,   145,   153,   158,   141,
     164,   169,    12,   174,   179,   119,   120,    13,    14,   113,
     132,   137,   146,   154,   159,   142,   165,   170,     3,   175,
     180,     4,   114,   133,   138,   147,   155,   160,     5,   166,
     171,    15,   176,   181,    16,    19,    21,    22,    23,    25,
      24,    29,    38,    28,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,   184,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    20,
      73,    74,    40,    41,    81,    43,   117,    44,   224,    47,
      78,    82,   107,    34,    35,    36,    37,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   121,   102,   103,   104,
     105,   106,   108,   109,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   150,   151,   163,   185,   189,    18,   192,
      27,   186,   235,   198,   201,   227,   188,   190,   204,   193,
     207,   196,   210,   195,   199,   202,   205,   213,   208,   216,
     211,   110,   214,   217,   220,   223,    46,    42,    79,    80,
     238,   225,   236,   234,   222,   233,   232,   226,   237,   228,
     229,   239,   231,   219,   221,   240,   242,   230,   241,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   111
};

static const yytype_int16 yycheck[] =
{
      41,     3,     4,    18,    18,    18,    18,    18,    18,    18,
      18,    18,    34,    18,    18,    36,    37,    37,    34,    34,
      34,    34,    34,    34,    34,    34,    34,    34,    30,    34,
      34,    33,    47,    47,    47,    47,    47,    47,    40,    47,
      47,    41,    47,    47,    34,     0,    39,    39,    39,    44,
      39,    37,    34,    41,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,   108,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,     7,
      31,    32,    41,    41,    44,    42,    34,    43,   196,    43,
      42,    44,    42,    21,    22,    23,    24,    44,    44,    44,
      44,    44,    44,    44,    44,    44,    44,    44,    44,    44,
      44,    44,    44,    44,    44,    44,    36,    44,    44,    44,
      44,    44,    39,    42,    36,    36,    36,    36,    36,    36,
      36,    36,    36,    36,    34,    36,    34,    34,     5,    34,
      13,    43,   224,    34,    34,   205,    45,    43,    34,    43,
      34,    43,    34,    46,    43,    43,    43,    34,    43,    34,
      43,    79,    43,    43,    36,    36,    32,    28,    44,    47,
     227,   199,   225,   222,   193,   221,   219,   202,   226,   208,
     211,   228,   217,   186,   190,   229,   231,   214,   230,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    80
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,     4,    30,    33,    40,    49,    50,    54,    55,
      59,    63,    34,    37,    34,    41,    34,    51,    52,     0,
      49,    39,    39,    39,    39,    44,    60,    60,    41,    37,
      56,    57,    52,    53,    49,    49,    49,    49,    34,    61,
      41,    41,    56,    42,    43,    58,    53,    43,    62,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    31,    32,    64,    65,    64,    42,    57,
      61,    44,    44,    44,    44,    44,    44,    44,    44,    44,
      44,    44,    44,    44,    44,    44,    44,    44,    44,    44,
      44,    44,    44,    44,    44,    44,    44,    42,    39,    42,
      58,    62,    18,    34,    47,    83,    84,    34,    70,    36,
      37,    36,    36,    36,    36,    36,    36,    36,    36,    36,
      36,    18,    34,    47,    80,    81,    18,    34,    47,    77,
      78,    18,    34,    66,    67,    18,    34,    47,    74,    75,
      36,    34,    69,    18,    34,    47,    86,    87,    18,    34,
      47,    71,    72,    36,    18,    34,    47,    89,    90,    18,
      34,    47,    92,    93,    18,    34,    47,    98,    99,    18,
      34,    47,    95,    96,    64,    34,    43,    85,    45,    34,
      43,    82,    34,    43,    79,    46,    43,    68,    34,    43,
      76,    34,    43,    88,    34,    43,    73,    34,    43,    91,
      34,    43,    94,    34,    43,   100,    34,    43,    97,    84,
      36,    81,    78,    36,    67,    75,    87,    72,    90,    93,
      99,    96,    85,    82,    79,    68,    76,    88,    73,    91,
      94,   100,    97
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    48,    49,    49,    49,    49,    49,    49,    50,    51,
      52,    53,    53,    54,    55,    56,    57,    58,    58,    59,
      60,    60,    61,    61,    62,    62,    63,    64,    64,    65,
      65,    65,    65,    65,    65,    65,    65,    65,    65,    65,
      65,    65,    65,    65,    65,    65,    65,    65,    65,    65,
      65,    65,    65,    65,    65,    65,    66,    67,    67,    67,
      68,    68,    69,    70,    71,    72,    72,    72,    73,    73,
      74,    75,    75,    75,    76,    76,    77,    78,    78,    78,
      79,    79,    80,    81,    81,    81,    82,    82,    83,    84,
      84,    84,    85,    85,    86,    87,    87,    87,    88,    88,
      89,    90,    90,    90,    91,    91,    92,    93,    93,    93,
      94,    94,    95,    96,    96,    96,    97,    97,    98,    99,
      99,    99,   100,   100
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     3,     3,     3,     3,     2,     0,     2,     2,
       1,     2,     0,     4,     5,     2,     1,     3,     0,     6,
       3,     0,     1,     0,     3,     0,     6,     3,     0,     3,
       5,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     1,     3,     1,
       3,     0,     1,     1,     2,     1,     2,     1,     3,     0,
       2,     1,     2,     1,     3,     0,     2,     1,     2,     1,
       3,     0,     2,     1,     2,     1,     3,     0,     2,     1,
       2,     1,     3,     0,     2,     1,     2,     1,     3,     0,
       2,     1,     2,     1,     3,     0,     2,     1,     2,     1,
       3,     0,     2,     1,     2,     1,     3,     0,     2,     1,
       2,     1,     3,     0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 8: /* comment_def: '#' comments  */
#line 710 "treasure.y"
                        {/*don't do anything*/;}
#line 2085 "treasure.c"
    break;

  case 10: /* comment: IDENTIFIER  */
#line 717 "treasure.y"
                        {/* don't do anything with it*/;}
#line 2091 "treasure.c"
    break;

  case 13: /* syllables_def: SYLLABLES '{' adjectives '}'  */
#line 725 "treasure.y"
                                { PutSyllables (); }
#line 2097 "treasure.c"
    break;

  case 14: /* unidentified_def: UNIDENTIFIED IDENTIFIER '{' adjectives '}'  */
#line 729 "treasure.y"
                                { PutAdjectives ((yyvsp[-3].sval)); }
#line 2103 "treasure.c"
    break;

  case 16: /* adjective: STRING_LIT  */
#line 736 "treasure.y"
                                { AddAdjective ((yyvsp[0].sval)); }
#line 2109 "treasure.c"
    break;

  case 19: /* class_def: CLASS IDENTIFIER parent_classes '{' features '}'  */
#line 744 "treasure.y"
                                { PutClassTemplate((yyvsp[-4].sval), &tmpTemplate); 
  				  tmpTemplate = blankTemplate; }
#line 2116 "treasure.c"
    break;

  case 21: /* parent_classes: %empty  */
#line 750 "treasure.y"
                        { tmpTemplate = blankTemplate; }
#line 2122 "treasure.c"
    break;

  case 22: /* parent_class: IDENTIFIER  */
#line 754 "treasure.y"
                                { MergeClassTemplate ((yyvsp[0].sval), &tmpTemplate); }
#line 2128 "treasure.c"
    break;

  case 23: /* parent_class: %empty  */
#line 756 "treasure.y"
                                { tmpTemplate = blankTemplate; }
#line 2134 "treasure.c"
    break;

  case 26: /* treasure_def: TREASURE STRING_LIT parent_classes '{' features '}'  */
#line 766 "treasure.y"
                                { 
                                  tmpTemplate.id = xasprintf("%06d", 
                                                             treasureCt);
                                  tmpTemplate.val.name = xasprintf("%s", 
                                                                   (yyvsp[-4].sval));
				  PutTreasure (tmpTemplate.id, &tmpTemplate,
					      arguments.tc.consistency_check);
				  tmpTemplate = blankTemplate;
                                  treasureCt++;
				}
#line 2149 "treasure.c"
    break;

  case 29: /* feature: LEVEL ':' INT_LIT  */
#line 783 "treasure.y"
                                { tmpTemplate.val.level = (yyvsp[0].ival);
				  tmpTemplate.def.level = TRUE; }
#line 2156 "treasure.c"
    break;

  case 30: /* feature: DAMAGE ':' INT_LIT '|' INT_LIT  */
#line 786 "treasure.y"
                                { tmpTemplate.val.damage[0] = (yyvsp[-2].ival);
				  tmpTemplate.val.damage[1] = (yyvsp[0].ival);
				  tmpTemplate.def.damage = TRUE; }
#line 2164 "treasure.c"
    break;

  case 31: /* feature: COST ':' INT_LIT  */
#line 790 "treasure.y"
                                { tmpTemplate.val.cost = (yyvsp[0].ival);
				  tmpTemplate.def.cost = TRUE; }
#line 2171 "treasure.c"
    break;

  case 32: /* feature: RELSUBVAL ':' INT_LIT  */
#line 792 "treasure.y"
                                              { AddRelativeSubval ((yyvsp[0].ival)); }
#line 2177 "treasure.c"
    break;

  case 33: /* feature: SUBVAL ':' INT_LIT  */
#line 794 "treasure.y"
                                { tmpTemplate.val.subval = (yyvsp[0].ival);
				  tmpTemplate.def.subval = TRUE; }
#line 2184 "treasure.c"
    break;

  case 34: /* feature: AC ':' INT_LIT  */
#line 797 "treasure.y"
                                { tmpTemplate.val.ac = (yyvsp[0].ival);
				  tmpTemplate.def.ac = TRUE; }
#line 2191 "treasure.c"
    break;

  case 35: /* feature: TCHAR ':' STRING_LIT  */
#line 800 "treasure.y"
                                { tmpTemplate.val.tchar = (yyvsp[0].sval)[0];
				  tmpTemplate.def.tchar = TRUE; }
#line 2198 "treasure.c"
    break;

  case 36: /* feature: TCHAR ':' INT_LIT  */
#line 803 "treasure.y"
                                { tmpTemplate.val.tchar = (yyvsp[0].ival); //XXX
				  tmpTemplate.def.tchar = TRUE; }
#line 2205 "treasure.c"
    break;

  case 37: /* feature: TO_AC ':' INT_LIT  */
#line 806 "treasure.y"
                                { tmpTemplate.val.toac = (yyvsp[0].ival);
				  tmpTemplate.def.toac = TRUE; }
#line 2212 "treasure.c"
    break;

  case 38: /* feature: TO_HIT ':' INT_LIT  */
#line 809 "treasure.y"
                                { tmpTemplate.val.tohit = (yyvsp[0].ival);
				  tmpTemplate.def.tohit = TRUE; }
#line 2219 "treasure.c"
    break;

  case 39: /* feature: TO_DAM ':' INT_LIT  */
#line 812 "treasure.y"
                                { tmpTemplate.val.todam = (yyvsp[0].ival);
				  tmpTemplate.def.todam = TRUE; }
#line 2226 "treasure.c"
    break;

  case 40: /* feature: P1 ':' INT_LIT  */
#line 815 "treasure.y"
                                { tmpTemplate.val.p1 = (yyvsp[0].ival);
				  tmpTemplate.def.p1 = TRUE; }
#line 2233 "treasure.c"
    break;

  case 41: /* feature: NUMBER ':' INT_LIT  */
#line 818 "treasure.y"
                                { tmpTemplate.val.number = (yyvsp[0].ival);
				  tmpTemplate.def.number = TRUE; }
#line 2240 "treasure.c"
    break;

  case 42: /* feature: WEIGHT ':' INT_LIT  */
#line 821 "treasure.y"
                                { tmpTemplate.val.weight = (yyvsp[0].ival);
				  tmpTemplate.def.weight = TRUE; }
#line 2247 "treasure.c"
    break;

  case 57: /* buy_flag: IDENTIFIER  */
#line 841 "treasure.y"
                                   { AddBuyableFlag ((yyvsp[0].sval), 1); }
#line 2253 "treasure.c"
    break;

  case 58: /* buy_flag: IDENTIFIER '*' INT_LIT  */
#line 843 "treasure.y"
                                { AddBuyableFlag ((yyvsp[-2].sval), (yyvsp[0].ival)); }
#line 2259 "treasure.c"
    break;

  case 62: /* unique_functions: IDENTIFIER  */
#line 851 "treasure.y"
                                   { AddUniqueFunction ((yyvsp[0].sval)); }
#line 2265 "treasure.c"
    break;

  case 63: /* tval: IDENTIFIER  */
#line 854 "treasure.y"
                                   { AddTVal ((yyvsp[0].sval)); }
#line 2271 "treasure.c"
    break;

  case 65: /* carry: IDENTIFIER  */
#line 860 "treasure.y"
                                   { AddContainsFlag ((yyvsp[0].sval)); }
#line 2277 "treasure.c"
    break;

  case 66: /* carry: '~' IDENTIFIER  */
#line 861 "treasure.y"
                                       { NegContainsFlag ((yyvsp[0].sval)); }
#line 2283 "treasure.c"
    break;

  case 67: /* carry: NONE  */
#line 862 "treasure.y"
                             { tmpTemplate.def.special = TRUE; }
#line 2289 "treasure.c"
    break;

  case 71: /* stack_flag: IDENTIFIER  */
#line 872 "treasure.y"
                                   { AddStackableFlag ((yyvsp[0].sval)); }
#line 2295 "treasure.c"
    break;

  case 72: /* stack_flag: '~' IDENTIFIER  */
#line 873 "treasure.y"
                                       { NegStackableFlag ((yyvsp[0].sval)); }
#line 2301 "treasure.c"
    break;

  case 77: /* spell: IDENTIFIER  */
#line 884 "treasure.y"
                                   { AddSpell ((yyvsp[0].sval)); }
#line 2307 "treasure.c"
    break;

  case 78: /* spell: '~' IDENTIFIER  */
#line 885 "treasure.y"
                                       { NegSpell ((yyvsp[0].sval)); }
#line 2313 "treasure.c"
    break;

  case 83: /* prayer: IDENTIFIER  */
#line 896 "treasure.y"
                                   { AddPrayer ((yyvsp[0].sval)); }
#line 2319 "treasure.c"
    break;

  case 84: /* prayer: '~' IDENTIFIER  */
#line 897 "treasure.y"
                                       { NegPrayer ((yyvsp[0].sval)); }
#line 2325 "treasure.c"
    break;

  case 89: /* special: IDENTIFIER  */
#line 908 "treasure.y"
                                   { AddSpecial ((yyvsp[0].sval)); }
#line 2331 "treasure.c"
    break;

  case 90: /* special: '~' IDENTIFIER  */
#line 909 "treasure.y"
                                       { NegSpecial ((yyvsp[0].sval)); }
#line 2337 "treasure.c"
    break;

  case 95: /* eatingcause: IDENTIFIER  */
#line 920 "treasure.y"
                                   { AddEatingFlag ((yyvsp[0].sval)); }
#line 2343 "treasure.c"
    break;

  case 96: /* eatingcause: '~' IDENTIFIER  */
#line 921 "treasure.y"
                                       { NegEatingFlag ((yyvsp[0].sval)); }
#line 2349 "treasure.c"
    break;

  case 101: /* potion1cause: IDENTIFIER  */
#line 932 "treasure.y"
                                   { AddPotionFlag ((yyvsp[0].sval)); }
#line 2355 "treasure.c"
    break;

  case 102: /* potion1cause: '~' IDENTIFIER  */
#line 933 "treasure.y"
                                       { NegPotionFlag ((yyvsp[0].sval)); }
#line 2361 "treasure.c"
    break;

  case 107: /* scrollcause: IDENTIFIER  */
#line 944 "treasure.y"
                                   { AddScrollFlag ((yyvsp[0].sval)); }
#line 2367 "treasure.c"
    break;

  case 108: /* scrollcause: '~' IDENTIFIER  */
#line 945 "treasure.y"
                                       { NegScrollFlag ((yyvsp[0].sval)); }
#line 2373 "treasure.c"
    break;

  case 113: /* staffcause: IDENTIFIER  */
#line 956 "treasure.y"
                                   { AddStaffFlag ((yyvsp[0].sval)); }
#line 2379 "treasure.c"
    break;

  case 114: /* staffcause: '~' IDENTIFIER  */
#line 957 "treasure.y"
                                       { NegStaffFlag ((yyvsp[0].sval)); }
#line 2385 "treasure.c"
    break;

  case 119: /* wandcause: IDENTIFIER  */
#line 968 "treasure.y"
                                   { AddWandFlag ((yyvsp[0].sval)); }
#line 2391 "treasure.c"
    break;

  case 120: /* wandcause: '~' IDENTIFIER  */
#line 969 "treasure.y"
                                       { NegWandFlag ((yyvsp[0].sval)); }
#line 2397 "treasure.c"
    break;


#line 2401 "treasure.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 976 "treasure.y"




/*
 * MyFGetC--
 *	fgetc with support for comments
 *
 *	# is the comment character.  comment lasts till end of line.
 * Spews out an extra char of whitespace at EOF since something seems to
 * need it.  I'll figure this out eventually...
 */
static int 
MyFGetC (FILE *input_F)
{
  while (!*inputBufp || (*inputBufp == '#')) 
    {
      (void) fgets (inputBuf, INPUT_BUF_SIZE, input_F);
      if (feof (input_F))
	return EOF;
      lineNo++;
      inputBufp = inputBuf;
    }
  return *inputBufp++;
}



/*
 * Advance--
 *	Advance to the next token in the input stream and set tokStr,
 * tokType.
 *
 *	On error, tokType is set to a negative value.
 */
static void 
Advance (FILE *input_F)
{
  register char *tok = tokStr;	/* accumulating token string		    */
  register int len = 0;		/* length of current token		    */
  static int c = 32;		/* current character; ' ' is harmless init  */


  /*
   * Skip whitespace in the stream
   */
  while ((c != EOF) && isspace (c))
    c = MyFGetC (input_F);

  /*
   * At end of file?
   */
  if (c == EOF) 
    {
      tokType = EOF;
      strcpy (tokStr, "[EOF]");
      return;
    }

  /*
   * Recognize a number [+|-][dddd][.][dddd][{e|E}[+|-]dddd]
   */
  if (isdigit (c) || (c == '.') || (c == '+') || (c == '-')) 
    {
      register int decPt = FALSE,   /* seen a decimal point yet?	*/
	       hasExp = FALSE;	    /* has an exponent?			*/

      if ((c == '-') || (c == '+')) 
	{
	  *tok++ = c;
	  c = MyFGetC (input_F);
	}

      while ((len < MAX_TOK_LEN - 1) && (isdigit (c) || (c == '.'))) 
	{
	  if (c == '.') 
	    {
	      if (decPt)
		break;
	      else
		decPt = TRUE;
	    }

	  *tok++ = c;
	  c = MyFGetC (input_F);
	  len++;
	}

      if ((c == 'e') || (c == 'E')) 
	{
	  hasExp = TRUE;
	  *tok++ = c;
	  c = MyFGetC (input_F);
	  len++;

	  if ((c == '-') || (c == '+')) 
	    {
	      *tok++ = c;
	      c = MyFGetC (input_F);
	      len++;
	    }

	  while ((len < MAX_TOK_LEN - 1) && isdigit (c)) 
	    {
	      *tok++ = c;
	      c = MyFGetC (input_F);
	      len++;
	    }
	}

      *tok = 0;

      if (decPt || hasExp) 
	{
	  tokType = FLOAT_LIT;
	  yylval.dval = atof (tokStr);
	} 
      else 
	{
	  tokType = INT_LIT;
	  yylval.ival = atoi (tokStr);
	}

      return;

    }

  /*
   * Recognize a quoted string
   */
  if (c == '\"') 
    {

      c = MyFGetC (input_F);

      while ((len < MAX_TOK_LEN - 1) &&
	     (c != EOF) && (c != '\n') && (c != '\"')) 
	{
	  *tok++ = c;
	  c = MyFGetC (input_F);
	}

      *tok = 0;

      c = MyFGetC (input_F);

      tokType = STRING_LIT;
      strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
      yylval.sval[MAX_TOK_LEN - 1] = 0;

      return;

    }

  /*
   * Recognize an identifier and try to match it with a keyword.
   * Identifiers begin with a letter and continue in letters and/or
   * digits.  Convert it to lowercase.
   */
  if (isalpha (c) || (c == '_') || (c == '$')) {

    if (isupper (c))
      c = tolower (c);
    *tok++ = c;
    c = MyFGetC (input_F);
    len++;

    while ((len < MAX_TOK_LEN - 1) && (isalpha (c) || isdigit (c) ||
				       (c == '_') || (c == '$'))) 
      {
	if (isupper (c))
	  c = tolower (c);
	*tok++ = c;
	c = MyFGetC (input_F);
	len++;
      }

    *tok = 0;

    /*
     * We've got the identifier; see if it matches any keywords.
     */

      {
	generic_t gval;
	int type;
	if (St_GetSym (keywordT_P, tokStr, &type, &gval) == ST_SYM_FOUND) 
	  {
	    tokType = gval.i;
	    strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
	    yylval.sval[MAX_TOK_LEN - 1] = 0;
	  } 
	else if (!strcmp (tokStr, "true")) 
	  {
	    tokType = BOOL_LIT;
	    yylval.ival = 1;
	  } 
	else if (!strcmp (tokStr, "false")) 
	  {
	    tokType = BOOL_LIT;
	    yylval.ival = 0;
	  } 
	else 
	  {
	    tokType = IDENTIFIER;
	    strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
	    yylval.sval[MAX_TOK_LEN - 1] = 0;
	  }
      }

    return;

  }

  /*
   * Recognize punctuation
   */

  tokType = c;
  *tok++ = c;
  *tok = 0;
  c = MyFGetC (input_F);
  return;
}

void 
ErrMsg (char *s)
{
  int i;

  fprintf (stderr, "Error: %s at line %d\n", s, lineNo);
  fprintf (stderr, "%s", inputBuf);
  for (i = 0; i < inputBufp - inputBuf; i++) 
    {
      fputc ((inputBuf[i] == '\t' ? '\t' : ' '), stderr);
    }
  fprintf (stderr, "^ before here\n\n");
  return;
}

int 
yyerror (char *s)
{
  ErrMsg (s);
  return 0;
}


int 
yylex ()
{
  Advance (input_F);
  return tokType;
}

unsigned int
lookup_flag (char *kind, char *f)
{
  char *flags;
  generic_t gval;
  int retval = 0;
  char *s;
  int type;
  char s1[256];
  static st_Table_Pt table;
  int negate = 0;

  if (strcmp (kind, "specials") == 0)
    table = specialT_P;
  else if (strcmp (kind, "spells") == 0)
    table = spellsT_P;
  else if (strcmp (kind, "prayers") == 0)
    table = prayersT_P;
  else if (strcmp (kind, "contains") == 0)
    table = containsT_P;
  else if (strcmp (kind, "eatingcauses") == 0)
    table = eatingcausesT_P;
  else
    return -1;

  flags = strdup (f);
  for (s = strtok (flags, ", "); s != NULL; s = strtok (NULL, ", "))
    {
      negate = 0;
      if (s[0] == '~')
	{
	  negate = 1;
	  s++;
	}
      if (St_GetSym (table, s, &type, &gval) != ST_SYM_FOUND) 
	{
	  sprintf (s1, "unknown %s '%s' (in internal code)", kind, s);
	  ErrMsg (s1);
	} 
      else
	{
	  if (negate)
	    retval &= ~(1 << gval.i);
	  else
	    retval |= (1 << gval.i);
	}
    }
  free (flags);
  return retval;
}

void
AddUniqueFunction (char *s)
{
  char s1[256];
  int type;
  generic_t gval;

  if (St_GetSym (uniqfuncT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown unique_function '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      switch (gval.i)
        {
        case UNIQ_CHEST_RUINED:
          if (tmpTemplate.val.tval != TV_CHEST)
            {
              sprintf (s1, "only a chest can be ruined");
              ErrMsg (s1);
              return;
            }
          break;
        case UNIQ_WIZARD_OBJECT:
          if (tmpTemplate.val.tval != TV_NOTHING)
            {
              sprintf (s1, "only a nothing can be a wizard object");
              ErrMsg (s1);
              return;
            }
          break;
        case UNIQ_SCARE_MONSTER:
          if (tmpTemplate.val.tval != TV_VIS_TRAP)
            {
              sprintf (s1, "only a visible trap can scare a monster");
              ErrMsg (s1);
              return;
            }
          break;
        case UNIQ_CREATED_BY_SPELL:
          if (tmpTemplate.val.tval != TV_FOOD)
            {
              sprintf (s1, "only a foodstuff can be created by the "
                           "create_food spell");
              ErrMsg (s1);
              return;
            }
          break;
        default:
          break;
        }
      tmpTemplate.state.unique_function = gval.i;
      tmpTemplate.def.unique_function = TRUE;
    }
  return;
}

char *
argz_copy (char *argz, size_t argz_len)
{
  char *new_argz = NULL;
  size_t new_argz_len = 0;
  char *entry = NULL;
  while ((entry = argz_next (argz, argz_len, entry)))
    argz_add (&new_argz, &new_argz_len, entry);
  return new_argz;
}

void
PutSyllables ()
{
  if (syllables_argz)
    free (syllables_argz);
  syllables_argz = argz_copy (adjective_argz, adjective_argz_len);
  syllables_argz_len = adjective_argz_len;
}

void
PutAdjectives (char *s)
{
  char s1[256];
  int type;
  generic_t gval;
  if (St_GetSym (tvalT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown TVal '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      int found = 0;
      switch (gval.i)
        {
          case TV_POTION1:
            if (potion_adjectives_argz)
              free (potion_adjectives_argz);
            potion_adjectives_argz = argz_copy (adjective_argz, 
                                                adjective_argz_len);
            potion_adjectives_argz_len = adjective_argz_len;
            found = 1;
            break;
          case TV_WAND:
            if (wand_adjectives_argz)
              free (wand_adjectives_argz);
            wand_adjectives_argz = argz_copy (adjective_argz, 
                                              adjective_argz_len);
            wand_adjectives_argz_len = adjective_argz_len;
            found = 1;
            break;
          case TV_AMULET:
            if (amulet_adjectives_argz)
              free (amulet_adjectives_argz);
            amulet_adjectives_argz = argz_copy (adjective_argz,
                                                adjective_argz_len);
            amulet_adjectives_argz_len = adjective_argz_len;
            found = 1;
            break;
          case TV_STAFF:
            if (staff_adjectives_argz)
              free (staff_adjectives_argz);
            staff_adjectives_argz = argz_copy (adjective_argz,
                                               adjective_argz_len);
            staff_adjectives_argz_len = adjective_argz_len;
            found = 1;
            break;
          case TV_RING:
            if (ring_adjectives_argz)
              free (ring_adjectives_argz);
            ring_adjectives_argz = argz_copy (adjective_argz,
                                              adjective_argz_len);
            ring_adjectives_argz_len = adjective_argz_len;
            found = 1;
            break;
          case TV_FOOD:
            if (strcmp (s, "mushroom") != 0)
              found = 0;
            else
              {
                if (mushroom_adjectives_argz)
                  free (mushroom_adjectives_argz);
                mushroom_adjectives_argz = argz_copy (adjective_argz,
                                                      adjective_argz_len);
                mushroom_adjectives_argz_len = adjective_argz_len;
                found = 1;
              }
            break;
          default:
            found = 0;
            break;
        }
      if (!found)
        {
          sprintf (s1, "The `unidentified' keyword cannot be used with '%s' "
                   "objects", s);
          ErrMsg (s1);
        }
      else
        {
          free (adjective_argz);
          adjective_argz = NULL;
          adjective_argz_len = 0;
        }
    }
  return;
}

void
show_adjective_list (char *argz, size_t argz_len, FILE *stream)
{
  size_t length = 0;
  char *entry = NULL;
  int first = 1;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      length += strlen (entry) + 4;
      if (length > 80)
        {
          length = strlen (entry) + 4;
          first = 1;
          fprintf (stream, "\n");
        }
      if (first)
        {
          fprintf (stream, "  ");
          first = 0;
          length += 2;
        }
      fprintf (stream, "\"%s\", ", entry);
    }
}

void
AddAdjective (char *s)
{
  argz_add (&adjective_argz, &adjective_argz_len, s);
  return;
}

void
AddTVal (char *s)
{
  char s1[256];
  int type;
  generic_t gval;

  if (St_GetSym (tvalT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown TVal '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.tval = gval.i;
      tmpTemplate.def.tval = TRUE;
      if (strcmp (s, "mushroom") == 0)
        {
          tmpTemplate.state.mushroom_flag = 1;
          tmpTemplate.def.mushroom_flag = TRUE;
        }
    }
  return;
}

void 
AddContainsFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (tmpTemplate.val.tval != TV_CHEST)
  {
      sprintf (s1, "this kind of object can't contain things");
      ErrMsg (s1);
      return;
  }
  if (St_GetSym (containsT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown container flag '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.flags |= (1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}


void 
NegContainsFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (tmpTemplate.val.tval != TV_CHEST)
  {
      sprintf (s1, "this kind of object can't contain things");
      ErrMsg (s1);
      return;
  }
  if (St_GetSym (containsT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown container flag '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.flags &= ~(1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void AddSpecial(char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (specialT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown special '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.flags |= (1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}
void
NegSpecial (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (specialT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown special '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.flags &= ~(1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void AddBuyableFlag(char *s, int freq)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (buyableT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown buyable flag '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      if (gval.i == 6) 
	{
	  /* not found in the dungeon, only in stores */
	  tmpTemplate.state.store_only = 1;
	  tmpTemplate.def.store_only = TRUE;
	}
      else
	{
	  tmpTemplate.state.buyable_freq[gval.i] = freq;
	  tmpTemplate.state.buyable |= (1 << gval.i);
	  tmpTemplate.def.buyable = TRUE;
	}
    }
  return;
}

void AddRelativeSubval(int id)
{
  tmpTemplate.state.stackable_id = id;
  tmpTemplate.def.stackable_id = TRUE;
}

void AddStackableFlag(char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (stackableT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown stackable flag '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.state.stackable |= (1 << gval.i);
      tmpTemplate.def.stackable = TRUE;
    }
  return;
}
void
NegStackableFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (stackableT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown stackable flag '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.state.stackable &= ~(1 << gval.i);
      tmpTemplate.def.stackable = TRUE;
    }
  return;
}

void AddSpell(char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (tmpTemplate.val.tval != TV_MAGIC_BOOK)
    {
      sprintf (s1, "This kind of object cannot contain spells");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (spellsT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown spell '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.flags |= (1 << gval.i);
      tmpTemplate.val.spells[gval.i] = 1;
      tmpTemplate.def.special = TRUE;
    }
  return;
}
void
NegSpell (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (tmpTemplate.val.tval != TV_MAGIC_BOOK)
    {
      sprintf (s1, "This kind of object cannot contain spells");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (spellsT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown spell '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.flags &= ~(1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}


void AddPrayer (char *s)
{
  generic_t gval;
  int type;
  char s1[256];
  if (tmpTemplate.val.tval != TV_PRAYER_BOOK)
    {
      sprintf (s1, "This kind of object cannot contain prayers");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (prayersT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown prayer '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.flags |= (1 << gval.i);
      tmpTemplate.val.spells[gval.i] = 1;
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void
NegPrayer (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (tmpTemplate.val.tval != TV_PRAYER_BOOK)
    {
      sprintf (s1, "This kind of object cannot contain prayers");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (prayersT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown prayer '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.flags &= ~(1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void AddEatingFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];
  if (tmpTemplate.val.tval != TV_FOOD)
    {
      sprintf (s1, "This kind of object cannot have eating effects "
                   "because it's not edible.");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (eatingcausesT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown eating effect '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.flags |= (1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void
NegEatingFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (tmpTemplate.val.tval != TV_FOOD)
    {
      sprintf (s1, "This kind of object cannot have eating effects "
                   "because it's not edible.");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (eatingcausesT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown eating effect '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.flags &= ~(1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void AddPotionFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];
  if (tmpTemplate.val.tval != TV_POTION1)
    {
      sprintf (s1, "This kind of object cannot have potion effects "
                   "because it's not of type POTION");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (potion1causesT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      if (St_GetSym (potion2causesT_P, s, &type, &gval) != ST_SYM_FOUND)
        {
          sprintf (s1, "unknown potion effect '%s'", s);
          ErrMsg (s1);
        }
      else
       {
          tmpTemplate.val.flags |= (1 << gval.i);
          tmpTemplate.def.special = TRUE;
          tmpTemplate.val.tval = TV_POTION2;
       }
    }
  else
    {
      tmpTemplate.val.flags |= (1 << gval.i);
      tmpTemplate.def.special = TRUE;
      tmpTemplate.val.tval = TV_POTION1;
    }
  return;
}

void
NegPotionFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (tmpTemplate.val.tval != TV_POTION1)
    {
      sprintf (s1, "This kind of object cannot have potion effects "
                   "because it's not of type POTION.");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (potion1causesT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      if (St_GetSym (potion2causesT_P, s, &type, &gval) != ST_SYM_FOUND)
        {
          sprintf (s1, "unknown potion effect '%s'", s);
          ErrMsg (s1);
        }
      else
       {
          tmpTemplate.val.flags &= ~(1 << gval.i);
          tmpTemplate.def.special = TRUE;
       }
    }
  else
    {
      tmpTemplate.val.flags &= ~(1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void AddScrollFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];
  if (tmpTemplate.val.tval != TV_SCROLL)
    {
      sprintf (s1, "This kind of object cannot have scroll effects "
                   "because it's not of type SCROLL.");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (scrollcausesT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown scroll effect '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.effect_idx = gval.i;
      tmpTemplate.def.special = TRUE;
      tmpTemplate.val.tval = TV_SCROLL;
    }
  return;
}

void
NegScrollFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (tmpTemplate.val.tval != TV_SCROLL)
    {
      sprintf (s1, "This kind of object cannot have scroll effects "
                   "because it's not of type SCROLL.");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (scrollcausesT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown scroll effect '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.effect_idx = 0;
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void AddStaffFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];
  if (tmpTemplate.val.tval != TV_STAFF)
    {
      sprintf (s1, "This kind of object cannot have staff effects "
                   "because it's not of type STAFF.");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (staffcausesT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown staff effect '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.effect_idx = gval.i;
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void
NegStaffFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (tmpTemplate.val.tval != TV_STAFF)
    {
      sprintf (s1, "This kind of object cannot have staff effects "
                   "because it's not of type STAFF.");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (staffcausesT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown staff effect '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.effect_idx = 0;
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void AddWandFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];
  if (tmpTemplate.val.tval != TV_WAND)
    {
      sprintf (s1, "This kind of object cannot have wand effects "
                   "because it's not of type WAND.");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (wandcausesT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown wand effect '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.effect_idx = gval.i;
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void
NegWandFlag (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (tmpTemplate.val.tval != TV_WAND)
    {
      sprintf (s1, "This kind of object cannot have wand effects "
                   "because it's not of type WAND.");
      ErrMsg (s1);
      return;
    }
  if (St_GetSym (wandcausesT_P, s, &type, &gval) != ST_SYM_FOUND)
    {
      sprintf (s1, "unknown wand effect '%s'", s);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.effect_idx = 0;
      tmpTemplate.def.special = TRUE;
    }
  return;
}

st_Table_Pt 
InitTable (char *name, symInit_t *init)
{
  int i;
  st_Table_Pt table_P;
  generic_t gval;

  table_P = St_NewTable (name, 20);
  for (i = 0; init[i].name; i++) 
    {
      gval.i = init[i].val;
      St_DefSym (table_P, init[i].name, GEN_TYPE_INT, gval);
    }

  return table_P;
}


void 
InitTables ()
{
  keywordT_P = InitTable ("keyword", keywordInit);
  specialT_P = InitTable ("specials", specialInit);
  uniqfuncT_P = InitTable ("unique_functions", uniqfuncInit);
  spellsT_P = InitTable ("spells", spellsInit);
  containsT_P = InitTable ("contains", containsInit);
  prayersT_P = InitTable ("prayers", prayersInit);
  eatingcausesT_P = InitTable ("eatingcauses", eatingcausesInit);
  potion1causesT_P = InitTable ("potion1causes", potion1causesInit);
  potion2causesT_P = InitTable ("potion2causes", potion2causesInit);
  scrollcausesT_P = InitTable ("scrollcauses", scrollcausesInit);
  staffcausesT_P = InitTable ("staffcauses", staffcausesInit);
  wandcausesT_P = InitTable ("wandcauses", wandcausesInit);
  tvalT_P = InitTable ("tvals", tvalInit);
  stackableT_P = InitTable ("stackable", stackableInit);
  buyableT_P = InitTable ("buyable", buyableInit);

  classT_P = St_NewTable ("class", 100);
  treasureT_P = St_NewTable ("treasure", 500);
  sortedtreasureT_P = St_NewTable ("sorted treasure", 500);

  return;
}

/* determine the correct TV_flag for this tval */
char *
getTValString (int tval)
{
  char *s = NULL;
  symInit_t *t;
  for (t  = &tvalInit[0]; t->name != NULL; t++)
    {
      if (tval == t->val)
        {
          char *letter;
          s = xasprintf("tv_%s", t->name);
          if (s)
            {
              for (letter = &s[0]; *letter != '\0'; letter++)
                {
                  *letter = toupper (*letter);
                }
              return s;
            }
        }
    }
  return NULL;
}

void 
WriteTreasure (sorted_template_t *tmpl_P, int count)
{
  char *tval;
  char s[256];
  strcpy (s, "\"");
  strcat (s, tmpl_P->val.name);
  strcat (s, "\"");            
  tval = getTValString (tmpl_P->val.tval);
  fprintf (arguments.tc.outfile, 
           "{%-31s,0x%08XL, %4u, %10s, '%s%c',\t/*%3d*/\n",
	   s, (unsigned int) tmpl_P->val.flags, tmpl_P->val.effect_idx, tval, tmpl_P->val.tchar == '\'' || tmpl_P->val.tchar == '\\' ? "\\" :"", tmpl_P->val.tchar, count);
  free (tval);
  fprintf (arguments.tc.outfile, 
	   "%5d,\t%4d,\t%2d,%4u,%4d,\t%1d,%4d,%3d,%4d, {%d,%d}%s,%3d",
           tmpl_P->val.p1, tmpl_P->val.cost, tmpl_P->val.subval, 
           tmpl_P->val.number, tmpl_P->val.weight, tmpl_P->val.tohit, 
           tmpl_P->val.todam, tmpl_P->val.ac, tmpl_P->val.toac, 
           tmpl_P->val.damage[0], tmpl_P->val.damage[1],
           (tmpl_P->val.damage[0] > 9 && tmpl_P->val.damage[1] > 9) ? "":"\t",
	   tmpl_P->val.level);
  if (tmpl_P->val.tval == TV_MAGIC_BOOK || tmpl_P->val.tval == TV_PRAYER_BOOK)
    {
      int i;
      fprintf (arguments.tc.outfile, ",\n  {");
      for (i = 0; i < MAX_SPELLS; i++)
        {
          fprintf (arguments.tc.outfile, "%d", tmpl_P->val.spells[i]);
          if (i != MAX_SPELLS - 1)
            fprintf (arguments.tc.outfile, ",");
        }
      fprintf (arguments.tc.outfile, "}},\n");
    }
  else
    fprintf (arguments.tc.outfile, "},\n");
  return;
}

void
AddSortedTreasure (template_t *t)
{
  generic_t gval;
  sorted_template_t *s;
  gval.v = malloc (sizeof (sorted_template_t));
  s = (sorted_template_t *) gval.v;
  memset (s, 0, sizeof (sorted_template_t));
  s->id = t->id;
  s->state = t->state;
  s->val = t->val;
  s->def = t->def;
  St_DefSym (sortedtreasureT_P, s->id, GEN_TYPE_TMPL, gval);
  return;
}

void 
SortTreasuresBy (int store, int tval)
{
  char *entry = NULL;
  char *argz = NULL;
  size_t argz_len = 0;
  int type;
  generic_t gval;
  template_t *t;
  St_SArgzTable (treasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (treasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in SortTreasuresBy\n");
          exit (1);
        }
      t = (template_t *) gval.v;
      if (t->state.store_only == store && t->val.tval == tval &&
          t->def.unique_function == FALSE)
        {
          AddSortedTreasure (t);
        }
    }
  free (argz);
}

void 
SortUniqueFunctionTreasure (int uniqfunc)
{
  char *entry = NULL;
  char *argz = NULL;
  size_t argz_len = 0;
  int type;
  generic_t gval;
  template_t *t;
  St_SArgzTable (treasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (treasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in SortUniqueFunctionTreasure\n");
          exit (1);
        }
      t = (template_t *) gval.v;
      if (t->state.unique_function == uniqfunc && 
          t->def.unique_function == TRUE)
        {
          AddSortedTreasure (t);
        }
    }
  free (argz);
}

/* Go to great lengths to order the object_list array in the same fashion
 * as the existing treasures.c file. */
void
SortTreasures ()
{
  int i;
  int not_in_stores_tvals[] = 
    {
      TV_FOOD, TV_SWORD, TV_HAFTED, TV_POLEARM, TV_BOW, TV_ARROW, TV_BOLT,
      TV_SLING_AMMO, TV_SPIKE, TV_LIGHT, TV_DIGGING, TV_BOOTS, TV_HELM,
      TV_SOFT_ARMOR, TV_HARD_ARMOR, TV_CLOAK, TV_GLOVES, TV_SHIELD, TV_RING, 
      TV_AMULET, TV_SCROLL, TV_POTION1, TV_POTION2, TV_FLASK, 
      TV_WAND, TV_STAFF, TV_MAGIC_BOOK, TV_PRAYER_BOOK, TV_CHEST, TV_MISC
    };
  int in_stores_tvals[] =
    {
      TV_FOOD, TV_SWORD, TV_HAFTED, TV_POLEARM, TV_BOW, TV_ARROW, TV_BOLT,
      TV_SLING_AMMO, TV_SPIKE, TV_DIGGING, TV_BOOTS, TV_HELM, TV_SOFT_ARMOR,
      TV_HARD_ARMOR, TV_CLOAK, TV_GLOVES, TV_SHIELD, TV_RING, TV_AMULET,
      TV_SCROLL, TV_POTION1, TV_POTION2, TV_LIGHT, TV_FLASK,
      TV_WAND, TV_STAFF, TV_MAGIC_BOOK, TV_PRAYER_BOOK, TV_CHEST, TV_MISC
    };
  int terrain_tvals[] =
   {
     TV_OPEN_DOOR, TV_CLOSED_DOOR, TV_SECRET_DOOR, TV_UP_STAIR, 
     TV_DOWN_STAIR, TV_STORE_DOOR, TV_VIS_TRAP, TV_INVIS_TRAP, TV_RUBBLE
   };
  
  for (i = 0; i < sizeof (not_in_stores_tvals) / sizeof (int); i++)
    SortTreasuresBy (!SOLD_IN_STORES, not_in_stores_tvals[i]);

  for (i = 0; i < sizeof (in_stores_tvals) / sizeof (int); i++)
    SortTreasuresBy (SOLD_IN_STORES, in_stores_tvals[i]);

  for (i = 0; i < sizeof (terrain_tvals) / sizeof (int); i++)
    SortTreasuresBy (!SOLD_IN_STORES, terrain_tvals[i]);

  SortUniqueFunctionTreasure (UNIQ_CREATED_BY_SPELL);
  SortUniqueFunctionTreasure (UNIQ_SCARE_MONSTER);
  SortTreasuresBy (!SOLD_IN_STORES, TV_GOLD);
  SortUniqueFunctionTreasure (UNIQ_INVENTORY_OBJECT);
  SortUniqueFunctionTreasure (UNIQ_CHEST_RUINED);
  SortUniqueFunctionTreasure (UNIQ_WIZARD_OBJECT);
}

void 
WriteTreasures ()
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  generic_t gval;
  int count = 0;

  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);

  fprintf (arguments.tc.outfile, "treasure_type object_list[MAX_OBJECTS] = {\n");
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in WriteTreasures\n");
          exit (1);
        }
      WriteTreasure ((sorted_template_t *) gval.v, count);
      count++;
    }

  fprintf (arguments.tc.outfile, "};\n\n");

  free (argz);
  return;
}

void 
oldWriteTreasures ()
{
  char **s_A, **sp;
  int type;
  generic_t gval;
  int count = 0;

  s_A = St_SListTable (sortedtreasureT_P);

  fprintf (arguments.tc.outfile, "treasure_type object_list[MAX_OBJECTS] = {\n");

  for (sp = s_A; *sp; sp++) 
    {
      if (St_GetSym (sortedtreasureT_P, *sp, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in WriteTreasures\n");
          exit (1);
        }
      WriteTreasure ((sorted_template_t *) gval.v, count);
      count++;
    }

  fprintf (arguments.tc.outfile, "};\n\n");

  St_SListTable (NULL);
  return;
}


void 
PutClassTemplate (char *s, template_t *tmpl_P)
{
  generic_t gval;
  char s1[256];

  gval.v = malloc (sizeof(template_t));
  *(template_t *) gval.v = *tmpl_P;

  if (St_DefSym (classT_P, s, GEN_TYPE_TMPL, gval) == ST_SYM_FOUND) 
    {
      sprintf (s1, "attempt to redefine class '%s'", s);
      ErrMsg (s1);
      free (gval.v);
      return;
    }
  return;
}


int
MergeClassTemplate (char *s, template_t *t1)
{
  template_t t2;
  t2 = GetClassTemplate (s);
  if (t2.def.special == TRUE)
    {
      t1->val.flags |= (t2.val.flags);
      t1->val.effect_idx = t2.val.effect_idx;
      t1->def.special = TRUE;
    }
  if (t2.def.damage == TRUE)
    {
      t1->val.damage[0] = t2.val.damage[0];
      t1->val.damage[1] = t2.val.damage[1];
      t1->def.damage = TRUE;
    }
  if (t2.def.cost == TRUE)
    {
      t1->val.cost = t2.val.cost;
      t1->def.cost = TRUE;
    }
  if (t2.def.subval == TRUE)
    {
      t1->val.subval = t2.val.subval;
      t1->def.subval = TRUE;
    }
  if (t2.def.weight == TRUE)
    {
      t1->val.weight = t2.val.weight;
      t1->def.weight = TRUE;
    }
  if (t2.def.number == TRUE)
    {
      t1->val.number = t2.val.number;
      t1->def.number = TRUE;
    }
  if (t2.def.tohit == TRUE)
    {
      t1->val.tohit = t2.val.tohit;
      t1->def.tohit = TRUE;
    }
  if (t2.def.todam == TRUE)
    {
      t1->val.todam = t2.val.todam;
      t1->def.todam = TRUE;
    }
  if (t2.def.toac == TRUE)
    {
      t1->val.toac = t2.val.toac;
      t1->def.toac = TRUE;
    }
  if (t2.def.ac == TRUE)
    {
      t1->val.ac = t2.val.ac;
      t1->def.ac = TRUE;
    }
  if (t2.def.p1 == TRUE)
    {
      t1->val.p1 = t2.val.p1;
      t1->def.p1 = TRUE;
    }
  if (t2.def.tchar == TRUE)
    {
      t1->val.tchar = t2.val.tchar;
      t1->def.tchar = TRUE;
    }
  if (t2.def.level == TRUE)
    {
      t1->val.level = t2.val.level;
      t1->def.level = TRUE;
    }
  if (t2.def.tval == TRUE)
    {
      t1->val.tval = t2.val.tval;
      t1->def.tval = TRUE;
    }
  if (t2.def.stackable == TRUE)
    {
      t1->state.stackable |= (t2.state.stackable);
      t1->def.stackable = TRUE;
    }
  if (t2.def.mushroom_flag == TRUE)
    {
      t1->state.mushroom_flag = t2.state.mushroom_flag;
      t1->def.mushroom_flag = TRUE;
    }
  if (t2.def.stackable_id == TRUE)
    {
      t1->state.stackable_id = t2.state.stackable_id;
      t1->def.stackable_id = TRUE;
    }
  if (t2.def.unique_function == TRUE)
    {
      t1->state.unique_function |= t2.state.unique_function;
      t1->def.unique_function = TRUE;
    }
  if (t2.def.store_only == TRUE)
    {
      t1->state.store_only = t2.state.store_only;
      t1->def.store_only = TRUE;
    }
  if (t2.def.buyable == TRUE)
    {
      int i;
      t1->state.buyable |= t2.state.buyable;
      for (i = 0; i < MAX_STORES; i++)
	t1->state.buyable_freq[i] += t2.state.buyable_freq[i];
      t1->def.buyable = TRUE;
    }

  return 0;
}

template_t 
GetClassTemplate (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (classT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "class '%s' undefined\n", s);
      ErrMsg (s1);
      return blankTemplate;
    } 
  else 
    {
      return *(template_t *) gval.v;
    }
  return blankTemplate;
}


void 
NotDefined(char *name, char *s)
{
  fprintf (stderr, "Warning: %s not defined for \"%s\", line %d\n",
	   s, name, lineNo);
  return;
}


void 
PutTreasure (char *s, template_t *tmpl_P, int consistency_check)
{
  generic_t gval;

  gval.v = malloc (sizeof(template_t));
  *(template_t *) gval.v = *tmpl_P;

  if (!tmpl_P->def.tval)
    NotDefined (tmpl_P->val.name, "TVAL");
  if (!tmpl_P->def.tchar)
    NotDefined (tmpl_P->val.name, "TCHAR");
  if (!tmpl_P->def.p1)
    NotDefined (tmpl_P->val.name, "P1");
  if (!tmpl_P->def.cost)
    NotDefined (tmpl_P->val.name, "COST");
  if (!tmpl_P->def.number)
    NotDefined (tmpl_P->val.name, "QUANTITY");
  if (!tmpl_P->def.weight)
    NotDefined (tmpl_P->val.name, "WEIGHT");
  if (!tmpl_P->def.tohit)
    NotDefined (tmpl_P->val.name, "TO_HIT");
  if (!tmpl_P->def.todam)
    NotDefined (tmpl_P->val.name, "TO_DAM");
  if (!tmpl_P->def.ac)
    NotDefined (tmpl_P->val.name, "AC");
  if (!tmpl_P->def.toac)
    NotDefined (tmpl_P->val.name, "TO_AC");
  if (!tmpl_P->def.damage)
    NotDefined (tmpl_P->val.name, "DAMAGE");
  if (!tmpl_P->def.level)
    NotDefined (tmpl_P->val.name, "LEVEL");
  if (!tmpl_P->def.stackable)
    NotDefined (tmpl_P->val.name, "STACKABLE");
  if (tmpl_P->val.tval == TV_STAFF && !tmpl_P->def.special)
    NotDefined (tmpl_P->val.name, "STAFF_CASTS");
  if (tmpl_P->val.tval == TV_SCROLL && !tmpl_P->def.special)
    NotDefined (tmpl_P->val.name, "SCROLL_CASTS");
  if (tmpl_P->val.tval == TV_WAND && !tmpl_P->def.special)
    NotDefined (tmpl_P->val.name, "WAND_CASTS");

  if (consistency_check)
    ConsistencyCheckTreasure (&tmpl_P->val, &tmpl_P->state);

  if (St_DefSym (treasureT_P, s, GEN_TYPE_TMPL, gval) == ST_SYM_FOUND) 
    {
      fprintf (arguments.tc.outfile, "Warning: redefining \"%s\", line %d\n", 
               tmpl_P->val.name, lineNo);
    }

  return;
}

int
get_max_dungeon_obj ()
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  generic_t gval;
  sorted_template_t *t;
  int retval = -1;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in get_max_dungeon_obj\n");
          exit (1);
        }
      t = (sorted_template_t *) gval.v;
      if (t->state.store_only)
        {
	  retval = atoi (t->id) - 1;
          break;
        }
    }
  free (argz);
  return retval;
}

int
count_specific_store_choices (int store)
{
  char *argz = NULL;
  size_t argz_len = 0;
  int count = 0;
  int type;
  char *entry = NULL;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err in count_specific_store_choices\n");
          exit (1);
        }
      t = (sorted_template_t *) gval.v;
      count += t->state.buyable_freq[store];
    }
  return count;
}

int
count_store_choices(int bail)
{
  int store_choices[MAX_STORES];
  int i;
  int warn = 0;
  memset (store_choices, 0, sizeof (store_choices));
  for (i = 0; i < MAX_STORES; i++)
    {
      store_choices[i] = count_specific_store_choices (i);
      if (i > 0)
	{
	  if (store_choices[i] != store_choices[i-1])
	    warn = 1;
	}
    }
  if (warn && bail)
    {
      fprintf(stderr, "Error: There must be an equal number of "
	      "choices per store!\n");
      for (i = 0; i < MAX_STORES; i++)
	{
	  fprintf (stderr, "\tStore `%d': %d choices\n", i + 1, 
		   store_choices[i]);
	}
      exit(1);
    }
  return store_choices[0];
}

int
count_obj_with_tval_and_subvals (int tval, int subval)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int count = 0;
  int type;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err in count_obj_with_tval_and_subvals\n");
          exit (1);
        }
      t = (sorted_template_t *) gval.v;
      if (t->val.tval == tval && t->val.subval == subval)
	count++;
    }
  free (argz);
  return count;
}

int
count_obj_with_tval (int tval)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int count = 0;
  int type;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in count_obj_with_tval\n");
          exit (1);
        }
      t = (sorted_template_t *) gval.v;
      if (t->val.tval == tval)
        count++;
    }
  free (argz);
  return count;
}

int
get_obj_with_tval (int tval)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int retval = -1;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in get_obj_with_tval\n");
          exit (1);
        }
      t = (sorted_template_t *) gval.v;
      if (t->val.tval == tval)
        {
	  retval = atoi (t->id);
          break;
        }
    }
  free (argz);
  return retval;
}

int
get_obj_with_uniq (int uniq)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int retval = -1;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in get_obj_with_uniq\n");
          exit (1);
        }
      t = (sorted_template_t *) gval.v;
      if (t->state.unique_function == uniq && t->def.unique_function == TRUE)
        {
	  retval = atoi (t->id);
          break;
        }
    }
  return retval;
}

int
get_subval_with_uniq (int uniq)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int retval = -1;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in get_obj_with_uniq\n");
          exit (1);
        }
      t = (sorted_template_t *) gval.v;
      if (t->state.unique_function == uniq && t->def.unique_function == TRUE)
        {
	  retval = t->val.subval;
          break;
        }
    }
  return retval;
}

int get_highest_subval_of_obj_with_tval (int tval)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int max = 0;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in "
		   "get_highest_subval_of_obj_with_tval\n");
          exit (1);
        }
      t = (sorted_template_t *) gval.v;
      if (t->val.tval != tval)
	continue;

      if (t->val.subval > max)
	max = t->val.subval;
    }
  return max;
}

int get_lowest_subval_of_obj_with_tval (int tval)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int min = -1;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in "
		   "get_lowest_subval_of_obj_with_tval\n");
          exit (1);
        }
      t = (sorted_template_t *) gval.v;
      if (t->val.tval != tval)
	continue;

      if (t->val.subval < min || min == -1)
	min = t->val.subval;
    }
  if (min == -1)
    min = 0;
  return min;
}

void
get_min_and_max_mushies (int *low, int *high)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int min = -1;
  int max = 0;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in "
		   "get_lowest_subval_of_obj_with_tval\n");
          exit (1);
        }
      t = (sorted_template_t *) gval.v;
      if (t->state.mushroom_flag == 0)
	continue;

      if (t->val.subval < min || min == -1)
	min = t->val.subval;
      if (t->val.subval > max)
	max = t->val.subval;
    }
  if (min == -1)
    min = 0;
  *low = min;
  *high = max;
  return;
}

int
count_mushies()
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int count = 0;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in "
		   "get_lowest_subval_of_obj_with_tval\n");
          exit (1);
        }
      t = (sorted_template_t *) gval.v;
      if (t->state.mushroom_flag)
	count++;
    }
  return count;
}

void 
WriteConstants (int never_min, int never_max, int single_min, int single_max,
		int group_min, int group_max)
{
  int scare_monster;
  int val;
  fprintf (arguments.tc.outfile,
	   "\n#define MAX_OBJECTS\t\t%d\n", St_TableSize (sortedtreasureT_P));
  int max_dungeon_obj = get_max_dungeon_obj ();
  if (max_dungeon_obj > 0)
    fprintf (arguments.tc.outfile, "#define MAX_DUNGEON_OBJ\t\t%d\n", 
	     max_dungeon_obj);
  if ((val = get_obj_with_tval (TV_OPEN_DOOR)) != -1)
    fprintf (arguments.tc.outfile,
	     "#define OBJ_OPEN_DOOR\t\t%d\n", val);
  if ((val = get_obj_with_tval (TV_CLOSED_DOOR)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_CLOSED_DOOR\t\t%d\n", val);
  if ((val = get_obj_with_tval (TV_SECRET_DOOR)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_SECRET_DOOR\t\t%d\n", val);
  if ((val = get_obj_with_tval (TV_UP_STAIR)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_UP_STAIR\t\t%d\n", val);
  if ((val = get_obj_with_tval (TV_DOWN_STAIR)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_DOWN_STAIR\t\t%d\n", val);
  if ((val = get_obj_with_tval (TV_STORE_DOOR)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_STORE_DOOR\t\t%d\n", val);
  if ((val = get_obj_with_tval (TV_VIS_TRAP)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_TRAP_LIST\t\t%d\n", val);
  if ((val = get_obj_with_tval (TV_RUBBLE)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_RUBBLE\t\t%d\n", val);
  if ((val = get_obj_with_uniq (UNIQ_CREATED_BY_SPELL)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_MUSH\t\t%d\n", val);
  if ((val = get_obj_with_uniq (UNIQ_SCARE_MONSTER)) != -1)
    {
      fprintf (arguments.tc.outfile, "#define OBJ_SCARE_MON\t\t%d\n", val);
      int subval;
      if ((subval = get_subval_with_uniq (UNIQ_SCARE_MONSTER)) != -1)
	fprintf (arguments.tc.outfile, "#define SCARE_MONSTER\t\t%d\n", subval);
      scare_monster = 1;
    }
  if ((val = get_obj_with_tval (TV_GOLD)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_GOLD_LIST\t\t%d\n", val);
  if ((val = get_obj_with_tval (TV_NOTHING)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_NOTHING\t\t%d\n", val);
  if ((val = get_obj_with_uniq (UNIQ_CHEST_RUINED)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_RUINED_CHEST\t%d\n", val);
  if ((val = get_obj_with_uniq (UNIQ_WIZARD_OBJECT)) != -1)
    fprintf (arguments.tc.outfile, "#define OBJ_WIZARD\t\t%d\n", val);
  if (single_min > 0)
    {
      fprintf (arguments.tc.outfile, "#define OBJECT_IDENT_SIZE\t%d\n", 
	       7 * single_min);
      fprintf (arguments.tc.outfile, 
	       "/* bit shift object ident indexes by %d bits in desc.c */\n", 
	       (int) log2 (single_min));
    }
  if (get_obj_with_tval (TV_GOLD) != -1)
    fprintf (arguments.tc.outfile, "#define MAX_GOLD\t\t%d\n", 
	     count_obj_with_tval (TV_GOLD));
  if (potion_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "#define MAX_COLORS\t\t%d\n", 
	       argz_count (potion_adjectives_argz, potion_adjectives_argz_len));
      //do we have enough?
      int max_subval = get_highest_subval_of_obj_with_tval (TV_POTION1);
      int max = max_subval;
      max_subval = get_highest_subval_of_obj_with_tval (TV_POTION2);
      if (max_subval > max)
	max = max_subval;
      int min_subval = get_lowest_subval_of_obj_with_tval (TV_POTION1);
      int min = min_subval;
      min_subval = get_lowest_subval_of_obj_with_tval (TV_POTION2);
      if (min_subval > max)
	min = max_subval;
      if  (potion_adjectives_argz_len < (max - min + 1) && max)
	{
	  fprintf (stderr, "Error: %d potion adjectives are required in "
		   "the `unidentified POTION' section, but only "
		   "%d are given\n", max - min + 1, 
		   argz_count (potion_adjectives_argz, 
			       potion_adjectives_argz_len));
	  exit (1);
	}
    }
  else if (count_obj_with_tval (TV_POTION1) || count_obj_with_tval (TV_POTION2))
    {
      fprintf (stderr, "Warning: potions identified, but no `unidentified "
	       "POTION' section declared");
    }

  if (mushroom_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "#define MAX_MUSH\t\t%d\n", 
	       argz_count (mushroom_adjectives_argz, 
			   mushroom_adjectives_argz_len));
      int min, max;
      get_min_and_max_mushies (&min, &max);
      if  (mushroom_adjectives_argz_len < (max - min + 1) && max)
	{
	  fprintf (stderr, "Error: %d mushroom adjectives are required in "
		   "the `unidentified MUSHROOM' section, but only "
		   "%d are given\n", max - min + 1, 
		   argz_count (mushroom_adjectives_argz, 
			       mushroom_adjectives_argz_len));
	  exit (1);
	}
      else if (argz_count (mushroom_adjectives_argz,
			   mushroom_adjectives_argz_len) != 
	       (max - min + 1) + 1 && max)
	{
	  fprintf (stderr, "Error: exactly %d mushroom adjectives are "
		   "required in the `unidentified MUSHROOM' section, but "
		   "%d are given\n", max ? max - min + 1 + 1 : 0, 
		   argz_count (mushroom_adjectives_argz, 
			       mushroom_adjectives_argz_len));
	  exit (1);
	}
    }
  else if (count_mushies())
    {
      fprintf (stderr, "Warning: mushrooms identified, but no `unidentified "
	       "MUSHROOM' section declared");
    }

  if (staff_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "#define MAX_WOODS\t\t%d\n", 
	       argz_count (staff_adjectives_argz, staff_adjectives_argz_len));
      //do we have enough?
      int max_subval = get_highest_subval_of_obj_with_tval (TV_STAFF);
      int max = max_subval;
      int min_subval = get_lowest_subval_of_obj_with_tval (TV_STAFF);
      int min = min_subval;
      if  (staff_adjectives_argz_len < (max - min + 1) && max)
	{
	  fprintf (stderr, "Error: %d staff adjectives are required in "
		   "the `unidentified STAFF' section, but only "
		   "%d are given\n", max - min + 1, 
		   argz_count (staff_adjectives_argz, 
			       staff_adjectives_argz_len));
	  exit (1);
	}
    }
  else if (count_obj_with_tval (TV_STAFF))
    {
      fprintf (stderr, "Warning: staves identified, but no `unidentified "
	       "STAFF' section declared");
    }
  if (wand_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "#define MAX_METALS\t\t%d\n", 
	       argz_count (wand_adjectives_argz, wand_adjectives_argz_len));
      //do we have enough?
      int max_subval = get_highest_subval_of_obj_with_tval (TV_WAND);
      int max = max_subval;
      int min_subval = get_lowest_subval_of_obj_with_tval (TV_WAND);
      int min = min_subval;
      if  (wand_adjectives_argz_len < (max - min + 1) && max)
	{
	  fprintf (stderr, "Error: %d wand adjectives are required in "
		   "the `unidentified WAND' section, but only "
		   "%d are given\n", max - min + 1, 
		   argz_count (wand_adjectives_argz, 
			       wand_adjectives_argz_len));
	  exit (1);
	}
    }
  else if (count_obj_with_tval (TV_WAND))
    {
      fprintf (stderr, "Warning: wands identified, but no `unidentified "
	       "WAND' section declared");
    }
  if (ring_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "#define MAX_ROCKS\t\t%d\n", 
	       argz_count (ring_adjectives_argz, ring_adjectives_argz_len));
      //do we have enough?
      int max_subval = get_highest_subval_of_obj_with_tval (TV_RING);
      int max = max_subval;
      int min_subval = get_lowest_subval_of_obj_with_tval (TV_RING);
      int min = min_subval;
      if  (ring_adjectives_argz_len < (max - min + 1) && max)
	{
	  fprintf (stderr, "Error: %d ring adjectives are required in "
		   "the `unidentified RING' section, but only "
		   "%d are given\n", max - min + 1, 
		   argz_count (ring_adjectives_argz, 
			       ring_adjectives_argz_len));
	  exit (1);
	}
    }
  else if (count_obj_with_tval (TV_RING))
    {
      fprintf (stderr, "Warning: rings identified, but no `unidentified "
	       "RING' section declared");
    }
  if (amulet_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "#define MAX_AMULETS\t\t%d\n", 
	       argz_count (amulet_adjectives_argz, amulet_adjectives_argz_len));
      //do we have enough?
      int max_subval = get_highest_subval_of_obj_with_tval (TV_AMULET);
      int max = max_subval;
      int min_subval = get_lowest_subval_of_obj_with_tval (TV_AMULET);
      int min = min_subval;
      if  (amulet_adjectives_argz_len < (max - min + 1) && max)
	{
	  fprintf (stderr, "Error: %d amulet adjectives are required in "
		   "the `unidentified AMULET' section, but only "
		   "%d are given\n", max - min + 1, 
		   argz_count (amulet_adjectives_argz, 
			       amulet_adjectives_argz_len));
	  exit (1);
	}
    }
  else if (count_obj_with_tval (TV_AMULET))
    {
      fprintf (stderr, "Warning: amulets identified, but no `unidentified "
	       "AMULET' section declared");
    }

  if (count_obj_with_tval (TV_SCROLL))
    {
      int highest_subval = 0;
      int subval = get_highest_subval_of_obj_with_tval (TV_SCROLL);
      if (subval > highest_subval)
	highest_subval = subval;
      int max_titles = highest_subval - single_min + 1;
      fprintf (arguments.tc.outfile, "#define MAX_TITLES\t\t%d\n", max_titles);

    }
  if (syllables_argz_len)
    {
      fprintf (arguments.tc.outfile, "#define MAX_SYLLABLES\t\t%d\n", 
	       argz_count (syllables_argz, syllables_argz_len));
    }
  else if (count_obj_with_tval (TV_SCROLL))
    {
      fprintf (stderr, "Warning: scrolls identified, but no `syllables' "
	       "section declared");
    }
  int store_choices = count_store_choices (0);
  if (store_choices)
    {
      fprintf (arguments.tc.outfile, "#define STORE_CHOICES\t\t%d\n", 
	       store_choices);
      count_store_choices (1);
    }
  if (never_max != 0 && single_max != 0 && group_max != 0)
    {
      fprintf (arguments.tc.outfile, "#define ITEM_NEVER_STACK_MIN\t%d\n", 
	       never_min);
      fprintf (arguments.tc.outfile, "#define ITEM_NEVER_STACK_MAX\t%d\n", 
	       never_max);
      fprintf (arguments.tc.outfile, "#define ITEM_SINGLE_STACK_MIN\t%d\n", 
	       single_min);
      fprintf (arguments.tc.outfile, "#define ITEM_SINGLE_STACK_MAX\t%d\n", 
	       single_max);
      fprintf (arguments.tc.outfile, "#define ITEM_GROUP_MIN\t\t%d\n", 
	       group_min);
      fprintf (arguments.tc.outfile, "#define ITEM_GROUP_MAX\t\t%d\n", 
	       group_max);
    }

  int trap_count = count_obj_with_tval (TV_INVIS_TRAP);
  trap_count += count_obj_with_tval (TV_VIS_TRAP);
  if (scare_monster && trap_count)
    trap_count--;
  if (trap_count)
    fprintf (arguments.tc.outfile, "#define MAX_TRAP\t\t%d\n", trap_count);

  fprintf (arguments.tc.outfile, "\n\n");
  return;
}

void
show_store_choices_list (int store, FILE *stream)
{
  size_t length = 0;
  char *entry = NULL;
  char *choicestr;
  int first = 1;
  int j;
  int freq;
  char *argz = NULL;
  size_t argz_len = 0;
  int type;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
	{
	  fprintf (stderr, "internal err in show_store_choices_list\n");
	  exit (1);
	}
      t = (sorted_template_t *) gval.v;
      if (t->state.buyable_freq[store] == 0)
	continue;
      freq = t->state.buyable_freq[store];
      choicestr = xasprintf ("%d", atoi (entry));
      if (choicestr == NULL)
	return;
      for (j = 0 ; j < freq; j++)
	{
	  length += strlen (choicestr) + 4;
	  if (length > 80)
	    {
	      length = strlen (choicestr) + 4;
	      first = 1;
	      fprintf (stream, "\n");
	    }
	  if (first)
	    {
	      fprintf (stream, "  ");
	      first = 0;
	      length += 2;
	    }
	  fprintf (stream, "%s, ", choicestr);
	}
      free (choicestr);
    }
}

void 
WriteStoreChoices ()
{
  int i;
  fprintf (arguments.tc.outfile,
	   "\nint16u store_choice[MAX_STORES][STORE_CHOICES] = {\n");
  for (i = 0; i < MAX_STORES; i++)
    {
      fprintf (arguments.tc.outfile, "\t/* ");
      switch (i)
	{
	case 0: fprintf (arguments.tc.outfile, "General Store"); break;
	case 1: fprintf (arguments.tc.outfile, "Armoury"); break;
	case 2: fprintf (arguments.tc.outfile, "Weaponsmith"); break;
	case 3: fprintf (arguments.tc.outfile, "Temple"); break;
	case 4: fprintf (arguments.tc.outfile, "Alchemy shop"); break;
	case 5: fprintf (arguments.tc.outfile, "Magic-User store"); break;
	default: fprintf (arguments.tc.outfile, "Unknown store"); break;
	}
      fprintf (arguments.tc.outfile, "\t*/\n");
      fprintf (arguments.tc.outfile, "{");

      if (count_store_choices(0))
	{
	  show_store_choices_list (i, arguments.tc.outfile);
	  fprintf (arguments.tc.outfile, "}%s\n", 
		   i == MAX_STORES - 1 ? "" : ",");
	}
    }
  fprintf (arguments.tc.outfile, "};\n\n");
}

void WriteGenerationNotice ()
{
  fprintf (arguments.tc.outfile,
	   "/* The following was generated by the %s treasure compiler \n"
           "   (%s-tc %s) on %s.\n", 
	   PACKAGE, GAME_NAME, VERSION, __DATE__);
  fprintf (arguments.tc.outfile,"\n\
   Copyright (c) 1989-94 James E. Wilson, Robert A. Koeneke\n\
   This program is free software; you can redistribute it and/or modify\n\
   it under the terms of the GNU General Public License as published by\n\
   the Free Software Foundation; either version 3 of the License, or\n\
   (at your option) any later version.\n\
   \n\
   This program is distributed in the hope that it will be useful,\n\
   but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
   GNU Library General Public License for more details.\n\
   \n\
   You should have received a copy of the GNU General Public License\n\
   along with this program; if not, write to the Free Software\n\
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n");
  fprintf (arguments.tc.outfile,
	   "*/\n\n");
}

void WriteTreasureHdr ()
{
  fprintf (arguments.tc.outfile,"\n\
/* Following are treasure arrays	and variables			*/ \n\
\n\
/* Object description:	Objects are defined here.  Each object has\n\
  the following attributes:\n\
	Descriptor : Name of item and formats.\n\
		& is replaced with 'a', 'an', or a number.\n\
		~ is replaced with null or 's'.\n\
	Character  : Character that represents the item.\n\
	Type value : Value representing the type of object.\n\
	Sub value  : separate value for each item of a type.\n\
		0 - 63: object can not stack\n\
		64 - 127: dungeon object, can stack with other D object\n\
		128 - 191: unused, previously for store items\n\
		192: stack with other iff have same p1 value, always\n\
			treated as individual objects\n\
		193 - 255: object can stack with others iff they have\n\
			the same p1 value, usually considered one group\n\
		Objects which have two type values, e.g. potions and\n\
		scrolls, need to have distinct subvals for\n\
		each item regardless of its tval\n\
	Damage	   : amount of damage item can cause.\n\
	Weight	   : relative weight of an item.\n\
	Number	   : number of items appearing in group.\n\
	To hit	   : magical plusses to hit.\n\
	To damage  : magical plusses to damage.\n\
	AC	   : objects relative armor class.\n\
		1 is worse than 5 is worse than 10 etc.\n\
	To AC	   : Magical bonuses to AC.\n\
	P1	   : Catch all for magical abilities such as\n\
		     plusses to strength, minuses to searching.\n\
	Flags	   : Abilities of object.  Each ability is a\n\
		     bit.  Bits 1-31 are used. (Signed integer)\n\
                     Foods and potions use this for multiple effects.\n\
        Effect Idx : A single effect of wands, scrolls, and staves.\n\
	Level	   : Minimum level on which item can be found.\n\
	Cost	   : Relative cost of item.\n\
\n\
	Special Abilities can be added to item by magic_init(),\n\
	found in misc.c.\n\
\n\
	Scrolls, Potions, and Food:\n\
	Flags is used to define a function which reading/quaffing\n\
	will cause.  Most scrolls and potions have only one bit\n\
	set.  Potions will generally have some food value, found\n\
	in p1.\n\
\n\
	Wands and Staffs:\n\
	Flags defines a function, p1 contains number of charges\n\
	for item.  p1 is set in magic_init() in misc.c.\n\
\n\
	Chests:\n\
	Traps are added randomly by magic_init() in misc.c.	*/\n");

  return;
}

int count_relsubvals_in_use (int tval, int relsubval)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int count = 0;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
	{
	  fprintf (stderr, "internal err. in subval_in_use\n");
	  exit (1);
	}
      t = (sorted_template_t *) gval.v;
      if (t->def.stackable_id == TRUE)
	if (t->val.tval == tval && t->state.stackable_id == relsubval)
	  count++;
    }

  free (argz);
  return count;
}
int
relsubval_in_use (int tval, int relsubval)
{
  int count = count_relsubvals_in_use (tval, relsubval);
  if (count > 1) /* should find myself, and then maybe one more */
    return 1;
  else
    return 0;
}

int
count_subvals_in_use (int tval, int subval)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int count = 0;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
	{
	  fprintf (stderr, "internal err. in subval_in_use\n");
	  exit (1);
	}
      t = (sorted_template_t *) gval.v;
      if (t->def.subval == TRUE)
	if (t->val.tval == tval && t->val.subval == subval)
	  count++;
    }

  free (argz);
  return count;
}
int
subval_in_use (int tval, int subval)
{
  int count = count_subvals_in_use (tval, subval);
  if (count > 1) /* should find myself, and then maybe one more */
    return 1;
  else
    return 0;
}

/* are we specifying relative subvals? */
int
using_relative_subvals ()
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int count = 0;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
	{
	  fprintf (stderr, "internal err. in using_relative_subvals\n");
	  exit (1);
	}
      t = (sorted_template_t *) gval.v;
      if (t->def.stackable_id == TRUE)
	count++;
    }

  free (argz);
  return count;
}

/* are we explicitly specifying subvals? */
int
using_subvals ()
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int count = 0;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
	{
	  fprintf (stderr, "internal err. in using_relative_subvals\n");
	  exit (1);
	}
      t = (sorted_template_t *) gval.v;
      if (t->def.subval == TRUE)
	count++;
    }

  free (argz);
  return count;
}

int get_subval_of_same_named_object (int relative, int stackable_flags, int tval, char *name)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int subval = -1;
  generic_t gval;
  sorted_template_t *t;
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
	{
	  fprintf (stderr, "internal err. in using_relative_subvals\n");
	  exit (1);
	}
      t = (sorted_template_t *) gval.v;
      if (t->state.stackable != stackable_flags)
	continue;
      if (t->def.tval == TRUE && t->val.tval != tval)
	continue;
      if (strcmp (t->val.name, name) != 0)
	continue;
      if (relative && t->def.stackable_id)
	subval = t->state.stackable_id;
      else if (!relative && t->def.subval)
	subval = t->val.subval;
    }

  free (argz);
  return subval;

}
void 
AutonumberSubVals (int relative, int stackable_flags, int min, int *max_subval)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int subvals[TV_MAX_VISIBLE];
  int relsubvals[TV_MAX_VISIBLE];
  int type;
  generic_t gval;
  sorted_template_t *t;
  memset (subvals, 0, sizeof (subvals));
  memset (relsubvals, 0, sizeof (relsubvals));
  int max = 0;

  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
	{
	  fprintf (stderr, "internal err. in AutonumberSubVals\n");
	  exit (1);
	}
      t = (sorted_template_t *) gval.v;
      if (t)
	{
	  if (t->state.stackable != stackable_flags)
	    continue;

	  if (!relative && t->def.subval == TRUE)
	    {
	      if (t->val.subval > max)
		max = t->val.subval;
	      continue; /* don't autonumber if set manually */
	    }
	  if (relative && t->def.stackable_id == TRUE)
	    {
	      t->val.subval = min + t->state.stackable_id;
	      if (t->val.subval > max)
		max = t->val.subval;
	      t->def.subval = TRUE;
	      continue; /* don't autonumber if set manually */
	    }
	  // try to number this the same as others with the same name
	  int subval = get_subval_of_same_named_object (relative,
							stackable_flags, 
							t->val.tval,
							t->val.name);
	  if (subval != -1)
	    {
	      t->val.subval = subval;
	      t->def.subval = TRUE;
	      continue;
	    }
	  if (relative)
	    {
	      //implicitly autonumber the relsubval
	      t->val.subval = min + relsubvals[t->val.tval];
	      t->def.subval = TRUE;
	      //is this subval already in use?  skip it.
	      while (relsubval_in_use (t->val.tval, t->val.subval))
		{
		  relsubvals[t->val.tval]++;
		  t->val.subval = min + relsubvals[t->val.tval];
		  t->def.subval = TRUE;
		}
	      relsubvals[t->val.tval]++;
	      if (t->val.subval > max)
		max = t->val.subval;
	    }
	  else
	    {
	      //implicitly autonumber the subval
	      //not going to work because subval is larger
	      t->val.subval = min + subvals[t->val.tval];
	      t->def.subval = TRUE;
	      //is this subval already in use?  skip it.
	      while (subval_in_use (t->val.tval, t->val.subval))
		{
		  subvals[t->val.tval]++;
		  t->val.subval = min + subvals[t->val.tval];
		  t->def.subval = TRUE;
		}
	      subvals[t->val.tval]++;
	      if (t->val.subval > max)
		max = t->val.subval;
	    }
	}
    }
  free (argz);
  if (max_subval)
    *max_subval = max;
  return;
}

void 
CalculateSubVals (int *never_stack_min, int *never_stack_max, int *item_single_stack_min, int *item_single_stack_max, int *item_group_min, int *item_group_max)
{
  int relative = 0;
  int subvals_specified = using_subvals();
  int relsubvals_specified = using_relative_subvals();
  if (subvals_specified && relsubvals_specified)
    {
      fprintf (stderr,"Error: Cannot have relsubval with subval\n");
      exit (1);
    }
  else if (relsubvals_specified)
    relative = 1;
  else if (subvals_specified)
    relative = 0;
  else
    relative = 0;

  //{ "never", 0},
  //{ "with_same_kind", 1},
  //{ "with_same_p1", 2},
  int never;
  int same_kind;
  int same_p1;
  int same_p1_and_kind;
  AutonumberSubVals (relative, 1 << 0, 0, &never);
  //now we bump up never to some power of 2, -1.
  if (never == 0) //FIXME: fix this such crapola!
    never = 0;
  else if (never + 1 <= 1) //synonymous
    never = 1 - 1;
  else if (never + 1 <= 2)
    never = 2 - 1;
  else if (never + 1 <= 4)
    never = 4 - 1;
  else if (never + 1 <= 8)
    never = 8 - 1;
  else if (never + 1 <= 16)
    never = 16 - 1;
  else if (never + 1 <= 32)
    never = 32 - 1;
  else if (never + 1 <= 64)
    never = 64 - 1;
  else if (never + 1 <= 128)
    never = 128 - 1;
  else if (never + 1 <= 256)
    never = 256 - 1;
  else if (never + 1 <= 1024)
    never = 1024 - 1;
  else if (never + 1 <= 2048)
    never = 2048 - 1;
  else if (never + 1 <= 4096)
    never = 4096 - 1;
  else if (never + 1 <= 8192)
    never = 8192 - 1;
  AutonumberSubVals (relative, 1 << 1, never + 1, &same_kind);

  AutonumberSubVals (relative, (1 << 2) | (1 << 1), same_kind + 1, 
		     &same_p1_and_kind);

  AutonumberSubVals (relative, 1 << 2, 
		     same_kind + 1 + same_p1_and_kind - same_kind, &same_p1);

  if (never_stack_min)
    *never_stack_min = 0;
  if (never_stack_max)
    *never_stack_max = never;
  if (item_single_stack_min)
    *item_single_stack_min = never + 1;
  if (item_single_stack_max)
    *item_single_stack_max = same_p1_and_kind;
  if (item_group_min)
    *item_group_min = same_kind + 1;
  if (item_group_max)
    *item_group_max = same_p1;

  return;
}

void
WriteAdjectives ()
{
  if (potion_adjectives_argz_len == 0 && mushroom_adjectives_argz_len  == 0 &&
      staff_adjectives_argz_len  == 0 && wand_adjectives_argz_len  == 0 &&
      ring_adjectives_argz_len == 0 && amulet_adjectives_argz_len == 0)
    return;
  if (potion_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "char *colors [MAX_COLORS] = {\n");
      show_adjective_list (potion_adjectives_argz, potion_adjectives_argz_len,
			   arguments.tc.outfile);
      fprintf (arguments.tc.outfile, "\n};\n");
    }
  if (mushroom_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "char *mushrooms[MAX_MUSH] = {\n");
      show_adjective_list (mushroom_adjectives_argz, 
			   mushroom_adjectives_argz_len,
			   arguments.tc.outfile);
      fprintf (arguments.tc.outfile, "\n};\n");
    }
  if (staff_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "char *woods[MAX_WOODS] = {\n");
      show_adjective_list (staff_adjectives_argz, staff_adjectives_argz_len,
			   arguments.tc.outfile);
      fprintf (arguments.tc.outfile, "\n};\n");
    }
  if (wand_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "char *metals[MAX_METALS] = {\n");
      show_adjective_list (wand_adjectives_argz, wand_adjectives_argz_len,
			   arguments.tc.outfile);
      fprintf (arguments.tc.outfile, "\n};\n");
    }
  if (ring_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "char *rocks[MAX_ROCKS] = {\n");
      show_adjective_list (ring_adjectives_argz, ring_adjectives_argz_len,
			   arguments.tc.outfile);
      fprintf (arguments.tc.outfile, "\n};\n");
    }
  if (amulet_adjectives_argz_len)
    {
      fprintf (arguments.tc.outfile, "char *amulets[MAX_AMULETS] = {\n");
      show_adjective_list (amulet_adjectives_argz, amulet_adjectives_argz_len,
			   arguments.tc.outfile);
      fprintf (arguments.tc.outfile, "\n};\n");
    }
  if (syllables_argz_len)
    {
      fprintf (arguments.tc.outfile, "char *syllables [MAX_SYLLABLES] = {\n");
      show_adjective_list (syllables_argz, syllables_argz_len,
			   arguments.tc.outfile);
      fprintf (arguments.tc.outfile, "\n};\n");
    }
}

void CheckForRequiredTreasures()
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  generic_t gval;

  struct required_items 
    {
      int tval;
      char *tval_name;
      int subval;
      int store;
      int found;
    };
  struct required_items required_items[] = 
    {
      {TV_FOOD, "TV_FOOD", 90, 1, 0},
      {TV_LIGHT, "TV_LIGHT", 192, 1, 0},
      {TV_CLOAK, "TV_CLOAK", 1, 0, 0},
      {TV_SWORD, "TV_SWORD", 3, 0, 0},
      {TV_SOFT_ARMOR, "TV_SOFT_ARMOR", 2, 0, 0},
      {TV_MAGIC_BOOK, "TV_MAGIC_BOOK", 64, 0, 0},
      {TV_PRAYER_BOOK, "TV_PRAYER_BOOK", 64, 0, 0},
    };
  int i;
  int num_required_items = 
    sizeof (required_items) / sizeof (struct required_items);
  St_SArgzTable (sortedtreasureT_P, &argz, &argz_len);
  int max_dungeon_obj = get_max_dungeon_obj ();

  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (sortedtreasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        continue;
      template_t *t = (template_t*) gval.v;
      for (i = 0; i < num_required_items; i++)
        {
          if (required_items[i].tval == t->val.tval &&
              required_items[i].subval == t->val.subval)
            {
              if (required_items[i].store == 0)
                required_items[i].found = 1;
              else
                {
                  if (required_items[i].store && atoi(t->id) >= max_dungeon_obj)
                    required_items[i].found = 1;
                }
            }
        }
    }
  for (i = 0; i < num_required_items; i++)
    {
      if (required_items[i].found == 0)
        fprintf (stderr, "Error: Necessary %s object with subval=%d not found%s \n", required_items[i].tval_name, required_items[i].subval, required_items[i].store ? " in stores." : ".");
    }

  free (argz);
  return;
}

int
tc_main (char *inputFilename)
{
  InitTables ();

  if (strcmp (inputFilename, "-") == 0)
    input_F = stdin;
  else
    {
      input_F = fopen (inputFilename, "r");
      if (!input_F) 
	{
	  fprintf (stderr, "Error: couldn't open file.\n");
	  return -1;
	}
    }

  if (yyparse ()) 
    {
      fprintf (stderr, "Errors prevent continuation.\n");
      return -2;
    }

  if (arguments.tc.sort)
    SortTreasures ();
  else
    {
      char *argz = NULL;
      size_t argz_len = 0;
      char *entry = NULL;
      generic_t gval;
      int type;
      template_t *t;

      St_SArgzTable (treasureT_P, &argz, &argz_len);
      while ((entry = argz_next (argz, argz_len, entry)))
	{
	  if (St_GetSym (treasureT_P, entry, &type, &gval) != ST_SYM_FOUND) 
	    {
	      fprintf (stderr, "internal err.\n");
	      exit (1);
	    }
	  t = (template_t *) gval.v;
	  AddSortedTreasure (t);
	}
      free (argz);
    }

  int never_min, never_max, single_min, single_max, group_min, group_max;
  CalculateSubVals (&never_min, &never_max, &single_min, &single_max, 
		    &group_min, &group_max);

  if (arguments.tc.consistency_check)
    CheckForRequiredTreasures();
  WriteGenerationNotice ();
  if (arguments.tc.only_generate_constants == 1)
    {
      WriteConstants (never_min, never_max, single_min, single_max, group_min,
                      group_max);
    }
  else
    {
      fprintf(arguments.tc.outfile, "#include \"constant.h\"\n");
      fprintf(arguments.tc.outfile, "#include \"types.h\"\n\n");
      if (count_store_choices(0))
        WriteStoreChoices();
      WriteAdjectives ();
      WriteTreasureHdr ();
      WriteTreasures ();
    }

  return 0;
}
