/* url.c - URL encoding
 *
 * Copyright (C) 2005 Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <config.h>
#include <stdint.h>
#include <string.h>
#include <ctype.h>
#include "xalloc.h"

#define HEXCHRLC(x) ((x) >= 10 ? 'a'+(x) : '0'+(x))
#define HEXCHRUC(x) ((x) >= 10 ? 'A'+(x) : '0'+(x))

void
sgmlescape(const char *str, char *target, uint32_t *length)
{
    if (target != NULL) {
        uint32_t len = 0;

        for (; *str; str++) {
            if (*str == '<') {
                memcpy(target+len, "&lt;", 4);
		len += 4;
	    } else if (*str == '>') {
                memcpy(target+len, "&gt;", 4);
		len += 4;
	    } else if (*str == '&') {
                memcpy(target+len, "&amp;", 5);
		len += 5;
            } else {
                target[len++] = *str;
            }
        }
	target[len] = '\0';

        if (length != NULL)
            *length = len;
    }
    else if (length != NULL) {
        uint32_t len = 0;

        for (; *str; str++) {
            if (*str == '<') {
		len += 4;
	    } else if (*str == '>') {
		len += 4;
	    } else if (*str == '&') {
		len += 5;
            } else {
                len++;
            }
        }

        *length = len;
    }
}

char *
xsgmlescape(const char *str)
{
    uint32_t len;
    char *out;
    
    sgmlescape(str, NULL, &len);
    out = xmalloc(len+1);
    sgmlescape(str, out, NULL);
    return out;
}

void
urlencode(const char *str, char *target, uint32_t *length)
{
    if (target != NULL) {
        uint32_t len = 0;

        for (; *str; str++) {
            if (!isalnum(*str) && *str != '/') {
                target[len++] = '%';
                target[len++] = HEXCHRUC(*str >> 4);
                target[len++] = HEXCHRUC(*str & 0x0F);
            } else {
                target[len++] = *str;
            }
        }
	target[len] = '\0';

        if (length != NULL)
            *length = len;
    }
    else if (length != NULL) {
        uint32_t len = 0;

        for (; *str; str++) {
            if (!isalnum(*str) && *str != '/') {
                len += 3;
            } else {
                len++;
            }
        }

        *length = len;
    }
}

char *
xurlencode(const char *str)
{
    uint32_t len;
    char *out;
    
    urlencode(str, NULL, &len);
    out = xmalloc(len+1);
    urlencode(str, out, NULL);
    return out;
}
