/* connectmgr.c - Implementation of UPnP ConnectionManager
 *
 * Copyright (C) 2005  Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <config.h>
#include <stdbool.h>
#include <upnp.h>
#include <upnptools.h>
#include "gmediaserver.h"

static bool
connectmgr_get_protocol_info(ActionEvent *event)
{
    upnp_add_response(event, "SOURCE", "http-get:*:audio/mpeg:*"); /* XXX format */
    upnp_add_response(event, "SINK", "");

    return event->status;
}

static bool
connectmgr_get_current_connection_ids(ActionEvent *event)
{
    upnp_add_response(event, "ConnectionIDs", "");
    return event->status;
}

static bool
connectmgr_get_current_connection_info(ActionEvent *event)
{
    upnp_add_response(event, "ConnectionID", "0");
    upnp_add_response(event, "RcsID", "-1");
    upnp_add_response(event, "AVTransportID", "-1");
    upnp_add_response(event, "ProtocolInfo", "http-get:*:audio/mpeg:*"); /* XXX format */
    upnp_add_response(event, "PeerConnectionManager", "");
    upnp_add_response(event, "PeerConnectionID", "-1");
    upnp_add_response(event, "Direction", "Output");
    upnp_add_response(event, "Status", "OK");
    return event->status;
}

/*
ServiceVariable connectmgr_service_variables[] = {
  { "SourceProtocolInfo"
  { "SinkProtocolInfo"
  { "CurrentConnectionIDs"
  { "A_ARG_TYPE_ConnectionStatus"
  { "A_ARG_TYPE_ConnectionManager"
  { "A_ARG_TYPE_Direction"
  { "A_ARG_TYPE_ProtocolInfo"
  { "A_ARG_TYPE_ConnectionID"
  { "A_ARG_TYPE_AVTransportID"
  { "A_ARG_TYPE_RcsID"
};
*/

ServiceAction connectmgr_service_actions[] = {
  { "GetProtocolInfo", connectmgr_get_protocol_info },
/*{ "PrepareForConnection", connectmgr_prepare_for_connection },*/
/*{ "ConnectionComplete", connectmgr_connection_complete },*/
  { "GetCurrentConnectionIDs", connectmgr_get_current_connection_ids },
  { "GetCurrentConnectionInfo", connectmgr_get_current_connection_info },
  { NULL, NULL }
};
