; Copyright (c) 2005 by Joseph Crayne
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions
; are met:
; 1. Redistributions of source code must retain the above copyright
;    notice, this list of conditions and the following disclaimer.
; 2. Redistributions in binary form must reproduce the above copyright
;    notice, this list of conditions and the following disclaimer in 
;    the documentation and/or other materials provided with the
;    distribution.
; 3. The name of the author may not be used to endorse or promote
;    products derived from this software without specific prior
;    written permission.
; 
; THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
; OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
; IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
; OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
; IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


;;; glue-desc.scm
;;; This file describes the interface to c.

(read-type-data '(
		  ( v "void"
		      'void 
		      "S48_UNSPECIFIC"
		      )
		  ( s "char *"
		      "s48_extract_string"
		      "s48_enter_string"
		      )
		  ( i "int"
		      "s48_extract_integer"
		      "s48_enter_integer")
		   ))
(interfacing-rule p
  "void *"

  (extract macro S48_POINTER_OR_NULL 
    "(S48_FALSE_P($1) ? NULL : S48_EXTRACT_VALUE($1,void*) )")

  (enter inline convert_pointer "
	s48_value retv;
	if($1) { 
		retv = S48_MAKE_VALUE( void* );
		S48_SET_VALUE( retv, void*, $1 );
	} else  
		retv = S48_FALSE;
	return retv;\n")
   )

(interfacing-rule sn
  "char *"

  (extract macro S48_STRING_OR_NULL 
	"(S48_FALSE_P($1) ? NULL : s48_extract_string($1) )")

  (enter inline convert_string "
	s48_value retv;
	if($1) { 
		retv = s48_enter_string($1 );
	} else  
		retv = S48_FALSE;
	return retv;\n")
  )

(interfacing-rule ui
  "unsigned int"
  (extract macro S48_MY_EXTRACT_UI "s48_extract_integer($1)")
  (enter macro S48_MY_ENTER_UI "s48_enter_integer($1)"))


