/*
  Copyright (C) 2007 Bradley Arsenault

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include "GameGUIMessageManager.h"
#include "GlobalContainer.h"

InGameMessage::InGameMessage(const std::string& text, Uint8 r, Uint8 g, Uint8 b, Uint8 a, int time)
 : timeLeft(time), text(text), r(r), g(g), b(b), a(a)
{
	lastTime = 0;
}



std::string InGameMessage::getText() const
{
	return text;
}



void InGameMessage::draw(int x, int y)
{
	Uint32 newTime = SDL_GetTicks();
	if(lastTime != 0)
	{
		timeLeft -=  (newTime - lastTime);
		timeLeft = std::max(0, timeLeft);
	}
	lastTime = newTime;

	globalContainer->standardFont->pushStyle(Font::Style(Font::STYLE_BOLD, r, g, b, a));
	globalContainer->gfx->drawString(x, y, globalContainer->standardFont, text.c_str());
	globalContainer->standardFont->popStyle();
}



GameGUIMessageManager::GameGUIMessageManager()
{

}


	
void GameGUIMessageManager::addMessage(const InGameMessage& message)
{
	history.push_front(message);
}



void GameGUIMessageManager::drawAllMessages(int x, int y)
{
	for (std::list <InGameMessage>::iterator i=history.begin(); i!=history.end(); ++i)
	{
		if(i->timeLeft != 0)
		{
			i->draw(x, y);
			y += 20;
		}
	}
}



InGameScrollableHistory* GameGUIMessageManager::createScrollableHistoryScreen()
{
	return new InGameScrollableHistory(globalContainer->gfx, history);
}


InGameScrollableHistory::InGameScrollableHistory(GraphicContext *context, const std::list<InGameMessage>& messageHistory)
: OverlayScreen(context, (globalContainer->gfx->getW()-152), 100), history(messageHistory)
{
	messageList=new List(0, 0, (globalContainer->gfx->getW()-152), 100, 0, 0, "standard");
	addWidget(messageList);
	updateList();
	dispatchInit();
}



void InGameScrollableHistory::onAction(Widget *source, Action action, int par1, int par2)
{

}


void InGameScrollableHistory::onTimer(Uint32 tick)
{
	if(lastSize != history.size())
		updateList();
}


void InGameScrollableHistory::updateList()
{
	messageList->clear();
	for(std::list<InGameMessage>::const_iterator i = history.begin(); i!=history.end(); ++i)
	{
		messageList->addText(i->getText());
	}
	lastSize = history.size();
}
