<?
// GiftWeb: PHP/PostgreSQL online Gift Registry System 
// Matthew T. Jachimstal
// Copyright (C) 2000-2003  Matthew T. Jachimstal
//
// email: matthew@jachimstal.com
//
// Snail mail: Matthew Jachimstal
//             460 Washington Blvd.
//             Hoffman Estates, IL 60194
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

require "./main.inc";

function checkprimary($uid)
{
	global $dbtype;
	global $dbhost;
	global $dbuser;
	global $dbpass;
	global $dbname;
	global $s;

	$conn = ADONewConnection($dbtype);
	$conn->PConnect($dbhost, $dbuser, $dbpass, $dbname);

	$sql = "SELECT * FROM members WHERE uid='$uid' and prim='t'";
	$result = $conn->Execute($sql);

	if ($result->RecordCount() == 0)
	{
		?>
		<table><tr><td width=50%>
		<h4>You have not chosen any group to be listed in. Other
		users will not be able to see your list until you select
		a group.<br>
		Please proceed to the "Edit your preferences" page and choose
		a group to be listed in.<br>
		Thank you</h4></td><td width=50%>&nbsp;</td></tr></table>
		<?
	}

	if ($result->RecordCount() > 1)
	{
		?>
		<table><tr><td width=50%>
		<h2>You have more than one group marked as primary. Please contact
		the site administrator to correct this problem.<br>
		Thank you.</h2></td><td width=50%>&nbsp;</td></tr></table>
		<?
	}
}

function startpage($title, $darken)
{
    global $background;
    global $bgcolor;
    global $textcolor;
    global $linkcolor;
    global $alinkcolor;
    global $vlinkcolor;
	global $s;
	global $dbtype;
	global $dbname;
	global $dbhost;
	global $dbuser;
	global $dbpass;
	global $uid;

	$conn = ADONewConnection($dbtype);
	$conn->PConnect($dbhost, $dbuser, $dbpass, $dbname);

	if ($darken >= -1)
	{
		$sql = "SELECT login FROM users WHERE uid='$uid'";
		$result= $conn->Execute($sql);

		if ( $result->RecordCount() == 1 )
		{
			$login = $result->fields["login"];
			$printuser = 1;
		}

		$main = "<a href=\"main.php?s=$s\">Main Page</a>";
		$edit = "<a href=\"editlist.php?s=$s\">Edit My List</a>";
		$other = "<a href=\"viewusers.php?s=$s\">Other Users</a>";
		$prefs = "<a href=\"editprefs.php?s=$s\">Preferences</a>";
		$myitems = "<a href=\"myitems.php?s=$s\">My Purchases</a>";

		if ($darken == 1)
			$main = "Main Page";

		if ($darken == 2)
			$edit = "Edit My List";

		if ($darken == 3)
			$other = "Other Users";
	
		if ($darken == 4)
			$prefs = "Preferences";

		if ($darken == 5)
			$myitems = "My Purchases";
	}
	

	?>
	<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
	<html>
	<head>
	<title><?echo $title?></title>
	</head>
	<?
    # build <body> tag with preferences set from main.inc
	echo "<body ";

    if ($background!="") { echo "background=\"$background\""; }
    if ($bgcolor!="") { echo " bgcolor=\"$bgcolor\""; }
    if ($textcolor!="") { echo " textcolor=\"$textcolor\""; }
    if ($linkcolor!="") { echo " link=\"$linkcolor\""; }
    if ($alinkcolor!="") { echo " alink=\"$alinkcolor\""; }
    if ($vlinkcolor!="") { echo " vlink=\"$vlinkcolor\""; }
    echo ">\n";

	if ($darken > -1)
	{
		?>

			<table width=100%>
			<tr><td width=15% valign=top><b>GiftWeb</b>

			<?
			if ( $printuser == 1 )
			{
				?>
					<br>User: <?echo $login?>
					<p>
					<a href="logout.php?s=<?echo $s?>">Logout</a>
					<?
			}
		?>
			</td>
			<td>
			<p>
			<center>
			<table cellpadding=5 cellspacing=5><tr>
			<td><font size=+1><?echo $main?></font></td>
			<td><font size=+1><?echo $edit?></font></td>
			<td><font size=+1><?echo $myitems?></font></td>
			<td><font size=+1><?echo $other?></font></td>
			<td><font size=+1><?echo $prefs?></font></td></tr></table></center>
			<?
	}
}

function endpage($darken)
{
	global $dbtype;
	global $dbname;
	global $dbhost;
	global $dbuser;
	global $dbpass;

	$conn = ADONewConnection($dbtype);
	$conn->PConnect($dbhost, $dbuser, $dbpass, $dbname);

	if ($darken != -1)
	{
	?>
		</td>
	</tr></table>
	<?
	}

	$sql = "SELECT giftweb.admin, users.email
			FROM giftweb, users
			WHERE giftweb.admin = users.uid";
	$result = $conn->Execute($sql);

	$email = chop($result->fields["email"]);
	$page = $_SERVER["REQUEST_URI"];
	
	?>
	<p>
	<center>Email the 
	<a href="mailto:<?echo $email?>?subject=User message from <?echo $page?>">
	site administrator</a> (report an error, etc)
	<p>
	<font size=-2>Powered by 
	<a href="http://savannah.nongnu.org/projects/giftweb/">
	GiftWeb</a>
	</font>
	</center>
	</body>
	</html>
	<?
}

function addsession($uid)
{
	global $dbtype;
	global $dbhost;
	global $dbuser;
	global $dbpass;
	global $dbname;

	$conn = ADONewConnection($dbtype);
	$conn->PConnect($dbhost, $dbuser, $dbpass, $dbname);

	mt_srand((double)microtime()*1000000);
	$charset="123456789";

	do
	{
		$sess_id="";
		for($i=0; $i < 5; $i++)
		{
			$x = mt_rand(0,strlen($charset)-1);
			$sess_id = $sess_id . substr($charset, $x, 1);
		}

		$seconds = time();

		$sql = "INSERT INTO session VALUES ('$sess_id', '$uid', $seconds)";
		$result = $conn->Execute($sql);
	} while ($result == false);

	return $sess_id;
}

function validatesession($sess_id)
{
	global $dbtype;
	global $dbname;
	global $dbhost;
	global $dbuser;
	global $dbpass;
	global $code_ver;

	$conn = ADONewConnection($dbtype);
	$conn->PConnect($dbhost, $dbuser, $dbpass, $dbname);

	$sql = "SELECT * FROM giftweb WHERE schema_key=1";

	$result = $conn->Execute($sql);
	
	if (!$result) 
	  {
	    print $conn->ErrorMsg();
	  }

	if ($result->RecordCount() != 1)
	{
		echo "Error checking database schema version. Please notify \n";
		echo "your site administrator.\n";

		exit();
	}
	else
	{
		$schema_ver = $result->fields["schema_ver"];
		if ($schema_ver != $code_ver)
		{
			echo "The GiftWeb code version does not match the database \n";
			echo "schema version. Please notify your site administrator.\n";
			echo "<br>";
			echo "Code version: $code_ver, Schema version: $schema_ver\n";

			exit();
		}
	}

	$sql = "SELECT * FROM session";
	$result = $conn->Execute($sql);
	$rows = $result->RecordCount();
	
	while (!$result->EOF)
	{
		$key = chop($result->fields["session_key"]);
		$last = $result->fields["last"];

		$seconds = time();

		if (($seconds - $last) > 3600)
		{
			$sql = "DELETE FROM session WHERE session_key='$key'";
			$conn->Execute($sql);
		}

		$result->MoveNext();
	}

	$sql = "SELECT * FROM session where session_key='$sess_id'";
	$result = $conn->Execute($sql);

	if ($result->RecordCount() != 1)
	{
		startpage("Invalid session ID", -2);
		echo "$s<br>";
		?>
		Error: Can&#39t validate session ID.<br>
		Please <a href="./index.php">Login</a> again.
		<?

		exit();
	}

	$seconds = time();

	$sql = "UPDATE session SET last = '$seconds' WHERE session_key = '$sess_id'";
	$conn->Execute($sql);

	return $result->fields["uid"];
}

function notify_group_admin($uid, $gid, $action)
{
	global $dbtype;
	global $dbhost;
	global $dbuser;
	global $dbpass;
	global $dbname;

	$conn = ADONewConnection($dbtype);
	$conn->PConnect($dbhost, $dbuser, $dbpass, $dbname);

	$sql = "SELECT name, email FROM users WHERE uid='$uid'";
	$result = $conn->Execute($sql);
	$name = chop($result->fields["last_name"]);
	$name .= ", ".chop($result->fields["first_name"]);
	$u_email = chop($result->fields["email"]);

	$sql = "SELECT * FROM groups WHERE gid='$gid'";
	$result = $conn->Execute($sql);
	$group = chop($result->fields["description"]);
	$admin = $result->fields["admin"];

	$sql = "SELECT email FROM users WHERE uid='$admin'";
	$result = $conn->Execute($sql);
	$email = chop($result->fields["email"]);

	if ($action == 1) // added a group
	{
		$text = "$name has asked to be added to the $group group. Please visit the group administration page after signing in, and approve or deny this request. Thank you.";
	}
	else			// dropped a group
	{
		$text = "$name has been removed from the $group group. No action on your part is necessary. Thank you.";
	}

	$from = "From: " . $u_email;
	$to = $email;
	$subject = "Group member add/drop";

	mail($to, $subject, $text, $from);
}

function notify_user($uid, $gid, $action)
{
	global $dbtype;
	global $dbhost;
	global $dbuser;
	global $dbpass;
	global $dbname;

	$conn = ADONewConnection($dbtype);
	$conn->Connect($dbhost, $dbuser, $dbpass, $dbname);

	$sql = "SELECT name, email FROM users WHERE uid='$uid'";
	$result = $conn->Execute($sql);
	$name = chop($result->fields["last_name"]);
	$name .= ", " . chop($result->fields["first_name"]);
	$email = chop($result->fields["email"]);

	$sql = "SELECT * FROM groups WHERE gid='$gid'";
	$result = $conn->Execute($sql);
	$group = chop($result->fields["description"]);
	$admin = $result->fields["admin"];

	$sql = "SELECT name, email FROM users WHERE uid='$admin'";
	$result = $conn->Execute($sql);
	$a_name = chop($result->fields["last_name"]);
	$a_name .= ", " . chop($result->fields["first_name"]);
	$a_email = chop($result->fields["email"]);

	if ($action == 1)
	{
		$text = "Your request to be added to the $group group has been ";
		$text .= "approved. If you have any questions, please contact ";
		$text .= "$a_name at $a_email.";
		$subj = "Group addition request approved.";
	}
	else
	{
		$text = "Your request to be added to the $group group has been ";
		$text .= "denied. If you have any questions, please contact ";
		$text .= "$a_name at $a_email.";
		$subj = "Group addition request denied.";
	}


	$from = "From: " . $a_email;

	mail($email, $subj, $text, $from);

}

function notify_purchaser($uid, $item_num, $purchaser)
{
	global $dbtype;
	global $dbhost;
	global $dbuser;
	global $dbpass;
	global $dbname;

	$conn = ADONewConnection($dbtype);
	$conn->Connect($dbhost, $dbuser, $dbpass, $dbname);

	$sql = "SELECT first_name, last_name, email FROM users WHERE uid='$uid'";
	$result = $conn->Execute($sql);
	if (!$result) 
	  {
	    print $conn->ErrorMsg();
	  }
	$u_name = chop($result->fields["last_name"]);
	$u_name .= ", " . chop($result->fields["first_name"]);
	$u_email = chop($result->fields["email"]);

	$sql = "SELECT first_name, last_name, email 
			FROM users WHERE uid='$purchaser'";
	$result = $conn->Execute($sql);
	$p_name = chop($result->fields["last_name"]);
	$p_name .= ", " . chop($result->fields["first_name"]);
	$p_email = chop($result->fields["email"]);

	$sql = "SELECT description FROM items WHERE item_num='$item_num'";
	$result = $conn->Execute($sql);
	$desc = $result->fields["description"];

	$text = "$u_name has removed $desc, which you have already purchased, ";
	$text .= "from their wish list";
	$subj = "Purchased item removed from $u_name's list";
	
	$from = "From: " . $u_email;

	mail($p_email, $subj, $text, $from);

}


// lesson: document code when writing it!

function cleanup_items()
{
	global $dbtype;
	global $dbhost;
	global $dbuser;
	global $dbpass;
	global $dbname;

	$conn = ADONewConnection($dbtype);
	$conn->PConnect($dbhost, $dbuser, $dbpass, $dbname);

	// delete items that have no user in the users table
	// these items will have a null users.uid when outer 
	// joined with the users table
	
	$sql = "DELETE FROM items 
			WHERE item_num IN
			(SELECT items.item_num FROM items LEFT OUTER JOIN users
			 on (items.uid=users.uid) WHERE users.uid is null)";
	$conn->Execute($sql);

	// delete items that are "added by purchaser", whose purchaser
	// is no longer in the users table. Simlar to above, but the
	// outer join is on items.purchaser instead of items.uid

	$sql = "DELETE FROM items
			WHERE item_num IN
			(SELECT items.item_num FROM items LEFT OUTER JOIN users
			 on (items.purchased=users.uid) WHERE 
			items.added=true and users.uid is null)";
	$conn->Execute($sql);
}

?>
