--
-- PostgreSQL database dump
--

\connect - apache

SET search_path = public, pg_catalog;

--
-- TOC entry 11 (OID 17089)
-- Name: users; Type: TABLE; Schema: public; Owner: apache
--

CREATE TABLE users (
    uid smallint DEFAULT nextval('users_uid_seq'::text) NOT NULL,
    last_name character(25) NOT NULL,
    "password" character(12) NOT NULL,
    login character(12),
    updated date,
    first_name character(25),
    email character(100)
);


--
-- TOC entry 12 (OID 17089)
-- Name: users; Type: ACL; Schema: public; Owner: apache
--

REVOKE ALL ON TABLE users FROM PUBLIC;
GRANT ALL ON TABLE users TO PUBLIC;


--
-- TOC entry 13 (OID 17093)
-- Name: groups; Type: TABLE; Schema: public; Owner: apache
--

CREATE TABLE groups (
    gid smallint DEFAULT nextval('groups_gid_seq'::text) NOT NULL,
    description character(20) NOT NULL,
    admin smallint NOT NULL,
    verify_requests boolean
);


--
-- TOC entry 14 (OID 17093)
-- Name: groups; Type: ACL; Schema: public; Owner: apache
--

REVOKE ALL ON TABLE groups FROM PUBLIC;
GRANT ALL ON TABLE groups TO PUBLIC;

--
-- TOC entry 15 (OID 17096)
-- Name: events; Type: TABLE; Schema: public; Owner: apache
--

CREATE TABLE events (
    uid smallint,
    "month" smallint,
    "day" smallint,
    description character(40),
    eid smallint DEFAULT nextval('events_eid_seq'::text)
);


--
-- TOC entry 16 (OID 17096)
-- Name: events; Type: ACL; Schema: public; Owner: apache
--

REVOKE ALL ON TABLE events FROM PUBLIC;
GRANT ALL ON TABLE events TO PUBLIC;


--
-- TOC entry 17 (OID 17099)
-- Name: session; Type: TABLE; Schema: public; Owner: apache
--

CREATE TABLE "session" (
    session_key character(16),
    uid smallint,
    last integer
);


--
-- TOC entry 18 (OID 17099)
-- Name: session; Type: ACL; Schema: public; Owner: apache
--

REVOKE ALL ON TABLE "session" FROM PUBLIC;
GRANT ALL ON TABLE "session" TO PUBLIC;


--
-- TOC entry 19 (OID 17101)
-- Name: items; Type: TABLE; Schema: public; Owner: apache
--

CREATE TABLE items (
    uid smallint,
    description text,
    url text,
    purchased smallint,
    added boolean,
    item_num smallint,
    event smallint,
    price numeric(8,2),
    image text
);


--
-- TOC entry 20 (OID 17101)
-- Name: items; Type: ACL; Schema: public; Owner: apache
--

REVOKE ALL ON TABLE items FROM PUBLIC;
GRANT ALL ON TABLE items TO PUBLIC;


--
-- TOC entry 21 (OID 17106)
-- Name: notes; Type: TABLE; Schema: public; Owner: apache
--

CREATE TABLE notes (
    item_num smallint,
    notes text
);


--
-- TOC entry 22 (OID 17106)
-- Name: notes; Type: ACL; Schema: public; Owner: apache
--

REVOKE ALL ON TABLE notes FROM PUBLIC;
GRANT ALL ON TABLE notes TO PUBLIC;


--
-- TOC entry 23 (OID 17111)
-- Name: members; Type: TABLE; Schema: public; Owner: apache
--

CREATE TABLE members (
    gid smallint,
    uid smallint,
    prim boolean,
    request boolean
);


--
-- TOC entry 24 (OID 17111)
-- Name: members; Type: ACL; Schema: public; Owner: apache
--

REVOKE ALL ON TABLE members FROM PUBLIC;
GRANT ALL ON TABLE members TO PUBLIC;


--
-- TOC entry 25 (OID 17113)
-- Name: giftweb; Type: TABLE; Schema: public; Owner: apache
--

CREATE TABLE giftweb (
    schema_key integer,
    schema_ver real,
    admin smallint
);


--
-- TOC entry 26 (OID 17113)
-- Name: giftweb; Type: ACL; Schema: public; Owner: apache
--

REVOKE ALL ON TABLE giftweb FROM PUBLIC;
GRANT ALL ON TABLE giftweb TO PUBLIC;


--
-- TOC entry 2 (OID 17115)
-- Name: users_uid_seq; Type: SEQUENCE; Schema: public; Owner: apache
--

CREATE SEQUENCE users_uid_seq
    START 102
    INCREMENT 1
    MAXVALUE 9223372036854775807
    MINVALUE 1
    CACHE 1;


--
-- TOC entry 4 (OID 17115)
-- Name: users_uid_seq; Type: ACL; Schema: public; Owner: apache
--

REVOKE ALL ON TABLE users_uid_seq FROM PUBLIC;
GRANT ALL ON TABLE users_uid_seq TO PUBLIC;


--
-- TOC entry 5 (OID 17117)
-- Name: groups_gid_seq; Type: SEQUENCE; Schema: public; Owner: apache
--

CREATE SEQUENCE groups_gid_seq
    START 1
    INCREMENT 1
    MAXVALUE 9223372036854775807
    MINVALUE 1
    CACHE 1;


--
-- TOC entry 7 (OID 17117)
-- Name: groups_gid_seq; Type: ACL; Schema: public; Owner: apache
--

REVOKE ALL ON TABLE groups_gid_seq FROM PUBLIC;
GRANT ALL ON TABLE groups_gid_seq TO PUBLIC;


--
-- TOC entry 8 (OID 17119)
-- Name: events_eid_seq; Type: SEQUENCE; Schema: public; Owner: apache
--

CREATE SEQUENCE events_eid_seq
    START 1
    INCREMENT 1
    MAXVALUE 9223372036854775807
    MINVALUE 1
    CACHE 1;


--
-- TOC entry 10 (OID 17119)
-- Name: events_eid_seq; Type: ACL; Schema: public; Owner: apache
--

REVOKE ALL ON TABLE events_eid_seq FROM PUBLIC;
GRANT ALL ON TABLE events_eid_seq TO PUBLIC;


--
-- Data for TOC entry 32 (OID 17089)
-- Name: users; Type: TABLE DATA; Schema: public; Owner: apache
--

COPY users (uid, last_name, "password", login, updated, first_name, email) FROM stdin;
101	Administrator            	password    	admin       	2001-01-01	Site                     	admin@giftwebsite.com                                                                               
\.


--
-- Data for TOC entry 33 (OID 17093)
-- Name: groups; Type: TABLE DATA; Schema: public; Owner: apache
--

COPY groups (gid, description, admin, verify_requests) FROM stdin;
101	DEFAULT_GROUP       	101	f
\.


--
-- Data for TOC entry 34 (OID 17096)
-- Name: events; Type: TABLE DATA; Schema: public; Owner: apache
--

COPY events (uid, "month", "day", description, eid) FROM stdin;
\.


--
-- Data for TOC entry 35 (OID 17099)
-- Name: session; Type: TABLE DATA; Schema: public; Owner: apache
--

COPY "session" (session_key, uid, last) FROM stdin;
\.


--
-- Data for TOC entry 36 (OID 17101)
-- Name: items; Type: TABLE DATA; Schema: public; Owner: apache
--

COPY items (uid, description, url, purchased, added, item_num, event, price, image) FROM stdin;
\.


--
-- Data for TOC entry 37 (OID 17106)
-- Name: notes; Type: TABLE DATA; Schema: public; Owner: apache
--

COPY notes (item_num, notes) FROM stdin;
\.


--
-- Data for TOC entry 38 (OID 17111)
-- Name: members; Type: TABLE DATA; Schema: public; Owner: apache
--

COPY members (gid, uid, prim, request) FROM stdin;
\.


--
-- Data for TOC entry 39 (OID 17113)
-- Name: giftweb; Type: TABLE DATA; Schema: public; Owner: apache
--

COPY giftweb (schema_key, schema_ver, admin) FROM stdin;
1	0.2	101
\.


--
-- TOC entry 31 (OID 17122)
-- Name: unique_key; Type: INDEX; Schema: public; Owner: apache
--

CREATE UNIQUE INDEX unique_key ON giftweb USING btree (schema_key);


--
-- TOC entry 27 (OID 17123)
-- Name: users_uid_key; Type: CONSTRAINT; Schema: public; Owner: apache
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_uid_key UNIQUE (uid);


--
-- TOC entry 30 (OID 17125)
-- Name: members_gid_uid_unique; Type: CONSTRAINT; Schema: public; Owner: apache
--

ALTER TABLE ONLY members
    ADD CONSTRAINT members_gid_uid_unique UNIQUE (gid, uid);


--
-- TOC entry 28 (OID 17127)
-- Name: members_gid_key; Type: CONSTRAINT; Schema: public; Owner: apache
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT members_gid_key UNIQUE (gid);


--
-- TOC entry 29 (OID 17129)
-- Name: events_eid_key; Type: CONSTRAINT; Schema: public; Owner: apache
--

ALTER TABLE ONLY events
    ADD CONSTRAINT events_eid_key UNIQUE (eid);


--
-- TOC entry 3 (OID 17115)
-- Name: users_uid_seq; Type: SEQUENCE SET; Schema: public; Owner: apache
--

SELECT pg_catalog.setval ('users_uid_seq', 104, true);


--
-- TOC entry 6 (OID 17117)
-- Name: groups_gid_seq; Type: SEQUENCE SET; Schema: public; Owner: apache
--

SELECT pg_catalog.setval ('groups_gid_seq', 1, false);


--
-- TOC entry 9 (OID 17119)
-- Name: events_eid_seq; Type: SEQUENCE SET; Schema: public; Owner: apache
--

SELECT pg_catalog.setval ('events_eid_seq', 1, false);


