/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "GEDCOMParser/Parser.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"
#include "GEDCOMParser/ParseErrorManagement/ParseErrorManager.hh"
#include "GEDCOMParser/Visitor/GEDCOMSerializerVisitor.hh"
#include "GEDCOMParser/Serializer/GEDCOMWriter.hh"
#include <fstream> 
#include <iostream>

#define _(String) (String)

int main(int argc, char **argv)
{

  GEDCOMParser::GEDCOMFactoryAccessor::Init();
  GEDCOMParser::GEDCOMFactory * factory = GEDCOMParser::GEDCOMFactoryAccessor::getFactory();
  GEDCOMParser::Parser viewparser(factory);
  if (argc == 3)
    {

      char * gedcom_filename = argv[1];
      char * output_filename = argv[2];

      GEDCOMParser::ParseErrorManagement::ParseErrorManager parse_error_manager = viewparser.Parse(gedcom_filename);
      if (parse_error_manager.ErrorCount() == 0)
	{
	  GEDCOMParser::LineageLinkageGedcom * const lineage = viewparser.getLineageLinkageGedcom();
	  GEDCOMParser::Writer * writer = new GEDCOMParser::GEDCOMWriter();
	  GEDCOMParser::GEDCOMSerializerVisitor * visitor = new GEDCOMParser::GEDCOMSerializerVisitor();
	  visitor->setWriter(writer);
	  lineage->Accept(visitor);
	  std::ofstream output_file(output_filename);
	  output_file << writer->getBuffer();
	  delete writer; writer = 0;
	  delete visitor; visitor = 0;
	}
      else
	{
	  std::cout << std::endl << _("Parsing finished with errors : ") << std::endl;
	  for (std::vector < GEDCOMParser::ParseErrorManagement::ParseError >::const_iterator err_iter = parse_error_manager.getErrors().begin(); err_iter != parse_error_manager.getErrors().end(); err_iter++)
	    {
	      std::cerr << err_iter->getDescription() << std::endl;
	    }
	}
    }
}
