/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "GEDCOMParser/UserReferenceManager.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

GEDCOMParser::UserReference *
  GEDCOMParser::UserReferenceManager::addUserReference (GEDCOMParser::
							UserReference *
							const data = 0)
{
  GEDCOMParser::UserReference * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createUserReference ();
    }
  _user_references.push_back (SmartPtr < UserReference > (tmp_data));
  return _user_references.back ().getPtr ();
}

GEDCOMParser::UserReferences_t const &
GEDCOMParser::UserReferenceManager::getUserReferences (void) const
{
  return _user_references;
}

void
GEDCOMParser::UserReferenceManager::removeUserReference (GEDCOMParser::
							 UserReference * data)
{
  GEDCOMParser::UserReferences_t::iterator iter =
    std::find (_user_references.begin (), _user_references.end (), data);
  if (iter != _user_references.end ())
    {
      _user_references.erase (iter);
    }
  return;
}
