/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_SUBMISSION_HH_
#define _GEDCOMPARSER_SUBMISSION_HH_

#include <string>
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 SUBMISSION_RECORD structure
  class Submission:public GEDCOMElement
  {
  protected:
    ///
    std::string _id;
    ///
    std::string _subm_xref;
    ///
    std::string _famf;
    ///
    std::string _gedc_temp;
    ///
    std::string _ance;
    ///
    std::string _desc;
    ///
    std::string _ordi;
    ///
    std::string _rin;
  public:
    ///
    virtual ~ Submission (void)
    {
    };
    ///@name Accessors (set) 
    //@{    
    ///
    void setId (std::string const &);
    ///
    void setSubmXref (std::string const &);
    ///
    void setFamf (std::string const &);
    ///
    void setTemp (std::string const &);
    ///
    void setAnce (std::string const &);
    ///
    void setDesc (std::string const &);
    ///
    void setOrdi (std::string const &);
    ///
    void setRin (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{    
    ///
    virtual std::string const &getId (void) const;
    ///
    virtual std::string const &getSubmXref (void) const;
    ///
    virtual std::string const &getFamf (void) const;
    ///
    virtual std::string const &getTemp (void) const;
    ///
    virtual std::string const &getAnce (void) const;
    ///
    virtual std::string const &getDesc (void) const;
    ///
    virtual std::string const &getOrdi (void) const;
    ///
    virtual std::string const &getRin (void) const;
    //@}
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  };
};
#endif
