#include "GEDCOMParser/Serializer/GEDCOMWriter.hh"
#include <iostream>
#include <algorithm>
#include "string_utility/Converter.hh"

#define TAG_SEPARATOR " "

std::string const
  NEWLINE =
  "\n";

void
GEDCOMParser::GEDCOMWriter::WriteString (std::string const &name,
					 std::string const &value,
					 bool write_blank_value)
{
  if (value != "")
    {
      _buffer = _buffer + name + TAG_SEPARATOR + value + NEWLINE;
    }
  else if (write_blank_value == true)
    {
      _buffer = _buffer + name + NEWLINE;
    }
    
  return;
}

void
GEDCOMParser::GEDCOMWriter::WriteStrings (std::string const &name,
					  std::vector < std::string >
					  const &values)
{
  for (std::vector < std::string >::const_iterator iter = values.begin ();
       iter != values.end (); iter++)
    {
      WriteString (name, *iter);
    }
  return;
}

void
GEDCOMParser::GEDCOMWriter::WriteObject (std::string const &name,
					 GEDCOMParser::Serializable const *s)
{
  std::cerr << "GEDCOMWriter : writing object to " << name << std::endl;
  return;
}

void
GEDCOMParser::GEDCOMWriter::WriteText (std::string const &name,
				       std::string const &value,
				       int ref_level)
{
  int const
    LINE_LENGTH =
    255;
  std::string const
    level =
    toString < int >(ref_level + 1);

  std::string::iterator tmp_iter;
  std::string tmp (value);
  std::string const
    CONT_REPLACE =
    level +
    " CONT ";
  std::string const
    CONC_REPLACE =
    level +
    " CONC ";
  std::string tmp2;
  std::vector < std::string > vec_text;
  std::string line_prefix = "";

  bool found = false;
  _buffer = _buffer + name + TAG_SEPARATOR;
  do
    {
      found = false;
      tmp_iter =
	std::search (tmp.begin (), tmp.end (), NEWLINE.begin (),
		     NEWLINE.end ());
      tmp2 = line_prefix + std::string (tmp.begin (), tmp_iter);
      vec_text.push_back (tmp2);

      if (tmp_iter != tmp.end ())
	{
	  found = true;
	  tmp2 = std::string (++tmp_iter, tmp.end ());
	  tmp = tmp2;
	  line_prefix = CONT_REPLACE;
	}
    }
  while (found);

  std::string head;
  std::string rest;
  int
    head_length;

  for (std::vector < std::string >::const_iterator iter = vec_text.begin ();
       iter != vec_text.end (); iter++)
    {
      tmp = *iter;
      line_prefix = "";
      do
	{
	  if (tmp.length () > LINE_LENGTH)
	    {
	      head_length = LINE_LENGTH;
	    }
	  else
	    {
	      head_length = tmp.length ();
	    }
	  head = std::string (tmp, 0, head_length);

	  _buffer = _buffer + line_prefix + head + NEWLINE;

	  if (head_length != tmp.length ())
	    {
	      rest =
		std::string (tmp, head_length, tmp.length () - head_length);
	    }
	  else
	    {
	      rest = "";
	    }
	  tmp = rest;
	  line_prefix = CONC_REPLACE;
	}
      while (rest != "");

    }
  return;
}

void
GEDCOMParser::GEDCOMWriter::WriteDate (std::string const &name,
				       GEDCOMParser::DateManagement::
				       DateValue const *const value)
{
  if (value != 0)
    {
      _buffer =
	_buffer + name + TAG_SEPARATOR + value->getRawValue () + NEWLINE;
    }
  return;
}
