#ifndef _GEDCOMPARSER_PREDICATES_NAMEEQUALSTO_HH_
#define _GEDCOMPARSER_PREDICATES_NAMEEQUALSTO_HH_

#include "GEDCOMParser/IndividualRecord.hh"
#include "GEDCOMParser/PersonalName.hh"
#include <string>
#include <functional>
#include <iostream>

namespace GEDCOMParser
{
  namespace Predicates
  {
    class NameEqualsTo:public std::binary_function < std::string,
      GEDCOMParser::IndividualRecords_elem_t, bool >
    {
    public:
      bool operator      () (std::string name,
			     GEDCOMParser::
			     IndividualRecords_elem_t individu) const
      {
	bool res = false;
	bool found = false;
	  GEDCOMParser::PersonalNames_t names =
	  individu.second->getPersonalNames ();
	  GEDCOMParser::PersonalNames_t::const_iterator name_iter =
	  names.begin ();
	do
	  {
	    if (name_iter != names.end ())
	      {
		if (!(*name_iter).Null ())
		  {
		    found = ((*name_iter)->getSurn () == name);
		  }
		name_iter++;
	      }
	  }
	while ((!found) && (name_iter != names.end ()));
	  res = found;
	  return res;
      };
    };
  };
};

#endif
