#ifndef _GEDCOMPARSER_PREDICATES_HASSPOUSE_HH_
#define _GEDCOMPARSER_PREDICATES_HASSPOUSE_HH_

#include "GEDCOMParser/LineageLinkageGedcom.hh"
#include "GEDCOMParser/IndividualRecord.hh"
#include <functional>

namespace GEDCOMParser
{
  namespace Predicates
  {
    class HasSpouse:public std::binary_function <
      GEDCOMParser::LineageLinkageGedcom const *const,
      GEDCOMParser::IndividualRecords_elem_t, bool >
    {
    public:
      bool operator      () (GEDCOMParser::
			     LineageLinkageGedcom const *const lineage,
			     GEDCOMParser::
			     IndividualRecords_elem_t individu_elem) const
      {
	GEDCOMParser::IndividualRecord const *const individu =
	  individu_elem.second.getPtr ();
	bool res = false;
	  std::string fam_id;
	  std::string spouse_id;
	  FamilyRecords_t::const_iterator fam_iter;
	  IndividualRecords_t::const_iterator spouse_iter;
	if (individu != 0)
	  {
	    SpouseToFamilyLinks_t const &spouse_to_family_links =
	      individu->getSpouseToFamilyLinks ();
	      SpouseToFamilyLinks_t::
	      const_iterator spouse_to_family_links_iter =
	      spouse_to_family_links.begin ();
	      GEDCOMParser::FamilyRecords_t const &families =
	      lineage->getFamilyRecords ();
	    while ((!res)
		   && (spouse_to_family_links_iter !=
		       spouse_to_family_links.end ()))
	      {
		fam_id = (*spouse_to_family_links_iter)->getFamXref ();
		fam_iter = families.find (fam_id);
		if (fam_iter != families.end ())
		  {
		    if (individu->getSex () ==
			GEDCOMParser::IndividualRecord::MALE)
		      {
			spouse_id = (*fam_iter).second->getWife ();
		      }
		    else
		      {
			spouse_id = (*fam_iter).second->getHusb ();
		      }
		    if (spouse_id != "")
		      {
			res = true;
		      }
		  }
		spouse_to_family_links_iter++;
	      }
	  }
	return res;
      };
    };
  };
};
#endif
