/* 
    Copyright 2003 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _GEDCOMPARSER_PREDICATES_HASCHILD_HH_
#define _GEDCOMPARSER_PREDICATES_HASCHILD_HH_

#include "GEDCOMParser/LineageLinkageGedcom.hh"
#include "GEDCOMParser/IndividualRecord.hh"
#include <functional>

namespace GEDCOMParser
{
  namespace Predicates
  {
    class HasChild:public std::binary_function <
      GEDCOMParser::LineageLinkageGedcom const *const,
      GEDCOMParser::IndividualRecords_elem_t, bool >
    {
    public:
      bool operator      () (GEDCOMParser::
			     LineageLinkageGedcom const *const lineage,
			     GEDCOMParser::
			     IndividualRecords_elem_t individu_elem) const
      {
	GEDCOMParser::IndividualRecord const *const individu =
	  individu_elem.second.getPtr ();
	bool res = false;
	  std::string fam_id;
	  FamilyRecords_t::const_iterator fam_iter;
	  IndividualRecords_t::const_iterator child_iter;
	if (individu != 0)
	  {
	    SpouseToFamilyLinks_t const &spouse_to_family_links =
	      individu->getSpouseToFamilyLinks ();
	      SpouseToFamilyLinks_t::
	      const_iterator spouse_to_family_links_iter =
	      spouse_to_family_links.begin ();
	      GEDCOMParser::FamilyRecords_t const &families =
	      lineage->getFamilyRecords ();
	    while ((!res)
		   && (spouse_to_family_links_iter !=
		       spouse_to_family_links.end ()))
	      {
		fam_id = (*spouse_to_family_links_iter)->getFamXref ();
		fam_iter = families.find (fam_id);
		if (fam_iter != families.end ())
		  {
		    if ((*fam_iter).second->getChilXrefs ().size () > 0)
		      {
			res = true;
		      }
		  }
		spouse_to_family_links_iter++;
	      }
	  }
	return res;
      };
    };
  };
};
#endif
