#ifndef _GEDCOMPARSER_PREDICATES_FAMILYISUSED_HH_
#define _GEDCOMPARSER_PREDICATES_FAMILYISUSED_HH_

#include "GEDCOMParser/LineageLinkageGedcom.hh"
#include "GEDCOMParser/FamilyRecord.hh"
#include <functional>

///
namespace GEDCOMParser
{
  /// Management of predicates
  namespace Predicates
  {
    /// @name
    class FamilyIsUsed:public std::binary_function <
      GEDCOMParser::LineageLinkageGedcom const *const,
      GEDCOMParser::FamilyRecords_elem_t, bool >
    {
    public:
      bool operator      () (GEDCOMParser::
			     LineageLinkageGedcom const *const lineage,
			     GEDCOMParser::
			     FamilyRecords_elem_t family_elem) const
      {
	GEDCOMParser::FamilyRecord const *const family =
	  family_elem.second.getPtr ();
	bool res = ((family->getHusb () != "") || (family->getWife () != "")
		    || (family->getChilXrefs ().size () > 0));
	  return res;
      };
    };
  };
};

#endif
