/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _GEDCOMPARSER_PARSEERRORMANAGEMENT_PARSEERROR_HH_
#define _GEDCOMPARSER_PARSEERRORMANAGEMENT_PARSEERROR_HH_

#include <string>
///
namespace GEDCOMParser
{
  /// Management of parsing errors
  namespace ParseErrorManagement
  {
    /// Main class ; handles the errors
    class ParseError
    {
    public:
      ParseError (int n, std::string const &desc):_number (n),
	_description (desc)
      {
      };
        std::string const &getDescription (void) const
      {
	return _description;
      }
      int const &getNumber (void) const
      {
	return _number;
      }
    private:
      int _number;
        std::string _description;
    };
  };
};

#endif
